"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.XmlFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const xmlbuilder2_1 = require("xmlbuilder2");
const object_file_1 = require("./object-file");
/**
 * Represents an XML file.
 *
 * Objects passed in will be synthesized using the npm "xml" library.
 * @see https://www.npmjs.com/package/xml
 */
class XmlFile extends object_file_1.ObjectFile {
    constructor(project, filePath, options = {}) {
        super(project, filePath, options);
    }
    synthesizeContent(resolver) {
        const obj = super.synthesizeContent(resolver);
        if (!obj) {
            return undefined;
        }
        const xmlString = (0, xmlbuilder2_1.create)({ encoding: "UTF-8" }, obj).end({
            prettyPrint: true,
            indent: " ".repeat(4),
        });
        return [
            xmlString,
            ...(this.marker ? [`<!-- ${this.marker} -->`] : []),
        ].join("\n");
    }
}
exports.XmlFile = XmlFile;
_a = JSII_RTTI_SYMBOL_1;
XmlFile[_a] = { fqn: "projen.XmlFile", version: "0.96.2" };
//# sourceMappingURL=data:application/json;base64,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