"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.YamlFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const YAML = require("yaml");
const object_file_1 = require("./object-file");
/**
 * Represents a YAML file.
 */
class YamlFile extends object_file_1.ObjectFile {
    constructor(scope, filePath, options) {
        super(scope, filePath, options);
        this.lineWidth = options.lineWidth ?? 0;
    }
    synthesizeContent(resolver) {
        const json = super.synthesizeContent(resolver);
        if (!json) {
            return undefined;
        }
        return [
            ...(this.marker ? [`# ${this.marker}`] : []),
            "",
            YAML.stringify(JSON.parse(json), {
                indent: 2,
                lineWidth: this.lineWidth,
            }),
        ].join("\n");
    }
}
exports.YamlFile = YamlFile;
_a = JSII_RTTI_SYMBOL_1;
YamlFile[_a] = { fqn: "projen.YamlFile", version: "0.96.2" };
//# sourceMappingURL=data:application/json;base64,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