# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: create_uuid7_func.sql
import dataclasses

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


CREATE_UUID7_FUNCTION = """-- name: create_uuid7_function \\:exec
CREATE OR REPLACE FUNCTION uuid7() RETURNS uuid
    LANGUAGE plpgsql
    VOLATILE  -- ← must be VOLATILE
AS $$
DECLARE
    ts         bigint;
    hex_ts     text;
    rand_hex   text;
    u          text;
    var_nibble text \\:= to_hex(8 + floor(random()*4))\\:\\:text; -- 8–B → RFC 4122 “10xx” variant
BEGIN
    -- 48-bit millisecond Unix epoch
    ts      \\:= floor(extract(epoch FROM clock_timestamp()) * 1000);
    hex_ts  \\:= lpad(to_hex(ts), 12, '0');

    -- 80 bits of random-ish hex (you’ll use 74 of them, per RFC 9562 §6.9)  [oai_citation\\:0‡rfc-editor.org](https\\://www.rfc-editor.org/rfc/rfc9562.html?utm_source=chatgpt.com)
    rand_hex \\:= substr(md5(random()\\:\\:text), 1, 20);

    -- Assemble UUIDv7\\:  time_hi | time_mid | ver+randA | var+randB | randC
    u \\:=
            substr(hex_ts,1,8)               || '-' ||
            substr(hex_ts,9,4)               || '-' ||
            '7'       || substr(rand_hex,1,3)   || '-' ||
            var_nibble|| substr(rand_hex,4,3)   || '-' ||
            substr(rand_hex,7,12);

    RETURN u\\:\\:uuid;
END;
$$
"""


@dataclasses.dataclass()
class CreateUuid7FunctionParams:

    pass

class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def create_uuid7_function(self, arg: CreateUuid7FunctionParams) -> None:
        self._conn.execute(sqlalchemy.text(CREATE_UUID7_FUNCTION))


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def create_uuid7_function(self, arg: CreateUuid7FunctionParams) -> None:
        await self._conn.execute(sqlalchemy.text(CREATE_UUID7_FUNCTION))
