# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: get_task_attempts_by_durable_id.sql
import dataclasses
import datetime
from typing import Any, AsyncIterator, Iterator, Optional
import uuid

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


GET_TASK_ATTEMPTS_BY_DURABLE_ID = """-- name: get_task_attempts_by_durable_id \\:many
SELECT 
    tr.id,
    tr.durable_id,
    tr.root_id,
    tr.parent_id,
    tr.task_name,
    tr.args,
    tr.queue,
    tr.max_retries,
    tr.priority,
    tr.status,
    tr.attempt_number,
    tr.scheduled_start,
    tr.executor_id,
    tr.queued,
    tr.started,
    tr.finished,
    tr.log_link,
    t.source_code,
    res.result
FROM hyrex_task_run tr
LEFT JOIN hyrex_task_def t ON tr.task_name = t.task_name
LEFT JOIN hyrex_task_result res ON tr.id = res.task_id
WHERE tr.durable_id = :p1
ORDER BY tr.attempt_number DESC
"""


@dataclasses.dataclass()
class GetTaskAttemptsByDurableIdParams:
    durable_id: uuid.UUID


@dataclasses.dataclass()
class GetTaskAttemptsByDurableIdRow:
    id: uuid.UUID
    durable_id: uuid.UUID
    root_id: uuid.UUID
    parent_id: Optional[uuid.UUID]
    task_name: str
    args: Any
    queue: str
    max_retries: int
    priority: int
    status: Any
    attempt_number: int
    scheduled_start: Optional[datetime.datetime]
    executor_id: Optional[uuid.UUID]
    queued: Optional[datetime.datetime]
    started: Optional[datetime.datetime]
    finished: Optional[datetime.datetime]
    log_link: Optional[str]
    source_code: Optional[str]
    result: Optional[Any]


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def get_task_attempts_by_durable_id(self, arg: GetTaskAttemptsByDurableIdParams) -> Iterator[GetTaskAttemptsByDurableIdRow]:
        result = self._conn.execute(sqlalchemy.text(GET_TASK_ATTEMPTS_BY_DURABLE_ID), {"p1": arg.durable_id})
        for row in result:
            yield GetTaskAttemptsByDurableIdRow(
                id=row[0],
                durable_id=row[1],
                root_id=row[2],
                parent_id=row[3],
                task_name=row[4],
                args=row[5],
                queue=row[6],
                max_retries=row[7],
                priority=row[8],
                status=row[9],
                attempt_number=row[10],
                scheduled_start=row[11],
                executor_id=row[12],
                queued=row[13],
                started=row[14],
                finished=row[15],
                log_link=row[16],
                source_code=row[17],
                result=row[18],
            )


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def get_task_attempts_by_durable_id(self, arg: GetTaskAttemptsByDurableIdParams) -> AsyncIterator[GetTaskAttemptsByDurableIdRow]:
        result = await self._conn.stream(sqlalchemy.text(GET_TASK_ATTEMPTS_BY_DURABLE_ID), {"p1": arg.durable_id})
        async for row in result:
            yield GetTaskAttemptsByDurableIdRow(
                id=row[0],
                durable_id=row[1],
                root_id=row[2],
                parent_id=row[3],
                task_name=row[4],
                args=row[5],
                queue=row[6],
                max_retries=row[7],
                priority=row[8],
                status=row[9],
                attempt_number=row[10],
                scheduled_start=row[11],
                executor_id=row[12],
                queued=row[13],
                started=row[14],
                finished=row[15],
                log_link=row[16],
                source_code=row[17],
                result=row[18],
            )
