# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: get_workflows_paginated.sql
import dataclasses
import datetime
from typing import Any, AsyncIterator, Iterator, Optional

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


GET_WORKFLOWS_PAGINATED = """-- name: get_workflows_paginated \\:many
SELECT 
    ROW_NUMBER() OVER (ORDER BY last_updated DESC) as row_number,
    workflow_name,
    cron_expr,
    source_code,
    dag_structure,
    last_updated
FROM hyrex_workflow
ORDER BY last_updated DESC
LIMIT :p1 OFFSET :p2
"""


@dataclasses.dataclass()
class GetWorkflowsPaginatedParams:
    limit: int
    offset: int


@dataclasses.dataclass()
class GetWorkflowsPaginatedRow:
    row_number: int
    workflow_name: str
    cron_expr: Optional[str]
    source_code: Optional[str]
    dag_structure: Optional[Any]
    last_updated: Optional[datetime.datetime]


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def get_workflows_paginated(self, arg: GetWorkflowsPaginatedParams) -> Iterator[GetWorkflowsPaginatedRow]:
        result = self._conn.execute(sqlalchemy.text(GET_WORKFLOWS_PAGINATED), {"p1": arg.limit, "p2": arg.offset})
        for row in result:
            yield GetWorkflowsPaginatedRow(
                row_number=row[0],
                workflow_name=row[1],
                cron_expr=row[2],
                source_code=row[3],
                dag_structure=row[4],
                last_updated=row[5],
            )


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def get_workflows_paginated(self, arg: GetWorkflowsPaginatedParams) -> AsyncIterator[GetWorkflowsPaginatedRow]:
        result = await self._conn.stream(sqlalchemy.text(GET_WORKFLOWS_PAGINATED), {"p1": arg.limit, "p2": arg.offset})
        async for row in result:
            yield GetWorkflowsPaginatedRow(
                row_number=row[0],
                workflow_name=row[1],
                cron_expr=row[2],
                source_code=row[3],
                dag_structure=row[4],
                last_updated=row[5],
            )
