# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: register_task_def.sql
import dataclasses
from typing import Any, Optional

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


REGISTER_TASK_DEF = """-- name: register_task_def \\:exec
INSERT INTO hyrex_task_def (task_name, cron_expr, source_code, arg_schema, queue, priority, max_retries, timeout_seconds, last_updated)
VALUES (:p1, :p2, :p3, :p4, :p5, :p6, :p7, :p8, NOW())
ON CONFLICT (task_name)
DO UPDATE SET
    cron_expr = EXCLUDED.cron_expr,
    source_code = EXCLUDED.source_code,
    arg_schema = EXCLUDED.arg_schema,
    queue = EXCLUDED.queue,
    priority = EXCLUDED.priority,
    max_retries = EXCLUDED.max_retries,
    timeout_seconds = EXCLUDED.timeout_seconds,
    last_updated = NOW()
"""


@dataclasses.dataclass()
class RegisterTaskDefParams:
    task_name: str
    cron_expr: Optional[str]
    source_code: Optional[str]
    arg_schema: Optional[Any]
    queue: Optional[str]
    priority: Optional[int]
    max_retries: Optional[int]
    timeout_seconds: Optional[int]


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def register_task_def(self, arg: RegisterTaskDefParams) -> None:
        self._conn.execute(sqlalchemy.text(REGISTER_TASK_DEF), {
            "p1": arg.task_name,
            "p2": arg.cron_expr,
            "p3": arg.source_code,
            "p4": arg.arg_schema,
            "p5": arg.queue,
            "p6": arg.priority,
            "p7": arg.max_retries,
            "p8": arg.timeout_seconds,
        })


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def register_task_def(self, arg: RegisterTaskDefParams) -> None:
        await self._conn.execute(sqlalchemy.text(REGISTER_TASK_DEF), {
            "p1": arg.task_name,
            "p2": arg.cron_expr,
            "p3": arg.source_code,
            "p4": arg.arg_schema,
            "p5": arg.queue,
            "p6": arg.priority,
            "p7": arg.max_retries,
            "p8": arg.timeout_seconds,
        })
