import subprocess
from pathlib import Path


def download_nuplan(target_dir: str = "nuplan_devkit") -> bool:
    """
    Download nuplan_devkit from GitHub

    Args:
        target_dir: Directory to save to (default "nuplan_devkit")

    Returns:
        bool: True if successful, False if error
    """
    repo_url = "https://github.com/motional/nuplan-devkit.git"

    try:
        # Check if git is available
        subprocess.run(["git", "--version"], check=True, capture_output=True)

        # Create directory if needed
        Path(target_dir).parent.mkdir(parents=True, exist_ok=True)

        # Clone repository
        print(f"Downloading nuplan_devkit to {target_dir}...")
        result = subprocess.run(
            ["git", "clone", repo_url, target_dir],
            check=True,
            capture_output=True,
            text=True
        )

        print("nuplan_devkit downloaded successfully!")
        return True

    except subprocess.CalledProcessError as e:
        print(f"Download error: {e.stderr}")
        return False
    except FileNotFoundError:
        print("Git is not installed. Please install git first.")
        return False
    except Exception as e:
        print(f"Unknown error: {e}")
        return False