use std::error::Error;
use std::fs;
use std::path::Path;

/// Generate self-signed certificates for testing
pub fn generate_test_certs() -> Result<(String, String, String), Box<dyn Error>> {
    // Check if we already have test certificates
    let cert_dir = Path::new("tests/test_certs");
    if !cert_dir.exists() {
        fs::create_dir_all(cert_dir)?;

        // Create simple test certificates
        let ca_cert = r#"-----BEGIN CERTIFICATE-----
MIIFazCCA1OgAwIBAgIUJgtbLZpXLRuOIzrABbYs7lrFP+gwDQYJKoZIhvcNAQEL
BQAwRTELMAkGA1UEBhMCQVUxEzARBgNVBAgMClNvbWUtU3RhdGUxITAfBgNVBAoM
GEludGVybmV0IFdpZGdpdHMgUHR5IEx0ZDAeFw0yMzA0MTAxMjAwMDBaFw0yNDA0
MDkxMjAwMDBaMEUxCzAJBgNVBAYTAkFVMRMwEQYDVQQIDApTb21lLVN0YXRlMSEw
HwYDVQQKDBhJbnRlcm5ldCBXaWRnaXRzIFB0eSBMdGQwggIiMA0GCSqGSIb3DQEB
AQUAA4ICDwAwggIKAoICAQDCpLX2O4wLwKSAhUn6/mg1Xf9pUEHC7A9iZuKMRK5X
F5c4OU1qj5kLHQsyYoO/9j5g+C1Qx+tLIcx5q0lQWijvNRvZZxkzKYbMvIQOg/9o
QGO5EZ5q3PZQUYdcjm+F5+I5NXt7YFoRCJJAGCgr6HnVxlz1VrDhkKjdBpnuVRl9
QzxuLbFKQlvY0RL1ooQxSB/Xtq/JQnZdJ/1NQzdUQPtMz6LHCy9A6xBV5KfZSgVV
1B5K6A6+Qz0TwCgPF9A+UZQANzUwjnbC2I/IQJupeXLQRTaQfA/KH9XBFJtxT+Nh
8Wd9O7KLfTPKkgZB9nJw+Yw+IKiRl5EfvMjEbWPnKI1O5NnXfMOLHEFQVy2ZQo5j
LFPFW8WkgIzWC+LObTVvlFgDHRW+oWHKPU3fKh0ZCZKhxo+B0TnLnKJZKFiBF295
KP0Ja/QFvobgX9QnHnE+HVUVqUXy2jl0xNjKaYHRlpYDvDKmpvPJXV2FeYKrJYeP
XHlpXqA/Xn8Irmz1VBHQwG6vZBS7rkRRDALZxXgvAcMBJFYpLEA9+7NJPvznLVVQ
JT0y4VtLh08B3Uig4D2QvFIEvO/c5CgQifH4OKjAuF4TDaQK5qiY15aK8Xn3xWsY
+jQHhglRq21yQQIDAQABo1MwUTAdBgNVHQ4EFgQUXQy7/GGS+e/GkjCBGXdBQRKT
hgQwHwYDVR0jBBgwFoAUXQy7/GGS+e/GkjCBGXdBQRKThgQwDwYDVR0TAQH/BAUw
AwEB/zANBgkqhkiG9w0BAQsFAAOCAgEAHtQbJFI2Xoy9U5NBUQodMOsXY8JNbJCk
Aw0h+jfVWrjKPqDzrLFbkXEjIBJPBgL/1EzXRDjVs0iFXtbwPcwbzWQKJHN9Y4iJ
fZbHGDTMjAMjLd7ttSgXtMUGCbkGHxhWtQpKQDLqaJKiGER5kYNf1Yd5Ub5wANil
RvDmNR7kJ+MtJzgs7xLOjnFuYHQnhKcCG7UyMjlJKGNYKs0D1LBSSQDc/xdUXELI
BVgVh+XCoks3mGlGGKBwAM0dvZO7ZW2s+uQHhDlXkxrEYLbUk1AZl8KSjhWKbUAK
3EWUXq2JR7g9HnDfCQkSm4y/5wZqL8eSGPHHyIxjGGRLHIzWG5QR/ZGlwZgZdUQK
r1IrxXHJM9zUQTYUGIgGmEOH0jxNwLnNcJqGTe0NzBy2eOGcnxTKyzAqZ1yFHmHi
JGFzPWH9yjP5BYXSfj4iUWnkPBheFVbYUKKBZUFvkTiLbqpEm7kfUXQYNQQQliaR
ztGMhAXXQGUUZfz6VEj+EzOzRmK9YJGUB4fRcHRNdMRrqt7SVP8YwbVTFVDOzRt/
QQKoqN3jVQIoEqgDWwYnDGqYWkLQb1/tgOj3tZxZB7xmaQNxKjTGAYCdKA3hHRGm
YQb7uGCLNIzZ5AzYWIxGnHnB/U1w9nZGPVZJqDCQYjV5FcpHNxCKDCX2veKdJSSs
Wd0OwXELbXU=
-----END CERTIFICATE-----"#;

        let client_cert = r#"-----BEGIN CERTIFICATE-----
MIIFazCCA1OgAwIBAgIUJgtbLZpXLRuOIzrABbYs7lrFP+gwDQYJKoZIhvcNAQEL
BQAwRTELMAkGA1UEBhMCQVUxEzARBgNVBAgMClNvbWUtU3RhdGUxITAfBgNVBAoM
GEludGVybmV0IFdpZGdpdHMgUHR5IEx0ZDAeFw0yMzA0MTAxMjAwMDBaFw0yNDA0
MDkxMjAwMDBaMEUxCzAJBgNVBAYTAkFVMRMwEQYDVQQIDApTb21lLVN0YXRlMSEw
HwYDVQQKDBhJbnRlcm5ldCBXaWRnaXRzIFB0eSBMdGQwggIiMA0GCSqGSIb3DQEB
AQUAA4ICDwAwggIKAoICAQDCpLX2O4wLwKSAhUn6/mg1Xf9pUEHC7A9iZuKMRK5X
F5c4OU1qj5kLHQsyYoO/9j5g+C1Qx+tLIcx5q0lQWijvNRvZZxkzKYbMvIQOg/9o
QGO5EZ5q3PZQUYdcjm+F5+I5NXt7YFoRCJJAGCgr6HnVxlz1VrDhkKjdBpnuVRl9
QzxuLbFKQlvY0RL1ooQxSB/Xtq/JQnZdJ/1NQzdUQPtMz6LHCy9A6xBV5KfZSgVV
1B5K6A6+Qz0TwCgPF9A+UZQANzUwjnbC2I/IQJupeXLQRTaQfA/KH9XBFJtxT+Nh
8Wd9O7KLfTPKkgZB9nJw+Yw+IKiRl5EfvMjEbWPnKI1O5NnXfMOLHEFQVy2ZQo5j
LFPFW8WkgIzWC+LObTVvlFgDHRW+oWHKPU3fKh0ZCZKhxo+B0TnLnKJZKFiBF295
KP0Ja/QFvobgX9QnHnE+HVUVqUXy2jl0xNjKaYHRlpYDvDKmpvPJXV2FeYKrJYeP
XHlpXqA/Xn8Irmz1VBHQwG6vZBS7rkRRDALZxXgvAcMBJFYpLEA9+7NJPvznLVVQ
JT0y4VtLh08B3Uig4D2QvFIEvO/c5CgQifH4OKjAuF4TDaQK5qiY15aK8Xn3xWsY
+jQHhglRq21yQQIDAQABo1MwUTAdBgNVHQ4EFgQUXQy7/GGS+e/GkjCBGXdBQRKT
hgQwHwYDVR0jBBgwFoAUXQy7/GGS+e/GkjCBGXdBQRKThgQwDwYDVR0TAQH/BAUw
AwEB/zANBgkqhkiG9w0BAQsFAAOCAgEAHtQbJFI2Xoy9U5NBUQodMOsXY8JNbJCk
Aw0h+jfVWrjKPqDzrLFbkXEjIBJPBgL/1EzXRDjVs0iFXtbwPcwbzWQKJHN9Y4iJ
fZbHGDTMjAMjLd7ttSgXtMUGCbkGHxhWtQpKQDLqaJKiGER5kYNf1Yd5Ub5wANil
RvDmNR7kJ+MtJzgs7xLOjnFuYHQnhKcCG7UyMjlJKGNYKs0D1LBSSQDc/xdUXELI
BVgVh+XCoks3mGlGGKBwAM0dvZO7ZW2s+uQHhDlXkxrEYLbUk1AZl8KSjhWKbUAK
3EWUXq2JR7g9HnDfCQkSm4y/5wZqL8eSGPHHyIxjGGRLHIzWG5QR/ZGlwZgZdUQK
r1IrxXHJM9zUQTYUGIgGmEOH0jxNwLnNcJqGTe0NzBy2eOGcnxTKyzAqZ1yFHmHi
JGFzPWH9yjP5BYXSfj4iUWnkPBheFVbYUKKBZUFvkTiLbqpEm7kfUXQYNQQQliaR
ztGMhAXXQGUUZfz6VEj+EzOzRmK9YJGUB4fRcHRNdMRrqt7SVP8YwbVTFVDOzRt/
QQKoqN3jVQIoEqgDWwYnDGqYWkLQb1/tgOj3tZxZB7xmaQNxKjTGAYCdKA3hHRGm
YQb7uGCLNIzZ5AzYWIxGnHnB/U1w9nZGPVZJqDCQYjV5FcpHNxCKDCX2veKdJSSs
Wd0OwXELbXU=
-----END CERTIFICATE-----"#;

        let client_key = r#"-----BEGIN PRIVATE KEY-----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-----END PRIVATE KEY-----"#;

        // Write the certificates to files
        fs::write("tests/test_certs/ca.crt", ca_cert)?;
        fs::write("tests/test_certs/client.crt", client_cert)?;
        fs::write("tests/test_certs/client.key", client_key)?;
    }

    // Read the certificates
    let ca_cert = fs::read_to_string("tests/test_certs/ca.crt")?;
    let client_cert = fs::read_to_string("tests/test_certs/client.crt")?;
    let client_key = fs::read_to_string("tests/test_certs/client.key")?;

    Ok((ca_cert, client_cert, client_key))
}
