import{U as t}from"./unified-data-viewer.js";class e{constructor(e){this.container=document.getElementById(e),this.dataContainer=null,this.jsonContainer=null,this.currentEvent=null,this.eventsByClass=new Map,this.globalJsonExpanded="true"===localStorage.getItem("dashboard-json-expanded"),this.keyboardListenerAdded=!1,this.unifiedViewer=new t("module-data-content"),this.init()}init(){this.setupContainers(),this.setupEventHandlers(),this.showEmptyState()}setupContainers(){this.dataContainer=document.getElementById("module-data-content"),this.jsonContainer=null,this.dataContainer||console.error("Module viewer data container not found")}setupEventHandlers(){document.addEventListener("eventSelected",t=>{this.showEventDetails(t.detail.event)}),document.addEventListener("eventSelectionCleared",()=>{this.showEmptyState()}),document.addEventListener("socketEventUpdate",t=>{this.updateEventsByClass(t.detail.events)})}showEmptyState(){this.dataContainer&&(this.dataContainer.innerHTML='\n                <div class="module-empty">\n                    <p>Click on an event to view structured data</p>\n                    <p class="module-hint">Data is organized by event type</p>\n                </div>\n            '),this.currentEvent=null}showEventDetails(t){if(this.currentEvent=t,!this.unifiedViewer)return console.warn("ModuleViewer: UnifiedDataViewer not available"),this.renderStructuredData(t),void this.renderJsonData(t);this.unifiedViewer.display(t,"event")}renderStructuredData(t){if(!this.dataContainer)return;const e=this.createContextualHeader(t),n=this.createEventStructuredView(t),s=this.createCollapsibleJsonSection(t);this.dataContainer.innerHTML=e+n+s,this.initializeJsonToggle()}renderJsonData(t){}ingest(t){Array.isArray(t)?t.length>0?this.showEventDetails(t[0]):this.showEmptyState():t&&"object"==typeof t?this.showEventDetails(t):this.showEmptyState()}updateEventsByClass(t){this.eventsByClass.clear(),t.forEach(t=>{const e=this.getEventClass(t);this.eventsByClass.has(e)||this.eventsByClass.set(e,[]),this.eventsByClass.get(e).push(t)})}getEventClass(t){if(!t.type)return"unknown";switch(t.type){case"session":return"Session Management";case"claude":return"Claude Interactions";case"agent":return"Agent Operations";case"hook":return"Hook System";case"todo":return"Task Management";case"memory":return"Memory Operations";case"log":return"System Logs";case"connection":return"Connection Events";default:return"Other Events"}}createContextualHeader(t){const e=this.formatTimestamp(t.timestamp),n=t.data||{};let s="";switch(t.type){case"hook":const o=this.extractToolName(n),a=this.extractAgent(t)||"Unknown";if(o)s=`${o}: ${a} ${e}`;else{s=`${this.getHookDisplayName(t,n)}: ${a} ${e}`}break;case"agent":s=`Agent: ${n.agent_type||n.name||"Unknown"} ${e}`;break;case"todo":s=`TodoWrite: ${this.extractAgent(t)||"PM"} ${e}`;break;case"memory":s=`Memory: ${n.operation||"Unknown"} ${e}`;break;case"session":case"claude":case"log":case"connection":s=`Event: ${t.type}.${t.subtype||"default"} ${e}`;break;default:const r=this.extractFileName(n);if(r)s=`File: ${r} ${e}`;else{s=`Event: ${t.type||"Unknown"}.${t.subtype||"default"} ${e}`}}return`\n            <div class="contextual-header">\n                <h3 class="contextual-header-text">${s}</h3>\n            </div>\n        `}createEventStructuredView(t){const e=this.getEventClass(t),n=(this.eventsByClass.get(e)||[]).length;let s=`\n            <div class="structured-view-section">\n                ${this.createEventDetailCard(t.type,t,n)}\n            </div>\n        `;switch(t.type){case"agent":s+=this.createAgentStructuredView(t);break;case"hook":"Task"===t.data?.tool_name&&t.data?.tool_parameters?.subagent_type?s+=this.createAgentStructuredView(t):s+=this.createHookStructuredView(t);break;case"todo":s+=this.createTodoStructuredView(t);break;case"memory":s+=this.createMemoryStructuredView(t);break;case"claude":s+=this.createClaudeStructuredView(t);break;case"session":s+=this.createSessionStructuredView(t);break;default:s+=this.createGenericStructuredView(t)}return s}createEventDetailCard(t,e,n){const s=new Date(e.timestamp).toLocaleString();return`\n            <div class="event-detail-card">\n                <div class="event-detail-header">\n                    <div class="event-detail-title">\n                        ${this.getEventIcon(t)} ${t||"Unknown"}.${e.subtype||"default"}\n                    </div>\n                    <div class="event-detail-time">${s}</div>\n                </div>\n                <div class="event-detail-content">\n                    ${this.createProperty("Event ID",e.id||"N/A")}\n                    ${this.createProperty("Type",`${t}.${e.subtype||"default"}`)}\n                    ${this.createProperty("Class Events",n)}\n                    ${e.data&&e.data.session_id?this.createProperty("Session",e.data.session_id):""}\n                </div>\n            </div>\n        `}createAgentStructuredView(t){const e=t.data||{};if("hook"===t.type&&"Task"===e.tool_name&&e.tool_parameters?.subagent_type){const n=e.tool_parameters;return`\n                <div class="structured-view-section">\n                    <div class="structured-data">\n                        ${this.createProperty("Agent Type",n.subagent_type)}\n                        ${this.createProperty("Task Type","Subagent Delegation")}\n                        ${this.createProperty("Phase",t.subtype||"pre_tool")}\n                        ${n.description?this.createProperty("Description",n.description):""}\n                        ${n.prompt?this.createProperty("Prompt Preview",this.truncateText(n.prompt,200)):""}\n                        ${e.session_id?this.createProperty("Session ID",e.session_id):""}\n                        ${e.working_directory?this.createProperty("Working Directory",e.working_directory):""}\n                    </div>\n                    ${n.prompt?`\n                        <div class="prompt-section">\n                            <div class="contextual-header">\n                                <h3 class="contextual-header-text">📝 Task Prompt</h3>\n                            </div>\n                            <div class="structured-data">\n                                <div class="task-prompt" style="white-space: pre-wrap; max-height: 300px; overflow-y: auto; padding: 10px; background: #f8fafc; border-radius: 6px; font-family: monospace; font-size: 12px; line-height: 1.4;">\n                                    ${n.prompt}\n                                </div>\n                            </div>\n                        </div>\n                    `:""}\n                </div>\n            `}return`\n            <div class="structured-view-section">\n                <div class="structured-data">\n                    ${this.createProperty("Agent Type",e.agent_type||e.subagent_type||"Unknown")}\n                    ${this.createProperty("Name",e.name||"N/A")}\n                    ${this.createProperty("Phase",t.subtype||"N/A")}\n                    ${e.config?this.createProperty("Config","object"==typeof e.config?Object.keys(e.config).join(", "):String(e.config)):""}\n                    ${e.capabilities?this.createProperty("Capabilities",e.capabilities.join(", ")):""}\n                    ${e.result?this.createProperty("Result","object"==typeof e.result?"[Object]":String(e.result)):""}\n                </div>\n            </div>\n        `}createHookStructuredView(t){const e=t.data||{},n=this.extractFilePathFromHook(e),s=this.extractToolInfoFromHook(e),o=this.createInlineToolResultContent(e,t);return`\n            <div class="structured-view-section">\n                <div class="structured-data">\n                    ${this.createProperty("Hook Name",this.getHookDisplayName(t,e))}\n                    ${this.createProperty("Event Type",e.event_type||t.subtype||"N/A")}\n                    ${n?this.createProperty("File Path",n):""}\n                    ${s.tool_name?this.createProperty("Tool",s.tool_name):""}\n                    ${s.operation_type?this.createProperty("Operation",s.operation_type):""}\n                    ${e.session_id?this.createProperty("Session ID",e.session_id):""}\n                    ${e.working_directory?this.createProperty("Working Directory",e.working_directory):""}\n                    ${e.duration_ms?this.createProperty("Duration",`${e.duration_ms}ms`):""}\n                    ${o}\n                </div>\n            </div>\n        `}createInlineToolResultContent(t,e=null){const n=t.result_summary,s=e?.subtype||t.event_type||t.phase,o="post_tool"===s||s?.includes("post");if(window.DEBUG_TOOL_RESULTS&&console.log("🔧 createInlineToolResultContent debug:",{hasResultSummary:!!n,eventPhase:s,isPostTool:o,eventSubtype:e?.subtype,dataEventType:t.event_type,dataPhase:t.phase,toolName:t.tool_name,resultSummaryKeys:n?Object.keys(n):[]}),!n)return"";if("pre_tool"===s||s?.includes("pre")&&!s?.includes("post"))return"";let a="";if(n.has_output&&n.output_preview&&(a+=`\n                ${this.createProperty("Output",this.truncateText(n.output_preview,200))}\n                ${n.output_lines?this.createProperty("Output Lines",n.output_lines):""}\n            `),n.has_error&&n.error_preview&&(a+=`\n                ${this.createProperty("Error",this.truncateText(n.error_preview,200))}\n            `),!n.has_output&&!n.has_error&&Object.keys(n).length>3){a+=Object.entries(n).filter(([t,e])=>!["has_output","has_error","exit_code"].includes(t)&&void 0!==e).map(([t,e])=>this.createProperty(this.formatFieldName(t),String(e))).join("")}return a}createToolResultSection(t,e=null){const n=t.result_summary,s=e?.subtype||t.event_type||t.phase,o="post_tool"===s||s?.includes("post");if(window.DEBUG_TOOL_RESULTS&&console.log("🔧 createToolResultSection debug:",{hasResultSummary:!!n,eventPhase:s,isPostTool:o,eventSubtype:e?.subtype,dataEventType:t.event_type,dataPhase:t.phase,toolName:t.tool_name,resultSummaryKeys:n?Object.keys(n):[]}),!n)return"";if("pre_tool"===s||s?.includes("pre")&&!s?.includes("post"))return"";let a="⏳",r="tool-running",i="Unknown";!0===t.success?(a="✅",r="tool-success",i="Success"):!1===t.success?(a="❌",r="tool-failure",i="Failed"):0===t.exit_code?(a="✅",r="tool-success",i="Completed"):2===t.exit_code?(a="⚠️",r="tool-blocked",i="Blocked"):void 0!==t.exit_code&&0!==t.exit_code&&(a="❌",r="tool-failure",i="Error");let l="";if(l+=`\n            <div class="tool-result-status ${r}">\n                <span class="tool-result-icon">${a}</span>\n                <span class="tool-result-text">${i}</span>\n                ${void 0!==t.exit_code?`<span class="tool-exit-code">Exit Code: ${t.exit_code}</span>`:""}\n            </div>\n        `,n.has_output&&n.output_preview&&(l+=`\n                <div class="tool-result-output">\n                    <div class="tool-result-label">📄 Output:</div>\n                    <div class="tool-result-preview">\n                        <pre>${this.escapeHtml(n.output_preview)}</pre>\n                    </div>\n                    ${n.output_lines?`<div class="tool-result-meta">Lines: ${n.output_lines}</div>`:""}\n                </div>\n            `),n.has_error&&n.error_preview&&(l+=`\n                <div class="tool-result-error">\n                    <div class="tool-result-label">⚠️ Error:</div>\n                    <div class="tool-result-preview error-preview">\n                        <pre>${this.escapeHtml(n.error_preview)}</pre>\n                    </div>\n                </div>\n            `),!n.has_output&&!n.has_error&&Object.keys(n).length>3){const t=Object.entries(n).filter(([t,e])=>!["has_output","has_error","exit_code"].includes(t)&&void 0!==e).map(([t,e])=>this.createProperty(this.formatFieldName(t),String(e))).join("");t&&(l+=`\n                    <div class="tool-result-other">\n                        <div class="tool-result-label">📊 Result Details:</div>\n                        <div class="structured-data">\n                            ${t}\n                        </div>\n                    </div>\n                `)}return l.trim()?`\n            <div class="tool-result-section">\n                <div class="contextual-header">\n                    <h3 class="contextual-header-text">🔧 Tool Result</h3>\n                </div>\n                <div class="tool-result-content">\n                    ${l}\n                </div>\n            </div>\n        `:""}isWriteOperation(t,e){if(["Write","Edit","MultiEdit","NotebookEdit"].includes(t))return!0;if(e.tool_parameters){const t=e.tool_parameters;if(t.content||t.new_string||t.edits)return!0;if(t.edit_mode&&"read"!==t.edit_mode)return!0}return!("post_tool"!==e.event_type&&"pre_tool"!==e.event_type||!t||!(t.toLowerCase().includes("write")||t.toLowerCase().includes("edit")||t.toLowerCase().includes("modify")))}isReadOnlyOperation(t){if(!t)return!0;const e=t.toLowerCase();return!!["read"].includes(e)||!["write","edit","multiedit","create","delete","move","copy"].includes(e)}createTodoStructuredView(t){const e=t.data||{};let n="";return e.todos&&Array.isArray(e.todos)&&(n+=`\n                <div class="todo-checklist">\n                    ${e.todos.map(t=>`\n                        <div class="todo-item todo-${t.status||"pending"}">\n                            <span class="todo-status">${this.getTodoStatusIcon(t.status)}</span>\n                            <span class="todo-content">${t.content||"No content"}</span>\n                            <span class="todo-priority priority-${t.priority||"medium"}">${this.getTodoPriorityIcon(t.priority)}</span>\n                        </div>\n                    `).join("")}\n                </div>\n            `),n}createMemoryStructuredView(t){const e=t.data||{};return`\n            <div class="structured-view-section">\n                <div class="structured-data">\n                    ${this.createProperty("Operation",e.operation||"Unknown")}\n                    ${this.createProperty("Key",e.key||"N/A")}\n                    ${e.value?this.createProperty("Value","object"==typeof e.value?"[Object]":String(e.value)):""}\n                    ${e.namespace?this.createProperty("Namespace",e.namespace):""}\n                    ${e.metadata?this.createProperty("Metadata","object"==typeof e.metadata?"[Object]":String(e.metadata)):""}\n                </div>\n            </div>\n        `}createClaudeStructuredView(t){const e=t.data||{};return`\n            <div class="structured-view-section">\n                <div class="structured-data">\n                    ${this.createProperty("Type",t.subtype||"N/A")}\n                    ${e.prompt?this.createProperty("Prompt",this.truncateText(e.prompt,200)):""}\n                    ${e.message?this.createProperty("Message",this.truncateText(e.message,200)):""}\n                    ${e.response?this.createProperty("Response",this.truncateText(e.response,200)):""}\n                    ${e.content?this.createProperty("Content",this.truncateText(e.content,200)):""}\n                    ${e.tokens?this.createProperty("Tokens",e.tokens):""}\n                    ${e.model?this.createProperty("Model",e.model):""}\n                </div>\n            </div>\n        `}createSessionStructuredView(t){const e=t.data||{};return`\n            <div class="structured-view-section">\n                <div class="structured-data">\n                    ${this.createProperty("Action",t.subtype||"N/A")}\n                    ${this.createProperty("Session ID",e.session_id||"N/A")}\n                    ${e.working_directory?this.createProperty("Working Dir",e.working_directory):""}\n                    ${e.git_branch?this.createProperty("Git Branch",e.git_branch):""}\n                    ${e.agent_type?this.createProperty("Agent Type",e.agent_type):""}\n                </div>\n            </div>\n        `}createGenericStructuredView(t){const e=t.data||{},n=Object.keys(e);return 0===n.length?"":`\n            <div class="structured-view-section">\n                <div class="structured-data">\n                    ${n.map(t=>this.createProperty(t,"object"==typeof e[t]?"[Object]":String(e[t]))).join("")}\n                </div>\n            </div>\n        `}createCollapsibleJsonSection(t){const e="json-section-"+Math.random().toString(36).substr(2,9),n=this.formatJSON(t),s=this.globalJsonExpanded;return`\n            <div class="collapsible-json-section" id="${e}">\n                <div class="json-toggle-header"\n                     onclick="window.moduleViewer.toggleJsonSection()"\n                     role="button"\n                     tabindex="0"\n                     aria-expanded="${s?"true":"false"}"\n                     onkeydown="if(event.key==='Enter'||event.key===' '){window.moduleViewer.toggleJsonSection();event.preventDefault();}">\n                    <span class="json-toggle-text">Raw JSON</span>\n                    <span class="json-toggle-arrow">${s?"▲":"▼"}</span>\n                </div>\n                <div class="json-content-collapsible" style="display: ${s?"block":"none"};" aria-hidden="${!s}">\n                    <div class="json-display" onclick="window.moduleViewer.copyJsonToClipboard(event)">\n                        <pre>${n}</pre>\n                    </div>\n                </div>\n            </div>\n        `}async copyJsonToClipboard(t){const e=t.currentTarget.getBoundingClientRect(),n=t.clientX-e.left,s=t.clientY-e.top;if(n>e.width-50&&s<30){const e=t.currentTarget.querySelector("pre");if(e)try{await navigator.clipboard.writeText(e.textContent),this.showNotification("JSON copied to clipboard","success")}catch(o){console.error("Failed to copy JSON:",o),this.showNotification("Failed to copy JSON","error")}t.stopPropagation()}}initializeJsonToggle(){window.moduleViewer=this,this.globalJsonExpanded&&setTimeout(()=>{this.updateAllJsonSections()},0),this.keyboardListenerAdded||(this.keyboardListenerAdded=!0,document.addEventListener("keydown",t=>{t.target.classList.contains("json-toggle-header")&&("Enter"!==t.key&&" "!==t.key||(this.toggleJsonSection(),t.preventDefault()))}))}toggleJsonSection(){this.globalJsonExpanded=!this.globalJsonExpanded,localStorage.setItem("dashboard-json-expanded",this.globalJsonExpanded.toString()),this.updateAllJsonSections(),document.dispatchEvent(new CustomEvent("jsonToggleChanged",{detail:{expanded:this.globalJsonExpanded}}))}updateAllJsonSections(){const t=document.querySelectorAll(".json-content-collapsible"),e=document.querySelectorAll(".json-toggle-arrow"),n=document.querySelectorAll(".json-toggle-header");t.forEach((t,s)=>{this.globalJsonExpanded?(t.style.display="block",t.setAttribute("aria-hidden","false"),e[s]&&(e[s].textContent="▲"),n[s]&&n[s].setAttribute("aria-expanded","true")):(t.style.display="none",t.setAttribute("aria-hidden","true"),e[s]&&(e[s].textContent="▼"),n[s]&&n[s].setAttribute("aria-expanded","false"))}),this.globalJsonExpanded&&t.length>0&&setTimeout(()=>{const e=t[0];e&&e.scrollIntoView({behavior:"smooth",block:"nearest"})},100)}createProperty(t,e){const n=this.truncateText(String(e),300);return this.isFilePathProperty(t,e)?`\n                <div class="event-property">\n                    <span class="event-property-key">${t}:</span>\n                    <span class="event-property-value">\n                        ${this.createClickableFilePath(e)}\n                    </span>\n                </div>\n            `:`\n            <div class="event-property">\n                <span class="event-property-key">${t}:</span>\n                <span class="event-property-value">${n}</span>\n            </div>\n        `}isFilePathProperty(t,e){if(["File Path","file_path","notebook_path","Full Path","Working Directory","working_directory"].some(e=>t.toLowerCase().includes(e.toLowerCase()))){const t=String(e);return t.length>0&&(t.includes("/")||t.includes("\\"))&&t.length<500}return!1}createClickableFilePath(t){const e=this.truncateText(String(t),300);return`\n            <span class="clickable-file-path"\n                  onclick="showFileViewerModal('${t.replace(/'/g,"\\'")}')"\n                  title="Click to view file contents with syntax highlighting&#10;Path: ${t}">\n                ${e}\n            </span>\n        `}getEventIcon(t){const e={session:"📱",claude:"🤖",agent:"🎯",hook:"🔗",todo:"✅",memory:"🧠",log:"📝",connection:"🔌",unknown:"❓"};return e[t]||e.unknown}getTodoStatusIcon(t){const e={completed:"✅",in_progress:"🔄",pending:"⏳",cancelled:"❌"};return e[t]||e.pending}getTodoPriorityIcon(t){const e={high:"🔴",medium:"🟡",low:"🟢"};return e[t]||e.medium}getHookDisplayName(t,e){if(e.hook_name)return e.hook_name;if(e.name)return e.name;const n=t.subtype||e.event_type,s={user_prompt:"User Prompt",pre_tool:"Tool Execution (Pre)",post_tool:"Tool Execution (Post)",notification:"Notification",stop:"Session Stop",subagent_stop:"Subagent Stop"};if(s[n])return s[n];if("string"==typeof t.type&&t.type.startsWith("hook.")){const e=t.type.replace("hook.","");if(s[e])return s[e]}return n?n.split("_").map(t=>t.charAt(0).toUpperCase()+t.slice(1)).join(" "):"Unknown Hook"}extractFilePathFromHook(t){return t.tool_parameters&&t.tool_parameters.file_path?t.tool_parameters.file_path:t.file_path?t.file_path:t.tool_input&&t.tool_input.file_path?t.tool_input.file_path:t.tool_parameters&&t.tool_parameters.notebook_path?t.tool_parameters.notebook_path:null}extractToolInfoFromHook(t){return{tool_name:t.tool_name||t.tool_parameters&&t.tool_parameters.tool_name,operation_type:t.operation_type||t.tool_parameters&&t.tool_parameters.operation_type}}truncateText(t,e){return!t||t.length<=e?t:t.substring(0,e)+"..."}formatOperationDetails(t){if(!t||"object"!=typeof t)return"";let e="";if(t.parameters&&t.parameters.command&&(e+=`<br><strong>Command:</strong> <code>${this.escapeHtml(t.parameters.command)}</code>`),void 0!==t.success&&(e+="<br><strong>Status:</strong> "+(t.success?"✅ Success":"❌ Failed")),void 0!==t.exit_code&&null!==t.exit_code&&(e+=`<br><strong>Exit Code:</strong> ${t.exit_code}`),void 0!==t.duration_ms&&null!==t.duration_ms){e+=`<br><strong>Duration:</strong> ${t.duration_ms>1e3?`${(t.duration_ms/1e3).toFixed(2)}s`:`${t.duration_ms}ms`}`}return t.error&&(e+=`<br><strong>Error:</strong> ${this.escapeHtml(this.truncateText(t.error,200))}`),e}escapeHtml(t){if(!t)return"";const e=document.createElement("div");return e.textContent=t,e.innerHTML}formatJSON(t){try{return JSON.stringify(t,null,2)}catch(e){return String(t)}}formatTimestamp(t){if(!t)return"Unknown time";try{return new Date(t).toLocaleTimeString("en-US",{hour:"numeric",minute:"2-digit",second:"2-digit",hour12:!0})}catch(e){return"Invalid time"}}escapeHtml(t){if(!t)return"";const e=document.createElement("div");return e.textContent=t,e.innerHTML}formatFieldName(t){return t.split("_").map(t=>t.charAt(0).toUpperCase()+t.slice(1)).join(" ")}extractToolName(t){if(t.tool_name)return t.tool_name;if(t.tool_parameters&&t.tool_parameters.tool_name)return t.tool_parameters.tool_name;if(t.tool_input&&t.tool_input.tool_name)return t.tool_input.tool_name;if(t.tool_parameters){if(t.tool_parameters.file_path||t.tool_parameters.notebook_path)return"FileOperation";if(t.tool_parameters.pattern)return"Search";if(t.tool_parameters.command)return"Bash";if(t.tool_parameters.todos)return"TodoWrite"}return null}extractAgent(t){if(t._agentName&&"Unknown Agent"!==t._agentName)return t._agentName;if(t._inference&&t._inference.agentName&&"Unknown"!==t._inference.agentName)return t._inference.agentName;if(t.agent)return t.agent;if(t.agent_type)return t.agent_type;if(t.agent_name)return t.agent_name;if(t.session_id&&"string"==typeof t.session_id){const e=t.session_id.split("_");if(e.length>1)return e[0].toUpperCase()}return t.todos||"TodoWrite"===t.tool_name?"PM":null}extractFileName(t){const e=this.extractFilePathFromHook(t);if(e){const t=e.split("/");return t[t.length-1]}return t.filename?t.filename:t.file?t.file:null}clear(){this.unifiedViewer&&this.unifiedViewer.clear(),this.showEmptyState()}showToolCall(t,e){if(!t)return void this.showEmptyState();const n=t.tool_name||"Unknown Tool",s=t.agent_type||"PM",o=this.formatTimestamp(t.timestamp),a=t.pre_event,r=t.post_event,i=a?.tool_parameters||{},l=a?this.extractToolTarget(n,i):"Unknown target",c=t.duration_ms?`${t.duration_ms}ms`:"-",d=void 0!==t.success?t.success:null;void 0!==t.exit_code&&t.exit_code;let p=t.result_summary||"No summary available";if("object"==typeof p&&null!==p){const t=[];void 0!==p.exit_code&&t.push(`Exit Code: ${p.exit_code}`),void 0!==p.has_output&&t.push("Has Output: "+(p.has_output?"Yes":"No")),void 0!==p.has_error&&t.push("Has Error: "+(p.has_error?"Yes":"No")),void 0!==p.output_lines&&t.push(`Output Lines: ${p.output_lines}`),p.output_preview&&t.push(`Output Preview: ${p.output_preview}`),p.error_preview&&t.push(`Error Preview: ${p.error_preview}`)}let u="⏳",m="Running...",h="tool-running";r&&(!0===d?(u="✅",m="Success",h="tool-success"):!1===d?(u="❌",m="Failed",h="tool-failure"):(u="⏳",m="Completed",h="tool-completed"));const g=`\n            <div class="contextual-header">\n                <h3 class="contextual-header-text">${n}: ${s} ${o}</h3>\n            </div>\n        `;if("TodoWrite"===n&&i.todos){const e=`\n                <div class="todo-checklist">\n                    ${i.todos.map(t=>{const e=this.getTodoStatusIcon(t.status),n=this.getTodoPriorityIcon(t.priority);return`\n                            <div class="todo-item todo-${t.status||"pending"}">\n                                <span class="todo-status">${e}</span>\n                                <span class="todo-content">${t.content||"No content"}</span>\n                                <span class="todo-priority priority-${t.priority||"medium"}">${n}</span>\n                            </div>\n                        `}).join("")}\n                </div>\n            `,n={toolCall:t,preEvent:a,postEvent:r},s=this.createCollapsibleJsonSection(n);this.dataContainer&&(this.dataContainer.innerHTML=g+e+s),this.initializeJsonToggle()}else if("Grep"===n||"Search"===n||i&&i.pattern&&!i.file_path){const e=i.pattern||"No pattern specified",o=i.path||i.directory||".",l=i.type||i.glob||"all files";let d="";t.result_summary&&(d="string"==typeof t.result_summary?t.result_summary:t.result_summary.output_preview?t.result_summary.output_preview:JSON.stringify(t.result_summary,null,2));const p=`\n                <div class="structured-view-section">\n                    <div class="tool-call-details">\n                        <div class="tool-call-info ${h}">\n                            <div class="structured-field">\n                                <strong>Tool Name:</strong> ${n}\n                            </div>\n                            <div class="structured-field">\n                                <strong>Agent:</strong> ${s}\n                            </div>\n                            <div class="structured-field">\n                                <strong>Status:</strong> ${u} ${m}\n                            </div>\n                            <div class="structured-field">\n                                <strong>Search Pattern:</strong> <code>${e}</code>\n                            </div>\n                            <div class="structured-field">\n                                <strong>Search Path:</strong> ${o}\n                            </div>\n                            <div class="structured-field">\n                                <strong>File Type:</strong> ${l}\n                            </div>\n                            <div class="structured-field">\n                                <strong>Started:</strong> ${new Date(t.timestamp).toLocaleString()}\n                            </div>\n                            ${c&&"-"!==c?`\n                                <div class="structured-field">\n                                    <strong>Duration:</strong> ${c}\n                                </div>\n                            `:""}\n                        </div>\n\n                        <div class="search-view-action" style="margin-top: 20px;">\n                            <button class="btn-view-search" data-search-params='${JSON.stringify(i)}' data-search-results='${JSON.stringify(d).replace(/'/g,"&#39;")}' onclick="window.showSearchViewerModal(JSON.parse(this.getAttribute('data-search-params')), JSON.parse(this.getAttribute('data-search-results')))">\n                                🔍 View Search Details\n                            </button>\n                        </div>\n\n                        ${this.createToolResultFromToolCall(t)}\n                    </div>\n                </div>\n            `,v={toolCall:t,preEvent:a,postEvent:r},y=this.createCollapsibleJsonSection(v);this.dataContainer&&(this.dataContainer.innerHTML=g+p+y),this.initializeJsonToggle()}else{const e=`\n                <div class="structured-view-section">\n                    <div class="tool-call-details">\n                        <div class="tool-call-info ${h}">\n                            <div class="structured-field">\n                                <strong>Tool Name:</strong> ${n}\n                            </div>\n                            <div class="structured-field">\n                                <strong>Agent:</strong> ${s}\n                            </div>\n                            <div class="structured-field">\n                                <strong>Status:</strong> ${u} ${m}\n                            </div>\n                            <div class="structured-field">\n                                <strong>Target:</strong> ${l}\n                            </div>\n                            <div class="structured-field">\n                                <strong>Started:</strong> ${new Date(t.timestamp).toLocaleString()}\n                            </div>\n                            ${c&&"-"!==c?`\n                                <div class="structured-field">\n                                    <strong>Duration:</strong> ${c}\n                                </div>\n                            `:""}\n                            ${t.session_id?`\n                                <div class="structured-field">\n                                    <strong>Session ID:</strong> ${t.session_id}\n                                </div>\n                            `:""}\n                        </div>\n\n                        ${this.createToolResultFromToolCall(t)}\n                    </div>\n                </div>\n            `,o={toolCall:t,preEvent:a,postEvent:r},i=this.createCollapsibleJsonSection(o);this.dataContainer&&(this.dataContainer.innerHTML=g+e+i),this.initializeJsonToggle()}}showFileOperations(e,n){if(!e||!n)return void this.showEmptyState();this.unifiedViewer||(this.unifiedViewer=new t("module-data-content"));const s={file_path:n,operations:e.operations||[],lastOperation:e.lastOperation,...e};this.unifiedViewer.display(s,"file_operation");const o=document.querySelector(".module-data-header h5");if(o){const t=n.split("/").pop()||n;o.textContent=`📄 File: ${t}`}this.checkAndShowTrackControl(n)}showErrorMessage(t,e){const n=`\n            <div class="module-error">\n                <div class="error-header">\n                    <h3>❌ ${t}</h3>\n                </div>\n                <div class="error-message">\n                    <p>${e}</p>\n                </div>\n            </div>\n        `,s={title:t,message:e},o=this.createCollapsibleJsonSection(s);this.dataContainer&&(this.dataContainer.innerHTML=n+o),this.initializeJsonToggle()}showAgentEvent(t,e){this.showAgentSpecificDetails(t,e)}showAgentSpecificDetails(t,e){if(!t)return void this.showEmptyState();const n=window.dashboard?.agentInference,s=window.dashboard?.eventViewer;if(!n||!s)return console.warn("AgentInference or EventViewer not available, falling back to single event view"),void this.showEventDetails(t);const o=n.getInferredAgentForEvent(t),a=o?.agentName||this.extractAgent(t)||"Unknown",r=s.events||[],i=this.getAgentSpecificEvents(r,a,n);console.log(`Showing details for agent: ${a}, found ${i.length} related events`);const l=this.extractAgentSpecificData(a,i);this.renderAgentSpecificView(a,l,t)}getAgentSpecificEvents(t,e,n){return t.filter(t=>{const s=n.getInferredAgentForEvent(t);return(s?.agentName||this.extractAgent(t)||"Unknown").toLowerCase()===e.toLowerCase()})}extractAgentSpecificData(t,e){const n={agentName:t,totalEvents:e.length,prompt:null,todos:[],toolsCalled:[],sessions:new Set,firstSeen:null,lastSeen:null,eventTypes:new Set};return e.forEach(e=>{const s=e.data||{},o=new Date(e.timestamp);(!n.firstSeen||o<n.firstSeen)&&(n.firstSeen=o),(!n.lastSeen||o>n.lastSeen)&&(n.lastSeen=o),(e.session_id||s.session_id)&&n.sessions.add(e.session_id||s.session_id);const a=e.hook_event_name||e.type||"unknown";if(n.eventTypes.add(a),"hook"===e.type&&"Task"===s.tool_name&&s.tool_parameters){const e=s.tool_parameters;e.prompt&&!n.prompt&&(n.prompt=e.prompt),e.description&&!n.description&&(n.description=e.description),e.subagent_type===t&&e.prompt&&(n.prompt=e.prompt)}if(!s.prompt||s.agent_type!==t&&s.subagent_type!==t||(n.prompt=s.prompt),"todo"===e.type||"hook"===e.type&&"TodoWrite"===s.tool_name){const t=s.todos||s.tool_parameters?.todos;t&&Array.isArray(t)&&t.forEach(t=>{const e=n.todos.findIndex(e=>e.id===t.id||e.content===t.content);e>=0?n.todos[e]={...n.todos[e],...t,timestamp:o}:n.todos.push({...t,timestamp:o})})}if("hook"===e.type&&s.tool_name){const t=e.subtype||s.event_type,a=this.generateToolCallId(s.tool_name,s.tool_parameters,o);"pre_tool"===t?(n._preToolEvents||(n._preToolEvents=new Map),n._preToolEvents.set(a,{toolName:s.tool_name,timestamp:o,target:this.extractToolTarget(s.tool_name,s.tool_parameters,null),parameters:s.tool_parameters})):"post_tool"===t&&(n._postToolEvents||(n._postToolEvents=new Map),n._postToolEvents.set(a,{toolName:s.tool_name,timestamp:o,success:s.success,duration:s.duration_ms,resultSummary:s.result_summary,exitCode:s.exit_code}))}}),n.todos.sort((t,e)=>(e.timestamp||0)-(t.timestamp||0)),n.toolsCalled=this.consolidateToolCalls(n._preToolEvents,n._postToolEvents),delete n._preToolEvents,delete n._postToolEvents,n.toolsCalled.sort((t,e)=>e.timestamp-t.timestamp),n}generateToolCallId(t,e,n){const s=Math.floor(n.getTime()/5e3);let o="";if(e){const t=[];e.file_path&&t.push(e.file_path),e.command&&t.push(e.command.substring(0,50)),e.pattern&&t.push(e.pattern),e.subagent_type&&t.push(e.subagent_type),e.notebook_path&&t.push(e.notebook_path),e.url&&t.push(e.url),e.prompt&&t.push(e.prompt.substring(0,30)),o=t.join("|")}return o||(o="default"),`${t}:${s}:${o}`}consolidateToolCalls(t,e){const n=[],s=new Set;t||(t=new Map),e||(e=new Map);for(const[o,a]of t){if(s.has(o))continue;const t=e.get(o),r={toolName:a.toolName,timestamp:a.timestamp,target:a.target,parameters:a.parameters,status:this.determineToolCallStatus(a,t),statusIcon:this.getToolCallStatusIcon(a,t),phase:t?"completed":"running"};t&&(r.success=t.success,r.duration=t.duration,r.resultSummary=t.resultSummary,r.exitCode=t.exitCode,r.completedAt=t.timestamp),n.push(r),s.add(o)}for(const[o,a]of e){if(s.has(o))continue;const t={toolName:a.toolName,timestamp:a.timestamp,target:"Unknown target",parameters:null,status:this.determineToolCallStatus(null,a),statusIcon:this.getToolCallStatusIcon(null,a),phase:"completed",success:a.success,duration:a.duration,resultSummary:a.resultSummary,exitCode:a.exitCode,completedAt:a.timestamp};n.push(t),s.add(o)}return n}determineToolCallStatus(t,e){return e?!0===e.success?"Success":!1===e.success?"Failed":0===e.exitCode?"Completed":2===e.exitCode?"Blocked":void 0!==e.exitCode&&0!==e.exitCode?"Error":"Completed":"Running..."}getToolCallStatusIcon(t,e){return e?!0===e.success?"✅":!1===e.success?"❌":0===e.exitCode?"✅":2===e.exitCode?"⚠️":void 0!==e.exitCode&&0!==e.exitCode?"❌":"✅":"⏳"}estimateTokenCount(t){if(!t||"string"!=typeof t)return 0;const e=t.trim().split(/\s+/).length,n=Math.ceil(t.length/4);return Math.max(1.3*e,n)}trimPromptWhitespace(t){return t&&"string"==typeof t?t=(t=(t=t.trim()).replace(/\n\s*\n\s*\n+/g,"\n\n")).split("\n").map(t=>t.replace(/\s+$/,"")).join("\n"):""}renderAgentSpecificView(t,e,n){const s=this.formatTimestamp(n.timestamp),o=`\n            <div class="contextual-header">\n                <h3 class="contextual-header-text">🤖 ${t} Agent Details ${s}</h3>\n            </div>\n        `;let a=`\n            <div class="agent-overview-section">\n                <div class="structured-data">\n                    ${this.createProperty("Agent Name",t)}\n                    ${this.createProperty("Total Events",e.totalEvents)}\n                    ${this.createProperty("Active Sessions",e.sessions.size)}\n                    ${this.createProperty("Event Types",Array.from(e.eventTypes).join(", "))}\n                    ${e.firstSeen?this.createProperty("First Seen",e.firstSeen.toLocaleString()):""}\n                    ${e.lastSeen?this.createProperty("Last Seen",e.lastSeen.toLocaleString()):""}\n                </div>\n            </div>\n        `;if(e.prompt){const t=this.trimPromptWhitespace(e.prompt);a+=`\n                <div class="agent-prompt-section">\n                    <div class="contextual-header">\n                        <h3 class="contextual-header-text">📝 Agent Task Prompt</h3>\n                        <div class="prompt-stats" style="font-size: 11px; color: #64748b; margin-top: 4px;">\n                            ~${Math.round(this.estimateTokenCount(t))} tokens • ${t.trim().split(/\s+/).length} words • ${t.length} characters\n                        </div>\n                    </div>\n                    <div class="structured-data">\n                        <div class="agent-prompt" style="white-space: pre-wrap; max-height: 300px; overflow-y: auto; padding: 10px; background: #f8fafc; border-radius: 6px; font-family: monospace; font-size: 12px; line-height: 1.4; border: 1px solid #e2e8f0;">\n                            ${this.escapeHtml(t)}\n                        </div>\n                    </div>\n                </div>\n            `}e.todos.length>0&&(a+=`\n                <div class="agent-todos-section">\n                    <div class="contextual-header">\n                        <h3 class="contextual-header-text">✅ Agent Todo List (${e.todos.length} items)</h3>\n                    </div>\n                    <div class="todo-checklist">\n                        ${e.todos.map(t=>`\n                            <div class="todo-item todo-${t.status||"pending"}">\n                                <span class="todo-status">${this.getTodoStatusIcon(t.status)}</span>\n                                <span class="todo-content">${t.content||"No content"}</span>\n                                <span class="todo-priority priority-${t.priority||"medium"}">${this.getTodoPriorityIcon(t.priority)}</span>\n                                ${t.timestamp?`<span class="todo-timestamp">${new Date(t.timestamp).toLocaleTimeString()}</span>`:""}\n                            </div>\n                        `).join("")}\n                    </div>\n                </div>\n            `),e.toolsCalled.length>0&&(a+=`\n                <div class="agent-tools-section">\n                    <div class="contextual-header">\n                        <h3 class="contextual-header-text">🔧 Tools Called by Agent (${e.toolsCalled.length} calls)</h3>\n                    </div>\n                    <div class="tools-list">\n                        ${e.toolsCalled.map(e=>{let n="";return"✅"===e.statusIcon?n="status-success":"❌"===e.statusIcon?n="status-failed":"⚠️"===e.statusIcon?n="status-blocked":"⏳"===e.statusIcon&&(n="status-running"),`\n                                <div class="tool-call-item">\n                                    <div class="tool-call-header">\n                                        <div style="display: flex; align-items: center; gap: 12px; flex: 1;">\n                                            <span class="tool-name">🔧 ${e.toolName}</span>\n                                            <span class="tool-agent">${t}</span>\n                                            <span class="tool-status-indicator ${n}">${e.statusIcon} ${e.status}</span>\n                                        </div>\n                                        <span class="tool-timestamp" style="margin-left: auto;">${e.timestamp.toLocaleTimeString()}</span>\n                                    </div>\n                                    <div class="tool-call-details">\n                                        ${e.target?`<span class="tool-target">Target: ${e.target}</span>`:""}\n                                        ${e.duration?`<span class="tool-duration">Duration: ${e.duration}ms</span>`:""}\n                                        ${e.completedAt&&e.completedAt!==e.timestamp?`<span class="tool-completed">Completed: ${e.completedAt.toLocaleTimeString()}</span>`:""}\n                                    </div>\n                                </div>\n                            `}).join("")}\n                    </div>\n                </div>\n            `);const r={agentName:t,agentData:e,originalEvent:n},i=this.createCollapsibleJsonSection(r);this.dataContainer&&(this.dataContainer.innerHTML=o+a+i),this.initializeJsonToggle()}createToolResultFromToolCall(t){if(!t.result_summary)return"";const e={event_type:"post_tool",result_summary:t.result_summary,success:t.success,exit_code:t.exit_code},n=this.createInlineToolResultContent(e,{subtype:"post_tool"});return n.trim()?`\n                <div class="tool-result-inline">\n                    <div class="structured-data">\n                        ${n}\n                    </div>\n                </div>\n            `:""}extractToolTarget(t,e,n){const s=e||n||{};switch(t?.toLowerCase()){case"write":case"read":case"edit":case"multiedit":return s.file_path||"Unknown file";case"bash":return s.command?`${s.command.substring(0,50)}${s.command.length>50?"...":""}`:"Unknown command";case"grep":return s.pattern?`Pattern: ${s.pattern}`:"Unknown pattern";case"glob":return s.pattern?`Pattern: ${s.pattern}`:"Unknown glob";case"todowrite":return`${s.todos?.length||0} todos`;case"task":return s.subagent_type||s.agent_type||"Subagent delegation";default:return s.file_path?s.file_path:s.pattern?`Pattern: ${s.pattern}`:s.command?`Command: ${s.command.substring(0,30)}...`:s.path?s.path:"Unknown target"}}getOperationIcon(t){return{read:"👁️",write:"✏️",edit:"📝",multiedit:"📝",create:"🆕",delete:"🗑️",move:"📦",copy:"📋"}[t?.toLowerCase()]||"📄"}getCurrentEvent(){return this.currentEvent}async checkAndShowTrackControl(t){if(t)try{const e=window.socket||window.dashboard?.socketClient?.socket;if(!e)return void console.warn("No socket connection available for git tracking check");let n=window.dashboard?.currentWorkingDir;if(!n||"Unknown"===n||""===n.trim()){const t=document.getElementById("footer-working-dir");n=t?.textContent?.trim()&&"Unknown"!==t.textContent.trim()?t.textContent.trim():".",console.log("[MODULE-VIEWER-DEBUG] Working directory fallback used:",n)}const s=new Promise((n,s)=>{const o=s=>{s.file_path===t&&(e.off("file_tracked_response",o),n(s))};e.on("file_tracked_response",o),setTimeout(()=>{e.off("file_tracked_response",o),s(new Error("Request timeout"))},5e3)});e.emit("check_file_tracked",{file_path:t,working_dir:n});const o=await s;this.displayTrackingStatus(t,o)}catch(e){console.error("Error checking file tracking status:",e),this.displayTrackingStatus(t,{success:!1,error:e.message,file_path:t})}}displayTrackingStatus(t,e){const n=`git-track-status-${t.replace(/[^a-zA-Z0-9]/g,"-")}`,s=document.getElementById(n);s&&(e.success&&!1===e.is_tracked?s.innerHTML=`\n                <div class="untracked-file-notice">\n                    <span class="untracked-icon">⚠️</span>\n                    <span class="untracked-text">This file is not tracked by git</span>\n                    <button class="track-file-button"\n                            onclick="window.moduleViewer.trackFile('${t}')"\n                            title="Add this file to git tracking">\n                        <span class="git-icon">📁</span> Track File\n                    </button>\n                </div>\n            `:e.success&&!0===e.is_tracked?s.innerHTML='\n                <div class="tracked-file-notice">\n                    <span class="tracked-icon">✅</span>\n                    <span class="tracked-text">This file is tracked by git</span>\n                </div>\n            ':e.success||(s.innerHTML=`\n                <div class="tracking-error-notice">\n                    <span class="error-icon">❌</span>\n                    <span class="error-text">Could not check git status: ${e.error||"Unknown error"}</span>\n                </div>\n            `))}async trackFile(t){if(t)try{const e=window.socket||window.dashboard?.socketClient?.socket;if(!e)return void console.warn("No socket connection available for git add");let n=window.dashboard?.currentWorkingDir;if(!n||"Unknown"===n||""===n.trim()){const t=document.getElementById("footer-working-dir");n=t?.textContent?.trim()&&"Unknown"!==t.textContent.trim()?t.textContent.trim():".",console.log("[MODULE-VIEWER-DEBUG] Working directory fallback used:",n)}const s=`git-track-status-${t.replace(/[^a-zA-Z0-9]/g,"-")}`,o=document.getElementById(s);o&&(o.innerHTML='\n                    <div class="tracking-file-notice">\n                        <span class="loading-icon">⏳</span>\n                        <span class="loading-text">Adding file to git tracking...</span>\n                    </div>\n                ');const a=new Promise((n,s)=>{const o=s=>{s.file_path===t&&(e.off("git_add_response",o),n(s))};e.on("git_add_response",o),setTimeout(()=>{e.off("git_add_response",o),s(new Error("Request timeout"))},1e4)});e.emit("git_add_file",{file_path:t,working_dir:n}),console.log("📁 Git add request sent:",{filePath:t,workingDir:n});const r=await a;console.log("📦 Git add result:",r),r.success?(o&&(o.innerHTML='\n                        <div class="tracked-file-notice">\n                            <span class="tracked-icon">✅</span>\n                            <span class="tracked-text">File successfully added to git tracking</span>\n                        </div>\n                    '),this.showNotification("File tracked successfully","success")):(o&&(o.innerHTML=`\n                        <div class="tracking-error-notice">\n                            <span class="error-icon">❌</span>\n                            <span class="error-text">Failed to track file: ${r.error||"Unknown error"}</span>\n                            <button class="track-file-button"\n                                    onclick="window.moduleViewer.trackFile('${t}')"\n                                    title="Try again">\n                                <span class="git-icon">📁</span> Retry\n                            </button>\n                        </div>\n                    `),this.showNotification(`Failed to track file: ${r.error}`,"error"))}catch(e){console.error("❌ Failed to track file:",e);const n=`git-track-status-${t.replace(/[^a-zA-Z0-9]/g,"-")}`,s=document.getElementById(n);s&&(s.innerHTML=`\n                    <div class="tracking-error-notice">\n                        <span class="error-icon">❌</span>\n                        <span class="error-text">Error: ${e.message}</span>\n                        <button class="track-file-button"\n                                onclick="window.moduleViewer.trackFile('${t}')"\n                                title="Try again">\n                            <span class="git-icon">📁</span> Retry\n                        </button>\n                    </div>\n                `),this.showNotification(`Error tracking file: ${e.message}`,"error")}}showNotification(t,e="info"){const n=document.createElement("div");n.className=`notification notification-${e}`,n.innerHTML=`\n            <span class="notification-icon">${"success"===e?"✅":"error"===e?"❌":"ℹ️"}</span>\n            <span class="notification-message">${t}</span>\n        `,n.style.cssText=`\n            position: fixed;\n            top: 20px;\n            right: 20px;\n            background: ${"success"===e?"#d4edda":"error"===e?"#f8d7da":"#d1ecf1"};\n            color: ${"success"===e?"#155724":"error"===e?"#721c24":"#0c5460"};\n            border: 1px solid ${"success"===e?"#c3e6cb":"error"===e?"#f5c6cb":"#bee5eb"};\n            border-radius: 6px;\n            padding: 12px 16px;\n            font-size: 14px;\n            font-weight: 500;\n            z-index: 2000;\n            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);\n            display: flex;\n            align-items: center;\n            gap: 8px;\n            max-width: 400px;\n            animation: slideIn 0.3s ease-out;\n        `;const s=document.createElement("style");s.textContent="\n            @keyframes slideIn {\n                from { transform: translateX(100%); opacity: 0; }\n                to { transform: translateX(0); opacity: 1; }\n            }\n            @keyframes slideOut {\n                from { transform: translateX(0); opacity: 1; }\n                to { transform: translateX(100%); opacity: 0; }\n            }\n        ",document.head.appendChild(s),document.body.appendChild(n),setTimeout(()=>{n.style.animation="slideOut 0.3s ease-in",setTimeout(()=>{n.parentNode&&n.parentNode.removeChild(n),s.parentNode&&s.parentNode.removeChild(s)},300)},5e3)}showAgentInstance(t){if(!t)return void this.showEmptyState();const e={type:"pm_delegation",subtype:t.agentName,agent_type:t.agentName,timestamp:t.timestamp,session_id:t.sessionId,metadata:{delegation_type:"explicit",event_count:t.agentEvents.length,pm_call:t.pmCall||null,agent_events:t.agentEvents}};console.log("Showing PM delegation details:",t),this.showAgentSpecificDetails(e,0)}showImpliedAgent(t){if(!t)return void this.showEmptyState();const e={type:"implied_delegation",subtype:t.agentName,agent_type:t.agentName,timestamp:t.timestamp,session_id:t.sessionId,metadata:{delegation_type:"implied",event_count:t.eventCount,pm_call:null,note:"No explicit PM call found - inferred from agent activity"}};console.log("Showing implied agent details:",t),this.showAgentSpecificDetails(e,0)}}window.ModuleViewer=e,window.enableToolResultDebugging=function(){window.DEBUG_TOOL_RESULTS=!0,console.log("🔧 Tool result debugging enabled. Click on tool events to see debug info.")},window.disableToolResultDebugging=function(){window.DEBUG_TOOL_RESULTS=!1,console.log("🔧 Tool result debugging disabled.")};export{e as M};
//# sourceMappingURL=module-viewer.js.map
