# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ApplicationOidcArgs', 'ApplicationOidc']

@pulumi.input_type
class ApplicationOidcArgs:
    def __init__(__self__, *,
                 grant_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 project_id: pulumi.Input[str],
                 redirect_uris: pulumi.Input[Sequence[pulumi.Input[str]]],
                 response_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 access_token_role_assertion: Optional[pulumi.Input[bool]] = None,
                 access_token_type: Optional[pulumi.Input[str]] = None,
                 additional_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_type: Optional[pulumi.Input[str]] = None,
                 auth_method_type: Optional[pulumi.Input[str]] = None,
                 clock_skew: Optional[pulumi.Input[str]] = None,
                 dev_mode: Optional[pulumi.Input[bool]] = None,
                 id_token_role_assertion: Optional[pulumi.Input[bool]] = None,
                 id_token_userinfo_assertion: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 post_logout_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ApplicationOidc resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_types: Grant types, supported values: OIDC*GRANT*TYPE*AUTHORIZATION*CODE, OIDC*GRANT*TYPE*IMPLICIT, OIDC*GRANT*TYPE*REFRESH*TOKEN, OIDC*GRANT*TYPE*DEVICE_CODE
        :param pulumi.Input[str] project_id: ID of the project
        :param pulumi.Input[Sequence[pulumi.Input[str]]] redirect_uris: RedirectURIs
        :param pulumi.Input[Sequence[pulumi.Input[str]]] response_types: Response type, supported values: OIDC*RESPONSE*TYPE*CODE, OIDC*RESPONSE*TYPE*ID*TOKEN, OIDC*RESPONSE*TYPE*ID*TOKEN*TOKEN
        :param pulumi.Input[bool] access_token_role_assertion: Access token role assertion
        :param pulumi.Input[str] access_token_type: Access token type, supported values: OIDC*TOKEN*TYPE*BEARER, OIDC*TOKEN*TYPE*JWT
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_origins: Additional origins
        :param pulumi.Input[str] app_type: App type, supported values: OIDC*APP*TYPE*WEB, OIDC*APP*TYPE*USER*AGENT, OIDC*APP*TYPE*NATIVE
        :param pulumi.Input[str] auth_method_type: Auth method type, supported values: OIDC*AUTH*METHOD*TYPE*BASIC, OIDC*AUTH*METHOD*TYPE*POST, OIDC*AUTH*METHOD*TYPE*NONE, OIDC*AUTH*METHOD*TYPE*PRIVATE*KEY*JWT
        :param pulumi.Input[str] clock_skew: Clockskew
        :param pulumi.Input[bool] dev_mode: Dev mode
        :param pulumi.Input[bool] id_token_role_assertion: ID token role assertion
        :param pulumi.Input[bool] id_token_userinfo_assertion: Token userinfo assertion
        :param pulumi.Input[str] name: Name of the application
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[Sequence[pulumi.Input[str]]] post_logout_redirect_uris: Post logout redirect URIs
        :param pulumi.Input[str] version: Version, supported values: OIDC*VERSION*1_0
        """
        ApplicationOidcArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            grant_types=grant_types,
            project_id=project_id,
            redirect_uris=redirect_uris,
            response_types=response_types,
            access_token_role_assertion=access_token_role_assertion,
            access_token_type=access_token_type,
            additional_origins=additional_origins,
            app_type=app_type,
            auth_method_type=auth_method_type,
            clock_skew=clock_skew,
            dev_mode=dev_mode,
            id_token_role_assertion=id_token_role_assertion,
            id_token_userinfo_assertion=id_token_userinfo_assertion,
            name=name,
            org_id=org_id,
            post_logout_redirect_uris=post_logout_redirect_uris,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             grant_types: pulumi.Input[Sequence[pulumi.Input[str]]],
             project_id: pulumi.Input[str],
             redirect_uris: pulumi.Input[Sequence[pulumi.Input[str]]],
             response_types: pulumi.Input[Sequence[pulumi.Input[str]]],
             access_token_role_assertion: Optional[pulumi.Input[bool]] = None,
             access_token_type: Optional[pulumi.Input[str]] = None,
             additional_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             app_type: Optional[pulumi.Input[str]] = None,
             auth_method_type: Optional[pulumi.Input[str]] = None,
             clock_skew: Optional[pulumi.Input[str]] = None,
             dev_mode: Optional[pulumi.Input[bool]] = None,
             id_token_role_assertion: Optional[pulumi.Input[bool]] = None,
             id_token_userinfo_assertion: Optional[pulumi.Input[bool]] = None,
             name: Optional[pulumi.Input[str]] = None,
             org_id: Optional[pulumi.Input[str]] = None,
             post_logout_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             version: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'grantTypes' in kwargs:
            grant_types = kwargs['grantTypes']
        if 'projectId' in kwargs:
            project_id = kwargs['projectId']
        if 'redirectUris' in kwargs:
            redirect_uris = kwargs['redirectUris']
        if 'responseTypes' in kwargs:
            response_types = kwargs['responseTypes']
        if 'accessTokenRoleAssertion' in kwargs:
            access_token_role_assertion = kwargs['accessTokenRoleAssertion']
        if 'accessTokenType' in kwargs:
            access_token_type = kwargs['accessTokenType']
        if 'additionalOrigins' in kwargs:
            additional_origins = kwargs['additionalOrigins']
        if 'appType' in kwargs:
            app_type = kwargs['appType']
        if 'authMethodType' in kwargs:
            auth_method_type = kwargs['authMethodType']
        if 'clockSkew' in kwargs:
            clock_skew = kwargs['clockSkew']
        if 'devMode' in kwargs:
            dev_mode = kwargs['devMode']
        if 'idTokenRoleAssertion' in kwargs:
            id_token_role_assertion = kwargs['idTokenRoleAssertion']
        if 'idTokenUserinfoAssertion' in kwargs:
            id_token_userinfo_assertion = kwargs['idTokenUserinfoAssertion']
        if 'orgId' in kwargs:
            org_id = kwargs['orgId']
        if 'postLogoutRedirectUris' in kwargs:
            post_logout_redirect_uris = kwargs['postLogoutRedirectUris']

        _setter("grant_types", grant_types)
        _setter("project_id", project_id)
        _setter("redirect_uris", redirect_uris)
        _setter("response_types", response_types)
        if access_token_role_assertion is not None:
            _setter("access_token_role_assertion", access_token_role_assertion)
        if access_token_type is not None:
            _setter("access_token_type", access_token_type)
        if additional_origins is not None:
            _setter("additional_origins", additional_origins)
        if app_type is not None:
            _setter("app_type", app_type)
        if auth_method_type is not None:
            _setter("auth_method_type", auth_method_type)
        if clock_skew is not None:
            _setter("clock_skew", clock_skew)
        if dev_mode is not None:
            _setter("dev_mode", dev_mode)
        if id_token_role_assertion is not None:
            _setter("id_token_role_assertion", id_token_role_assertion)
        if id_token_userinfo_assertion is not None:
            _setter("id_token_userinfo_assertion", id_token_userinfo_assertion)
        if name is not None:
            _setter("name", name)
        if org_id is not None:
            _setter("org_id", org_id)
        if post_logout_redirect_uris is not None:
            _setter("post_logout_redirect_uris", post_logout_redirect_uris)
        if version is not None:
            _setter("version", version)

    @property
    @pulumi.getter(name="grantTypes")
    def grant_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Grant types, supported values: OIDC*GRANT*TYPE*AUTHORIZATION*CODE, OIDC*GRANT*TYPE*IMPLICIT, OIDC*GRANT*TYPE*REFRESH*TOKEN, OIDC*GRANT*TYPE*DEVICE_CODE
        """
        return pulumi.get(self, "grant_types")

    @grant_types.setter
    def grant_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "grant_types", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        ID of the project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="redirectUris")
    def redirect_uris(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        RedirectURIs
        """
        return pulumi.get(self, "redirect_uris")

    @redirect_uris.setter
    def redirect_uris(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "redirect_uris", value)

    @property
    @pulumi.getter(name="responseTypes")
    def response_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Response type, supported values: OIDC*RESPONSE*TYPE*CODE, OIDC*RESPONSE*TYPE*ID*TOKEN, OIDC*RESPONSE*TYPE*ID*TOKEN*TOKEN
        """
        return pulumi.get(self, "response_types")

    @response_types.setter
    def response_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "response_types", value)

    @property
    @pulumi.getter(name="accessTokenRoleAssertion")
    def access_token_role_assertion(self) -> Optional[pulumi.Input[bool]]:
        """
        Access token role assertion
        """
        return pulumi.get(self, "access_token_role_assertion")

    @access_token_role_assertion.setter
    def access_token_role_assertion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "access_token_role_assertion", value)

    @property
    @pulumi.getter(name="accessTokenType")
    def access_token_type(self) -> Optional[pulumi.Input[str]]:
        """
        Access token type, supported values: OIDC*TOKEN*TYPE*BEARER, OIDC*TOKEN*TYPE*JWT
        """
        return pulumi.get(self, "access_token_type")

    @access_token_type.setter
    def access_token_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_token_type", value)

    @property
    @pulumi.getter(name="additionalOrigins")
    def additional_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Additional origins
        """
        return pulumi.get(self, "additional_origins")

    @additional_origins.setter
    def additional_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "additional_origins", value)

    @property
    @pulumi.getter(name="appType")
    def app_type(self) -> Optional[pulumi.Input[str]]:
        """
        App type, supported values: OIDC*APP*TYPE*WEB, OIDC*APP*TYPE*USER*AGENT, OIDC*APP*TYPE*NATIVE
        """
        return pulumi.get(self, "app_type")

    @app_type.setter
    def app_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_type", value)

    @property
    @pulumi.getter(name="authMethodType")
    def auth_method_type(self) -> Optional[pulumi.Input[str]]:
        """
        Auth method type, supported values: OIDC*AUTH*METHOD*TYPE*BASIC, OIDC*AUTH*METHOD*TYPE*POST, OIDC*AUTH*METHOD*TYPE*NONE, OIDC*AUTH*METHOD*TYPE*PRIVATE*KEY*JWT
        """
        return pulumi.get(self, "auth_method_type")

    @auth_method_type.setter
    def auth_method_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_method_type", value)

    @property
    @pulumi.getter(name="clockSkew")
    def clock_skew(self) -> Optional[pulumi.Input[str]]:
        """
        Clockskew
        """
        return pulumi.get(self, "clock_skew")

    @clock_skew.setter
    def clock_skew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "clock_skew", value)

    @property
    @pulumi.getter(name="devMode")
    def dev_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Dev mode
        """
        return pulumi.get(self, "dev_mode")

    @dev_mode.setter
    def dev_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dev_mode", value)

    @property
    @pulumi.getter(name="idTokenRoleAssertion")
    def id_token_role_assertion(self) -> Optional[pulumi.Input[bool]]:
        """
        ID token role assertion
        """
        return pulumi.get(self, "id_token_role_assertion")

    @id_token_role_assertion.setter
    def id_token_role_assertion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "id_token_role_assertion", value)

    @property
    @pulumi.getter(name="idTokenUserinfoAssertion")
    def id_token_userinfo_assertion(self) -> Optional[pulumi.Input[bool]]:
        """
        Token userinfo assertion
        """
        return pulumi.get(self, "id_token_userinfo_assertion")

    @id_token_userinfo_assertion.setter
    def id_token_userinfo_assertion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "id_token_userinfo_assertion", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the application
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="postLogoutRedirectUris")
    def post_logout_redirect_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Post logout redirect URIs
        """
        return pulumi.get(self, "post_logout_redirect_uris")

    @post_logout_redirect_uris.setter
    def post_logout_redirect_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "post_logout_redirect_uris", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version, supported values: OIDC*VERSION*1_0
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _ApplicationOidcState:
    def __init__(__self__, *,
                 access_token_role_assertion: Optional[pulumi.Input[bool]] = None,
                 access_token_type: Optional[pulumi.Input[str]] = None,
                 additional_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_type: Optional[pulumi.Input[str]] = None,
                 auth_method_type: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 clock_skew: Optional[pulumi.Input[str]] = None,
                 dev_mode: Optional[pulumi.Input[bool]] = None,
                 grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 id_token_role_assertion: Optional[pulumi.Input[bool]] = None,
                 id_token_userinfo_assertion: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 post_logout_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 response_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ApplicationOidc resources.
        :param pulumi.Input[bool] access_token_role_assertion: Access token role assertion
        :param pulumi.Input[str] access_token_type: Access token type, supported values: OIDC*TOKEN*TYPE*BEARER, OIDC*TOKEN*TYPE*JWT
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_origins: Additional origins
        :param pulumi.Input[str] app_type: App type, supported values: OIDC*APP*TYPE*WEB, OIDC*APP*TYPE*USER*AGENT, OIDC*APP*TYPE*NATIVE
        :param pulumi.Input[str] auth_method_type: Auth method type, supported values: OIDC*AUTH*METHOD*TYPE*BASIC, OIDC*AUTH*METHOD*TYPE*POST, OIDC*AUTH*METHOD*TYPE*NONE, OIDC*AUTH*METHOD*TYPE*PRIVATE*KEY*JWT
        :param pulumi.Input[str] client_id: generated ID for this config
        :param pulumi.Input[str] client_secret: generated secret for this config
        :param pulumi.Input[str] clock_skew: Clockskew
        :param pulumi.Input[bool] dev_mode: Dev mode
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_types: Grant types, supported values: OIDC*GRANT*TYPE*AUTHORIZATION*CODE, OIDC*GRANT*TYPE*IMPLICIT, OIDC*GRANT*TYPE*REFRESH*TOKEN, OIDC*GRANT*TYPE*DEVICE_CODE
        :param pulumi.Input[bool] id_token_role_assertion: ID token role assertion
        :param pulumi.Input[bool] id_token_userinfo_assertion: Token userinfo assertion
        :param pulumi.Input[str] name: Name of the application
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[Sequence[pulumi.Input[str]]] post_logout_redirect_uris: Post logout redirect URIs
        :param pulumi.Input[str] project_id: ID of the project
        :param pulumi.Input[Sequence[pulumi.Input[str]]] redirect_uris: RedirectURIs
        :param pulumi.Input[Sequence[pulumi.Input[str]]] response_types: Response type, supported values: OIDC*RESPONSE*TYPE*CODE, OIDC*RESPONSE*TYPE*ID*TOKEN, OIDC*RESPONSE*TYPE*ID*TOKEN*TOKEN
        :param pulumi.Input[str] version: Version, supported values: OIDC*VERSION*1_0
        """
        _ApplicationOidcState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            access_token_role_assertion=access_token_role_assertion,
            access_token_type=access_token_type,
            additional_origins=additional_origins,
            app_type=app_type,
            auth_method_type=auth_method_type,
            client_id=client_id,
            client_secret=client_secret,
            clock_skew=clock_skew,
            dev_mode=dev_mode,
            grant_types=grant_types,
            id_token_role_assertion=id_token_role_assertion,
            id_token_userinfo_assertion=id_token_userinfo_assertion,
            name=name,
            org_id=org_id,
            post_logout_redirect_uris=post_logout_redirect_uris,
            project_id=project_id,
            redirect_uris=redirect_uris,
            response_types=response_types,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             access_token_role_assertion: Optional[pulumi.Input[bool]] = None,
             access_token_type: Optional[pulumi.Input[str]] = None,
             additional_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             app_type: Optional[pulumi.Input[str]] = None,
             auth_method_type: Optional[pulumi.Input[str]] = None,
             client_id: Optional[pulumi.Input[str]] = None,
             client_secret: Optional[pulumi.Input[str]] = None,
             clock_skew: Optional[pulumi.Input[str]] = None,
             dev_mode: Optional[pulumi.Input[bool]] = None,
             grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             id_token_role_assertion: Optional[pulumi.Input[bool]] = None,
             id_token_userinfo_assertion: Optional[pulumi.Input[bool]] = None,
             name: Optional[pulumi.Input[str]] = None,
             org_id: Optional[pulumi.Input[str]] = None,
             post_logout_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             project_id: Optional[pulumi.Input[str]] = None,
             redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             response_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             version: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'accessTokenRoleAssertion' in kwargs:
            access_token_role_assertion = kwargs['accessTokenRoleAssertion']
        if 'accessTokenType' in kwargs:
            access_token_type = kwargs['accessTokenType']
        if 'additionalOrigins' in kwargs:
            additional_origins = kwargs['additionalOrigins']
        if 'appType' in kwargs:
            app_type = kwargs['appType']
        if 'authMethodType' in kwargs:
            auth_method_type = kwargs['authMethodType']
        if 'clientId' in kwargs:
            client_id = kwargs['clientId']
        if 'clientSecret' in kwargs:
            client_secret = kwargs['clientSecret']
        if 'clockSkew' in kwargs:
            clock_skew = kwargs['clockSkew']
        if 'devMode' in kwargs:
            dev_mode = kwargs['devMode']
        if 'grantTypes' in kwargs:
            grant_types = kwargs['grantTypes']
        if 'idTokenRoleAssertion' in kwargs:
            id_token_role_assertion = kwargs['idTokenRoleAssertion']
        if 'idTokenUserinfoAssertion' in kwargs:
            id_token_userinfo_assertion = kwargs['idTokenUserinfoAssertion']
        if 'orgId' in kwargs:
            org_id = kwargs['orgId']
        if 'postLogoutRedirectUris' in kwargs:
            post_logout_redirect_uris = kwargs['postLogoutRedirectUris']
        if 'projectId' in kwargs:
            project_id = kwargs['projectId']
        if 'redirectUris' in kwargs:
            redirect_uris = kwargs['redirectUris']
        if 'responseTypes' in kwargs:
            response_types = kwargs['responseTypes']

        if access_token_role_assertion is not None:
            _setter("access_token_role_assertion", access_token_role_assertion)
        if access_token_type is not None:
            _setter("access_token_type", access_token_type)
        if additional_origins is not None:
            _setter("additional_origins", additional_origins)
        if app_type is not None:
            _setter("app_type", app_type)
        if auth_method_type is not None:
            _setter("auth_method_type", auth_method_type)
        if client_id is not None:
            _setter("client_id", client_id)
        if client_secret is not None:
            _setter("client_secret", client_secret)
        if clock_skew is not None:
            _setter("clock_skew", clock_skew)
        if dev_mode is not None:
            _setter("dev_mode", dev_mode)
        if grant_types is not None:
            _setter("grant_types", grant_types)
        if id_token_role_assertion is not None:
            _setter("id_token_role_assertion", id_token_role_assertion)
        if id_token_userinfo_assertion is not None:
            _setter("id_token_userinfo_assertion", id_token_userinfo_assertion)
        if name is not None:
            _setter("name", name)
        if org_id is not None:
            _setter("org_id", org_id)
        if post_logout_redirect_uris is not None:
            _setter("post_logout_redirect_uris", post_logout_redirect_uris)
        if project_id is not None:
            _setter("project_id", project_id)
        if redirect_uris is not None:
            _setter("redirect_uris", redirect_uris)
        if response_types is not None:
            _setter("response_types", response_types)
        if version is not None:
            _setter("version", version)

    @property
    @pulumi.getter(name="accessTokenRoleAssertion")
    def access_token_role_assertion(self) -> Optional[pulumi.Input[bool]]:
        """
        Access token role assertion
        """
        return pulumi.get(self, "access_token_role_assertion")

    @access_token_role_assertion.setter
    def access_token_role_assertion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "access_token_role_assertion", value)

    @property
    @pulumi.getter(name="accessTokenType")
    def access_token_type(self) -> Optional[pulumi.Input[str]]:
        """
        Access token type, supported values: OIDC*TOKEN*TYPE*BEARER, OIDC*TOKEN*TYPE*JWT
        """
        return pulumi.get(self, "access_token_type")

    @access_token_type.setter
    def access_token_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_token_type", value)

    @property
    @pulumi.getter(name="additionalOrigins")
    def additional_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Additional origins
        """
        return pulumi.get(self, "additional_origins")

    @additional_origins.setter
    def additional_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "additional_origins", value)

    @property
    @pulumi.getter(name="appType")
    def app_type(self) -> Optional[pulumi.Input[str]]:
        """
        App type, supported values: OIDC*APP*TYPE*WEB, OIDC*APP*TYPE*USER*AGENT, OIDC*APP*TYPE*NATIVE
        """
        return pulumi.get(self, "app_type")

    @app_type.setter
    def app_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_type", value)

    @property
    @pulumi.getter(name="authMethodType")
    def auth_method_type(self) -> Optional[pulumi.Input[str]]:
        """
        Auth method type, supported values: OIDC*AUTH*METHOD*TYPE*BASIC, OIDC*AUTH*METHOD*TYPE*POST, OIDC*AUTH*METHOD*TYPE*NONE, OIDC*AUTH*METHOD*TYPE*PRIVATE*KEY*JWT
        """
        return pulumi.get(self, "auth_method_type")

    @auth_method_type.setter
    def auth_method_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_method_type", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        generated ID for this config
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        generated secret for this config
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="clockSkew")
    def clock_skew(self) -> Optional[pulumi.Input[str]]:
        """
        Clockskew
        """
        return pulumi.get(self, "clock_skew")

    @clock_skew.setter
    def clock_skew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "clock_skew", value)

    @property
    @pulumi.getter(name="devMode")
    def dev_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Dev mode
        """
        return pulumi.get(self, "dev_mode")

    @dev_mode.setter
    def dev_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dev_mode", value)

    @property
    @pulumi.getter(name="grantTypes")
    def grant_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Grant types, supported values: OIDC*GRANT*TYPE*AUTHORIZATION*CODE, OIDC*GRANT*TYPE*IMPLICIT, OIDC*GRANT*TYPE*REFRESH*TOKEN, OIDC*GRANT*TYPE*DEVICE_CODE
        """
        return pulumi.get(self, "grant_types")

    @grant_types.setter
    def grant_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "grant_types", value)

    @property
    @pulumi.getter(name="idTokenRoleAssertion")
    def id_token_role_assertion(self) -> Optional[pulumi.Input[bool]]:
        """
        ID token role assertion
        """
        return pulumi.get(self, "id_token_role_assertion")

    @id_token_role_assertion.setter
    def id_token_role_assertion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "id_token_role_assertion", value)

    @property
    @pulumi.getter(name="idTokenUserinfoAssertion")
    def id_token_userinfo_assertion(self) -> Optional[pulumi.Input[bool]]:
        """
        Token userinfo assertion
        """
        return pulumi.get(self, "id_token_userinfo_assertion")

    @id_token_userinfo_assertion.setter
    def id_token_userinfo_assertion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "id_token_userinfo_assertion", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the application
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="postLogoutRedirectUris")
    def post_logout_redirect_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Post logout redirect URIs
        """
        return pulumi.get(self, "post_logout_redirect_uris")

    @post_logout_redirect_uris.setter
    def post_logout_redirect_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "post_logout_redirect_uris", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="redirectUris")
    def redirect_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        RedirectURIs
        """
        return pulumi.get(self, "redirect_uris")

    @redirect_uris.setter
    def redirect_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "redirect_uris", value)

    @property
    @pulumi.getter(name="responseTypes")
    def response_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Response type, supported values: OIDC*RESPONSE*TYPE*CODE, OIDC*RESPONSE*TYPE*ID*TOKEN, OIDC*RESPONSE*TYPE*ID*TOKEN*TOKEN
        """
        return pulumi.get(self, "response_types")

    @response_types.setter
    def response_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "response_types", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version, supported values: OIDC*VERSION*1_0
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class ApplicationOidc(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token_role_assertion: Optional[pulumi.Input[bool]] = None,
                 access_token_type: Optional[pulumi.Input[str]] = None,
                 additional_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_type: Optional[pulumi.Input[str]] = None,
                 auth_method_type: Optional[pulumi.Input[str]] = None,
                 clock_skew: Optional[pulumi.Input[str]] = None,
                 dev_mode: Optional[pulumi.Input[bool]] = None,
                 grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 id_token_role_assertion: Optional[pulumi.Input[bool]] = None,
                 id_token_userinfo_assertion: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 post_logout_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 response_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource representing an OIDC application belonging to a project, with all configuration possibilities.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.ApplicationOidc("default",
            project_id=data["zitadel_project"]["default"]["id"],
            org_id=data["zitadel_org"]["default"]["id"],
            redirect_uris=["https://localhost.com"],
            response_types=["OIDC_RESPONSE_TYPE_CODE"],
            grant_types=["OIDC_GRANT_TYPE_AUTHORIZATION_CODE"],
            post_logout_redirect_uris=["https://localhost.com"],
            app_type="OIDC_APP_TYPE_WEB",
            auth_method_type="OIDC_AUTH_METHOD_TYPE_BASIC",
            version="OIDC_VERSION_1_0",
            clock_skew="0s",
            dev_mode=True,
            access_token_type="OIDC_TOKEN_TYPE_BEARER",
            access_token_role_assertion=False,
            id_token_role_assertion=False,
            id_token_userinfo_assertion=False,
            additional_origins=[])
        ```

        ## Import

        terraform The resource can be imported using the ID format `<id:project_id[:org_id][:client_id][:client_secret]>`, e.g.

        ```sh
         $ pulumi import zitadel:index/applicationOidc:ApplicationOidc imported '123456789012345678:123456789012345678:123456789012345678:123456789012345678@zitadel:JuaDFFeOak5DGE655KCYPSAclSkbMVEJXXuX1lEMBT14eLMSs0A0qhafKX5SA2Df'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] access_token_role_assertion: Access token role assertion
        :param pulumi.Input[str] access_token_type: Access token type, supported values: OIDC*TOKEN*TYPE*BEARER, OIDC*TOKEN*TYPE*JWT
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_origins: Additional origins
        :param pulumi.Input[str] app_type: App type, supported values: OIDC*APP*TYPE*WEB, OIDC*APP*TYPE*USER*AGENT, OIDC*APP*TYPE*NATIVE
        :param pulumi.Input[str] auth_method_type: Auth method type, supported values: OIDC*AUTH*METHOD*TYPE*BASIC, OIDC*AUTH*METHOD*TYPE*POST, OIDC*AUTH*METHOD*TYPE*NONE, OIDC*AUTH*METHOD*TYPE*PRIVATE*KEY*JWT
        :param pulumi.Input[str] clock_skew: Clockskew
        :param pulumi.Input[bool] dev_mode: Dev mode
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_types: Grant types, supported values: OIDC*GRANT*TYPE*AUTHORIZATION*CODE, OIDC*GRANT*TYPE*IMPLICIT, OIDC*GRANT*TYPE*REFRESH*TOKEN, OIDC*GRANT*TYPE*DEVICE_CODE
        :param pulumi.Input[bool] id_token_role_assertion: ID token role assertion
        :param pulumi.Input[bool] id_token_userinfo_assertion: Token userinfo assertion
        :param pulumi.Input[str] name: Name of the application
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[Sequence[pulumi.Input[str]]] post_logout_redirect_uris: Post logout redirect URIs
        :param pulumi.Input[str] project_id: ID of the project
        :param pulumi.Input[Sequence[pulumi.Input[str]]] redirect_uris: RedirectURIs
        :param pulumi.Input[Sequence[pulumi.Input[str]]] response_types: Response type, supported values: OIDC*RESPONSE*TYPE*CODE, OIDC*RESPONSE*TYPE*ID*TOKEN, OIDC*RESPONSE*TYPE*ID*TOKEN*TOKEN
        :param pulumi.Input[str] version: Version, supported values: OIDC*VERSION*1_0
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationOidcArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource representing an OIDC application belonging to a project, with all configuration possibilities.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.ApplicationOidc("default",
            project_id=data["zitadel_project"]["default"]["id"],
            org_id=data["zitadel_org"]["default"]["id"],
            redirect_uris=["https://localhost.com"],
            response_types=["OIDC_RESPONSE_TYPE_CODE"],
            grant_types=["OIDC_GRANT_TYPE_AUTHORIZATION_CODE"],
            post_logout_redirect_uris=["https://localhost.com"],
            app_type="OIDC_APP_TYPE_WEB",
            auth_method_type="OIDC_AUTH_METHOD_TYPE_BASIC",
            version="OIDC_VERSION_1_0",
            clock_skew="0s",
            dev_mode=True,
            access_token_type="OIDC_TOKEN_TYPE_BEARER",
            access_token_role_assertion=False,
            id_token_role_assertion=False,
            id_token_userinfo_assertion=False,
            additional_origins=[])
        ```

        ## Import

        terraform The resource can be imported using the ID format `<id:project_id[:org_id][:client_id][:client_secret]>`, e.g.

        ```sh
         $ pulumi import zitadel:index/applicationOidc:ApplicationOidc imported '123456789012345678:123456789012345678:123456789012345678:123456789012345678@zitadel:JuaDFFeOak5DGE655KCYPSAclSkbMVEJXXuX1lEMBT14eLMSs0A0qhafKX5SA2Df'
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationOidcArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationOidcArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ApplicationOidcArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token_role_assertion: Optional[pulumi.Input[bool]] = None,
                 access_token_type: Optional[pulumi.Input[str]] = None,
                 additional_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_type: Optional[pulumi.Input[str]] = None,
                 auth_method_type: Optional[pulumi.Input[str]] = None,
                 clock_skew: Optional[pulumi.Input[str]] = None,
                 dev_mode: Optional[pulumi.Input[bool]] = None,
                 grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 id_token_role_assertion: Optional[pulumi.Input[bool]] = None,
                 id_token_userinfo_assertion: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 post_logout_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 response_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationOidcArgs.__new__(ApplicationOidcArgs)

            __props__.__dict__["access_token_role_assertion"] = access_token_role_assertion
            __props__.__dict__["access_token_type"] = access_token_type
            __props__.__dict__["additional_origins"] = additional_origins
            __props__.__dict__["app_type"] = app_type
            __props__.__dict__["auth_method_type"] = auth_method_type
            __props__.__dict__["clock_skew"] = clock_skew
            __props__.__dict__["dev_mode"] = dev_mode
            if grant_types is None and not opts.urn:
                raise TypeError("Missing required property 'grant_types'")
            __props__.__dict__["grant_types"] = grant_types
            __props__.__dict__["id_token_role_assertion"] = id_token_role_assertion
            __props__.__dict__["id_token_userinfo_assertion"] = id_token_userinfo_assertion
            __props__.__dict__["name"] = name
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["post_logout_redirect_uris"] = post_logout_redirect_uris
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if redirect_uris is None and not opts.urn:
                raise TypeError("Missing required property 'redirect_uris'")
            __props__.__dict__["redirect_uris"] = redirect_uris
            if response_types is None and not opts.urn:
                raise TypeError("Missing required property 'response_types'")
            __props__.__dict__["response_types"] = response_types
            __props__.__dict__["version"] = version
            __props__.__dict__["client_id"] = None
            __props__.__dict__["client_secret"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientId", "clientSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ApplicationOidc, __self__).__init__(
            'zitadel:index/applicationOidc:ApplicationOidc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_token_role_assertion: Optional[pulumi.Input[bool]] = None,
            access_token_type: Optional[pulumi.Input[str]] = None,
            additional_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            app_type: Optional[pulumi.Input[str]] = None,
            auth_method_type: Optional[pulumi.Input[str]] = None,
            client_id: Optional[pulumi.Input[str]] = None,
            client_secret: Optional[pulumi.Input[str]] = None,
            clock_skew: Optional[pulumi.Input[str]] = None,
            dev_mode: Optional[pulumi.Input[bool]] = None,
            grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            id_token_role_assertion: Optional[pulumi.Input[bool]] = None,
            id_token_userinfo_assertion: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            post_logout_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            response_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'ApplicationOidc':
        """
        Get an existing ApplicationOidc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] access_token_role_assertion: Access token role assertion
        :param pulumi.Input[str] access_token_type: Access token type, supported values: OIDC*TOKEN*TYPE*BEARER, OIDC*TOKEN*TYPE*JWT
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_origins: Additional origins
        :param pulumi.Input[str] app_type: App type, supported values: OIDC*APP*TYPE*WEB, OIDC*APP*TYPE*USER*AGENT, OIDC*APP*TYPE*NATIVE
        :param pulumi.Input[str] auth_method_type: Auth method type, supported values: OIDC*AUTH*METHOD*TYPE*BASIC, OIDC*AUTH*METHOD*TYPE*POST, OIDC*AUTH*METHOD*TYPE*NONE, OIDC*AUTH*METHOD*TYPE*PRIVATE*KEY*JWT
        :param pulumi.Input[str] client_id: generated ID for this config
        :param pulumi.Input[str] client_secret: generated secret for this config
        :param pulumi.Input[str] clock_skew: Clockskew
        :param pulumi.Input[bool] dev_mode: Dev mode
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_types: Grant types, supported values: OIDC*GRANT*TYPE*AUTHORIZATION*CODE, OIDC*GRANT*TYPE*IMPLICIT, OIDC*GRANT*TYPE*REFRESH*TOKEN, OIDC*GRANT*TYPE*DEVICE_CODE
        :param pulumi.Input[bool] id_token_role_assertion: ID token role assertion
        :param pulumi.Input[bool] id_token_userinfo_assertion: Token userinfo assertion
        :param pulumi.Input[str] name: Name of the application
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[Sequence[pulumi.Input[str]]] post_logout_redirect_uris: Post logout redirect URIs
        :param pulumi.Input[str] project_id: ID of the project
        :param pulumi.Input[Sequence[pulumi.Input[str]]] redirect_uris: RedirectURIs
        :param pulumi.Input[Sequence[pulumi.Input[str]]] response_types: Response type, supported values: OIDC*RESPONSE*TYPE*CODE, OIDC*RESPONSE*TYPE*ID*TOKEN, OIDC*RESPONSE*TYPE*ID*TOKEN*TOKEN
        :param pulumi.Input[str] version: Version, supported values: OIDC*VERSION*1_0
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationOidcState.__new__(_ApplicationOidcState)

        __props__.__dict__["access_token_role_assertion"] = access_token_role_assertion
        __props__.__dict__["access_token_type"] = access_token_type
        __props__.__dict__["additional_origins"] = additional_origins
        __props__.__dict__["app_type"] = app_type
        __props__.__dict__["auth_method_type"] = auth_method_type
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["clock_skew"] = clock_skew
        __props__.__dict__["dev_mode"] = dev_mode
        __props__.__dict__["grant_types"] = grant_types
        __props__.__dict__["id_token_role_assertion"] = id_token_role_assertion
        __props__.__dict__["id_token_userinfo_assertion"] = id_token_userinfo_assertion
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["post_logout_redirect_uris"] = post_logout_redirect_uris
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["redirect_uris"] = redirect_uris
        __props__.__dict__["response_types"] = response_types
        __props__.__dict__["version"] = version
        return ApplicationOidc(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessTokenRoleAssertion")
    def access_token_role_assertion(self) -> pulumi.Output[Optional[bool]]:
        """
        Access token role assertion
        """
        return pulumi.get(self, "access_token_role_assertion")

    @property
    @pulumi.getter(name="accessTokenType")
    def access_token_type(self) -> pulumi.Output[Optional[str]]:
        """
        Access token type, supported values: OIDC*TOKEN*TYPE*BEARER, OIDC*TOKEN*TYPE*JWT
        """
        return pulumi.get(self, "access_token_type")

    @property
    @pulumi.getter(name="additionalOrigins")
    def additional_origins(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Additional origins
        """
        return pulumi.get(self, "additional_origins")

    @property
    @pulumi.getter(name="appType")
    def app_type(self) -> pulumi.Output[Optional[str]]:
        """
        App type, supported values: OIDC*APP*TYPE*WEB, OIDC*APP*TYPE*USER*AGENT, OIDC*APP*TYPE*NATIVE
        """
        return pulumi.get(self, "app_type")

    @property
    @pulumi.getter(name="authMethodType")
    def auth_method_type(self) -> pulumi.Output[Optional[str]]:
        """
        Auth method type, supported values: OIDC*AUTH*METHOD*TYPE*BASIC, OIDC*AUTH*METHOD*TYPE*POST, OIDC*AUTH*METHOD*TYPE*NONE, OIDC*AUTH*METHOD*TYPE*PRIVATE*KEY*JWT
        """
        return pulumi.get(self, "auth_method_type")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[str]:
        """
        generated ID for this config
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[str]:
        """
        generated secret for this config
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="clockSkew")
    def clock_skew(self) -> pulumi.Output[Optional[str]]:
        """
        Clockskew
        """
        return pulumi.get(self, "clock_skew")

    @property
    @pulumi.getter(name="devMode")
    def dev_mode(self) -> pulumi.Output[Optional[bool]]:
        """
        Dev mode
        """
        return pulumi.get(self, "dev_mode")

    @property
    @pulumi.getter(name="grantTypes")
    def grant_types(self) -> pulumi.Output[Sequence[str]]:
        """
        Grant types, supported values: OIDC*GRANT*TYPE*AUTHORIZATION*CODE, OIDC*GRANT*TYPE*IMPLICIT, OIDC*GRANT*TYPE*REFRESH*TOKEN, OIDC*GRANT*TYPE*DEVICE_CODE
        """
        return pulumi.get(self, "grant_types")

    @property
    @pulumi.getter(name="idTokenRoleAssertion")
    def id_token_role_assertion(self) -> pulumi.Output[Optional[bool]]:
        """
        ID token role assertion
        """
        return pulumi.get(self, "id_token_role_assertion")

    @property
    @pulumi.getter(name="idTokenUserinfoAssertion")
    def id_token_userinfo_assertion(self) -> pulumi.Output[Optional[bool]]:
        """
        Token userinfo assertion
        """
        return pulumi.get(self, "id_token_userinfo_assertion")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the application
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="postLogoutRedirectUris")
    def post_logout_redirect_uris(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Post logout redirect URIs
        """
        return pulumi.get(self, "post_logout_redirect_uris")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        ID of the project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="redirectUris")
    def redirect_uris(self) -> pulumi.Output[Sequence[str]]:
        """
        RedirectURIs
        """
        return pulumi.get(self, "redirect_uris")

    @property
    @pulumi.getter(name="responseTypes")
    def response_types(self) -> pulumi.Output[Sequence[str]]:
        """
        Response type, supported values: OIDC*RESPONSE*TYPE*CODE, OIDC*RESPONSE*TYPE*ID*TOKEN, OIDC*RESPONSE*TYPE*ID*TOKEN*TOKEN
        """
        return pulumi.get(self, "response_types")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[str]]:
        """
        Version, supported values: OIDC*VERSION*1_0
        """
        return pulumi.get(self, "version")

