# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['DefaultDomainPolicyArgs', 'DefaultDomainPolicy']

@pulumi.input_type
class DefaultDomainPolicyArgs:
    def __init__(__self__, *,
                 smtp_sender_address_matches_instance_domain: pulumi.Input[bool],
                 user_login_must_be_domain: pulumi.Input[bool],
                 validate_org_domains: pulumi.Input[bool]):
        """
        The set of arguments for constructing a DefaultDomainPolicy resource.
        :param pulumi.Input[bool] user_login_must_be_domain: User login must be domain
        :param pulumi.Input[bool] validate_org_domains: Validate organization domains
        """
        DefaultDomainPolicyArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            smtp_sender_address_matches_instance_domain=smtp_sender_address_matches_instance_domain,
            user_login_must_be_domain=user_login_must_be_domain,
            validate_org_domains=validate_org_domains,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             smtp_sender_address_matches_instance_domain: pulumi.Input[bool],
             user_login_must_be_domain: pulumi.Input[bool],
             validate_org_domains: pulumi.Input[bool],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'smtpSenderAddressMatchesInstanceDomain' in kwargs:
            smtp_sender_address_matches_instance_domain = kwargs['smtpSenderAddressMatchesInstanceDomain']
        if 'userLoginMustBeDomain' in kwargs:
            user_login_must_be_domain = kwargs['userLoginMustBeDomain']
        if 'validateOrgDomains' in kwargs:
            validate_org_domains = kwargs['validateOrgDomains']

        _setter("smtp_sender_address_matches_instance_domain", smtp_sender_address_matches_instance_domain)
        _setter("user_login_must_be_domain", user_login_must_be_domain)
        _setter("validate_org_domains", validate_org_domains)

    @property
    @pulumi.getter(name="smtpSenderAddressMatchesInstanceDomain")
    def smtp_sender_address_matches_instance_domain(self) -> pulumi.Input[bool]:
        return pulumi.get(self, "smtp_sender_address_matches_instance_domain")

    @smtp_sender_address_matches_instance_domain.setter
    def smtp_sender_address_matches_instance_domain(self, value: pulumi.Input[bool]):
        pulumi.set(self, "smtp_sender_address_matches_instance_domain", value)

    @property
    @pulumi.getter(name="userLoginMustBeDomain")
    def user_login_must_be_domain(self) -> pulumi.Input[bool]:
        """
        User login must be domain
        """
        return pulumi.get(self, "user_login_must_be_domain")

    @user_login_must_be_domain.setter
    def user_login_must_be_domain(self, value: pulumi.Input[bool]):
        pulumi.set(self, "user_login_must_be_domain", value)

    @property
    @pulumi.getter(name="validateOrgDomains")
    def validate_org_domains(self) -> pulumi.Input[bool]:
        """
        Validate organization domains
        """
        return pulumi.get(self, "validate_org_domains")

    @validate_org_domains.setter
    def validate_org_domains(self, value: pulumi.Input[bool]):
        pulumi.set(self, "validate_org_domains", value)


@pulumi.input_type
class _DefaultDomainPolicyState:
    def __init__(__self__, *,
                 smtp_sender_address_matches_instance_domain: Optional[pulumi.Input[bool]] = None,
                 user_login_must_be_domain: Optional[pulumi.Input[bool]] = None,
                 validate_org_domains: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering DefaultDomainPolicy resources.
        :param pulumi.Input[bool] user_login_must_be_domain: User login must be domain
        :param pulumi.Input[bool] validate_org_domains: Validate organization domains
        """
        _DefaultDomainPolicyState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            smtp_sender_address_matches_instance_domain=smtp_sender_address_matches_instance_domain,
            user_login_must_be_domain=user_login_must_be_domain,
            validate_org_domains=validate_org_domains,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             smtp_sender_address_matches_instance_domain: Optional[pulumi.Input[bool]] = None,
             user_login_must_be_domain: Optional[pulumi.Input[bool]] = None,
             validate_org_domains: Optional[pulumi.Input[bool]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'smtpSenderAddressMatchesInstanceDomain' in kwargs:
            smtp_sender_address_matches_instance_domain = kwargs['smtpSenderAddressMatchesInstanceDomain']
        if 'userLoginMustBeDomain' in kwargs:
            user_login_must_be_domain = kwargs['userLoginMustBeDomain']
        if 'validateOrgDomains' in kwargs:
            validate_org_domains = kwargs['validateOrgDomains']

        if smtp_sender_address_matches_instance_domain is not None:
            _setter("smtp_sender_address_matches_instance_domain", smtp_sender_address_matches_instance_domain)
        if user_login_must_be_domain is not None:
            _setter("user_login_must_be_domain", user_login_must_be_domain)
        if validate_org_domains is not None:
            _setter("validate_org_domains", validate_org_domains)

    @property
    @pulumi.getter(name="smtpSenderAddressMatchesInstanceDomain")
    def smtp_sender_address_matches_instance_domain(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "smtp_sender_address_matches_instance_domain")

    @smtp_sender_address_matches_instance_domain.setter
    def smtp_sender_address_matches_instance_domain(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "smtp_sender_address_matches_instance_domain", value)

    @property
    @pulumi.getter(name="userLoginMustBeDomain")
    def user_login_must_be_domain(self) -> Optional[pulumi.Input[bool]]:
        """
        User login must be domain
        """
        return pulumi.get(self, "user_login_must_be_domain")

    @user_login_must_be_domain.setter
    def user_login_must_be_domain(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "user_login_must_be_domain", value)

    @property
    @pulumi.getter(name="validateOrgDomains")
    def validate_org_domains(self) -> Optional[pulumi.Input[bool]]:
        """
        Validate organization domains
        """
        return pulumi.get(self, "validate_org_domains")

    @validate_org_domains.setter
    def validate_org_domains(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate_org_domains", value)


class DefaultDomainPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 smtp_sender_address_matches_instance_domain: Optional[pulumi.Input[bool]] = None,
                 user_login_must_be_domain: Optional[pulumi.Input[bool]] = None,
                 validate_org_domains: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Resource representing the default domain policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.DefaultDomainPolicy("default",
            smtp_sender_address_matches_instance_domain=True,
            user_login_must_be_domain=False,
            validate_org_domains=True)
        ```

        ## Import

        terraform The resource can be imported using the ID format `<>`, e.g.

        ```sh
         $ pulumi import zitadel:index/defaultDomainPolicy:DefaultDomainPolicy imported ''
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] user_login_must_be_domain: User login must be domain
        :param pulumi.Input[bool] validate_org_domains: Validate organization domains
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DefaultDomainPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource representing the default domain policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.DefaultDomainPolicy("default",
            smtp_sender_address_matches_instance_domain=True,
            user_login_must_be_domain=False,
            validate_org_domains=True)
        ```

        ## Import

        terraform The resource can be imported using the ID format `<>`, e.g.

        ```sh
         $ pulumi import zitadel:index/defaultDomainPolicy:DefaultDomainPolicy imported ''
        ```

        :param str resource_name: The name of the resource.
        :param DefaultDomainPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DefaultDomainPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            DefaultDomainPolicyArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 smtp_sender_address_matches_instance_domain: Optional[pulumi.Input[bool]] = None,
                 user_login_must_be_domain: Optional[pulumi.Input[bool]] = None,
                 validate_org_domains: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DefaultDomainPolicyArgs.__new__(DefaultDomainPolicyArgs)

            if smtp_sender_address_matches_instance_domain is None and not opts.urn:
                raise TypeError("Missing required property 'smtp_sender_address_matches_instance_domain'")
            __props__.__dict__["smtp_sender_address_matches_instance_domain"] = smtp_sender_address_matches_instance_domain
            if user_login_must_be_domain is None and not opts.urn:
                raise TypeError("Missing required property 'user_login_must_be_domain'")
            __props__.__dict__["user_login_must_be_domain"] = user_login_must_be_domain
            if validate_org_domains is None and not opts.urn:
                raise TypeError("Missing required property 'validate_org_domains'")
            __props__.__dict__["validate_org_domains"] = validate_org_domains
        super(DefaultDomainPolicy, __self__).__init__(
            'zitadel:index/defaultDomainPolicy:DefaultDomainPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            smtp_sender_address_matches_instance_domain: Optional[pulumi.Input[bool]] = None,
            user_login_must_be_domain: Optional[pulumi.Input[bool]] = None,
            validate_org_domains: Optional[pulumi.Input[bool]] = None) -> 'DefaultDomainPolicy':
        """
        Get an existing DefaultDomainPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] user_login_must_be_domain: User login must be domain
        :param pulumi.Input[bool] validate_org_domains: Validate organization domains
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DefaultDomainPolicyState.__new__(_DefaultDomainPolicyState)

        __props__.__dict__["smtp_sender_address_matches_instance_domain"] = smtp_sender_address_matches_instance_domain
        __props__.__dict__["user_login_must_be_domain"] = user_login_must_be_domain
        __props__.__dict__["validate_org_domains"] = validate_org_domains
        return DefaultDomainPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="smtpSenderAddressMatchesInstanceDomain")
    def smtp_sender_address_matches_instance_domain(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "smtp_sender_address_matches_instance_domain")

    @property
    @pulumi.getter(name="userLoginMustBeDomain")
    def user_login_must_be_domain(self) -> pulumi.Output[bool]:
        """
        User login must be domain
        """
        return pulumi.get(self, "user_login_must_be_domain")

    @property
    @pulumi.getter(name="validateOrgDomains")
    def validate_org_domains(self) -> pulumi.Output[bool]:
        """
        Validate organization domains
        """
        return pulumi.get(self, "validate_org_domains")

