# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['DefaultLockoutPolicyArgs', 'DefaultLockoutPolicy']

@pulumi.input_type
class DefaultLockoutPolicyArgs:
    def __init__(__self__, *,
                 max_password_attempts: pulumi.Input[int]):
        """
        The set of arguments for constructing a DefaultLockoutPolicy resource.
        :param pulumi.Input[int] max_password_attempts: Maximum password check attempts before the account gets locked. Attempts are reset as soon as the password is entered correctly or the password is reset.
        """
        DefaultLockoutPolicyArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            max_password_attempts=max_password_attempts,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             max_password_attempts: pulumi.Input[int],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'maxPasswordAttempts' in kwargs:
            max_password_attempts = kwargs['maxPasswordAttempts']

        _setter("max_password_attempts", max_password_attempts)

    @property
    @pulumi.getter(name="maxPasswordAttempts")
    def max_password_attempts(self) -> pulumi.Input[int]:
        """
        Maximum password check attempts before the account gets locked. Attempts are reset as soon as the password is entered correctly or the password is reset.
        """
        return pulumi.get(self, "max_password_attempts")

    @max_password_attempts.setter
    def max_password_attempts(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_password_attempts", value)


@pulumi.input_type
class _DefaultLockoutPolicyState:
    def __init__(__self__, *,
                 max_password_attempts: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering DefaultLockoutPolicy resources.
        :param pulumi.Input[int] max_password_attempts: Maximum password check attempts before the account gets locked. Attempts are reset as soon as the password is entered correctly or the password is reset.
        """
        _DefaultLockoutPolicyState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            max_password_attempts=max_password_attempts,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             max_password_attempts: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'maxPasswordAttempts' in kwargs:
            max_password_attempts = kwargs['maxPasswordAttempts']

        if max_password_attempts is not None:
            _setter("max_password_attempts", max_password_attempts)

    @property
    @pulumi.getter(name="maxPasswordAttempts")
    def max_password_attempts(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum password check attempts before the account gets locked. Attempts are reset as soon as the password is entered correctly or the password is reset.
        """
        return pulumi.get(self, "max_password_attempts")

    @max_password_attempts.setter
    def max_password_attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_password_attempts", value)


class DefaultLockoutPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 max_password_attempts: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Resource representing the default lockout policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.DefaultLockoutPolicy("default", max_password_attempts=5)
        ```

        ## Import

        terraform The resource can be imported using the ID format `<>`, e.g.

        ```sh
         $ pulumi import zitadel:index/defaultLockoutPolicy:DefaultLockoutPolicy imported ''
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] max_password_attempts: Maximum password check attempts before the account gets locked. Attempts are reset as soon as the password is entered correctly or the password is reset.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DefaultLockoutPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource representing the default lockout policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.DefaultLockoutPolicy("default", max_password_attempts=5)
        ```

        ## Import

        terraform The resource can be imported using the ID format `<>`, e.g.

        ```sh
         $ pulumi import zitadel:index/defaultLockoutPolicy:DefaultLockoutPolicy imported ''
        ```

        :param str resource_name: The name of the resource.
        :param DefaultLockoutPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DefaultLockoutPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            DefaultLockoutPolicyArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 max_password_attempts: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DefaultLockoutPolicyArgs.__new__(DefaultLockoutPolicyArgs)

            if max_password_attempts is None and not opts.urn:
                raise TypeError("Missing required property 'max_password_attempts'")
            __props__.__dict__["max_password_attempts"] = max_password_attempts
        super(DefaultLockoutPolicy, __self__).__init__(
            'zitadel:index/defaultLockoutPolicy:DefaultLockoutPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            max_password_attempts: Optional[pulumi.Input[int]] = None) -> 'DefaultLockoutPolicy':
        """
        Get an existing DefaultLockoutPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] max_password_attempts: Maximum password check attempts before the account gets locked. Attempts are reset as soon as the password is entered correctly or the password is reset.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DefaultLockoutPolicyState.__new__(_DefaultLockoutPolicyState)

        __props__.__dict__["max_password_attempts"] = max_password_attempts
        return DefaultLockoutPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="maxPasswordAttempts")
    def max_password_attempts(self) -> pulumi.Output[int]:
        """
        Maximum password check attempts before the account gets locked. Attempts are reset as soon as the password is entered correctly or the password is reset.
        """
        return pulumi.get(self, "max_password_attempts")

