# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['DefaultOidcSettingsArgs', 'DefaultOidcSettings']

@pulumi.input_type
class DefaultOidcSettingsArgs:
    def __init__(__self__, *,
                 access_token_lifetime: pulumi.Input[str],
                 id_token_lifetime: pulumi.Input[str],
                 refresh_token_expiration: pulumi.Input[str],
                 refresh_token_idle_expiration: pulumi.Input[str]):
        """
        The set of arguments for constructing a DefaultOidcSettings resource.
        :param pulumi.Input[str] access_token_lifetime: lifetime duration of access tokens
        :param pulumi.Input[str] id_token_lifetime: lifetime duration of id tokens
        :param pulumi.Input[str] refresh_token_expiration: expiration duration of refresh tokens
        :param pulumi.Input[str] refresh_token_idle_expiration: expiration duration of idle refresh tokens
        """
        DefaultOidcSettingsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            access_token_lifetime=access_token_lifetime,
            id_token_lifetime=id_token_lifetime,
            refresh_token_expiration=refresh_token_expiration,
            refresh_token_idle_expiration=refresh_token_idle_expiration,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             access_token_lifetime: pulumi.Input[str],
             id_token_lifetime: pulumi.Input[str],
             refresh_token_expiration: pulumi.Input[str],
             refresh_token_idle_expiration: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'accessTokenLifetime' in kwargs:
            access_token_lifetime = kwargs['accessTokenLifetime']
        if 'idTokenLifetime' in kwargs:
            id_token_lifetime = kwargs['idTokenLifetime']
        if 'refreshTokenExpiration' in kwargs:
            refresh_token_expiration = kwargs['refreshTokenExpiration']
        if 'refreshTokenIdleExpiration' in kwargs:
            refresh_token_idle_expiration = kwargs['refreshTokenIdleExpiration']

        _setter("access_token_lifetime", access_token_lifetime)
        _setter("id_token_lifetime", id_token_lifetime)
        _setter("refresh_token_expiration", refresh_token_expiration)
        _setter("refresh_token_idle_expiration", refresh_token_idle_expiration)

    @property
    @pulumi.getter(name="accessTokenLifetime")
    def access_token_lifetime(self) -> pulumi.Input[str]:
        """
        lifetime duration of access tokens
        """
        return pulumi.get(self, "access_token_lifetime")

    @access_token_lifetime.setter
    def access_token_lifetime(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_token_lifetime", value)

    @property
    @pulumi.getter(name="idTokenLifetime")
    def id_token_lifetime(self) -> pulumi.Input[str]:
        """
        lifetime duration of id tokens
        """
        return pulumi.get(self, "id_token_lifetime")

    @id_token_lifetime.setter
    def id_token_lifetime(self, value: pulumi.Input[str]):
        pulumi.set(self, "id_token_lifetime", value)

    @property
    @pulumi.getter(name="refreshTokenExpiration")
    def refresh_token_expiration(self) -> pulumi.Input[str]:
        """
        expiration duration of refresh tokens
        """
        return pulumi.get(self, "refresh_token_expiration")

    @refresh_token_expiration.setter
    def refresh_token_expiration(self, value: pulumi.Input[str]):
        pulumi.set(self, "refresh_token_expiration", value)

    @property
    @pulumi.getter(name="refreshTokenIdleExpiration")
    def refresh_token_idle_expiration(self) -> pulumi.Input[str]:
        """
        expiration duration of idle refresh tokens
        """
        return pulumi.get(self, "refresh_token_idle_expiration")

    @refresh_token_idle_expiration.setter
    def refresh_token_idle_expiration(self, value: pulumi.Input[str]):
        pulumi.set(self, "refresh_token_idle_expiration", value)


@pulumi.input_type
class _DefaultOidcSettingsState:
    def __init__(__self__, *,
                 access_token_lifetime: Optional[pulumi.Input[str]] = None,
                 id_token_lifetime: Optional[pulumi.Input[str]] = None,
                 refresh_token_expiration: Optional[pulumi.Input[str]] = None,
                 refresh_token_idle_expiration: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DefaultOidcSettings resources.
        :param pulumi.Input[str] access_token_lifetime: lifetime duration of access tokens
        :param pulumi.Input[str] id_token_lifetime: lifetime duration of id tokens
        :param pulumi.Input[str] refresh_token_expiration: expiration duration of refresh tokens
        :param pulumi.Input[str] refresh_token_idle_expiration: expiration duration of idle refresh tokens
        """
        _DefaultOidcSettingsState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            access_token_lifetime=access_token_lifetime,
            id_token_lifetime=id_token_lifetime,
            refresh_token_expiration=refresh_token_expiration,
            refresh_token_idle_expiration=refresh_token_idle_expiration,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             access_token_lifetime: Optional[pulumi.Input[str]] = None,
             id_token_lifetime: Optional[pulumi.Input[str]] = None,
             refresh_token_expiration: Optional[pulumi.Input[str]] = None,
             refresh_token_idle_expiration: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'accessTokenLifetime' in kwargs:
            access_token_lifetime = kwargs['accessTokenLifetime']
        if 'idTokenLifetime' in kwargs:
            id_token_lifetime = kwargs['idTokenLifetime']
        if 'refreshTokenExpiration' in kwargs:
            refresh_token_expiration = kwargs['refreshTokenExpiration']
        if 'refreshTokenIdleExpiration' in kwargs:
            refresh_token_idle_expiration = kwargs['refreshTokenIdleExpiration']

        if access_token_lifetime is not None:
            _setter("access_token_lifetime", access_token_lifetime)
        if id_token_lifetime is not None:
            _setter("id_token_lifetime", id_token_lifetime)
        if refresh_token_expiration is not None:
            _setter("refresh_token_expiration", refresh_token_expiration)
        if refresh_token_idle_expiration is not None:
            _setter("refresh_token_idle_expiration", refresh_token_idle_expiration)

    @property
    @pulumi.getter(name="accessTokenLifetime")
    def access_token_lifetime(self) -> Optional[pulumi.Input[str]]:
        """
        lifetime duration of access tokens
        """
        return pulumi.get(self, "access_token_lifetime")

    @access_token_lifetime.setter
    def access_token_lifetime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_token_lifetime", value)

    @property
    @pulumi.getter(name="idTokenLifetime")
    def id_token_lifetime(self) -> Optional[pulumi.Input[str]]:
        """
        lifetime duration of id tokens
        """
        return pulumi.get(self, "id_token_lifetime")

    @id_token_lifetime.setter
    def id_token_lifetime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id_token_lifetime", value)

    @property
    @pulumi.getter(name="refreshTokenExpiration")
    def refresh_token_expiration(self) -> Optional[pulumi.Input[str]]:
        """
        expiration duration of refresh tokens
        """
        return pulumi.get(self, "refresh_token_expiration")

    @refresh_token_expiration.setter
    def refresh_token_expiration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_token_expiration", value)

    @property
    @pulumi.getter(name="refreshTokenIdleExpiration")
    def refresh_token_idle_expiration(self) -> Optional[pulumi.Input[str]]:
        """
        expiration duration of idle refresh tokens
        """
        return pulumi.get(self, "refresh_token_idle_expiration")

    @refresh_token_idle_expiration.setter
    def refresh_token_idle_expiration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_token_idle_expiration", value)


class DefaultOidcSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token_lifetime: Optional[pulumi.Input[str]] = None,
                 id_token_lifetime: Optional[pulumi.Input[str]] = None,
                 refresh_token_expiration: Optional[pulumi.Input[str]] = None,
                 refresh_token_idle_expiration: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource representing the default oidc settings.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.DefaultOidcSettings("default",
            access_token_lifetime="12h0m0s",
            id_token_lifetime="12h0m0s",
            refresh_token_expiration="720h0m0s",
            refresh_token_idle_expiration="2160h0m0s")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_token_lifetime: lifetime duration of access tokens
        :param pulumi.Input[str] id_token_lifetime: lifetime duration of id tokens
        :param pulumi.Input[str] refresh_token_expiration: expiration duration of refresh tokens
        :param pulumi.Input[str] refresh_token_idle_expiration: expiration duration of idle refresh tokens
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DefaultOidcSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource representing the default oidc settings.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.DefaultOidcSettings("default",
            access_token_lifetime="12h0m0s",
            id_token_lifetime="12h0m0s",
            refresh_token_expiration="720h0m0s",
            refresh_token_idle_expiration="2160h0m0s")
        ```

        :param str resource_name: The name of the resource.
        :param DefaultOidcSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DefaultOidcSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            DefaultOidcSettingsArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token_lifetime: Optional[pulumi.Input[str]] = None,
                 id_token_lifetime: Optional[pulumi.Input[str]] = None,
                 refresh_token_expiration: Optional[pulumi.Input[str]] = None,
                 refresh_token_idle_expiration: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DefaultOidcSettingsArgs.__new__(DefaultOidcSettingsArgs)

            if access_token_lifetime is None and not opts.urn:
                raise TypeError("Missing required property 'access_token_lifetime'")
            __props__.__dict__["access_token_lifetime"] = access_token_lifetime
            if id_token_lifetime is None and not opts.urn:
                raise TypeError("Missing required property 'id_token_lifetime'")
            __props__.__dict__["id_token_lifetime"] = id_token_lifetime
            if refresh_token_expiration is None and not opts.urn:
                raise TypeError("Missing required property 'refresh_token_expiration'")
            __props__.__dict__["refresh_token_expiration"] = refresh_token_expiration
            if refresh_token_idle_expiration is None and not opts.urn:
                raise TypeError("Missing required property 'refresh_token_idle_expiration'")
            __props__.__dict__["refresh_token_idle_expiration"] = refresh_token_idle_expiration
        super(DefaultOidcSettings, __self__).__init__(
            'zitadel:index/defaultOidcSettings:DefaultOidcSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_token_lifetime: Optional[pulumi.Input[str]] = None,
            id_token_lifetime: Optional[pulumi.Input[str]] = None,
            refresh_token_expiration: Optional[pulumi.Input[str]] = None,
            refresh_token_idle_expiration: Optional[pulumi.Input[str]] = None) -> 'DefaultOidcSettings':
        """
        Get an existing DefaultOidcSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_token_lifetime: lifetime duration of access tokens
        :param pulumi.Input[str] id_token_lifetime: lifetime duration of id tokens
        :param pulumi.Input[str] refresh_token_expiration: expiration duration of refresh tokens
        :param pulumi.Input[str] refresh_token_idle_expiration: expiration duration of idle refresh tokens
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DefaultOidcSettingsState.__new__(_DefaultOidcSettingsState)

        __props__.__dict__["access_token_lifetime"] = access_token_lifetime
        __props__.__dict__["id_token_lifetime"] = id_token_lifetime
        __props__.__dict__["refresh_token_expiration"] = refresh_token_expiration
        __props__.__dict__["refresh_token_idle_expiration"] = refresh_token_idle_expiration
        return DefaultOidcSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessTokenLifetime")
    def access_token_lifetime(self) -> pulumi.Output[str]:
        """
        lifetime duration of access tokens
        """
        return pulumi.get(self, "access_token_lifetime")

    @property
    @pulumi.getter(name="idTokenLifetime")
    def id_token_lifetime(self) -> pulumi.Output[str]:
        """
        lifetime duration of id tokens
        """
        return pulumi.get(self, "id_token_lifetime")

    @property
    @pulumi.getter(name="refreshTokenExpiration")
    def refresh_token_expiration(self) -> pulumi.Output[str]:
        """
        expiration duration of refresh tokens
        """
        return pulumi.get(self, "refresh_token_expiration")

    @property
    @pulumi.getter(name="refreshTokenIdleExpiration")
    def refresh_token_idle_expiration(self) -> pulumi.Output[str]:
        """
        expiration duration of idle refresh tokens
        """
        return pulumi.get(self, "refresh_token_idle_expiration")

