# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetActionResult',
    'AwaitableGetActionResult',
    'get_action',
    'get_action_output',
]

@pulumi.output_type
class GetActionResult:
    """
    A collection of values returned by getAction.
    """
    def __init__(__self__, action_id=None, allowed_to_fail=None, id=None, name=None, org_id=None, script=None, state=None, timeout=None):
        if action_id and not isinstance(action_id, str):
            raise TypeError("Expected argument 'action_id' to be a str")
        pulumi.set(__self__, "action_id", action_id)
        if allowed_to_fail and not isinstance(allowed_to_fail, bool):
            raise TypeError("Expected argument 'allowed_to_fail' to be a bool")
        pulumi.set(__self__, "allowed_to_fail", allowed_to_fail)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if script and not isinstance(script, str):
            raise TypeError("Expected argument 'script' to be a str")
        pulumi.set(__self__, "script", script)
        if state and not isinstance(state, int):
            raise TypeError("Expected argument 'state' to be a int")
        pulumi.set(__self__, "state", state)
        if timeout and not isinstance(timeout, str):
            raise TypeError("Expected argument 'timeout' to be a str")
        pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="actionId")
    def action_id(self) -> str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "action_id")

    @property
    @pulumi.getter(name="allowedToFail")
    def allowed_to_fail(self) -> bool:
        """
        when true, the next action will be called even if this action fails
        """
        return pulumi.get(self, "allowed_to_fail")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[str]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter
    def script(self) -> str:
        return pulumi.get(self, "script")

    @property
    @pulumi.getter
    def state(self) -> int:
        """
        the state of the action
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def timeout(self) -> str:
        """
        after which time the action will be terminated if not finished
        """
        return pulumi.get(self, "timeout")


class AwaitableGetActionResult(GetActionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetActionResult(
            action_id=self.action_id,
            allowed_to_fail=self.allowed_to_fail,
            id=self.id,
            name=self.name,
            org_id=self.org_id,
            script=self.script,
            state=self.state,
            timeout=self.timeout)


def get_action(action_id: Optional[str] = None,
               org_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetActionResult:
    """
    Datasource representing an action belonging to an organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_zitadel as zitadel

    default = zitadel.get_action(org_id=data["zitadel_org"]["default"]["id"],
        action_id="123456789012345678")
    pulumi.export("action", default)
    ```


    :param str action_id: The ID of this resource.
    :param str org_id: ID of the organization
    """
    __args__ = dict()
    __args__['actionId'] = action_id
    __args__['orgId'] = org_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('zitadel:index/getAction:getAction', __args__, opts=opts, typ=GetActionResult).value

    return AwaitableGetActionResult(
        action_id=pulumi.get(__ret__, 'action_id'),
        allowed_to_fail=pulumi.get(__ret__, 'allowed_to_fail'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        script=pulumi.get(__ret__, 'script'),
        state=pulumi.get(__ret__, 'state'),
        timeout=pulumi.get(__ret__, 'timeout'))


@_utilities.lift_output_func(get_action)
def get_action_output(action_id: Optional[pulumi.Input[str]] = None,
                      org_id: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetActionResult]:
    """
    Datasource representing an action belonging to an organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_zitadel as zitadel

    default = zitadel.get_action(org_id=data["zitadel_org"]["default"]["id"],
        action_id="123456789012345678")
    pulumi.export("action", default)
    ```


    :param str action_id: The ID of this resource.
    :param str org_id: ID of the organization
    """
    ...
