# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetOrgResult',
    'AwaitableGetOrgResult',
    'get_org',
    'get_org_output',
]

@pulumi.output_type
class GetOrgResult:
    """
    A collection of values returned by getOrg.
    """
    def __init__(__self__, id=None, is_default=None, name=None, primary_domain=None, state=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if primary_domain and not isinstance(primary_domain, str):
            raise TypeError("Expected argument 'primary_domain' to be a str")
        pulumi.set(__self__, "primary_domain", primary_domain)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the organization
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        """
        Indicates whether the org is the default org of the instance.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the org.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryDomain")
    def primary_domain(self) -> str:
        """
        Primary domain of the org
        """
        return pulumi.get(self, "primary_domain")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the org, supported values: ORG*STATE*UNSPECIFIED, ORG*STATE*ACTIVE, ORG*STATE*INACTIVE, ORG*STATE*REMOVED
        """
        return pulumi.get(self, "state")


class AwaitableGetOrgResult(GetOrgResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrgResult(
            id=self.id,
            is_default=self.is_default,
            name=self.name,
            primary_domain=self.primary_domain,
            state=self.state)


def get_org(id: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrgResult:
    """
    Datasource representing an organization in ZITADEL, which is the highest level after the instance and contains several other resource including policies if the configuration differs to the default policies on the instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_zitadel as zitadel

    default = zitadel.get_org(id="123456789012345678")
    pulumi.export("org", default)
    ```


    :param str id: ID of the organization
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('zitadel:index/getOrg:getOrg', __args__, opts=opts, typ=GetOrgResult).value

    return AwaitableGetOrgResult(
        id=pulumi.get(__ret__, 'id'),
        is_default=pulumi.get(__ret__, 'is_default'),
        name=pulumi.get(__ret__, 'name'),
        primary_domain=pulumi.get(__ret__, 'primary_domain'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_org)
def get_org_output(id: Optional[pulumi.Input[str]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOrgResult]:
    """
    Datasource representing an organization in ZITADEL, which is the highest level after the instance and contains several other resource including policies if the configuration differs to the default policies on the instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_zitadel as zitadel

    default = zitadel.get_org(id="123456789012345678")
    pulumi.export("org", default)
    ```


    :param str id: ID of the organization
    """
    ...
