# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetOrgJwtIdpResult',
    'AwaitableGetOrgJwtIdpResult',
    'get_org_jwt_idp',
    'get_org_jwt_idp_output',
]

@pulumi.output_type
class GetOrgJwtIdpResult:
    """
    A collection of values returned by getOrgJwtIdp.
    """
    def __init__(__self__, auto_register=None, header_name=None, id=None, idp_id=None, issuer=None, jwt_endpoint=None, keys_endpoint=None, name=None, org_id=None, styling_type=None):
        if auto_register and not isinstance(auto_register, bool):
            raise TypeError("Expected argument 'auto_register' to be a bool")
        pulumi.set(__self__, "auto_register", auto_register)
        if header_name and not isinstance(header_name, str):
            raise TypeError("Expected argument 'header_name' to be a str")
        pulumi.set(__self__, "header_name", header_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if idp_id and not isinstance(idp_id, str):
            raise TypeError("Expected argument 'idp_id' to be a str")
        pulumi.set(__self__, "idp_id", idp_id)
        if issuer and not isinstance(issuer, str):
            raise TypeError("Expected argument 'issuer' to be a str")
        pulumi.set(__self__, "issuer", issuer)
        if jwt_endpoint and not isinstance(jwt_endpoint, str):
            raise TypeError("Expected argument 'jwt_endpoint' to be a str")
        pulumi.set(__self__, "jwt_endpoint", jwt_endpoint)
        if keys_endpoint and not isinstance(keys_endpoint, str):
            raise TypeError("Expected argument 'keys_endpoint' to be a str")
        pulumi.set(__self__, "keys_endpoint", keys_endpoint)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if styling_type and not isinstance(styling_type, str):
            raise TypeError("Expected argument 'styling_type' to be a str")
        pulumi.set(__self__, "styling_type", styling_type)

    @property
    @pulumi.getter(name="autoRegister")
    def auto_register(self) -> bool:
        """
        auto register for users from this idp
        """
        return pulumi.get(self, "auto_register")

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> str:
        """
        the name of the header where the JWT is sent in, default is authorization
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "idp_id")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        the issuer of the jwt (for validation)
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="jwtEndpoint")
    def jwt_endpoint(self) -> str:
        """
        the endpoint where the jwt can be extracted
        """
        return pulumi.get(self, "jwt_endpoint")

    @property
    @pulumi.getter(name="keysEndpoint")
    def keys_endpoint(self) -> str:
        """
        the endpoint to the key (JWK) which are used to sign the JWT with
        """
        return pulumi.get(self, "keys_endpoint")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the IDP
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> str:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="stylingType")
    def styling_type(self) -> str:
        """
        Some identity providers specify the styling of the button to their login
        """
        return pulumi.get(self, "styling_type")


class AwaitableGetOrgJwtIdpResult(GetOrgJwtIdpResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrgJwtIdpResult(
            auto_register=self.auto_register,
            header_name=self.header_name,
            id=self.id,
            idp_id=self.idp_id,
            issuer=self.issuer,
            jwt_endpoint=self.jwt_endpoint,
            keys_endpoint=self.keys_endpoint,
            name=self.name,
            org_id=self.org_id,
            styling_type=self.styling_type)


def get_org_jwt_idp(idp_id: Optional[str] = None,
                    org_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrgJwtIdpResult:
    """
    Datasource representing a generic JWT IdP on the organization.


    :param str idp_id: The ID of this resource.
    :param str org_id: ID of the organization
    """
    __args__ = dict()
    __args__['idpId'] = idp_id
    __args__['orgId'] = org_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('zitadel:index/getOrgJwtIdp:getOrgJwtIdp', __args__, opts=opts, typ=GetOrgJwtIdpResult).value

    return AwaitableGetOrgJwtIdpResult(
        auto_register=pulumi.get(__ret__, 'auto_register'),
        header_name=pulumi.get(__ret__, 'header_name'),
        id=pulumi.get(__ret__, 'id'),
        idp_id=pulumi.get(__ret__, 'idp_id'),
        issuer=pulumi.get(__ret__, 'issuer'),
        jwt_endpoint=pulumi.get(__ret__, 'jwt_endpoint'),
        keys_endpoint=pulumi.get(__ret__, 'keys_endpoint'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        styling_type=pulumi.get(__ret__, 'styling_type'))


@_utilities.lift_output_func(get_org_jwt_idp)
def get_org_jwt_idp_output(idp_id: Optional[pulumi.Input[str]] = None,
                           org_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOrgJwtIdpResult]:
    """
    Datasource representing a generic JWT IdP on the organization.


    :param str idp_id: The ID of this resource.
    :param str org_id: ID of the organization
    """
    ...
