# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetProjectRoleResult',
    'AwaitableGetProjectRoleResult',
    'get_project_role',
    'get_project_role_output',
]

@pulumi.output_type
class GetProjectRoleResult:
    """
    A collection of values returned by getProjectRole.
    """
    def __init__(__self__, display_name=None, group=None, id=None, org_id=None, project_id=None, role_key=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if group and not isinstance(group, str):
            raise TypeError("Expected argument 'group' to be a str")
        pulumi.set(__self__, "group", group)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if role_key and not isinstance(role_key, str):
            raise TypeError("Expected argument 'role_key' to be a str")
        pulumi.set(__self__, "role_key", role_key)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name used for project role
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def group(self) -> str:
        """
        Group used for project role
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> str:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        ID of the project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="roleKey")
    def role_key(self) -> str:
        """
        Key used for project role
        """
        return pulumi.get(self, "role_key")


class AwaitableGetProjectRoleResult(GetProjectRoleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectRoleResult(
            display_name=self.display_name,
            group=self.group,
            id=self.id,
            org_id=self.org_id,
            project_id=self.project_id,
            role_key=self.role_key)


def get_project_role(org_id: Optional[str] = None,
                     project_id: Optional[str] = None,
                     role_key: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectRoleResult:
    """
    Datasource representing the project roles, which can be given as authorizations to users.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_zitadel as zitadel

    default = zitadel.get_project_role(org_id=data["zitadel_org"]["default"]["id"],
        project_id=data["zitadel_project"]["default"]["id"],
        role_key="key")
    pulumi.export("projectRole", default)
    ```


    :param str org_id: ID of the organization
    :param str project_id: ID of the project
    :param str role_key: Key used for project role
    """
    __args__ = dict()
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    __args__['roleKey'] = role_key
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('zitadel:index/getProjectRole:getProjectRole', __args__, opts=opts, typ=GetProjectRoleResult).value

    return AwaitableGetProjectRoleResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        group=pulumi.get(__ret__, 'group'),
        id=pulumi.get(__ret__, 'id'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        role_key=pulumi.get(__ret__, 'role_key'))


@_utilities.lift_output_func(get_project_role)
def get_project_role_output(org_id: Optional[pulumi.Input[str]] = None,
                            project_id: Optional[pulumi.Input[str]] = None,
                            role_key: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProjectRoleResult]:
    """
    Datasource representing the project roles, which can be given as authorizations to users.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_zitadel as zitadel

    default = zitadel.get_project_role(org_id=data["zitadel_org"]["default"]["id"],
        project_id=data["zitadel_project"]["default"]["id"],
        role_key="key")
    pulumi.export("projectRole", default)
    ```


    :param str org_id: ID of the organization
    :param str project_id: ID of the project
    :param str role_key: Key used for project role
    """
    ...
