# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['IdpLdapArgs', 'IdpLdap']

@pulumi.input_type
class IdpLdapArgs:
    def __init__(__self__, *,
                 base_dn: pulumi.Input[str],
                 bind_dn: pulumi.Input[str],
                 bind_password: pulumi.Input[str],
                 is_auto_creation: pulumi.Input[bool],
                 is_auto_update: pulumi.Input[bool],
                 is_creation_allowed: pulumi.Input[bool],
                 is_linking_allowed: pulumi.Input[bool],
                 servers: pulumi.Input[Sequence[pulumi.Input[str]]],
                 start_tls: pulumi.Input[bool],
                 timeout: pulumi.Input[str],
                 user_base: pulumi.Input[str],
                 user_filters: pulumi.Input[Sequence[pulumi.Input[str]]],
                 user_object_classes: pulumi.Input[Sequence[pulumi.Input[str]]],
                 avatar_url_attribute: Optional[pulumi.Input[str]] = None,
                 display_name_attribute: Optional[pulumi.Input[str]] = None,
                 email_attribute: Optional[pulumi.Input[str]] = None,
                 email_verified_attribute: Optional[pulumi.Input[str]] = None,
                 first_name_attribute: Optional[pulumi.Input[str]] = None,
                 id_attribute: Optional[pulumi.Input[str]] = None,
                 last_name_attribute: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nick_name_attribute: Optional[pulumi.Input[str]] = None,
                 phone_attribute: Optional[pulumi.Input[str]] = None,
                 phone_verified_attribute: Optional[pulumi.Input[str]] = None,
                 preferred_language_attribute: Optional[pulumi.Input[str]] = None,
                 preferred_username_attribute: Optional[pulumi.Input[str]] = None,
                 profile_attribute: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a IdpLdap resource.
        :param pulumi.Input[str] base_dn: Base DN for LDAP connections
        :param pulumi.Input[str] bind_dn: Bind DN for LDAP connections
        :param pulumi.Input[str] bind_password: Bind password for LDAP connections
        :param pulumi.Input[bool] is_auto_creation: enable if a new account in ZITADEL should be created automatically on login with an external account
        :param pulumi.Input[bool] is_auto_update: enable if a the ZITADEL account fields should be updated automatically on each login
        :param pulumi.Input[bool] is_creation_allowed: enable if users should be able to create a new account in ZITADEL when using an external account
        :param pulumi.Input[bool] is_linking_allowed: enable if users should be able to link an existing ZITADEL user with an external account
        :param pulumi.Input[Sequence[pulumi.Input[str]]] servers: Servers to try in order for establishing LDAP connections
        :param pulumi.Input[bool] start_tls: Wether to use StartTLS for LDAP connections
        :param pulumi.Input[str] timeout: Timeout for LDAP connections
        :param pulumi.Input[str] user_base: User base for LDAP connections
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_filters: User filters for LDAP connections
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_object_classes: User object classes for LDAP connections
        :param pulumi.Input[str] avatar_url_attribute: User attribute for the avatar url
        :param pulumi.Input[str] display_name_attribute: User attribute for the display name
        :param pulumi.Input[str] email_attribute: User attribute for the email
        :param pulumi.Input[str] email_verified_attribute: User attribute for the email verified state
        :param pulumi.Input[str] first_name_attribute: User attribute for the first name
        :param pulumi.Input[str] id_attribute: User attribute for the id
        :param pulumi.Input[str] last_name_attribute: User attribute for the last name
        :param pulumi.Input[str] name: Name of the IDP
        :param pulumi.Input[str] nick_name_attribute: User attribute for the nick name
        :param pulumi.Input[str] phone_attribute: User attribute for the phone
        :param pulumi.Input[str] phone_verified_attribute: User attribute for the phone verified state
        :param pulumi.Input[str] preferred_language_attribute: User attribute for the preferred language
        :param pulumi.Input[str] preferred_username_attribute: User attribute for the preferred username
        :param pulumi.Input[str] profile_attribute: User attribute for the profile
        """
        IdpLdapArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            base_dn=base_dn,
            bind_dn=bind_dn,
            bind_password=bind_password,
            is_auto_creation=is_auto_creation,
            is_auto_update=is_auto_update,
            is_creation_allowed=is_creation_allowed,
            is_linking_allowed=is_linking_allowed,
            servers=servers,
            start_tls=start_tls,
            timeout=timeout,
            user_base=user_base,
            user_filters=user_filters,
            user_object_classes=user_object_classes,
            avatar_url_attribute=avatar_url_attribute,
            display_name_attribute=display_name_attribute,
            email_attribute=email_attribute,
            email_verified_attribute=email_verified_attribute,
            first_name_attribute=first_name_attribute,
            id_attribute=id_attribute,
            last_name_attribute=last_name_attribute,
            name=name,
            nick_name_attribute=nick_name_attribute,
            phone_attribute=phone_attribute,
            phone_verified_attribute=phone_verified_attribute,
            preferred_language_attribute=preferred_language_attribute,
            preferred_username_attribute=preferred_username_attribute,
            profile_attribute=profile_attribute,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             base_dn: pulumi.Input[str],
             bind_dn: pulumi.Input[str],
             bind_password: pulumi.Input[str],
             is_auto_creation: pulumi.Input[bool],
             is_auto_update: pulumi.Input[bool],
             is_creation_allowed: pulumi.Input[bool],
             is_linking_allowed: pulumi.Input[bool],
             servers: pulumi.Input[Sequence[pulumi.Input[str]]],
             start_tls: pulumi.Input[bool],
             timeout: pulumi.Input[str],
             user_base: pulumi.Input[str],
             user_filters: pulumi.Input[Sequence[pulumi.Input[str]]],
             user_object_classes: pulumi.Input[Sequence[pulumi.Input[str]]],
             avatar_url_attribute: Optional[pulumi.Input[str]] = None,
             display_name_attribute: Optional[pulumi.Input[str]] = None,
             email_attribute: Optional[pulumi.Input[str]] = None,
             email_verified_attribute: Optional[pulumi.Input[str]] = None,
             first_name_attribute: Optional[pulumi.Input[str]] = None,
             id_attribute: Optional[pulumi.Input[str]] = None,
             last_name_attribute: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             nick_name_attribute: Optional[pulumi.Input[str]] = None,
             phone_attribute: Optional[pulumi.Input[str]] = None,
             phone_verified_attribute: Optional[pulumi.Input[str]] = None,
             preferred_language_attribute: Optional[pulumi.Input[str]] = None,
             preferred_username_attribute: Optional[pulumi.Input[str]] = None,
             profile_attribute: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'baseDn' in kwargs:
            base_dn = kwargs['baseDn']
        if 'bindDn' in kwargs:
            bind_dn = kwargs['bindDn']
        if 'bindPassword' in kwargs:
            bind_password = kwargs['bindPassword']
        if 'isAutoCreation' in kwargs:
            is_auto_creation = kwargs['isAutoCreation']
        if 'isAutoUpdate' in kwargs:
            is_auto_update = kwargs['isAutoUpdate']
        if 'isCreationAllowed' in kwargs:
            is_creation_allowed = kwargs['isCreationAllowed']
        if 'isLinkingAllowed' in kwargs:
            is_linking_allowed = kwargs['isLinkingAllowed']
        if 'startTls' in kwargs:
            start_tls = kwargs['startTls']
        if 'userBase' in kwargs:
            user_base = kwargs['userBase']
        if 'userFilters' in kwargs:
            user_filters = kwargs['userFilters']
        if 'userObjectClasses' in kwargs:
            user_object_classes = kwargs['userObjectClasses']
        if 'avatarUrlAttribute' in kwargs:
            avatar_url_attribute = kwargs['avatarUrlAttribute']
        if 'displayNameAttribute' in kwargs:
            display_name_attribute = kwargs['displayNameAttribute']
        if 'emailAttribute' in kwargs:
            email_attribute = kwargs['emailAttribute']
        if 'emailVerifiedAttribute' in kwargs:
            email_verified_attribute = kwargs['emailVerifiedAttribute']
        if 'firstNameAttribute' in kwargs:
            first_name_attribute = kwargs['firstNameAttribute']
        if 'idAttribute' in kwargs:
            id_attribute = kwargs['idAttribute']
        if 'lastNameAttribute' in kwargs:
            last_name_attribute = kwargs['lastNameAttribute']
        if 'nickNameAttribute' in kwargs:
            nick_name_attribute = kwargs['nickNameAttribute']
        if 'phoneAttribute' in kwargs:
            phone_attribute = kwargs['phoneAttribute']
        if 'phoneVerifiedAttribute' in kwargs:
            phone_verified_attribute = kwargs['phoneVerifiedAttribute']
        if 'preferredLanguageAttribute' in kwargs:
            preferred_language_attribute = kwargs['preferredLanguageAttribute']
        if 'preferredUsernameAttribute' in kwargs:
            preferred_username_attribute = kwargs['preferredUsernameAttribute']
        if 'profileAttribute' in kwargs:
            profile_attribute = kwargs['profileAttribute']

        _setter("base_dn", base_dn)
        _setter("bind_dn", bind_dn)
        _setter("bind_password", bind_password)
        _setter("is_auto_creation", is_auto_creation)
        _setter("is_auto_update", is_auto_update)
        _setter("is_creation_allowed", is_creation_allowed)
        _setter("is_linking_allowed", is_linking_allowed)
        _setter("servers", servers)
        _setter("start_tls", start_tls)
        _setter("timeout", timeout)
        _setter("user_base", user_base)
        _setter("user_filters", user_filters)
        _setter("user_object_classes", user_object_classes)
        if avatar_url_attribute is not None:
            _setter("avatar_url_attribute", avatar_url_attribute)
        if display_name_attribute is not None:
            _setter("display_name_attribute", display_name_attribute)
        if email_attribute is not None:
            _setter("email_attribute", email_attribute)
        if email_verified_attribute is not None:
            _setter("email_verified_attribute", email_verified_attribute)
        if first_name_attribute is not None:
            _setter("first_name_attribute", first_name_attribute)
        if id_attribute is not None:
            _setter("id_attribute", id_attribute)
        if last_name_attribute is not None:
            _setter("last_name_attribute", last_name_attribute)
        if name is not None:
            _setter("name", name)
        if nick_name_attribute is not None:
            _setter("nick_name_attribute", nick_name_attribute)
        if phone_attribute is not None:
            _setter("phone_attribute", phone_attribute)
        if phone_verified_attribute is not None:
            _setter("phone_verified_attribute", phone_verified_attribute)
        if preferred_language_attribute is not None:
            _setter("preferred_language_attribute", preferred_language_attribute)
        if preferred_username_attribute is not None:
            _setter("preferred_username_attribute", preferred_username_attribute)
        if profile_attribute is not None:
            _setter("profile_attribute", profile_attribute)

    @property
    @pulumi.getter(name="baseDn")
    def base_dn(self) -> pulumi.Input[str]:
        """
        Base DN for LDAP connections
        """
        return pulumi.get(self, "base_dn")

    @base_dn.setter
    def base_dn(self, value: pulumi.Input[str]):
        pulumi.set(self, "base_dn", value)

    @property
    @pulumi.getter(name="bindDn")
    def bind_dn(self) -> pulumi.Input[str]:
        """
        Bind DN for LDAP connections
        """
        return pulumi.get(self, "bind_dn")

    @bind_dn.setter
    def bind_dn(self, value: pulumi.Input[str]):
        pulumi.set(self, "bind_dn", value)

    @property
    @pulumi.getter(name="bindPassword")
    def bind_password(self) -> pulumi.Input[str]:
        """
        Bind password for LDAP connections
        """
        return pulumi.get(self, "bind_password")

    @bind_password.setter
    def bind_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "bind_password", value)

    @property
    @pulumi.getter(name="isAutoCreation")
    def is_auto_creation(self) -> pulumi.Input[bool]:
        """
        enable if a new account in ZITADEL should be created automatically on login with an external account
        """
        return pulumi.get(self, "is_auto_creation")

    @is_auto_creation.setter
    def is_auto_creation(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_auto_creation", value)

    @property
    @pulumi.getter(name="isAutoUpdate")
    def is_auto_update(self) -> pulumi.Input[bool]:
        """
        enable if a the ZITADEL account fields should be updated automatically on each login
        """
        return pulumi.get(self, "is_auto_update")

    @is_auto_update.setter
    def is_auto_update(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_auto_update", value)

    @property
    @pulumi.getter(name="isCreationAllowed")
    def is_creation_allowed(self) -> pulumi.Input[bool]:
        """
        enable if users should be able to create a new account in ZITADEL when using an external account
        """
        return pulumi.get(self, "is_creation_allowed")

    @is_creation_allowed.setter
    def is_creation_allowed(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_creation_allowed", value)

    @property
    @pulumi.getter(name="isLinkingAllowed")
    def is_linking_allowed(self) -> pulumi.Input[bool]:
        """
        enable if users should be able to link an existing ZITADEL user with an external account
        """
        return pulumi.get(self, "is_linking_allowed")

    @is_linking_allowed.setter
    def is_linking_allowed(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_linking_allowed", value)

    @property
    @pulumi.getter
    def servers(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Servers to try in order for establishing LDAP connections
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "servers", value)

    @property
    @pulumi.getter(name="startTls")
    def start_tls(self) -> pulumi.Input[bool]:
        """
        Wether to use StartTLS for LDAP connections
        """
        return pulumi.get(self, "start_tls")

    @start_tls.setter
    def start_tls(self, value: pulumi.Input[bool]):
        pulumi.set(self, "start_tls", value)

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Input[str]:
        """
        Timeout for LDAP connections
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: pulumi.Input[str]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="userBase")
    def user_base(self) -> pulumi.Input[str]:
        """
        User base for LDAP connections
        """
        return pulumi.get(self, "user_base")

    @user_base.setter
    def user_base(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_base", value)

    @property
    @pulumi.getter(name="userFilters")
    def user_filters(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        User filters for LDAP connections
        """
        return pulumi.get(self, "user_filters")

    @user_filters.setter
    def user_filters(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "user_filters", value)

    @property
    @pulumi.getter(name="userObjectClasses")
    def user_object_classes(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        User object classes for LDAP connections
        """
        return pulumi.get(self, "user_object_classes")

    @user_object_classes.setter
    def user_object_classes(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "user_object_classes", value)

    @property
    @pulumi.getter(name="avatarUrlAttribute")
    def avatar_url_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the avatar url
        """
        return pulumi.get(self, "avatar_url_attribute")

    @avatar_url_attribute.setter
    def avatar_url_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "avatar_url_attribute", value)

    @property
    @pulumi.getter(name="displayNameAttribute")
    def display_name_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the display name
        """
        return pulumi.get(self, "display_name_attribute")

    @display_name_attribute.setter
    def display_name_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name_attribute", value)

    @property
    @pulumi.getter(name="emailAttribute")
    def email_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the email
        """
        return pulumi.get(self, "email_attribute")

    @email_attribute.setter
    def email_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_attribute", value)

    @property
    @pulumi.getter(name="emailVerifiedAttribute")
    def email_verified_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the email verified state
        """
        return pulumi.get(self, "email_verified_attribute")

    @email_verified_attribute.setter
    def email_verified_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_verified_attribute", value)

    @property
    @pulumi.getter(name="firstNameAttribute")
    def first_name_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the first name
        """
        return pulumi.get(self, "first_name_attribute")

    @first_name_attribute.setter
    def first_name_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_name_attribute", value)

    @property
    @pulumi.getter(name="idAttribute")
    def id_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the id
        """
        return pulumi.get(self, "id_attribute")

    @id_attribute.setter
    def id_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id_attribute", value)

    @property
    @pulumi.getter(name="lastNameAttribute")
    def last_name_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the last name
        """
        return pulumi.get(self, "last_name_attribute")

    @last_name_attribute.setter
    def last_name_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_name_attribute", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the IDP
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nickNameAttribute")
    def nick_name_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the nick name
        """
        return pulumi.get(self, "nick_name_attribute")

    @nick_name_attribute.setter
    def nick_name_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nick_name_attribute", value)

    @property
    @pulumi.getter(name="phoneAttribute")
    def phone_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the phone
        """
        return pulumi.get(self, "phone_attribute")

    @phone_attribute.setter
    def phone_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone_attribute", value)

    @property
    @pulumi.getter(name="phoneVerifiedAttribute")
    def phone_verified_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the phone verified state
        """
        return pulumi.get(self, "phone_verified_attribute")

    @phone_verified_attribute.setter
    def phone_verified_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone_verified_attribute", value)

    @property
    @pulumi.getter(name="preferredLanguageAttribute")
    def preferred_language_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the preferred language
        """
        return pulumi.get(self, "preferred_language_attribute")

    @preferred_language_attribute.setter
    def preferred_language_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_language_attribute", value)

    @property
    @pulumi.getter(name="preferredUsernameAttribute")
    def preferred_username_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the preferred username
        """
        return pulumi.get(self, "preferred_username_attribute")

    @preferred_username_attribute.setter
    def preferred_username_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_username_attribute", value)

    @property
    @pulumi.getter(name="profileAttribute")
    def profile_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the profile
        """
        return pulumi.get(self, "profile_attribute")

    @profile_attribute.setter
    def profile_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_attribute", value)


@pulumi.input_type
class _IdpLdapState:
    def __init__(__self__, *,
                 avatar_url_attribute: Optional[pulumi.Input[str]] = None,
                 base_dn: Optional[pulumi.Input[str]] = None,
                 bind_dn: Optional[pulumi.Input[str]] = None,
                 bind_password: Optional[pulumi.Input[str]] = None,
                 display_name_attribute: Optional[pulumi.Input[str]] = None,
                 email_attribute: Optional[pulumi.Input[str]] = None,
                 email_verified_attribute: Optional[pulumi.Input[str]] = None,
                 first_name_attribute: Optional[pulumi.Input[str]] = None,
                 id_attribute: Optional[pulumi.Input[str]] = None,
                 is_auto_creation: Optional[pulumi.Input[bool]] = None,
                 is_auto_update: Optional[pulumi.Input[bool]] = None,
                 is_creation_allowed: Optional[pulumi.Input[bool]] = None,
                 is_linking_allowed: Optional[pulumi.Input[bool]] = None,
                 last_name_attribute: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nick_name_attribute: Optional[pulumi.Input[str]] = None,
                 phone_attribute: Optional[pulumi.Input[str]] = None,
                 phone_verified_attribute: Optional[pulumi.Input[str]] = None,
                 preferred_language_attribute: Optional[pulumi.Input[str]] = None,
                 preferred_username_attribute: Optional[pulumi.Input[str]] = None,
                 profile_attribute: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 start_tls: Optional[pulumi.Input[bool]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 user_base: Optional[pulumi.Input[str]] = None,
                 user_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_object_classes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering IdpLdap resources.
        :param pulumi.Input[str] avatar_url_attribute: User attribute for the avatar url
        :param pulumi.Input[str] base_dn: Base DN for LDAP connections
        :param pulumi.Input[str] bind_dn: Bind DN for LDAP connections
        :param pulumi.Input[str] bind_password: Bind password for LDAP connections
        :param pulumi.Input[str] display_name_attribute: User attribute for the display name
        :param pulumi.Input[str] email_attribute: User attribute for the email
        :param pulumi.Input[str] email_verified_attribute: User attribute for the email verified state
        :param pulumi.Input[str] first_name_attribute: User attribute for the first name
        :param pulumi.Input[str] id_attribute: User attribute for the id
        :param pulumi.Input[bool] is_auto_creation: enable if a new account in ZITADEL should be created automatically on login with an external account
        :param pulumi.Input[bool] is_auto_update: enable if a the ZITADEL account fields should be updated automatically on each login
        :param pulumi.Input[bool] is_creation_allowed: enable if users should be able to create a new account in ZITADEL when using an external account
        :param pulumi.Input[bool] is_linking_allowed: enable if users should be able to link an existing ZITADEL user with an external account
        :param pulumi.Input[str] last_name_attribute: User attribute for the last name
        :param pulumi.Input[str] name: Name of the IDP
        :param pulumi.Input[str] nick_name_attribute: User attribute for the nick name
        :param pulumi.Input[str] phone_attribute: User attribute for the phone
        :param pulumi.Input[str] phone_verified_attribute: User attribute for the phone verified state
        :param pulumi.Input[str] preferred_language_attribute: User attribute for the preferred language
        :param pulumi.Input[str] preferred_username_attribute: User attribute for the preferred username
        :param pulumi.Input[str] profile_attribute: User attribute for the profile
        :param pulumi.Input[Sequence[pulumi.Input[str]]] servers: Servers to try in order for establishing LDAP connections
        :param pulumi.Input[bool] start_tls: Wether to use StartTLS for LDAP connections
        :param pulumi.Input[str] timeout: Timeout for LDAP connections
        :param pulumi.Input[str] user_base: User base for LDAP connections
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_filters: User filters for LDAP connections
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_object_classes: User object classes for LDAP connections
        """
        _IdpLdapState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            avatar_url_attribute=avatar_url_attribute,
            base_dn=base_dn,
            bind_dn=bind_dn,
            bind_password=bind_password,
            display_name_attribute=display_name_attribute,
            email_attribute=email_attribute,
            email_verified_attribute=email_verified_attribute,
            first_name_attribute=first_name_attribute,
            id_attribute=id_attribute,
            is_auto_creation=is_auto_creation,
            is_auto_update=is_auto_update,
            is_creation_allowed=is_creation_allowed,
            is_linking_allowed=is_linking_allowed,
            last_name_attribute=last_name_attribute,
            name=name,
            nick_name_attribute=nick_name_attribute,
            phone_attribute=phone_attribute,
            phone_verified_attribute=phone_verified_attribute,
            preferred_language_attribute=preferred_language_attribute,
            preferred_username_attribute=preferred_username_attribute,
            profile_attribute=profile_attribute,
            servers=servers,
            start_tls=start_tls,
            timeout=timeout,
            user_base=user_base,
            user_filters=user_filters,
            user_object_classes=user_object_classes,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             avatar_url_attribute: Optional[pulumi.Input[str]] = None,
             base_dn: Optional[pulumi.Input[str]] = None,
             bind_dn: Optional[pulumi.Input[str]] = None,
             bind_password: Optional[pulumi.Input[str]] = None,
             display_name_attribute: Optional[pulumi.Input[str]] = None,
             email_attribute: Optional[pulumi.Input[str]] = None,
             email_verified_attribute: Optional[pulumi.Input[str]] = None,
             first_name_attribute: Optional[pulumi.Input[str]] = None,
             id_attribute: Optional[pulumi.Input[str]] = None,
             is_auto_creation: Optional[pulumi.Input[bool]] = None,
             is_auto_update: Optional[pulumi.Input[bool]] = None,
             is_creation_allowed: Optional[pulumi.Input[bool]] = None,
             is_linking_allowed: Optional[pulumi.Input[bool]] = None,
             last_name_attribute: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             nick_name_attribute: Optional[pulumi.Input[str]] = None,
             phone_attribute: Optional[pulumi.Input[str]] = None,
             phone_verified_attribute: Optional[pulumi.Input[str]] = None,
             preferred_language_attribute: Optional[pulumi.Input[str]] = None,
             preferred_username_attribute: Optional[pulumi.Input[str]] = None,
             profile_attribute: Optional[pulumi.Input[str]] = None,
             servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             start_tls: Optional[pulumi.Input[bool]] = None,
             timeout: Optional[pulumi.Input[str]] = None,
             user_base: Optional[pulumi.Input[str]] = None,
             user_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             user_object_classes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'avatarUrlAttribute' in kwargs:
            avatar_url_attribute = kwargs['avatarUrlAttribute']
        if 'baseDn' in kwargs:
            base_dn = kwargs['baseDn']
        if 'bindDn' in kwargs:
            bind_dn = kwargs['bindDn']
        if 'bindPassword' in kwargs:
            bind_password = kwargs['bindPassword']
        if 'displayNameAttribute' in kwargs:
            display_name_attribute = kwargs['displayNameAttribute']
        if 'emailAttribute' in kwargs:
            email_attribute = kwargs['emailAttribute']
        if 'emailVerifiedAttribute' in kwargs:
            email_verified_attribute = kwargs['emailVerifiedAttribute']
        if 'firstNameAttribute' in kwargs:
            first_name_attribute = kwargs['firstNameAttribute']
        if 'idAttribute' in kwargs:
            id_attribute = kwargs['idAttribute']
        if 'isAutoCreation' in kwargs:
            is_auto_creation = kwargs['isAutoCreation']
        if 'isAutoUpdate' in kwargs:
            is_auto_update = kwargs['isAutoUpdate']
        if 'isCreationAllowed' in kwargs:
            is_creation_allowed = kwargs['isCreationAllowed']
        if 'isLinkingAllowed' in kwargs:
            is_linking_allowed = kwargs['isLinkingAllowed']
        if 'lastNameAttribute' in kwargs:
            last_name_attribute = kwargs['lastNameAttribute']
        if 'nickNameAttribute' in kwargs:
            nick_name_attribute = kwargs['nickNameAttribute']
        if 'phoneAttribute' in kwargs:
            phone_attribute = kwargs['phoneAttribute']
        if 'phoneVerifiedAttribute' in kwargs:
            phone_verified_attribute = kwargs['phoneVerifiedAttribute']
        if 'preferredLanguageAttribute' in kwargs:
            preferred_language_attribute = kwargs['preferredLanguageAttribute']
        if 'preferredUsernameAttribute' in kwargs:
            preferred_username_attribute = kwargs['preferredUsernameAttribute']
        if 'profileAttribute' in kwargs:
            profile_attribute = kwargs['profileAttribute']
        if 'startTls' in kwargs:
            start_tls = kwargs['startTls']
        if 'userBase' in kwargs:
            user_base = kwargs['userBase']
        if 'userFilters' in kwargs:
            user_filters = kwargs['userFilters']
        if 'userObjectClasses' in kwargs:
            user_object_classes = kwargs['userObjectClasses']

        if avatar_url_attribute is not None:
            _setter("avatar_url_attribute", avatar_url_attribute)
        if base_dn is not None:
            _setter("base_dn", base_dn)
        if bind_dn is not None:
            _setter("bind_dn", bind_dn)
        if bind_password is not None:
            _setter("bind_password", bind_password)
        if display_name_attribute is not None:
            _setter("display_name_attribute", display_name_attribute)
        if email_attribute is not None:
            _setter("email_attribute", email_attribute)
        if email_verified_attribute is not None:
            _setter("email_verified_attribute", email_verified_attribute)
        if first_name_attribute is not None:
            _setter("first_name_attribute", first_name_attribute)
        if id_attribute is not None:
            _setter("id_attribute", id_attribute)
        if is_auto_creation is not None:
            _setter("is_auto_creation", is_auto_creation)
        if is_auto_update is not None:
            _setter("is_auto_update", is_auto_update)
        if is_creation_allowed is not None:
            _setter("is_creation_allowed", is_creation_allowed)
        if is_linking_allowed is not None:
            _setter("is_linking_allowed", is_linking_allowed)
        if last_name_attribute is not None:
            _setter("last_name_attribute", last_name_attribute)
        if name is not None:
            _setter("name", name)
        if nick_name_attribute is not None:
            _setter("nick_name_attribute", nick_name_attribute)
        if phone_attribute is not None:
            _setter("phone_attribute", phone_attribute)
        if phone_verified_attribute is not None:
            _setter("phone_verified_attribute", phone_verified_attribute)
        if preferred_language_attribute is not None:
            _setter("preferred_language_attribute", preferred_language_attribute)
        if preferred_username_attribute is not None:
            _setter("preferred_username_attribute", preferred_username_attribute)
        if profile_attribute is not None:
            _setter("profile_attribute", profile_attribute)
        if servers is not None:
            _setter("servers", servers)
        if start_tls is not None:
            _setter("start_tls", start_tls)
        if timeout is not None:
            _setter("timeout", timeout)
        if user_base is not None:
            _setter("user_base", user_base)
        if user_filters is not None:
            _setter("user_filters", user_filters)
        if user_object_classes is not None:
            _setter("user_object_classes", user_object_classes)

    @property
    @pulumi.getter(name="avatarUrlAttribute")
    def avatar_url_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the avatar url
        """
        return pulumi.get(self, "avatar_url_attribute")

    @avatar_url_attribute.setter
    def avatar_url_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "avatar_url_attribute", value)

    @property
    @pulumi.getter(name="baseDn")
    def base_dn(self) -> Optional[pulumi.Input[str]]:
        """
        Base DN for LDAP connections
        """
        return pulumi.get(self, "base_dn")

    @base_dn.setter
    def base_dn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_dn", value)

    @property
    @pulumi.getter(name="bindDn")
    def bind_dn(self) -> Optional[pulumi.Input[str]]:
        """
        Bind DN for LDAP connections
        """
        return pulumi.get(self, "bind_dn")

    @bind_dn.setter
    def bind_dn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bind_dn", value)

    @property
    @pulumi.getter(name="bindPassword")
    def bind_password(self) -> Optional[pulumi.Input[str]]:
        """
        Bind password for LDAP connections
        """
        return pulumi.get(self, "bind_password")

    @bind_password.setter
    def bind_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bind_password", value)

    @property
    @pulumi.getter(name="displayNameAttribute")
    def display_name_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the display name
        """
        return pulumi.get(self, "display_name_attribute")

    @display_name_attribute.setter
    def display_name_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name_attribute", value)

    @property
    @pulumi.getter(name="emailAttribute")
    def email_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the email
        """
        return pulumi.get(self, "email_attribute")

    @email_attribute.setter
    def email_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_attribute", value)

    @property
    @pulumi.getter(name="emailVerifiedAttribute")
    def email_verified_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the email verified state
        """
        return pulumi.get(self, "email_verified_attribute")

    @email_verified_attribute.setter
    def email_verified_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_verified_attribute", value)

    @property
    @pulumi.getter(name="firstNameAttribute")
    def first_name_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the first name
        """
        return pulumi.get(self, "first_name_attribute")

    @first_name_attribute.setter
    def first_name_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_name_attribute", value)

    @property
    @pulumi.getter(name="idAttribute")
    def id_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the id
        """
        return pulumi.get(self, "id_attribute")

    @id_attribute.setter
    def id_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id_attribute", value)

    @property
    @pulumi.getter(name="isAutoCreation")
    def is_auto_creation(self) -> Optional[pulumi.Input[bool]]:
        """
        enable if a new account in ZITADEL should be created automatically on login with an external account
        """
        return pulumi.get(self, "is_auto_creation")

    @is_auto_creation.setter
    def is_auto_creation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_creation", value)

    @property
    @pulumi.getter(name="isAutoUpdate")
    def is_auto_update(self) -> Optional[pulumi.Input[bool]]:
        """
        enable if a the ZITADEL account fields should be updated automatically on each login
        """
        return pulumi.get(self, "is_auto_update")

    @is_auto_update.setter
    def is_auto_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_update", value)

    @property
    @pulumi.getter(name="isCreationAllowed")
    def is_creation_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        enable if users should be able to create a new account in ZITADEL when using an external account
        """
        return pulumi.get(self, "is_creation_allowed")

    @is_creation_allowed.setter
    def is_creation_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_creation_allowed", value)

    @property
    @pulumi.getter(name="isLinkingAllowed")
    def is_linking_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        enable if users should be able to link an existing ZITADEL user with an external account
        """
        return pulumi.get(self, "is_linking_allowed")

    @is_linking_allowed.setter
    def is_linking_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_linking_allowed", value)

    @property
    @pulumi.getter(name="lastNameAttribute")
    def last_name_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the last name
        """
        return pulumi.get(self, "last_name_attribute")

    @last_name_attribute.setter
    def last_name_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_name_attribute", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the IDP
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nickNameAttribute")
    def nick_name_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the nick name
        """
        return pulumi.get(self, "nick_name_attribute")

    @nick_name_attribute.setter
    def nick_name_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nick_name_attribute", value)

    @property
    @pulumi.getter(name="phoneAttribute")
    def phone_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the phone
        """
        return pulumi.get(self, "phone_attribute")

    @phone_attribute.setter
    def phone_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone_attribute", value)

    @property
    @pulumi.getter(name="phoneVerifiedAttribute")
    def phone_verified_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the phone verified state
        """
        return pulumi.get(self, "phone_verified_attribute")

    @phone_verified_attribute.setter
    def phone_verified_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone_verified_attribute", value)

    @property
    @pulumi.getter(name="preferredLanguageAttribute")
    def preferred_language_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the preferred language
        """
        return pulumi.get(self, "preferred_language_attribute")

    @preferred_language_attribute.setter
    def preferred_language_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_language_attribute", value)

    @property
    @pulumi.getter(name="preferredUsernameAttribute")
    def preferred_username_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the preferred username
        """
        return pulumi.get(self, "preferred_username_attribute")

    @preferred_username_attribute.setter
    def preferred_username_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_username_attribute", value)

    @property
    @pulumi.getter(name="profileAttribute")
    def profile_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for the profile
        """
        return pulumi.get(self, "profile_attribute")

    @profile_attribute.setter
    def profile_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_attribute", value)

    @property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Servers to try in order for establishing LDAP connections
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "servers", value)

    @property
    @pulumi.getter(name="startTls")
    def start_tls(self) -> Optional[pulumi.Input[bool]]:
        """
        Wether to use StartTLS for LDAP connections
        """
        return pulumi.get(self, "start_tls")

    @start_tls.setter
    def start_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "start_tls", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Timeout for LDAP connections
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="userBase")
    def user_base(self) -> Optional[pulumi.Input[str]]:
        """
        User base for LDAP connections
        """
        return pulumi.get(self, "user_base")

    @user_base.setter
    def user_base(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_base", value)

    @property
    @pulumi.getter(name="userFilters")
    def user_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        User filters for LDAP connections
        """
        return pulumi.get(self, "user_filters")

    @user_filters.setter
    def user_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_filters", value)

    @property
    @pulumi.getter(name="userObjectClasses")
    def user_object_classes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        User object classes for LDAP connections
        """
        return pulumi.get(self, "user_object_classes")

    @user_object_classes.setter
    def user_object_classes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_object_classes", value)


class IdpLdap(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 avatar_url_attribute: Optional[pulumi.Input[str]] = None,
                 base_dn: Optional[pulumi.Input[str]] = None,
                 bind_dn: Optional[pulumi.Input[str]] = None,
                 bind_password: Optional[pulumi.Input[str]] = None,
                 display_name_attribute: Optional[pulumi.Input[str]] = None,
                 email_attribute: Optional[pulumi.Input[str]] = None,
                 email_verified_attribute: Optional[pulumi.Input[str]] = None,
                 first_name_attribute: Optional[pulumi.Input[str]] = None,
                 id_attribute: Optional[pulumi.Input[str]] = None,
                 is_auto_creation: Optional[pulumi.Input[bool]] = None,
                 is_auto_update: Optional[pulumi.Input[bool]] = None,
                 is_creation_allowed: Optional[pulumi.Input[bool]] = None,
                 is_linking_allowed: Optional[pulumi.Input[bool]] = None,
                 last_name_attribute: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nick_name_attribute: Optional[pulumi.Input[str]] = None,
                 phone_attribute: Optional[pulumi.Input[str]] = None,
                 phone_verified_attribute: Optional[pulumi.Input[str]] = None,
                 preferred_language_attribute: Optional[pulumi.Input[str]] = None,
                 preferred_username_attribute: Optional[pulumi.Input[str]] = None,
                 profile_attribute: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 start_tls: Optional[pulumi.Input[bool]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 user_base: Optional[pulumi.Input[str]] = None,
                 user_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_object_classes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource representing an LDAP IDP on the instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.IdpLdap("default",
            base_dn="dc=example,dc=com",
            bind_dn="cn=admin,dc=example,dc=com",
            bind_password="Password1!",
            first_name_attribute="firstname",
            id_attribute="uid",
            is_auto_creation=False,
            is_auto_update=True,
            is_creation_allowed=True,
            is_linking_allowed=False,
            last_name_attribute="lastname",
            servers=[
                "ldaps://my.primary.server:389",
                "ldaps://my.secondary.server:389",
            ],
            start_tls=False,
            timeout="10s",
            user_base="dn",
            user_filters=[
                "uid",
                "email",
            ],
            user_object_classes=["inetOrgPerson"])
        ```

        ## Import

        terraform The resource can be imported using the ID format `<id[:bind_password]>`, e.g.

        ```sh
         $ pulumi import zitadel:index/idpLdap:IdpLdap imported '123456789012345678:b1nd_p4ssw0rd'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] avatar_url_attribute: User attribute for the avatar url
        :param pulumi.Input[str] base_dn: Base DN for LDAP connections
        :param pulumi.Input[str] bind_dn: Bind DN for LDAP connections
        :param pulumi.Input[str] bind_password: Bind password for LDAP connections
        :param pulumi.Input[str] display_name_attribute: User attribute for the display name
        :param pulumi.Input[str] email_attribute: User attribute for the email
        :param pulumi.Input[str] email_verified_attribute: User attribute for the email verified state
        :param pulumi.Input[str] first_name_attribute: User attribute for the first name
        :param pulumi.Input[str] id_attribute: User attribute for the id
        :param pulumi.Input[bool] is_auto_creation: enable if a new account in ZITADEL should be created automatically on login with an external account
        :param pulumi.Input[bool] is_auto_update: enable if a the ZITADEL account fields should be updated automatically on each login
        :param pulumi.Input[bool] is_creation_allowed: enable if users should be able to create a new account in ZITADEL when using an external account
        :param pulumi.Input[bool] is_linking_allowed: enable if users should be able to link an existing ZITADEL user with an external account
        :param pulumi.Input[str] last_name_attribute: User attribute for the last name
        :param pulumi.Input[str] name: Name of the IDP
        :param pulumi.Input[str] nick_name_attribute: User attribute for the nick name
        :param pulumi.Input[str] phone_attribute: User attribute for the phone
        :param pulumi.Input[str] phone_verified_attribute: User attribute for the phone verified state
        :param pulumi.Input[str] preferred_language_attribute: User attribute for the preferred language
        :param pulumi.Input[str] preferred_username_attribute: User attribute for the preferred username
        :param pulumi.Input[str] profile_attribute: User attribute for the profile
        :param pulumi.Input[Sequence[pulumi.Input[str]]] servers: Servers to try in order for establishing LDAP connections
        :param pulumi.Input[bool] start_tls: Wether to use StartTLS for LDAP connections
        :param pulumi.Input[str] timeout: Timeout for LDAP connections
        :param pulumi.Input[str] user_base: User base for LDAP connections
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_filters: User filters for LDAP connections
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_object_classes: User object classes for LDAP connections
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IdpLdapArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource representing an LDAP IDP on the instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.IdpLdap("default",
            base_dn="dc=example,dc=com",
            bind_dn="cn=admin,dc=example,dc=com",
            bind_password="Password1!",
            first_name_attribute="firstname",
            id_attribute="uid",
            is_auto_creation=False,
            is_auto_update=True,
            is_creation_allowed=True,
            is_linking_allowed=False,
            last_name_attribute="lastname",
            servers=[
                "ldaps://my.primary.server:389",
                "ldaps://my.secondary.server:389",
            ],
            start_tls=False,
            timeout="10s",
            user_base="dn",
            user_filters=[
                "uid",
                "email",
            ],
            user_object_classes=["inetOrgPerson"])
        ```

        ## Import

        terraform The resource can be imported using the ID format `<id[:bind_password]>`, e.g.

        ```sh
         $ pulumi import zitadel:index/idpLdap:IdpLdap imported '123456789012345678:b1nd_p4ssw0rd'
        ```

        :param str resource_name: The name of the resource.
        :param IdpLdapArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IdpLdapArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            IdpLdapArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 avatar_url_attribute: Optional[pulumi.Input[str]] = None,
                 base_dn: Optional[pulumi.Input[str]] = None,
                 bind_dn: Optional[pulumi.Input[str]] = None,
                 bind_password: Optional[pulumi.Input[str]] = None,
                 display_name_attribute: Optional[pulumi.Input[str]] = None,
                 email_attribute: Optional[pulumi.Input[str]] = None,
                 email_verified_attribute: Optional[pulumi.Input[str]] = None,
                 first_name_attribute: Optional[pulumi.Input[str]] = None,
                 id_attribute: Optional[pulumi.Input[str]] = None,
                 is_auto_creation: Optional[pulumi.Input[bool]] = None,
                 is_auto_update: Optional[pulumi.Input[bool]] = None,
                 is_creation_allowed: Optional[pulumi.Input[bool]] = None,
                 is_linking_allowed: Optional[pulumi.Input[bool]] = None,
                 last_name_attribute: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nick_name_attribute: Optional[pulumi.Input[str]] = None,
                 phone_attribute: Optional[pulumi.Input[str]] = None,
                 phone_verified_attribute: Optional[pulumi.Input[str]] = None,
                 preferred_language_attribute: Optional[pulumi.Input[str]] = None,
                 preferred_username_attribute: Optional[pulumi.Input[str]] = None,
                 profile_attribute: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 start_tls: Optional[pulumi.Input[bool]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 user_base: Optional[pulumi.Input[str]] = None,
                 user_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_object_classes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IdpLdapArgs.__new__(IdpLdapArgs)

            __props__.__dict__["avatar_url_attribute"] = avatar_url_attribute
            if base_dn is None and not opts.urn:
                raise TypeError("Missing required property 'base_dn'")
            __props__.__dict__["base_dn"] = base_dn
            if bind_dn is None and not opts.urn:
                raise TypeError("Missing required property 'bind_dn'")
            __props__.__dict__["bind_dn"] = bind_dn
            if bind_password is None and not opts.urn:
                raise TypeError("Missing required property 'bind_password'")
            __props__.__dict__["bind_password"] = None if bind_password is None else pulumi.Output.secret(bind_password)
            __props__.__dict__["display_name_attribute"] = display_name_attribute
            __props__.__dict__["email_attribute"] = email_attribute
            __props__.__dict__["email_verified_attribute"] = email_verified_attribute
            __props__.__dict__["first_name_attribute"] = first_name_attribute
            __props__.__dict__["id_attribute"] = id_attribute
            if is_auto_creation is None and not opts.urn:
                raise TypeError("Missing required property 'is_auto_creation'")
            __props__.__dict__["is_auto_creation"] = is_auto_creation
            if is_auto_update is None and not opts.urn:
                raise TypeError("Missing required property 'is_auto_update'")
            __props__.__dict__["is_auto_update"] = is_auto_update
            if is_creation_allowed is None and not opts.urn:
                raise TypeError("Missing required property 'is_creation_allowed'")
            __props__.__dict__["is_creation_allowed"] = is_creation_allowed
            if is_linking_allowed is None and not opts.urn:
                raise TypeError("Missing required property 'is_linking_allowed'")
            __props__.__dict__["is_linking_allowed"] = is_linking_allowed
            __props__.__dict__["last_name_attribute"] = last_name_attribute
            __props__.__dict__["name"] = name
            __props__.__dict__["nick_name_attribute"] = nick_name_attribute
            __props__.__dict__["phone_attribute"] = phone_attribute
            __props__.__dict__["phone_verified_attribute"] = phone_verified_attribute
            __props__.__dict__["preferred_language_attribute"] = preferred_language_attribute
            __props__.__dict__["preferred_username_attribute"] = preferred_username_attribute
            __props__.__dict__["profile_attribute"] = profile_attribute
            if servers is None and not opts.urn:
                raise TypeError("Missing required property 'servers'")
            __props__.__dict__["servers"] = servers
            if start_tls is None and not opts.urn:
                raise TypeError("Missing required property 'start_tls'")
            __props__.__dict__["start_tls"] = start_tls
            if timeout is None and not opts.urn:
                raise TypeError("Missing required property 'timeout'")
            __props__.__dict__["timeout"] = timeout
            if user_base is None and not opts.urn:
                raise TypeError("Missing required property 'user_base'")
            __props__.__dict__["user_base"] = user_base
            if user_filters is None and not opts.urn:
                raise TypeError("Missing required property 'user_filters'")
            __props__.__dict__["user_filters"] = user_filters
            if user_object_classes is None and not opts.urn:
                raise TypeError("Missing required property 'user_object_classes'")
            __props__.__dict__["user_object_classes"] = user_object_classes
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["bindPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(IdpLdap, __self__).__init__(
            'zitadel:index/idpLdap:IdpLdap',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            avatar_url_attribute: Optional[pulumi.Input[str]] = None,
            base_dn: Optional[pulumi.Input[str]] = None,
            bind_dn: Optional[pulumi.Input[str]] = None,
            bind_password: Optional[pulumi.Input[str]] = None,
            display_name_attribute: Optional[pulumi.Input[str]] = None,
            email_attribute: Optional[pulumi.Input[str]] = None,
            email_verified_attribute: Optional[pulumi.Input[str]] = None,
            first_name_attribute: Optional[pulumi.Input[str]] = None,
            id_attribute: Optional[pulumi.Input[str]] = None,
            is_auto_creation: Optional[pulumi.Input[bool]] = None,
            is_auto_update: Optional[pulumi.Input[bool]] = None,
            is_creation_allowed: Optional[pulumi.Input[bool]] = None,
            is_linking_allowed: Optional[pulumi.Input[bool]] = None,
            last_name_attribute: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nick_name_attribute: Optional[pulumi.Input[str]] = None,
            phone_attribute: Optional[pulumi.Input[str]] = None,
            phone_verified_attribute: Optional[pulumi.Input[str]] = None,
            preferred_language_attribute: Optional[pulumi.Input[str]] = None,
            preferred_username_attribute: Optional[pulumi.Input[str]] = None,
            profile_attribute: Optional[pulumi.Input[str]] = None,
            servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            start_tls: Optional[pulumi.Input[bool]] = None,
            timeout: Optional[pulumi.Input[str]] = None,
            user_base: Optional[pulumi.Input[str]] = None,
            user_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            user_object_classes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'IdpLdap':
        """
        Get an existing IdpLdap resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] avatar_url_attribute: User attribute for the avatar url
        :param pulumi.Input[str] base_dn: Base DN for LDAP connections
        :param pulumi.Input[str] bind_dn: Bind DN for LDAP connections
        :param pulumi.Input[str] bind_password: Bind password for LDAP connections
        :param pulumi.Input[str] display_name_attribute: User attribute for the display name
        :param pulumi.Input[str] email_attribute: User attribute for the email
        :param pulumi.Input[str] email_verified_attribute: User attribute for the email verified state
        :param pulumi.Input[str] first_name_attribute: User attribute for the first name
        :param pulumi.Input[str] id_attribute: User attribute for the id
        :param pulumi.Input[bool] is_auto_creation: enable if a new account in ZITADEL should be created automatically on login with an external account
        :param pulumi.Input[bool] is_auto_update: enable if a the ZITADEL account fields should be updated automatically on each login
        :param pulumi.Input[bool] is_creation_allowed: enable if users should be able to create a new account in ZITADEL when using an external account
        :param pulumi.Input[bool] is_linking_allowed: enable if users should be able to link an existing ZITADEL user with an external account
        :param pulumi.Input[str] last_name_attribute: User attribute for the last name
        :param pulumi.Input[str] name: Name of the IDP
        :param pulumi.Input[str] nick_name_attribute: User attribute for the nick name
        :param pulumi.Input[str] phone_attribute: User attribute for the phone
        :param pulumi.Input[str] phone_verified_attribute: User attribute for the phone verified state
        :param pulumi.Input[str] preferred_language_attribute: User attribute for the preferred language
        :param pulumi.Input[str] preferred_username_attribute: User attribute for the preferred username
        :param pulumi.Input[str] profile_attribute: User attribute for the profile
        :param pulumi.Input[Sequence[pulumi.Input[str]]] servers: Servers to try in order for establishing LDAP connections
        :param pulumi.Input[bool] start_tls: Wether to use StartTLS for LDAP connections
        :param pulumi.Input[str] timeout: Timeout for LDAP connections
        :param pulumi.Input[str] user_base: User base for LDAP connections
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_filters: User filters for LDAP connections
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_object_classes: User object classes for LDAP connections
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IdpLdapState.__new__(_IdpLdapState)

        __props__.__dict__["avatar_url_attribute"] = avatar_url_attribute
        __props__.__dict__["base_dn"] = base_dn
        __props__.__dict__["bind_dn"] = bind_dn
        __props__.__dict__["bind_password"] = bind_password
        __props__.__dict__["display_name_attribute"] = display_name_attribute
        __props__.__dict__["email_attribute"] = email_attribute
        __props__.__dict__["email_verified_attribute"] = email_verified_attribute
        __props__.__dict__["first_name_attribute"] = first_name_attribute
        __props__.__dict__["id_attribute"] = id_attribute
        __props__.__dict__["is_auto_creation"] = is_auto_creation
        __props__.__dict__["is_auto_update"] = is_auto_update
        __props__.__dict__["is_creation_allowed"] = is_creation_allowed
        __props__.__dict__["is_linking_allowed"] = is_linking_allowed
        __props__.__dict__["last_name_attribute"] = last_name_attribute
        __props__.__dict__["name"] = name
        __props__.__dict__["nick_name_attribute"] = nick_name_attribute
        __props__.__dict__["phone_attribute"] = phone_attribute
        __props__.__dict__["phone_verified_attribute"] = phone_verified_attribute
        __props__.__dict__["preferred_language_attribute"] = preferred_language_attribute
        __props__.__dict__["preferred_username_attribute"] = preferred_username_attribute
        __props__.__dict__["profile_attribute"] = profile_attribute
        __props__.__dict__["servers"] = servers
        __props__.__dict__["start_tls"] = start_tls
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["user_base"] = user_base
        __props__.__dict__["user_filters"] = user_filters
        __props__.__dict__["user_object_classes"] = user_object_classes
        return IdpLdap(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="avatarUrlAttribute")
    def avatar_url_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        User attribute for the avatar url
        """
        return pulumi.get(self, "avatar_url_attribute")

    @property
    @pulumi.getter(name="baseDn")
    def base_dn(self) -> pulumi.Output[str]:
        """
        Base DN for LDAP connections
        """
        return pulumi.get(self, "base_dn")

    @property
    @pulumi.getter(name="bindDn")
    def bind_dn(self) -> pulumi.Output[str]:
        """
        Bind DN for LDAP connections
        """
        return pulumi.get(self, "bind_dn")

    @property
    @pulumi.getter(name="bindPassword")
    def bind_password(self) -> pulumi.Output[str]:
        """
        Bind password for LDAP connections
        """
        return pulumi.get(self, "bind_password")

    @property
    @pulumi.getter(name="displayNameAttribute")
    def display_name_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        User attribute for the display name
        """
        return pulumi.get(self, "display_name_attribute")

    @property
    @pulumi.getter(name="emailAttribute")
    def email_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        User attribute for the email
        """
        return pulumi.get(self, "email_attribute")

    @property
    @pulumi.getter(name="emailVerifiedAttribute")
    def email_verified_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        User attribute for the email verified state
        """
        return pulumi.get(self, "email_verified_attribute")

    @property
    @pulumi.getter(name="firstNameAttribute")
    def first_name_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        User attribute for the first name
        """
        return pulumi.get(self, "first_name_attribute")

    @property
    @pulumi.getter(name="idAttribute")
    def id_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        User attribute for the id
        """
        return pulumi.get(self, "id_attribute")

    @property
    @pulumi.getter(name="isAutoCreation")
    def is_auto_creation(self) -> pulumi.Output[bool]:
        """
        enable if a new account in ZITADEL should be created automatically on login with an external account
        """
        return pulumi.get(self, "is_auto_creation")

    @property
    @pulumi.getter(name="isAutoUpdate")
    def is_auto_update(self) -> pulumi.Output[bool]:
        """
        enable if a the ZITADEL account fields should be updated automatically on each login
        """
        return pulumi.get(self, "is_auto_update")

    @property
    @pulumi.getter(name="isCreationAllowed")
    def is_creation_allowed(self) -> pulumi.Output[bool]:
        """
        enable if users should be able to create a new account in ZITADEL when using an external account
        """
        return pulumi.get(self, "is_creation_allowed")

    @property
    @pulumi.getter(name="isLinkingAllowed")
    def is_linking_allowed(self) -> pulumi.Output[bool]:
        """
        enable if users should be able to link an existing ZITADEL user with an external account
        """
        return pulumi.get(self, "is_linking_allowed")

    @property
    @pulumi.getter(name="lastNameAttribute")
    def last_name_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        User attribute for the last name
        """
        return pulumi.get(self, "last_name_attribute")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the IDP
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nickNameAttribute")
    def nick_name_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        User attribute for the nick name
        """
        return pulumi.get(self, "nick_name_attribute")

    @property
    @pulumi.getter(name="phoneAttribute")
    def phone_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        User attribute for the phone
        """
        return pulumi.get(self, "phone_attribute")

    @property
    @pulumi.getter(name="phoneVerifiedAttribute")
    def phone_verified_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        User attribute for the phone verified state
        """
        return pulumi.get(self, "phone_verified_attribute")

    @property
    @pulumi.getter(name="preferredLanguageAttribute")
    def preferred_language_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        User attribute for the preferred language
        """
        return pulumi.get(self, "preferred_language_attribute")

    @property
    @pulumi.getter(name="preferredUsernameAttribute")
    def preferred_username_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        User attribute for the preferred username
        """
        return pulumi.get(self, "preferred_username_attribute")

    @property
    @pulumi.getter(name="profileAttribute")
    def profile_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        User attribute for the profile
        """
        return pulumi.get(self, "profile_attribute")

    @property
    @pulumi.getter
    def servers(self) -> pulumi.Output[Sequence[str]]:
        """
        Servers to try in order for establishing LDAP connections
        """
        return pulumi.get(self, "servers")

    @property
    @pulumi.getter(name="startTls")
    def start_tls(self) -> pulumi.Output[bool]:
        """
        Wether to use StartTLS for LDAP connections
        """
        return pulumi.get(self, "start_tls")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[str]:
        """
        Timeout for LDAP connections
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="userBase")
    def user_base(self) -> pulumi.Output[str]:
        """
        User base for LDAP connections
        """
        return pulumi.get(self, "user_base")

    @property
    @pulumi.getter(name="userFilters")
    def user_filters(self) -> pulumi.Output[Sequence[str]]:
        """
        User filters for LDAP connections
        """
        return pulumi.get(self, "user_filters")

    @property
    @pulumi.getter(name="userObjectClasses")
    def user_object_classes(self) -> pulumi.Output[Sequence[str]]:
        """
        User object classes for LDAP connections
        """
        return pulumi.get(self, "user_object_classes")

