# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['LabelPolicyArgs', 'LabelPolicy']

@pulumi.input_type
class LabelPolicyArgs:
    def __init__(__self__, *,
                 background_color: pulumi.Input[str],
                 background_color_dark: pulumi.Input[str],
                 disable_watermark: pulumi.Input[bool],
                 font_color: pulumi.Input[str],
                 font_color_dark: pulumi.Input[str],
                 hide_login_name_suffix: pulumi.Input[bool],
                 primary_color: pulumi.Input[str],
                 primary_color_dark: pulumi.Input[str],
                 warn_color: pulumi.Input[str],
                 warn_color_dark: pulumi.Input[str],
                 font_hash: Optional[pulumi.Input[str]] = None,
                 font_path: Optional[pulumi.Input[str]] = None,
                 icon_dark_hash: Optional[pulumi.Input[str]] = None,
                 icon_dark_path: Optional[pulumi.Input[str]] = None,
                 icon_hash: Optional[pulumi.Input[str]] = None,
                 icon_path: Optional[pulumi.Input[str]] = None,
                 logo_dark_hash: Optional[pulumi.Input[str]] = None,
                 logo_dark_path: Optional[pulumi.Input[str]] = None,
                 logo_hash: Optional[pulumi.Input[str]] = None,
                 logo_path: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 set_active: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a LabelPolicy resource.
        :param pulumi.Input[str] background_color: hex value for background color
        :param pulumi.Input[str] background_color_dark: hex value for background color dark theme
        :param pulumi.Input[bool] disable_watermark: disable watermark
        :param pulumi.Input[str] font_color: hex value for font color
        :param pulumi.Input[str] font_color_dark: hex value for font color dark theme
        :param pulumi.Input[bool] hide_login_name_suffix: hides the org suffix on the login form if the scope "urn:zitadel:iam:org:domain:primary:{domainname}" is set. Details about this scope in https://zitadel.com/docs/apis/openidoauth/scopes#reserved-scopes
        :param pulumi.Input[str] primary_color: hex value for primary color
        :param pulumi.Input[str] primary_color_dark: hex value for primary color dark theme
        :param pulumi.Input[str] warn_color: hex value for warn color
        :param pulumi.Input[str] warn_color_dark: hex value for warn color dark theme
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[bool] set_active: set the label policy active after creating/updating
        """
        LabelPolicyArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            background_color=background_color,
            background_color_dark=background_color_dark,
            disable_watermark=disable_watermark,
            font_color=font_color,
            font_color_dark=font_color_dark,
            hide_login_name_suffix=hide_login_name_suffix,
            primary_color=primary_color,
            primary_color_dark=primary_color_dark,
            warn_color=warn_color,
            warn_color_dark=warn_color_dark,
            font_hash=font_hash,
            font_path=font_path,
            icon_dark_hash=icon_dark_hash,
            icon_dark_path=icon_dark_path,
            icon_hash=icon_hash,
            icon_path=icon_path,
            logo_dark_hash=logo_dark_hash,
            logo_dark_path=logo_dark_path,
            logo_hash=logo_hash,
            logo_path=logo_path,
            org_id=org_id,
            set_active=set_active,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             background_color: pulumi.Input[str],
             background_color_dark: pulumi.Input[str],
             disable_watermark: pulumi.Input[bool],
             font_color: pulumi.Input[str],
             font_color_dark: pulumi.Input[str],
             hide_login_name_suffix: pulumi.Input[bool],
             primary_color: pulumi.Input[str],
             primary_color_dark: pulumi.Input[str],
             warn_color: pulumi.Input[str],
             warn_color_dark: pulumi.Input[str],
             font_hash: Optional[pulumi.Input[str]] = None,
             font_path: Optional[pulumi.Input[str]] = None,
             icon_dark_hash: Optional[pulumi.Input[str]] = None,
             icon_dark_path: Optional[pulumi.Input[str]] = None,
             icon_hash: Optional[pulumi.Input[str]] = None,
             icon_path: Optional[pulumi.Input[str]] = None,
             logo_dark_hash: Optional[pulumi.Input[str]] = None,
             logo_dark_path: Optional[pulumi.Input[str]] = None,
             logo_hash: Optional[pulumi.Input[str]] = None,
             logo_path: Optional[pulumi.Input[str]] = None,
             org_id: Optional[pulumi.Input[str]] = None,
             set_active: Optional[pulumi.Input[bool]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'backgroundColor' in kwargs:
            background_color = kwargs['backgroundColor']
        if 'backgroundColorDark' in kwargs:
            background_color_dark = kwargs['backgroundColorDark']
        if 'disableWatermark' in kwargs:
            disable_watermark = kwargs['disableWatermark']
        if 'fontColor' in kwargs:
            font_color = kwargs['fontColor']
        if 'fontColorDark' in kwargs:
            font_color_dark = kwargs['fontColorDark']
        if 'hideLoginNameSuffix' in kwargs:
            hide_login_name_suffix = kwargs['hideLoginNameSuffix']
        if 'primaryColor' in kwargs:
            primary_color = kwargs['primaryColor']
        if 'primaryColorDark' in kwargs:
            primary_color_dark = kwargs['primaryColorDark']
        if 'warnColor' in kwargs:
            warn_color = kwargs['warnColor']
        if 'warnColorDark' in kwargs:
            warn_color_dark = kwargs['warnColorDark']
        if 'fontHash' in kwargs:
            font_hash = kwargs['fontHash']
        if 'fontPath' in kwargs:
            font_path = kwargs['fontPath']
        if 'iconDarkHash' in kwargs:
            icon_dark_hash = kwargs['iconDarkHash']
        if 'iconDarkPath' in kwargs:
            icon_dark_path = kwargs['iconDarkPath']
        if 'iconHash' in kwargs:
            icon_hash = kwargs['iconHash']
        if 'iconPath' in kwargs:
            icon_path = kwargs['iconPath']
        if 'logoDarkHash' in kwargs:
            logo_dark_hash = kwargs['logoDarkHash']
        if 'logoDarkPath' in kwargs:
            logo_dark_path = kwargs['logoDarkPath']
        if 'logoHash' in kwargs:
            logo_hash = kwargs['logoHash']
        if 'logoPath' in kwargs:
            logo_path = kwargs['logoPath']
        if 'orgId' in kwargs:
            org_id = kwargs['orgId']
        if 'setActive' in kwargs:
            set_active = kwargs['setActive']

        _setter("background_color", background_color)
        _setter("background_color_dark", background_color_dark)
        _setter("disable_watermark", disable_watermark)
        _setter("font_color", font_color)
        _setter("font_color_dark", font_color_dark)
        _setter("hide_login_name_suffix", hide_login_name_suffix)
        _setter("primary_color", primary_color)
        _setter("primary_color_dark", primary_color_dark)
        _setter("warn_color", warn_color)
        _setter("warn_color_dark", warn_color_dark)
        if font_hash is not None:
            _setter("font_hash", font_hash)
        if font_path is not None:
            _setter("font_path", font_path)
        if icon_dark_hash is not None:
            _setter("icon_dark_hash", icon_dark_hash)
        if icon_dark_path is not None:
            _setter("icon_dark_path", icon_dark_path)
        if icon_hash is not None:
            _setter("icon_hash", icon_hash)
        if icon_path is not None:
            _setter("icon_path", icon_path)
        if logo_dark_hash is not None:
            _setter("logo_dark_hash", logo_dark_hash)
        if logo_dark_path is not None:
            _setter("logo_dark_path", logo_dark_path)
        if logo_hash is not None:
            _setter("logo_hash", logo_hash)
        if logo_path is not None:
            _setter("logo_path", logo_path)
        if org_id is not None:
            _setter("org_id", org_id)
        if set_active is not None:
            _setter("set_active", set_active)

    @property
    @pulumi.getter(name="backgroundColor")
    def background_color(self) -> pulumi.Input[str]:
        """
        hex value for background color
        """
        return pulumi.get(self, "background_color")

    @background_color.setter
    def background_color(self, value: pulumi.Input[str]):
        pulumi.set(self, "background_color", value)

    @property
    @pulumi.getter(name="backgroundColorDark")
    def background_color_dark(self) -> pulumi.Input[str]:
        """
        hex value for background color dark theme
        """
        return pulumi.get(self, "background_color_dark")

    @background_color_dark.setter
    def background_color_dark(self, value: pulumi.Input[str]):
        pulumi.set(self, "background_color_dark", value)

    @property
    @pulumi.getter(name="disableWatermark")
    def disable_watermark(self) -> pulumi.Input[bool]:
        """
        disable watermark
        """
        return pulumi.get(self, "disable_watermark")

    @disable_watermark.setter
    def disable_watermark(self, value: pulumi.Input[bool]):
        pulumi.set(self, "disable_watermark", value)

    @property
    @pulumi.getter(name="fontColor")
    def font_color(self) -> pulumi.Input[str]:
        """
        hex value for font color
        """
        return pulumi.get(self, "font_color")

    @font_color.setter
    def font_color(self, value: pulumi.Input[str]):
        pulumi.set(self, "font_color", value)

    @property
    @pulumi.getter(name="fontColorDark")
    def font_color_dark(self) -> pulumi.Input[str]:
        """
        hex value for font color dark theme
        """
        return pulumi.get(self, "font_color_dark")

    @font_color_dark.setter
    def font_color_dark(self, value: pulumi.Input[str]):
        pulumi.set(self, "font_color_dark", value)

    @property
    @pulumi.getter(name="hideLoginNameSuffix")
    def hide_login_name_suffix(self) -> pulumi.Input[bool]:
        """
        hides the org suffix on the login form if the scope "urn:zitadel:iam:org:domain:primary:{domainname}" is set. Details about this scope in https://zitadel.com/docs/apis/openidoauth/scopes#reserved-scopes
        """
        return pulumi.get(self, "hide_login_name_suffix")

    @hide_login_name_suffix.setter
    def hide_login_name_suffix(self, value: pulumi.Input[bool]):
        pulumi.set(self, "hide_login_name_suffix", value)

    @property
    @pulumi.getter(name="primaryColor")
    def primary_color(self) -> pulumi.Input[str]:
        """
        hex value for primary color
        """
        return pulumi.get(self, "primary_color")

    @primary_color.setter
    def primary_color(self, value: pulumi.Input[str]):
        pulumi.set(self, "primary_color", value)

    @property
    @pulumi.getter(name="primaryColorDark")
    def primary_color_dark(self) -> pulumi.Input[str]:
        """
        hex value for primary color dark theme
        """
        return pulumi.get(self, "primary_color_dark")

    @primary_color_dark.setter
    def primary_color_dark(self, value: pulumi.Input[str]):
        pulumi.set(self, "primary_color_dark", value)

    @property
    @pulumi.getter(name="warnColor")
    def warn_color(self) -> pulumi.Input[str]:
        """
        hex value for warn color
        """
        return pulumi.get(self, "warn_color")

    @warn_color.setter
    def warn_color(self, value: pulumi.Input[str]):
        pulumi.set(self, "warn_color", value)

    @property
    @pulumi.getter(name="warnColorDark")
    def warn_color_dark(self) -> pulumi.Input[str]:
        """
        hex value for warn color dark theme
        """
        return pulumi.get(self, "warn_color_dark")

    @warn_color_dark.setter
    def warn_color_dark(self, value: pulumi.Input[str]):
        pulumi.set(self, "warn_color_dark", value)

    @property
    @pulumi.getter(name="fontHash")
    def font_hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "font_hash")

    @font_hash.setter
    def font_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "font_hash", value)

    @property
    @pulumi.getter(name="fontPath")
    def font_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "font_path")

    @font_path.setter
    def font_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "font_path", value)

    @property
    @pulumi.getter(name="iconDarkHash")
    def icon_dark_hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "icon_dark_hash")

    @icon_dark_hash.setter
    def icon_dark_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_dark_hash", value)

    @property
    @pulumi.getter(name="iconDarkPath")
    def icon_dark_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "icon_dark_path")

    @icon_dark_path.setter
    def icon_dark_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_dark_path", value)

    @property
    @pulumi.getter(name="iconHash")
    def icon_hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "icon_hash")

    @icon_hash.setter
    def icon_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_hash", value)

    @property
    @pulumi.getter(name="iconPath")
    def icon_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "icon_path")

    @icon_path.setter
    def icon_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_path", value)

    @property
    @pulumi.getter(name="logoDarkHash")
    def logo_dark_hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "logo_dark_hash")

    @logo_dark_hash.setter
    def logo_dark_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_dark_hash", value)

    @property
    @pulumi.getter(name="logoDarkPath")
    def logo_dark_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "logo_dark_path")

    @logo_dark_path.setter
    def logo_dark_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_dark_path", value)

    @property
    @pulumi.getter(name="logoHash")
    def logo_hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "logo_hash")

    @logo_hash.setter
    def logo_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_hash", value)

    @property
    @pulumi.getter(name="logoPath")
    def logo_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "logo_path")

    @logo_path.setter
    def logo_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_path", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="setActive")
    def set_active(self) -> Optional[pulumi.Input[bool]]:
        """
        set the label policy active after creating/updating
        """
        return pulumi.get(self, "set_active")

    @set_active.setter
    def set_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "set_active", value)


@pulumi.input_type
class _LabelPolicyState:
    def __init__(__self__, *,
                 background_color: Optional[pulumi.Input[str]] = None,
                 background_color_dark: Optional[pulumi.Input[str]] = None,
                 disable_watermark: Optional[pulumi.Input[bool]] = None,
                 font_color: Optional[pulumi.Input[str]] = None,
                 font_color_dark: Optional[pulumi.Input[str]] = None,
                 font_hash: Optional[pulumi.Input[str]] = None,
                 font_path: Optional[pulumi.Input[str]] = None,
                 font_url: Optional[pulumi.Input[str]] = None,
                 hide_login_name_suffix: Optional[pulumi.Input[bool]] = None,
                 icon_dark_hash: Optional[pulumi.Input[str]] = None,
                 icon_dark_path: Optional[pulumi.Input[str]] = None,
                 icon_hash: Optional[pulumi.Input[str]] = None,
                 icon_path: Optional[pulumi.Input[str]] = None,
                 icon_url: Optional[pulumi.Input[str]] = None,
                 icon_url_dark: Optional[pulumi.Input[str]] = None,
                 logo_dark_hash: Optional[pulumi.Input[str]] = None,
                 logo_dark_path: Optional[pulumi.Input[str]] = None,
                 logo_hash: Optional[pulumi.Input[str]] = None,
                 logo_path: Optional[pulumi.Input[str]] = None,
                 logo_url: Optional[pulumi.Input[str]] = None,
                 logo_url_dark: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 primary_color: Optional[pulumi.Input[str]] = None,
                 primary_color_dark: Optional[pulumi.Input[str]] = None,
                 set_active: Optional[pulumi.Input[bool]] = None,
                 warn_color: Optional[pulumi.Input[str]] = None,
                 warn_color_dark: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LabelPolicy resources.
        :param pulumi.Input[str] background_color: hex value for background color
        :param pulumi.Input[str] background_color_dark: hex value for background color dark theme
        :param pulumi.Input[bool] disable_watermark: disable watermark
        :param pulumi.Input[str] font_color: hex value for font color
        :param pulumi.Input[str] font_color_dark: hex value for font color dark theme
        :param pulumi.Input[bool] hide_login_name_suffix: hides the org suffix on the login form if the scope "urn:zitadel:iam:org:domain:primary:{domainname}" is set. Details about this scope in https://zitadel.com/docs/apis/openidoauth/scopes#reserved-scopes
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] primary_color: hex value for primary color
        :param pulumi.Input[str] primary_color_dark: hex value for primary color dark theme
        :param pulumi.Input[bool] set_active: set the label policy active after creating/updating
        :param pulumi.Input[str] warn_color: hex value for warn color
        :param pulumi.Input[str] warn_color_dark: hex value for warn color dark theme
        """
        _LabelPolicyState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            background_color=background_color,
            background_color_dark=background_color_dark,
            disable_watermark=disable_watermark,
            font_color=font_color,
            font_color_dark=font_color_dark,
            font_hash=font_hash,
            font_path=font_path,
            font_url=font_url,
            hide_login_name_suffix=hide_login_name_suffix,
            icon_dark_hash=icon_dark_hash,
            icon_dark_path=icon_dark_path,
            icon_hash=icon_hash,
            icon_path=icon_path,
            icon_url=icon_url,
            icon_url_dark=icon_url_dark,
            logo_dark_hash=logo_dark_hash,
            logo_dark_path=logo_dark_path,
            logo_hash=logo_hash,
            logo_path=logo_path,
            logo_url=logo_url,
            logo_url_dark=logo_url_dark,
            org_id=org_id,
            primary_color=primary_color,
            primary_color_dark=primary_color_dark,
            set_active=set_active,
            warn_color=warn_color,
            warn_color_dark=warn_color_dark,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             background_color: Optional[pulumi.Input[str]] = None,
             background_color_dark: Optional[pulumi.Input[str]] = None,
             disable_watermark: Optional[pulumi.Input[bool]] = None,
             font_color: Optional[pulumi.Input[str]] = None,
             font_color_dark: Optional[pulumi.Input[str]] = None,
             font_hash: Optional[pulumi.Input[str]] = None,
             font_path: Optional[pulumi.Input[str]] = None,
             font_url: Optional[pulumi.Input[str]] = None,
             hide_login_name_suffix: Optional[pulumi.Input[bool]] = None,
             icon_dark_hash: Optional[pulumi.Input[str]] = None,
             icon_dark_path: Optional[pulumi.Input[str]] = None,
             icon_hash: Optional[pulumi.Input[str]] = None,
             icon_path: Optional[pulumi.Input[str]] = None,
             icon_url: Optional[pulumi.Input[str]] = None,
             icon_url_dark: Optional[pulumi.Input[str]] = None,
             logo_dark_hash: Optional[pulumi.Input[str]] = None,
             logo_dark_path: Optional[pulumi.Input[str]] = None,
             logo_hash: Optional[pulumi.Input[str]] = None,
             logo_path: Optional[pulumi.Input[str]] = None,
             logo_url: Optional[pulumi.Input[str]] = None,
             logo_url_dark: Optional[pulumi.Input[str]] = None,
             org_id: Optional[pulumi.Input[str]] = None,
             primary_color: Optional[pulumi.Input[str]] = None,
             primary_color_dark: Optional[pulumi.Input[str]] = None,
             set_active: Optional[pulumi.Input[bool]] = None,
             warn_color: Optional[pulumi.Input[str]] = None,
             warn_color_dark: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'backgroundColor' in kwargs:
            background_color = kwargs['backgroundColor']
        if 'backgroundColorDark' in kwargs:
            background_color_dark = kwargs['backgroundColorDark']
        if 'disableWatermark' in kwargs:
            disable_watermark = kwargs['disableWatermark']
        if 'fontColor' in kwargs:
            font_color = kwargs['fontColor']
        if 'fontColorDark' in kwargs:
            font_color_dark = kwargs['fontColorDark']
        if 'fontHash' in kwargs:
            font_hash = kwargs['fontHash']
        if 'fontPath' in kwargs:
            font_path = kwargs['fontPath']
        if 'fontUrl' in kwargs:
            font_url = kwargs['fontUrl']
        if 'hideLoginNameSuffix' in kwargs:
            hide_login_name_suffix = kwargs['hideLoginNameSuffix']
        if 'iconDarkHash' in kwargs:
            icon_dark_hash = kwargs['iconDarkHash']
        if 'iconDarkPath' in kwargs:
            icon_dark_path = kwargs['iconDarkPath']
        if 'iconHash' in kwargs:
            icon_hash = kwargs['iconHash']
        if 'iconPath' in kwargs:
            icon_path = kwargs['iconPath']
        if 'iconUrl' in kwargs:
            icon_url = kwargs['iconUrl']
        if 'iconUrlDark' in kwargs:
            icon_url_dark = kwargs['iconUrlDark']
        if 'logoDarkHash' in kwargs:
            logo_dark_hash = kwargs['logoDarkHash']
        if 'logoDarkPath' in kwargs:
            logo_dark_path = kwargs['logoDarkPath']
        if 'logoHash' in kwargs:
            logo_hash = kwargs['logoHash']
        if 'logoPath' in kwargs:
            logo_path = kwargs['logoPath']
        if 'logoUrl' in kwargs:
            logo_url = kwargs['logoUrl']
        if 'logoUrlDark' in kwargs:
            logo_url_dark = kwargs['logoUrlDark']
        if 'orgId' in kwargs:
            org_id = kwargs['orgId']
        if 'primaryColor' in kwargs:
            primary_color = kwargs['primaryColor']
        if 'primaryColorDark' in kwargs:
            primary_color_dark = kwargs['primaryColorDark']
        if 'setActive' in kwargs:
            set_active = kwargs['setActive']
        if 'warnColor' in kwargs:
            warn_color = kwargs['warnColor']
        if 'warnColorDark' in kwargs:
            warn_color_dark = kwargs['warnColorDark']

        if background_color is not None:
            _setter("background_color", background_color)
        if background_color_dark is not None:
            _setter("background_color_dark", background_color_dark)
        if disable_watermark is not None:
            _setter("disable_watermark", disable_watermark)
        if font_color is not None:
            _setter("font_color", font_color)
        if font_color_dark is not None:
            _setter("font_color_dark", font_color_dark)
        if font_hash is not None:
            _setter("font_hash", font_hash)
        if font_path is not None:
            _setter("font_path", font_path)
        if font_url is not None:
            _setter("font_url", font_url)
        if hide_login_name_suffix is not None:
            _setter("hide_login_name_suffix", hide_login_name_suffix)
        if icon_dark_hash is not None:
            _setter("icon_dark_hash", icon_dark_hash)
        if icon_dark_path is not None:
            _setter("icon_dark_path", icon_dark_path)
        if icon_hash is not None:
            _setter("icon_hash", icon_hash)
        if icon_path is not None:
            _setter("icon_path", icon_path)
        if icon_url is not None:
            _setter("icon_url", icon_url)
        if icon_url_dark is not None:
            _setter("icon_url_dark", icon_url_dark)
        if logo_dark_hash is not None:
            _setter("logo_dark_hash", logo_dark_hash)
        if logo_dark_path is not None:
            _setter("logo_dark_path", logo_dark_path)
        if logo_hash is not None:
            _setter("logo_hash", logo_hash)
        if logo_path is not None:
            _setter("logo_path", logo_path)
        if logo_url is not None:
            _setter("logo_url", logo_url)
        if logo_url_dark is not None:
            _setter("logo_url_dark", logo_url_dark)
        if org_id is not None:
            _setter("org_id", org_id)
        if primary_color is not None:
            _setter("primary_color", primary_color)
        if primary_color_dark is not None:
            _setter("primary_color_dark", primary_color_dark)
        if set_active is not None:
            _setter("set_active", set_active)
        if warn_color is not None:
            _setter("warn_color", warn_color)
        if warn_color_dark is not None:
            _setter("warn_color_dark", warn_color_dark)

    @property
    @pulumi.getter(name="backgroundColor")
    def background_color(self) -> Optional[pulumi.Input[str]]:
        """
        hex value for background color
        """
        return pulumi.get(self, "background_color")

    @background_color.setter
    def background_color(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "background_color", value)

    @property
    @pulumi.getter(name="backgroundColorDark")
    def background_color_dark(self) -> Optional[pulumi.Input[str]]:
        """
        hex value for background color dark theme
        """
        return pulumi.get(self, "background_color_dark")

    @background_color_dark.setter
    def background_color_dark(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "background_color_dark", value)

    @property
    @pulumi.getter(name="disableWatermark")
    def disable_watermark(self) -> Optional[pulumi.Input[bool]]:
        """
        disable watermark
        """
        return pulumi.get(self, "disable_watermark")

    @disable_watermark.setter
    def disable_watermark(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_watermark", value)

    @property
    @pulumi.getter(name="fontColor")
    def font_color(self) -> Optional[pulumi.Input[str]]:
        """
        hex value for font color
        """
        return pulumi.get(self, "font_color")

    @font_color.setter
    def font_color(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "font_color", value)

    @property
    @pulumi.getter(name="fontColorDark")
    def font_color_dark(self) -> Optional[pulumi.Input[str]]:
        """
        hex value for font color dark theme
        """
        return pulumi.get(self, "font_color_dark")

    @font_color_dark.setter
    def font_color_dark(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "font_color_dark", value)

    @property
    @pulumi.getter(name="fontHash")
    def font_hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "font_hash")

    @font_hash.setter
    def font_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "font_hash", value)

    @property
    @pulumi.getter(name="fontPath")
    def font_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "font_path")

    @font_path.setter
    def font_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "font_path", value)

    @property
    @pulumi.getter(name="fontUrl")
    def font_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "font_url")

    @font_url.setter
    def font_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "font_url", value)

    @property
    @pulumi.getter(name="hideLoginNameSuffix")
    def hide_login_name_suffix(self) -> Optional[pulumi.Input[bool]]:
        """
        hides the org suffix on the login form if the scope "urn:zitadel:iam:org:domain:primary:{domainname}" is set. Details about this scope in https://zitadel.com/docs/apis/openidoauth/scopes#reserved-scopes
        """
        return pulumi.get(self, "hide_login_name_suffix")

    @hide_login_name_suffix.setter
    def hide_login_name_suffix(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_login_name_suffix", value)

    @property
    @pulumi.getter(name="iconDarkHash")
    def icon_dark_hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "icon_dark_hash")

    @icon_dark_hash.setter
    def icon_dark_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_dark_hash", value)

    @property
    @pulumi.getter(name="iconDarkPath")
    def icon_dark_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "icon_dark_path")

    @icon_dark_path.setter
    def icon_dark_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_dark_path", value)

    @property
    @pulumi.getter(name="iconHash")
    def icon_hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "icon_hash")

    @icon_hash.setter
    def icon_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_hash", value)

    @property
    @pulumi.getter(name="iconPath")
    def icon_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "icon_path")

    @icon_path.setter
    def icon_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_path", value)

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "icon_url")

    @icon_url.setter
    def icon_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_url", value)

    @property
    @pulumi.getter(name="iconUrlDark")
    def icon_url_dark(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "icon_url_dark")

    @icon_url_dark.setter
    def icon_url_dark(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_url_dark", value)

    @property
    @pulumi.getter(name="logoDarkHash")
    def logo_dark_hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "logo_dark_hash")

    @logo_dark_hash.setter
    def logo_dark_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_dark_hash", value)

    @property
    @pulumi.getter(name="logoDarkPath")
    def logo_dark_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "logo_dark_path")

    @logo_dark_path.setter
    def logo_dark_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_dark_path", value)

    @property
    @pulumi.getter(name="logoHash")
    def logo_hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "logo_hash")

    @logo_hash.setter
    def logo_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_hash", value)

    @property
    @pulumi.getter(name="logoPath")
    def logo_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "logo_path")

    @logo_path.setter
    def logo_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_path", value)

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "logo_url")

    @logo_url.setter
    def logo_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_url", value)

    @property
    @pulumi.getter(name="logoUrlDark")
    def logo_url_dark(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "logo_url_dark")

    @logo_url_dark.setter
    def logo_url_dark(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_url_dark", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="primaryColor")
    def primary_color(self) -> Optional[pulumi.Input[str]]:
        """
        hex value for primary color
        """
        return pulumi.get(self, "primary_color")

    @primary_color.setter
    def primary_color(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_color", value)

    @property
    @pulumi.getter(name="primaryColorDark")
    def primary_color_dark(self) -> Optional[pulumi.Input[str]]:
        """
        hex value for primary color dark theme
        """
        return pulumi.get(self, "primary_color_dark")

    @primary_color_dark.setter
    def primary_color_dark(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_color_dark", value)

    @property
    @pulumi.getter(name="setActive")
    def set_active(self) -> Optional[pulumi.Input[bool]]:
        """
        set the label policy active after creating/updating
        """
        return pulumi.get(self, "set_active")

    @set_active.setter
    def set_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "set_active", value)

    @property
    @pulumi.getter(name="warnColor")
    def warn_color(self) -> Optional[pulumi.Input[str]]:
        """
        hex value for warn color
        """
        return pulumi.get(self, "warn_color")

    @warn_color.setter
    def warn_color(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warn_color", value)

    @property
    @pulumi.getter(name="warnColorDark")
    def warn_color_dark(self) -> Optional[pulumi.Input[str]]:
        """
        hex value for warn color dark theme
        """
        return pulumi.get(self, "warn_color_dark")

    @warn_color_dark.setter
    def warn_color_dark(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warn_color_dark", value)


class LabelPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 background_color: Optional[pulumi.Input[str]] = None,
                 background_color_dark: Optional[pulumi.Input[str]] = None,
                 disable_watermark: Optional[pulumi.Input[bool]] = None,
                 font_color: Optional[pulumi.Input[str]] = None,
                 font_color_dark: Optional[pulumi.Input[str]] = None,
                 font_hash: Optional[pulumi.Input[str]] = None,
                 font_path: Optional[pulumi.Input[str]] = None,
                 hide_login_name_suffix: Optional[pulumi.Input[bool]] = None,
                 icon_dark_hash: Optional[pulumi.Input[str]] = None,
                 icon_dark_path: Optional[pulumi.Input[str]] = None,
                 icon_hash: Optional[pulumi.Input[str]] = None,
                 icon_path: Optional[pulumi.Input[str]] = None,
                 logo_dark_hash: Optional[pulumi.Input[str]] = None,
                 logo_dark_path: Optional[pulumi.Input[str]] = None,
                 logo_hash: Optional[pulumi.Input[str]] = None,
                 logo_path: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 primary_color: Optional[pulumi.Input[str]] = None,
                 primary_color_dark: Optional[pulumi.Input[str]] = None,
                 set_active: Optional[pulumi.Input[bool]] = None,
                 warn_color: Optional[pulumi.Input[str]] = None,
                 warn_color_dark: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource representing the custom label policy of an organization.

        ## Import

        terraform The resource can be imported using the ID format `<[org_id]>`, e.g.

        ```sh
         $ pulumi import zitadel:index/labelPolicy:LabelPolicy imported '123456789012345678'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] background_color: hex value for background color
        :param pulumi.Input[str] background_color_dark: hex value for background color dark theme
        :param pulumi.Input[bool] disable_watermark: disable watermark
        :param pulumi.Input[str] font_color: hex value for font color
        :param pulumi.Input[str] font_color_dark: hex value for font color dark theme
        :param pulumi.Input[bool] hide_login_name_suffix: hides the org suffix on the login form if the scope "urn:zitadel:iam:org:domain:primary:{domainname}" is set. Details about this scope in https://zitadel.com/docs/apis/openidoauth/scopes#reserved-scopes
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] primary_color: hex value for primary color
        :param pulumi.Input[str] primary_color_dark: hex value for primary color dark theme
        :param pulumi.Input[bool] set_active: set the label policy active after creating/updating
        :param pulumi.Input[str] warn_color: hex value for warn color
        :param pulumi.Input[str] warn_color_dark: hex value for warn color dark theme
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LabelPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource representing the custom label policy of an organization.

        ## Import

        terraform The resource can be imported using the ID format `<[org_id]>`, e.g.

        ```sh
         $ pulumi import zitadel:index/labelPolicy:LabelPolicy imported '123456789012345678'
        ```

        :param str resource_name: The name of the resource.
        :param LabelPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LabelPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            LabelPolicyArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 background_color: Optional[pulumi.Input[str]] = None,
                 background_color_dark: Optional[pulumi.Input[str]] = None,
                 disable_watermark: Optional[pulumi.Input[bool]] = None,
                 font_color: Optional[pulumi.Input[str]] = None,
                 font_color_dark: Optional[pulumi.Input[str]] = None,
                 font_hash: Optional[pulumi.Input[str]] = None,
                 font_path: Optional[pulumi.Input[str]] = None,
                 hide_login_name_suffix: Optional[pulumi.Input[bool]] = None,
                 icon_dark_hash: Optional[pulumi.Input[str]] = None,
                 icon_dark_path: Optional[pulumi.Input[str]] = None,
                 icon_hash: Optional[pulumi.Input[str]] = None,
                 icon_path: Optional[pulumi.Input[str]] = None,
                 logo_dark_hash: Optional[pulumi.Input[str]] = None,
                 logo_dark_path: Optional[pulumi.Input[str]] = None,
                 logo_hash: Optional[pulumi.Input[str]] = None,
                 logo_path: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 primary_color: Optional[pulumi.Input[str]] = None,
                 primary_color_dark: Optional[pulumi.Input[str]] = None,
                 set_active: Optional[pulumi.Input[bool]] = None,
                 warn_color: Optional[pulumi.Input[str]] = None,
                 warn_color_dark: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LabelPolicyArgs.__new__(LabelPolicyArgs)

            if background_color is None and not opts.urn:
                raise TypeError("Missing required property 'background_color'")
            __props__.__dict__["background_color"] = background_color
            if background_color_dark is None and not opts.urn:
                raise TypeError("Missing required property 'background_color_dark'")
            __props__.__dict__["background_color_dark"] = background_color_dark
            if disable_watermark is None and not opts.urn:
                raise TypeError("Missing required property 'disable_watermark'")
            __props__.__dict__["disable_watermark"] = disable_watermark
            if font_color is None and not opts.urn:
                raise TypeError("Missing required property 'font_color'")
            __props__.__dict__["font_color"] = font_color
            if font_color_dark is None and not opts.urn:
                raise TypeError("Missing required property 'font_color_dark'")
            __props__.__dict__["font_color_dark"] = font_color_dark
            __props__.__dict__["font_hash"] = font_hash
            __props__.__dict__["font_path"] = font_path
            if hide_login_name_suffix is None and not opts.urn:
                raise TypeError("Missing required property 'hide_login_name_suffix'")
            __props__.__dict__["hide_login_name_suffix"] = hide_login_name_suffix
            __props__.__dict__["icon_dark_hash"] = icon_dark_hash
            __props__.__dict__["icon_dark_path"] = icon_dark_path
            __props__.__dict__["icon_hash"] = icon_hash
            __props__.__dict__["icon_path"] = icon_path
            __props__.__dict__["logo_dark_hash"] = logo_dark_hash
            __props__.__dict__["logo_dark_path"] = logo_dark_path
            __props__.__dict__["logo_hash"] = logo_hash
            __props__.__dict__["logo_path"] = logo_path
            __props__.__dict__["org_id"] = org_id
            if primary_color is None and not opts.urn:
                raise TypeError("Missing required property 'primary_color'")
            __props__.__dict__["primary_color"] = primary_color
            if primary_color_dark is None and not opts.urn:
                raise TypeError("Missing required property 'primary_color_dark'")
            __props__.__dict__["primary_color_dark"] = primary_color_dark
            __props__.__dict__["set_active"] = set_active
            if warn_color is None and not opts.urn:
                raise TypeError("Missing required property 'warn_color'")
            __props__.__dict__["warn_color"] = warn_color
            if warn_color_dark is None and not opts.urn:
                raise TypeError("Missing required property 'warn_color_dark'")
            __props__.__dict__["warn_color_dark"] = warn_color_dark
            __props__.__dict__["font_url"] = None
            __props__.__dict__["icon_url"] = None
            __props__.__dict__["icon_url_dark"] = None
            __props__.__dict__["logo_url"] = None
            __props__.__dict__["logo_url_dark"] = None
        super(LabelPolicy, __self__).__init__(
            'zitadel:index/labelPolicy:LabelPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            background_color: Optional[pulumi.Input[str]] = None,
            background_color_dark: Optional[pulumi.Input[str]] = None,
            disable_watermark: Optional[pulumi.Input[bool]] = None,
            font_color: Optional[pulumi.Input[str]] = None,
            font_color_dark: Optional[pulumi.Input[str]] = None,
            font_hash: Optional[pulumi.Input[str]] = None,
            font_path: Optional[pulumi.Input[str]] = None,
            font_url: Optional[pulumi.Input[str]] = None,
            hide_login_name_suffix: Optional[pulumi.Input[bool]] = None,
            icon_dark_hash: Optional[pulumi.Input[str]] = None,
            icon_dark_path: Optional[pulumi.Input[str]] = None,
            icon_hash: Optional[pulumi.Input[str]] = None,
            icon_path: Optional[pulumi.Input[str]] = None,
            icon_url: Optional[pulumi.Input[str]] = None,
            icon_url_dark: Optional[pulumi.Input[str]] = None,
            logo_dark_hash: Optional[pulumi.Input[str]] = None,
            logo_dark_path: Optional[pulumi.Input[str]] = None,
            logo_hash: Optional[pulumi.Input[str]] = None,
            logo_path: Optional[pulumi.Input[str]] = None,
            logo_url: Optional[pulumi.Input[str]] = None,
            logo_url_dark: Optional[pulumi.Input[str]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            primary_color: Optional[pulumi.Input[str]] = None,
            primary_color_dark: Optional[pulumi.Input[str]] = None,
            set_active: Optional[pulumi.Input[bool]] = None,
            warn_color: Optional[pulumi.Input[str]] = None,
            warn_color_dark: Optional[pulumi.Input[str]] = None) -> 'LabelPolicy':
        """
        Get an existing LabelPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] background_color: hex value for background color
        :param pulumi.Input[str] background_color_dark: hex value for background color dark theme
        :param pulumi.Input[bool] disable_watermark: disable watermark
        :param pulumi.Input[str] font_color: hex value for font color
        :param pulumi.Input[str] font_color_dark: hex value for font color dark theme
        :param pulumi.Input[bool] hide_login_name_suffix: hides the org suffix on the login form if the scope "urn:zitadel:iam:org:domain:primary:{domainname}" is set. Details about this scope in https://zitadel.com/docs/apis/openidoauth/scopes#reserved-scopes
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] primary_color: hex value for primary color
        :param pulumi.Input[str] primary_color_dark: hex value for primary color dark theme
        :param pulumi.Input[bool] set_active: set the label policy active after creating/updating
        :param pulumi.Input[str] warn_color: hex value for warn color
        :param pulumi.Input[str] warn_color_dark: hex value for warn color dark theme
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LabelPolicyState.__new__(_LabelPolicyState)

        __props__.__dict__["background_color"] = background_color
        __props__.__dict__["background_color_dark"] = background_color_dark
        __props__.__dict__["disable_watermark"] = disable_watermark
        __props__.__dict__["font_color"] = font_color
        __props__.__dict__["font_color_dark"] = font_color_dark
        __props__.__dict__["font_hash"] = font_hash
        __props__.__dict__["font_path"] = font_path
        __props__.__dict__["font_url"] = font_url
        __props__.__dict__["hide_login_name_suffix"] = hide_login_name_suffix
        __props__.__dict__["icon_dark_hash"] = icon_dark_hash
        __props__.__dict__["icon_dark_path"] = icon_dark_path
        __props__.__dict__["icon_hash"] = icon_hash
        __props__.__dict__["icon_path"] = icon_path
        __props__.__dict__["icon_url"] = icon_url
        __props__.__dict__["icon_url_dark"] = icon_url_dark
        __props__.__dict__["logo_dark_hash"] = logo_dark_hash
        __props__.__dict__["logo_dark_path"] = logo_dark_path
        __props__.__dict__["logo_hash"] = logo_hash
        __props__.__dict__["logo_path"] = logo_path
        __props__.__dict__["logo_url"] = logo_url
        __props__.__dict__["logo_url_dark"] = logo_url_dark
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["primary_color"] = primary_color
        __props__.__dict__["primary_color_dark"] = primary_color_dark
        __props__.__dict__["set_active"] = set_active
        __props__.__dict__["warn_color"] = warn_color
        __props__.__dict__["warn_color_dark"] = warn_color_dark
        return LabelPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backgroundColor")
    def background_color(self) -> pulumi.Output[str]:
        """
        hex value for background color
        """
        return pulumi.get(self, "background_color")

    @property
    @pulumi.getter(name="backgroundColorDark")
    def background_color_dark(self) -> pulumi.Output[str]:
        """
        hex value for background color dark theme
        """
        return pulumi.get(self, "background_color_dark")

    @property
    @pulumi.getter(name="disableWatermark")
    def disable_watermark(self) -> pulumi.Output[bool]:
        """
        disable watermark
        """
        return pulumi.get(self, "disable_watermark")

    @property
    @pulumi.getter(name="fontColor")
    def font_color(self) -> pulumi.Output[str]:
        """
        hex value for font color
        """
        return pulumi.get(self, "font_color")

    @property
    @pulumi.getter(name="fontColorDark")
    def font_color_dark(self) -> pulumi.Output[str]:
        """
        hex value for font color dark theme
        """
        return pulumi.get(self, "font_color_dark")

    @property
    @pulumi.getter(name="fontHash")
    def font_hash(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "font_hash")

    @property
    @pulumi.getter(name="fontPath")
    def font_path(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "font_path")

    @property
    @pulumi.getter(name="fontUrl")
    def font_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "font_url")

    @property
    @pulumi.getter(name="hideLoginNameSuffix")
    def hide_login_name_suffix(self) -> pulumi.Output[bool]:
        """
        hides the org suffix on the login form if the scope "urn:zitadel:iam:org:domain:primary:{domainname}" is set. Details about this scope in https://zitadel.com/docs/apis/openidoauth/scopes#reserved-scopes
        """
        return pulumi.get(self, "hide_login_name_suffix")

    @property
    @pulumi.getter(name="iconDarkHash")
    def icon_dark_hash(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "icon_dark_hash")

    @property
    @pulumi.getter(name="iconDarkPath")
    def icon_dark_path(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "icon_dark_path")

    @property
    @pulumi.getter(name="iconHash")
    def icon_hash(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "icon_hash")

    @property
    @pulumi.getter(name="iconPath")
    def icon_path(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "icon_path")

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "icon_url")

    @property
    @pulumi.getter(name="iconUrlDark")
    def icon_url_dark(self) -> pulumi.Output[str]:
        return pulumi.get(self, "icon_url_dark")

    @property
    @pulumi.getter(name="logoDarkHash")
    def logo_dark_hash(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "logo_dark_hash")

    @property
    @pulumi.getter(name="logoDarkPath")
    def logo_dark_path(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "logo_dark_path")

    @property
    @pulumi.getter(name="logoHash")
    def logo_hash(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "logo_hash")

    @property
    @pulumi.getter(name="logoPath")
    def logo_path(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "logo_path")

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "logo_url")

    @property
    @pulumi.getter(name="logoUrlDark")
    def logo_url_dark(self) -> pulumi.Output[str]:
        return pulumi.get(self, "logo_url_dark")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="primaryColor")
    def primary_color(self) -> pulumi.Output[str]:
        """
        hex value for primary color
        """
        return pulumi.get(self, "primary_color")

    @property
    @pulumi.getter(name="primaryColorDark")
    def primary_color_dark(self) -> pulumi.Output[str]:
        """
        hex value for primary color dark theme
        """
        return pulumi.get(self, "primary_color_dark")

    @property
    @pulumi.getter(name="setActive")
    def set_active(self) -> pulumi.Output[Optional[bool]]:
        """
        set the label policy active after creating/updating
        """
        return pulumi.get(self, "set_active")

    @property
    @pulumi.getter(name="warnColor")
    def warn_color(self) -> pulumi.Output[str]:
        """
        hex value for warn color
        """
        return pulumi.get(self, "warn_color")

    @property
    @pulumi.getter(name="warnColorDark")
    def warn_color_dark(self) -> pulumi.Output[str]:
        """
        hex value for warn color dark theme
        """
        return pulumi.get(self, "warn_color_dark")

