# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['LoginPolicyArgs', 'LoginPolicy']

@pulumi.input_type
class LoginPolicyArgs:
    def __init__(__self__, *,
                 allow_external_idp: pulumi.Input[bool],
                 allow_register: pulumi.Input[bool],
                 default_redirect_uri: pulumi.Input[str],
                 external_login_check_lifetime: pulumi.Input[str],
                 force_mfa: pulumi.Input[bool],
                 force_mfa_local_only: pulumi.Input[bool],
                 hide_password_reset: pulumi.Input[bool],
                 ignore_unknown_usernames: pulumi.Input[bool],
                 mfa_init_skip_lifetime: pulumi.Input[str],
                 multi_factor_check_lifetime: pulumi.Input[str],
                 password_check_lifetime: pulumi.Input[str],
                 passwordless_type: pulumi.Input[str],
                 second_factor_check_lifetime: pulumi.Input[str],
                 user_login: pulumi.Input[bool],
                 allow_domain_discovery: Optional[pulumi.Input[bool]] = None,
                 disable_login_with_email: Optional[pulumi.Input[bool]] = None,
                 disable_login_with_phone: Optional[pulumi.Input[bool]] = None,
                 idps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 multi_factors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 second_factors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a LoginPolicy resource.
        :param pulumi.Input[bool] allow_external_idp: defines if a user is allowed to add a defined identity provider. E.g. Google auth
        :param pulumi.Input[bool] allow_register: defines if a person is allowed to register a user on this organisation
        :param pulumi.Input[str] default_redirect_uri: defines where the user will be redirected to if the login is started without app context (e.g. from mail)
        :param pulumi.Input[bool] force_mfa: defines if a user MUST use a multi factor to log in
        :param pulumi.Input[bool] force_mfa_local_only: if activated, ZITADEL only enforces MFA on local authentications. On authentications through MFA, ZITADEL won't prompt for MFA.
        :param pulumi.Input[bool] hide_password_reset: defines if password reset link should be shown in the login screen
        :param pulumi.Input[bool] ignore_unknown_usernames: defines if unknown username on login screen directly return an error or always display the password screen
        :param pulumi.Input[str] passwordless_type: defines if passwordless is allowed for users
        :param pulumi.Input[bool] user_login: defines if a user is allowed to login with his username and password
        :param pulumi.Input[bool] allow_domain_discovery: if set to true, the suffix (@domain.com) of an unknown username input on the login screen will be matched against the org domains and will redirect to the registration of that organisation on success.
        :param pulumi.Input[bool] disable_login_with_email: defines if user can additionally (to the loginname) be identified by their verified email address
        :param pulumi.Input[bool] disable_login_with_phone: defines if user can additionally (to the loginname) be identified by their verified phone number
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idps: allowed idps to login or register
        :param pulumi.Input[Sequence[pulumi.Input[str]]] multi_factors: allowed multi factors
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[Sequence[pulumi.Input[str]]] second_factors: allowed second factors
        """
        LoginPolicyArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            allow_external_idp=allow_external_idp,
            allow_register=allow_register,
            default_redirect_uri=default_redirect_uri,
            external_login_check_lifetime=external_login_check_lifetime,
            force_mfa=force_mfa,
            force_mfa_local_only=force_mfa_local_only,
            hide_password_reset=hide_password_reset,
            ignore_unknown_usernames=ignore_unknown_usernames,
            mfa_init_skip_lifetime=mfa_init_skip_lifetime,
            multi_factor_check_lifetime=multi_factor_check_lifetime,
            password_check_lifetime=password_check_lifetime,
            passwordless_type=passwordless_type,
            second_factor_check_lifetime=second_factor_check_lifetime,
            user_login=user_login,
            allow_domain_discovery=allow_domain_discovery,
            disable_login_with_email=disable_login_with_email,
            disable_login_with_phone=disable_login_with_phone,
            idps=idps,
            multi_factors=multi_factors,
            org_id=org_id,
            second_factors=second_factors,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             allow_external_idp: pulumi.Input[bool],
             allow_register: pulumi.Input[bool],
             default_redirect_uri: pulumi.Input[str],
             external_login_check_lifetime: pulumi.Input[str],
             force_mfa: pulumi.Input[bool],
             force_mfa_local_only: pulumi.Input[bool],
             hide_password_reset: pulumi.Input[bool],
             ignore_unknown_usernames: pulumi.Input[bool],
             mfa_init_skip_lifetime: pulumi.Input[str],
             multi_factor_check_lifetime: pulumi.Input[str],
             password_check_lifetime: pulumi.Input[str],
             passwordless_type: pulumi.Input[str],
             second_factor_check_lifetime: pulumi.Input[str],
             user_login: pulumi.Input[bool],
             allow_domain_discovery: Optional[pulumi.Input[bool]] = None,
             disable_login_with_email: Optional[pulumi.Input[bool]] = None,
             disable_login_with_phone: Optional[pulumi.Input[bool]] = None,
             idps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             multi_factors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             org_id: Optional[pulumi.Input[str]] = None,
             second_factors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'allowExternalIdp' in kwargs:
            allow_external_idp = kwargs['allowExternalIdp']
        if 'allowRegister' in kwargs:
            allow_register = kwargs['allowRegister']
        if 'defaultRedirectUri' in kwargs:
            default_redirect_uri = kwargs['defaultRedirectUri']
        if 'externalLoginCheckLifetime' in kwargs:
            external_login_check_lifetime = kwargs['externalLoginCheckLifetime']
        if 'forceMfa' in kwargs:
            force_mfa = kwargs['forceMfa']
        if 'forceMfaLocalOnly' in kwargs:
            force_mfa_local_only = kwargs['forceMfaLocalOnly']
        if 'hidePasswordReset' in kwargs:
            hide_password_reset = kwargs['hidePasswordReset']
        if 'ignoreUnknownUsernames' in kwargs:
            ignore_unknown_usernames = kwargs['ignoreUnknownUsernames']
        if 'mfaInitSkipLifetime' in kwargs:
            mfa_init_skip_lifetime = kwargs['mfaInitSkipLifetime']
        if 'multiFactorCheckLifetime' in kwargs:
            multi_factor_check_lifetime = kwargs['multiFactorCheckLifetime']
        if 'passwordCheckLifetime' in kwargs:
            password_check_lifetime = kwargs['passwordCheckLifetime']
        if 'passwordlessType' in kwargs:
            passwordless_type = kwargs['passwordlessType']
        if 'secondFactorCheckLifetime' in kwargs:
            second_factor_check_lifetime = kwargs['secondFactorCheckLifetime']
        if 'userLogin' in kwargs:
            user_login = kwargs['userLogin']
        if 'allowDomainDiscovery' in kwargs:
            allow_domain_discovery = kwargs['allowDomainDiscovery']
        if 'disableLoginWithEmail' in kwargs:
            disable_login_with_email = kwargs['disableLoginWithEmail']
        if 'disableLoginWithPhone' in kwargs:
            disable_login_with_phone = kwargs['disableLoginWithPhone']
        if 'multiFactors' in kwargs:
            multi_factors = kwargs['multiFactors']
        if 'orgId' in kwargs:
            org_id = kwargs['orgId']
        if 'secondFactors' in kwargs:
            second_factors = kwargs['secondFactors']

        _setter("allow_external_idp", allow_external_idp)
        _setter("allow_register", allow_register)
        _setter("default_redirect_uri", default_redirect_uri)
        _setter("external_login_check_lifetime", external_login_check_lifetime)
        _setter("force_mfa", force_mfa)
        _setter("force_mfa_local_only", force_mfa_local_only)
        _setter("hide_password_reset", hide_password_reset)
        _setter("ignore_unknown_usernames", ignore_unknown_usernames)
        _setter("mfa_init_skip_lifetime", mfa_init_skip_lifetime)
        _setter("multi_factor_check_lifetime", multi_factor_check_lifetime)
        _setter("password_check_lifetime", password_check_lifetime)
        _setter("passwordless_type", passwordless_type)
        _setter("second_factor_check_lifetime", second_factor_check_lifetime)
        _setter("user_login", user_login)
        if allow_domain_discovery is not None:
            _setter("allow_domain_discovery", allow_domain_discovery)
        if disable_login_with_email is not None:
            _setter("disable_login_with_email", disable_login_with_email)
        if disable_login_with_phone is not None:
            _setter("disable_login_with_phone", disable_login_with_phone)
        if idps is not None:
            _setter("idps", idps)
        if multi_factors is not None:
            _setter("multi_factors", multi_factors)
        if org_id is not None:
            _setter("org_id", org_id)
        if second_factors is not None:
            _setter("second_factors", second_factors)

    @property
    @pulumi.getter(name="allowExternalIdp")
    def allow_external_idp(self) -> pulumi.Input[bool]:
        """
        defines if a user is allowed to add a defined identity provider. E.g. Google auth
        """
        return pulumi.get(self, "allow_external_idp")

    @allow_external_idp.setter
    def allow_external_idp(self, value: pulumi.Input[bool]):
        pulumi.set(self, "allow_external_idp", value)

    @property
    @pulumi.getter(name="allowRegister")
    def allow_register(self) -> pulumi.Input[bool]:
        """
        defines if a person is allowed to register a user on this organisation
        """
        return pulumi.get(self, "allow_register")

    @allow_register.setter
    def allow_register(self, value: pulumi.Input[bool]):
        pulumi.set(self, "allow_register", value)

    @property
    @pulumi.getter(name="defaultRedirectUri")
    def default_redirect_uri(self) -> pulumi.Input[str]:
        """
        defines where the user will be redirected to if the login is started without app context (e.g. from mail)
        """
        return pulumi.get(self, "default_redirect_uri")

    @default_redirect_uri.setter
    def default_redirect_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "default_redirect_uri", value)

    @property
    @pulumi.getter(name="externalLoginCheckLifetime")
    def external_login_check_lifetime(self) -> pulumi.Input[str]:
        return pulumi.get(self, "external_login_check_lifetime")

    @external_login_check_lifetime.setter
    def external_login_check_lifetime(self, value: pulumi.Input[str]):
        pulumi.set(self, "external_login_check_lifetime", value)

    @property
    @pulumi.getter(name="forceMfa")
    def force_mfa(self) -> pulumi.Input[bool]:
        """
        defines if a user MUST use a multi factor to log in
        """
        return pulumi.get(self, "force_mfa")

    @force_mfa.setter
    def force_mfa(self, value: pulumi.Input[bool]):
        pulumi.set(self, "force_mfa", value)

    @property
    @pulumi.getter(name="forceMfaLocalOnly")
    def force_mfa_local_only(self) -> pulumi.Input[bool]:
        """
        if activated, ZITADEL only enforces MFA on local authentications. On authentications through MFA, ZITADEL won't prompt for MFA.
        """
        return pulumi.get(self, "force_mfa_local_only")

    @force_mfa_local_only.setter
    def force_mfa_local_only(self, value: pulumi.Input[bool]):
        pulumi.set(self, "force_mfa_local_only", value)

    @property
    @pulumi.getter(name="hidePasswordReset")
    def hide_password_reset(self) -> pulumi.Input[bool]:
        """
        defines if password reset link should be shown in the login screen
        """
        return pulumi.get(self, "hide_password_reset")

    @hide_password_reset.setter
    def hide_password_reset(self, value: pulumi.Input[bool]):
        pulumi.set(self, "hide_password_reset", value)

    @property
    @pulumi.getter(name="ignoreUnknownUsernames")
    def ignore_unknown_usernames(self) -> pulumi.Input[bool]:
        """
        defines if unknown username on login screen directly return an error or always display the password screen
        """
        return pulumi.get(self, "ignore_unknown_usernames")

    @ignore_unknown_usernames.setter
    def ignore_unknown_usernames(self, value: pulumi.Input[bool]):
        pulumi.set(self, "ignore_unknown_usernames", value)

    @property
    @pulumi.getter(name="mfaInitSkipLifetime")
    def mfa_init_skip_lifetime(self) -> pulumi.Input[str]:
        return pulumi.get(self, "mfa_init_skip_lifetime")

    @mfa_init_skip_lifetime.setter
    def mfa_init_skip_lifetime(self, value: pulumi.Input[str]):
        pulumi.set(self, "mfa_init_skip_lifetime", value)

    @property
    @pulumi.getter(name="multiFactorCheckLifetime")
    def multi_factor_check_lifetime(self) -> pulumi.Input[str]:
        return pulumi.get(self, "multi_factor_check_lifetime")

    @multi_factor_check_lifetime.setter
    def multi_factor_check_lifetime(self, value: pulumi.Input[str]):
        pulumi.set(self, "multi_factor_check_lifetime", value)

    @property
    @pulumi.getter(name="passwordCheckLifetime")
    def password_check_lifetime(self) -> pulumi.Input[str]:
        return pulumi.get(self, "password_check_lifetime")

    @password_check_lifetime.setter
    def password_check_lifetime(self, value: pulumi.Input[str]):
        pulumi.set(self, "password_check_lifetime", value)

    @property
    @pulumi.getter(name="passwordlessType")
    def passwordless_type(self) -> pulumi.Input[str]:
        """
        defines if passwordless is allowed for users
        """
        return pulumi.get(self, "passwordless_type")

    @passwordless_type.setter
    def passwordless_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "passwordless_type", value)

    @property
    @pulumi.getter(name="secondFactorCheckLifetime")
    def second_factor_check_lifetime(self) -> pulumi.Input[str]:
        return pulumi.get(self, "second_factor_check_lifetime")

    @second_factor_check_lifetime.setter
    def second_factor_check_lifetime(self, value: pulumi.Input[str]):
        pulumi.set(self, "second_factor_check_lifetime", value)

    @property
    @pulumi.getter(name="userLogin")
    def user_login(self) -> pulumi.Input[bool]:
        """
        defines if a user is allowed to login with his username and password
        """
        return pulumi.get(self, "user_login")

    @user_login.setter
    def user_login(self, value: pulumi.Input[bool]):
        pulumi.set(self, "user_login", value)

    @property
    @pulumi.getter(name="allowDomainDiscovery")
    def allow_domain_discovery(self) -> Optional[pulumi.Input[bool]]:
        """
        if set to true, the suffix (@domain.com) of an unknown username input on the login screen will be matched against the org domains and will redirect to the registration of that organisation on success.
        """
        return pulumi.get(self, "allow_domain_discovery")

    @allow_domain_discovery.setter
    def allow_domain_discovery(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_domain_discovery", value)

    @property
    @pulumi.getter(name="disableLoginWithEmail")
    def disable_login_with_email(self) -> Optional[pulumi.Input[bool]]:
        """
        defines if user can additionally (to the loginname) be identified by their verified email address
        """
        return pulumi.get(self, "disable_login_with_email")

    @disable_login_with_email.setter
    def disable_login_with_email(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_login_with_email", value)

    @property
    @pulumi.getter(name="disableLoginWithPhone")
    def disable_login_with_phone(self) -> Optional[pulumi.Input[bool]]:
        """
        defines if user can additionally (to the loginname) be identified by their verified phone number
        """
        return pulumi.get(self, "disable_login_with_phone")

    @disable_login_with_phone.setter
    def disable_login_with_phone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_login_with_phone", value)

    @property
    @pulumi.getter
    def idps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        allowed idps to login or register
        """
        return pulumi.get(self, "idps")

    @idps.setter
    def idps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "idps", value)

    @property
    @pulumi.getter(name="multiFactors")
    def multi_factors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        allowed multi factors
        """
        return pulumi.get(self, "multi_factors")

    @multi_factors.setter
    def multi_factors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "multi_factors", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="secondFactors")
    def second_factors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        allowed second factors
        """
        return pulumi.get(self, "second_factors")

    @second_factors.setter
    def second_factors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "second_factors", value)


@pulumi.input_type
class _LoginPolicyState:
    def __init__(__self__, *,
                 allow_domain_discovery: Optional[pulumi.Input[bool]] = None,
                 allow_external_idp: Optional[pulumi.Input[bool]] = None,
                 allow_register: Optional[pulumi.Input[bool]] = None,
                 default_redirect_uri: Optional[pulumi.Input[str]] = None,
                 disable_login_with_email: Optional[pulumi.Input[bool]] = None,
                 disable_login_with_phone: Optional[pulumi.Input[bool]] = None,
                 external_login_check_lifetime: Optional[pulumi.Input[str]] = None,
                 force_mfa: Optional[pulumi.Input[bool]] = None,
                 force_mfa_local_only: Optional[pulumi.Input[bool]] = None,
                 hide_password_reset: Optional[pulumi.Input[bool]] = None,
                 idps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ignore_unknown_usernames: Optional[pulumi.Input[bool]] = None,
                 mfa_init_skip_lifetime: Optional[pulumi.Input[str]] = None,
                 multi_factor_check_lifetime: Optional[pulumi.Input[str]] = None,
                 multi_factors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 password_check_lifetime: Optional[pulumi.Input[str]] = None,
                 passwordless_type: Optional[pulumi.Input[str]] = None,
                 second_factor_check_lifetime: Optional[pulumi.Input[str]] = None,
                 second_factors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_login: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering LoginPolicy resources.
        :param pulumi.Input[bool] allow_domain_discovery: if set to true, the suffix (@domain.com) of an unknown username input on the login screen will be matched against the org domains and will redirect to the registration of that organisation on success.
        :param pulumi.Input[bool] allow_external_idp: defines if a user is allowed to add a defined identity provider. E.g. Google auth
        :param pulumi.Input[bool] allow_register: defines if a person is allowed to register a user on this organisation
        :param pulumi.Input[str] default_redirect_uri: defines where the user will be redirected to if the login is started without app context (e.g. from mail)
        :param pulumi.Input[bool] disable_login_with_email: defines if user can additionally (to the loginname) be identified by their verified email address
        :param pulumi.Input[bool] disable_login_with_phone: defines if user can additionally (to the loginname) be identified by their verified phone number
        :param pulumi.Input[bool] force_mfa: defines if a user MUST use a multi factor to log in
        :param pulumi.Input[bool] force_mfa_local_only: if activated, ZITADEL only enforces MFA on local authentications. On authentications through MFA, ZITADEL won't prompt for MFA.
        :param pulumi.Input[bool] hide_password_reset: defines if password reset link should be shown in the login screen
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idps: allowed idps to login or register
        :param pulumi.Input[bool] ignore_unknown_usernames: defines if unknown username on login screen directly return an error or always display the password screen
        :param pulumi.Input[Sequence[pulumi.Input[str]]] multi_factors: allowed multi factors
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] passwordless_type: defines if passwordless is allowed for users
        :param pulumi.Input[Sequence[pulumi.Input[str]]] second_factors: allowed second factors
        :param pulumi.Input[bool] user_login: defines if a user is allowed to login with his username and password
        """
        _LoginPolicyState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            allow_domain_discovery=allow_domain_discovery,
            allow_external_idp=allow_external_idp,
            allow_register=allow_register,
            default_redirect_uri=default_redirect_uri,
            disable_login_with_email=disable_login_with_email,
            disable_login_with_phone=disable_login_with_phone,
            external_login_check_lifetime=external_login_check_lifetime,
            force_mfa=force_mfa,
            force_mfa_local_only=force_mfa_local_only,
            hide_password_reset=hide_password_reset,
            idps=idps,
            ignore_unknown_usernames=ignore_unknown_usernames,
            mfa_init_skip_lifetime=mfa_init_skip_lifetime,
            multi_factor_check_lifetime=multi_factor_check_lifetime,
            multi_factors=multi_factors,
            org_id=org_id,
            password_check_lifetime=password_check_lifetime,
            passwordless_type=passwordless_type,
            second_factor_check_lifetime=second_factor_check_lifetime,
            second_factors=second_factors,
            user_login=user_login,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             allow_domain_discovery: Optional[pulumi.Input[bool]] = None,
             allow_external_idp: Optional[pulumi.Input[bool]] = None,
             allow_register: Optional[pulumi.Input[bool]] = None,
             default_redirect_uri: Optional[pulumi.Input[str]] = None,
             disable_login_with_email: Optional[pulumi.Input[bool]] = None,
             disable_login_with_phone: Optional[pulumi.Input[bool]] = None,
             external_login_check_lifetime: Optional[pulumi.Input[str]] = None,
             force_mfa: Optional[pulumi.Input[bool]] = None,
             force_mfa_local_only: Optional[pulumi.Input[bool]] = None,
             hide_password_reset: Optional[pulumi.Input[bool]] = None,
             idps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             ignore_unknown_usernames: Optional[pulumi.Input[bool]] = None,
             mfa_init_skip_lifetime: Optional[pulumi.Input[str]] = None,
             multi_factor_check_lifetime: Optional[pulumi.Input[str]] = None,
             multi_factors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             org_id: Optional[pulumi.Input[str]] = None,
             password_check_lifetime: Optional[pulumi.Input[str]] = None,
             passwordless_type: Optional[pulumi.Input[str]] = None,
             second_factor_check_lifetime: Optional[pulumi.Input[str]] = None,
             second_factors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             user_login: Optional[pulumi.Input[bool]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'allowDomainDiscovery' in kwargs:
            allow_domain_discovery = kwargs['allowDomainDiscovery']
        if 'allowExternalIdp' in kwargs:
            allow_external_idp = kwargs['allowExternalIdp']
        if 'allowRegister' in kwargs:
            allow_register = kwargs['allowRegister']
        if 'defaultRedirectUri' in kwargs:
            default_redirect_uri = kwargs['defaultRedirectUri']
        if 'disableLoginWithEmail' in kwargs:
            disable_login_with_email = kwargs['disableLoginWithEmail']
        if 'disableLoginWithPhone' in kwargs:
            disable_login_with_phone = kwargs['disableLoginWithPhone']
        if 'externalLoginCheckLifetime' in kwargs:
            external_login_check_lifetime = kwargs['externalLoginCheckLifetime']
        if 'forceMfa' in kwargs:
            force_mfa = kwargs['forceMfa']
        if 'forceMfaLocalOnly' in kwargs:
            force_mfa_local_only = kwargs['forceMfaLocalOnly']
        if 'hidePasswordReset' in kwargs:
            hide_password_reset = kwargs['hidePasswordReset']
        if 'ignoreUnknownUsernames' in kwargs:
            ignore_unknown_usernames = kwargs['ignoreUnknownUsernames']
        if 'mfaInitSkipLifetime' in kwargs:
            mfa_init_skip_lifetime = kwargs['mfaInitSkipLifetime']
        if 'multiFactorCheckLifetime' in kwargs:
            multi_factor_check_lifetime = kwargs['multiFactorCheckLifetime']
        if 'multiFactors' in kwargs:
            multi_factors = kwargs['multiFactors']
        if 'orgId' in kwargs:
            org_id = kwargs['orgId']
        if 'passwordCheckLifetime' in kwargs:
            password_check_lifetime = kwargs['passwordCheckLifetime']
        if 'passwordlessType' in kwargs:
            passwordless_type = kwargs['passwordlessType']
        if 'secondFactorCheckLifetime' in kwargs:
            second_factor_check_lifetime = kwargs['secondFactorCheckLifetime']
        if 'secondFactors' in kwargs:
            second_factors = kwargs['secondFactors']
        if 'userLogin' in kwargs:
            user_login = kwargs['userLogin']

        if allow_domain_discovery is not None:
            _setter("allow_domain_discovery", allow_domain_discovery)
        if allow_external_idp is not None:
            _setter("allow_external_idp", allow_external_idp)
        if allow_register is not None:
            _setter("allow_register", allow_register)
        if default_redirect_uri is not None:
            _setter("default_redirect_uri", default_redirect_uri)
        if disable_login_with_email is not None:
            _setter("disable_login_with_email", disable_login_with_email)
        if disable_login_with_phone is not None:
            _setter("disable_login_with_phone", disable_login_with_phone)
        if external_login_check_lifetime is not None:
            _setter("external_login_check_lifetime", external_login_check_lifetime)
        if force_mfa is not None:
            _setter("force_mfa", force_mfa)
        if force_mfa_local_only is not None:
            _setter("force_mfa_local_only", force_mfa_local_only)
        if hide_password_reset is not None:
            _setter("hide_password_reset", hide_password_reset)
        if idps is not None:
            _setter("idps", idps)
        if ignore_unknown_usernames is not None:
            _setter("ignore_unknown_usernames", ignore_unknown_usernames)
        if mfa_init_skip_lifetime is not None:
            _setter("mfa_init_skip_lifetime", mfa_init_skip_lifetime)
        if multi_factor_check_lifetime is not None:
            _setter("multi_factor_check_lifetime", multi_factor_check_lifetime)
        if multi_factors is not None:
            _setter("multi_factors", multi_factors)
        if org_id is not None:
            _setter("org_id", org_id)
        if password_check_lifetime is not None:
            _setter("password_check_lifetime", password_check_lifetime)
        if passwordless_type is not None:
            _setter("passwordless_type", passwordless_type)
        if second_factor_check_lifetime is not None:
            _setter("second_factor_check_lifetime", second_factor_check_lifetime)
        if second_factors is not None:
            _setter("second_factors", second_factors)
        if user_login is not None:
            _setter("user_login", user_login)

    @property
    @pulumi.getter(name="allowDomainDiscovery")
    def allow_domain_discovery(self) -> Optional[pulumi.Input[bool]]:
        """
        if set to true, the suffix (@domain.com) of an unknown username input on the login screen will be matched against the org domains and will redirect to the registration of that organisation on success.
        """
        return pulumi.get(self, "allow_domain_discovery")

    @allow_domain_discovery.setter
    def allow_domain_discovery(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_domain_discovery", value)

    @property
    @pulumi.getter(name="allowExternalIdp")
    def allow_external_idp(self) -> Optional[pulumi.Input[bool]]:
        """
        defines if a user is allowed to add a defined identity provider. E.g. Google auth
        """
        return pulumi.get(self, "allow_external_idp")

    @allow_external_idp.setter
    def allow_external_idp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_external_idp", value)

    @property
    @pulumi.getter(name="allowRegister")
    def allow_register(self) -> Optional[pulumi.Input[bool]]:
        """
        defines if a person is allowed to register a user on this organisation
        """
        return pulumi.get(self, "allow_register")

    @allow_register.setter
    def allow_register(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_register", value)

    @property
    @pulumi.getter(name="defaultRedirectUri")
    def default_redirect_uri(self) -> Optional[pulumi.Input[str]]:
        """
        defines where the user will be redirected to if the login is started without app context (e.g. from mail)
        """
        return pulumi.get(self, "default_redirect_uri")

    @default_redirect_uri.setter
    def default_redirect_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_redirect_uri", value)

    @property
    @pulumi.getter(name="disableLoginWithEmail")
    def disable_login_with_email(self) -> Optional[pulumi.Input[bool]]:
        """
        defines if user can additionally (to the loginname) be identified by their verified email address
        """
        return pulumi.get(self, "disable_login_with_email")

    @disable_login_with_email.setter
    def disable_login_with_email(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_login_with_email", value)

    @property
    @pulumi.getter(name="disableLoginWithPhone")
    def disable_login_with_phone(self) -> Optional[pulumi.Input[bool]]:
        """
        defines if user can additionally (to the loginname) be identified by their verified phone number
        """
        return pulumi.get(self, "disable_login_with_phone")

    @disable_login_with_phone.setter
    def disable_login_with_phone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_login_with_phone", value)

    @property
    @pulumi.getter(name="externalLoginCheckLifetime")
    def external_login_check_lifetime(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "external_login_check_lifetime")

    @external_login_check_lifetime.setter
    def external_login_check_lifetime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_login_check_lifetime", value)

    @property
    @pulumi.getter(name="forceMfa")
    def force_mfa(self) -> Optional[pulumi.Input[bool]]:
        """
        defines if a user MUST use a multi factor to log in
        """
        return pulumi.get(self, "force_mfa")

    @force_mfa.setter
    def force_mfa(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_mfa", value)

    @property
    @pulumi.getter(name="forceMfaLocalOnly")
    def force_mfa_local_only(self) -> Optional[pulumi.Input[bool]]:
        """
        if activated, ZITADEL only enforces MFA on local authentications. On authentications through MFA, ZITADEL won't prompt for MFA.
        """
        return pulumi.get(self, "force_mfa_local_only")

    @force_mfa_local_only.setter
    def force_mfa_local_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_mfa_local_only", value)

    @property
    @pulumi.getter(name="hidePasswordReset")
    def hide_password_reset(self) -> Optional[pulumi.Input[bool]]:
        """
        defines if password reset link should be shown in the login screen
        """
        return pulumi.get(self, "hide_password_reset")

    @hide_password_reset.setter
    def hide_password_reset(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_password_reset", value)

    @property
    @pulumi.getter
    def idps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        allowed idps to login or register
        """
        return pulumi.get(self, "idps")

    @idps.setter
    def idps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "idps", value)

    @property
    @pulumi.getter(name="ignoreUnknownUsernames")
    def ignore_unknown_usernames(self) -> Optional[pulumi.Input[bool]]:
        """
        defines if unknown username on login screen directly return an error or always display the password screen
        """
        return pulumi.get(self, "ignore_unknown_usernames")

    @ignore_unknown_usernames.setter
    def ignore_unknown_usernames(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_unknown_usernames", value)

    @property
    @pulumi.getter(name="mfaInitSkipLifetime")
    def mfa_init_skip_lifetime(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "mfa_init_skip_lifetime")

    @mfa_init_skip_lifetime.setter
    def mfa_init_skip_lifetime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mfa_init_skip_lifetime", value)

    @property
    @pulumi.getter(name="multiFactorCheckLifetime")
    def multi_factor_check_lifetime(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "multi_factor_check_lifetime")

    @multi_factor_check_lifetime.setter
    def multi_factor_check_lifetime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_factor_check_lifetime", value)

    @property
    @pulumi.getter(name="multiFactors")
    def multi_factors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        allowed multi factors
        """
        return pulumi.get(self, "multi_factors")

    @multi_factors.setter
    def multi_factors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "multi_factors", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="passwordCheckLifetime")
    def password_check_lifetime(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "password_check_lifetime")

    @password_check_lifetime.setter
    def password_check_lifetime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_check_lifetime", value)

    @property
    @pulumi.getter(name="passwordlessType")
    def passwordless_type(self) -> Optional[pulumi.Input[str]]:
        """
        defines if passwordless is allowed for users
        """
        return pulumi.get(self, "passwordless_type")

    @passwordless_type.setter
    def passwordless_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "passwordless_type", value)

    @property
    @pulumi.getter(name="secondFactorCheckLifetime")
    def second_factor_check_lifetime(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "second_factor_check_lifetime")

    @second_factor_check_lifetime.setter
    def second_factor_check_lifetime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "second_factor_check_lifetime", value)

    @property
    @pulumi.getter(name="secondFactors")
    def second_factors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        allowed second factors
        """
        return pulumi.get(self, "second_factors")

    @second_factors.setter
    def second_factors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "second_factors", value)

    @property
    @pulumi.getter(name="userLogin")
    def user_login(self) -> Optional[pulumi.Input[bool]]:
        """
        defines if a user is allowed to login with his username and password
        """
        return pulumi.get(self, "user_login")

    @user_login.setter
    def user_login(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "user_login", value)


class LoginPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_domain_discovery: Optional[pulumi.Input[bool]] = None,
                 allow_external_idp: Optional[pulumi.Input[bool]] = None,
                 allow_register: Optional[pulumi.Input[bool]] = None,
                 default_redirect_uri: Optional[pulumi.Input[str]] = None,
                 disable_login_with_email: Optional[pulumi.Input[bool]] = None,
                 disable_login_with_phone: Optional[pulumi.Input[bool]] = None,
                 external_login_check_lifetime: Optional[pulumi.Input[str]] = None,
                 force_mfa: Optional[pulumi.Input[bool]] = None,
                 force_mfa_local_only: Optional[pulumi.Input[bool]] = None,
                 hide_password_reset: Optional[pulumi.Input[bool]] = None,
                 idps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ignore_unknown_usernames: Optional[pulumi.Input[bool]] = None,
                 mfa_init_skip_lifetime: Optional[pulumi.Input[str]] = None,
                 multi_factor_check_lifetime: Optional[pulumi.Input[str]] = None,
                 multi_factors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 password_check_lifetime: Optional[pulumi.Input[str]] = None,
                 passwordless_type: Optional[pulumi.Input[str]] = None,
                 second_factor_check_lifetime: Optional[pulumi.Input[str]] = None,
                 second_factors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_login: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Resource representing the custom login policy of an organization.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.LoginPolicy("default",
            org_id=data["zitadel_org"]["default"]["id"],
            user_login=True,
            allow_register=True,
            allow_external_idp=True,
            force_mfa=False,
            force_mfa_local_only=False,
            passwordless_type="PASSWORDLESS_TYPE_ALLOWED",
            hide_password_reset=False,
            password_check_lifetime="240h0m0s",
            external_login_check_lifetime="240h0m0s",
            multi_factor_check_lifetime="24h0m0s",
            mfa_init_skip_lifetime="720h0m0s",
            second_factor_check_lifetime="24h0m0s",
            ignore_unknown_usernames=True,
            default_redirect_uri="localhost:8080",
            second_factors=[
                "SECOND_FACTOR_TYPE_OTP",
                "SECOND_FACTOR_TYPE_U2F",
            ],
            multi_factors=["MULTI_FACTOR_TYPE_U2F_WITH_VERIFICATION"],
            idps=[
                data["zitadel_idp_google"]["default"]["id"],
                data["zitadel_idp_azure_ad"]["default"]["id"],
            ],
            allow_domain_discovery=True,
            disable_login_with_email=True,
            disable_login_with_phone=True)
        ```

        ## Import

        terraform The resource can be imported using the ID format `<[org_id]>`, e.g.

        ```sh
         $ pulumi import zitadel:index/loginPolicy:LoginPolicy imported '123456789012345678'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_domain_discovery: if set to true, the suffix (@domain.com) of an unknown username input on the login screen will be matched against the org domains and will redirect to the registration of that organisation on success.
        :param pulumi.Input[bool] allow_external_idp: defines if a user is allowed to add a defined identity provider. E.g. Google auth
        :param pulumi.Input[bool] allow_register: defines if a person is allowed to register a user on this organisation
        :param pulumi.Input[str] default_redirect_uri: defines where the user will be redirected to if the login is started without app context (e.g. from mail)
        :param pulumi.Input[bool] disable_login_with_email: defines if user can additionally (to the loginname) be identified by their verified email address
        :param pulumi.Input[bool] disable_login_with_phone: defines if user can additionally (to the loginname) be identified by their verified phone number
        :param pulumi.Input[bool] force_mfa: defines if a user MUST use a multi factor to log in
        :param pulumi.Input[bool] force_mfa_local_only: if activated, ZITADEL only enforces MFA on local authentications. On authentications through MFA, ZITADEL won't prompt for MFA.
        :param pulumi.Input[bool] hide_password_reset: defines if password reset link should be shown in the login screen
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idps: allowed idps to login or register
        :param pulumi.Input[bool] ignore_unknown_usernames: defines if unknown username on login screen directly return an error or always display the password screen
        :param pulumi.Input[Sequence[pulumi.Input[str]]] multi_factors: allowed multi factors
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] passwordless_type: defines if passwordless is allowed for users
        :param pulumi.Input[Sequence[pulumi.Input[str]]] second_factors: allowed second factors
        :param pulumi.Input[bool] user_login: defines if a user is allowed to login with his username and password
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoginPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource representing the custom login policy of an organization.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.LoginPolicy("default",
            org_id=data["zitadel_org"]["default"]["id"],
            user_login=True,
            allow_register=True,
            allow_external_idp=True,
            force_mfa=False,
            force_mfa_local_only=False,
            passwordless_type="PASSWORDLESS_TYPE_ALLOWED",
            hide_password_reset=False,
            password_check_lifetime="240h0m0s",
            external_login_check_lifetime="240h0m0s",
            multi_factor_check_lifetime="24h0m0s",
            mfa_init_skip_lifetime="720h0m0s",
            second_factor_check_lifetime="24h0m0s",
            ignore_unknown_usernames=True,
            default_redirect_uri="localhost:8080",
            second_factors=[
                "SECOND_FACTOR_TYPE_OTP",
                "SECOND_FACTOR_TYPE_U2F",
            ],
            multi_factors=["MULTI_FACTOR_TYPE_U2F_WITH_VERIFICATION"],
            idps=[
                data["zitadel_idp_google"]["default"]["id"],
                data["zitadel_idp_azure_ad"]["default"]["id"],
            ],
            allow_domain_discovery=True,
            disable_login_with_email=True,
            disable_login_with_phone=True)
        ```

        ## Import

        terraform The resource can be imported using the ID format `<[org_id]>`, e.g.

        ```sh
         $ pulumi import zitadel:index/loginPolicy:LoginPolicy imported '123456789012345678'
        ```

        :param str resource_name: The name of the resource.
        :param LoginPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoginPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            LoginPolicyArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_domain_discovery: Optional[pulumi.Input[bool]] = None,
                 allow_external_idp: Optional[pulumi.Input[bool]] = None,
                 allow_register: Optional[pulumi.Input[bool]] = None,
                 default_redirect_uri: Optional[pulumi.Input[str]] = None,
                 disable_login_with_email: Optional[pulumi.Input[bool]] = None,
                 disable_login_with_phone: Optional[pulumi.Input[bool]] = None,
                 external_login_check_lifetime: Optional[pulumi.Input[str]] = None,
                 force_mfa: Optional[pulumi.Input[bool]] = None,
                 force_mfa_local_only: Optional[pulumi.Input[bool]] = None,
                 hide_password_reset: Optional[pulumi.Input[bool]] = None,
                 idps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ignore_unknown_usernames: Optional[pulumi.Input[bool]] = None,
                 mfa_init_skip_lifetime: Optional[pulumi.Input[str]] = None,
                 multi_factor_check_lifetime: Optional[pulumi.Input[str]] = None,
                 multi_factors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 password_check_lifetime: Optional[pulumi.Input[str]] = None,
                 passwordless_type: Optional[pulumi.Input[str]] = None,
                 second_factor_check_lifetime: Optional[pulumi.Input[str]] = None,
                 second_factors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_login: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoginPolicyArgs.__new__(LoginPolicyArgs)

            __props__.__dict__["allow_domain_discovery"] = allow_domain_discovery
            if allow_external_idp is None and not opts.urn:
                raise TypeError("Missing required property 'allow_external_idp'")
            __props__.__dict__["allow_external_idp"] = allow_external_idp
            if allow_register is None and not opts.urn:
                raise TypeError("Missing required property 'allow_register'")
            __props__.__dict__["allow_register"] = allow_register
            if default_redirect_uri is None and not opts.urn:
                raise TypeError("Missing required property 'default_redirect_uri'")
            __props__.__dict__["default_redirect_uri"] = default_redirect_uri
            __props__.__dict__["disable_login_with_email"] = disable_login_with_email
            __props__.__dict__["disable_login_with_phone"] = disable_login_with_phone
            if external_login_check_lifetime is None and not opts.urn:
                raise TypeError("Missing required property 'external_login_check_lifetime'")
            __props__.__dict__["external_login_check_lifetime"] = external_login_check_lifetime
            if force_mfa is None and not opts.urn:
                raise TypeError("Missing required property 'force_mfa'")
            __props__.__dict__["force_mfa"] = force_mfa
            if force_mfa_local_only is None and not opts.urn:
                raise TypeError("Missing required property 'force_mfa_local_only'")
            __props__.__dict__["force_mfa_local_only"] = force_mfa_local_only
            if hide_password_reset is None and not opts.urn:
                raise TypeError("Missing required property 'hide_password_reset'")
            __props__.__dict__["hide_password_reset"] = hide_password_reset
            __props__.__dict__["idps"] = idps
            if ignore_unknown_usernames is None and not opts.urn:
                raise TypeError("Missing required property 'ignore_unknown_usernames'")
            __props__.__dict__["ignore_unknown_usernames"] = ignore_unknown_usernames
            if mfa_init_skip_lifetime is None and not opts.urn:
                raise TypeError("Missing required property 'mfa_init_skip_lifetime'")
            __props__.__dict__["mfa_init_skip_lifetime"] = mfa_init_skip_lifetime
            if multi_factor_check_lifetime is None and not opts.urn:
                raise TypeError("Missing required property 'multi_factor_check_lifetime'")
            __props__.__dict__["multi_factor_check_lifetime"] = multi_factor_check_lifetime
            __props__.__dict__["multi_factors"] = multi_factors
            __props__.__dict__["org_id"] = org_id
            if password_check_lifetime is None and not opts.urn:
                raise TypeError("Missing required property 'password_check_lifetime'")
            __props__.__dict__["password_check_lifetime"] = password_check_lifetime
            if passwordless_type is None and not opts.urn:
                raise TypeError("Missing required property 'passwordless_type'")
            __props__.__dict__["passwordless_type"] = passwordless_type
            if second_factor_check_lifetime is None and not opts.urn:
                raise TypeError("Missing required property 'second_factor_check_lifetime'")
            __props__.__dict__["second_factor_check_lifetime"] = second_factor_check_lifetime
            __props__.__dict__["second_factors"] = second_factors
            if user_login is None and not opts.urn:
                raise TypeError("Missing required property 'user_login'")
            __props__.__dict__["user_login"] = user_login
        super(LoginPolicy, __self__).__init__(
            'zitadel:index/loginPolicy:LoginPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_domain_discovery: Optional[pulumi.Input[bool]] = None,
            allow_external_idp: Optional[pulumi.Input[bool]] = None,
            allow_register: Optional[pulumi.Input[bool]] = None,
            default_redirect_uri: Optional[pulumi.Input[str]] = None,
            disable_login_with_email: Optional[pulumi.Input[bool]] = None,
            disable_login_with_phone: Optional[pulumi.Input[bool]] = None,
            external_login_check_lifetime: Optional[pulumi.Input[str]] = None,
            force_mfa: Optional[pulumi.Input[bool]] = None,
            force_mfa_local_only: Optional[pulumi.Input[bool]] = None,
            hide_password_reset: Optional[pulumi.Input[bool]] = None,
            idps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ignore_unknown_usernames: Optional[pulumi.Input[bool]] = None,
            mfa_init_skip_lifetime: Optional[pulumi.Input[str]] = None,
            multi_factor_check_lifetime: Optional[pulumi.Input[str]] = None,
            multi_factors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            password_check_lifetime: Optional[pulumi.Input[str]] = None,
            passwordless_type: Optional[pulumi.Input[str]] = None,
            second_factor_check_lifetime: Optional[pulumi.Input[str]] = None,
            second_factors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            user_login: Optional[pulumi.Input[bool]] = None) -> 'LoginPolicy':
        """
        Get an existing LoginPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_domain_discovery: if set to true, the suffix (@domain.com) of an unknown username input on the login screen will be matched against the org domains and will redirect to the registration of that organisation on success.
        :param pulumi.Input[bool] allow_external_idp: defines if a user is allowed to add a defined identity provider. E.g. Google auth
        :param pulumi.Input[bool] allow_register: defines if a person is allowed to register a user on this organisation
        :param pulumi.Input[str] default_redirect_uri: defines where the user will be redirected to if the login is started without app context (e.g. from mail)
        :param pulumi.Input[bool] disable_login_with_email: defines if user can additionally (to the loginname) be identified by their verified email address
        :param pulumi.Input[bool] disable_login_with_phone: defines if user can additionally (to the loginname) be identified by their verified phone number
        :param pulumi.Input[bool] force_mfa: defines if a user MUST use a multi factor to log in
        :param pulumi.Input[bool] force_mfa_local_only: if activated, ZITADEL only enforces MFA on local authentications. On authentications through MFA, ZITADEL won't prompt for MFA.
        :param pulumi.Input[bool] hide_password_reset: defines if password reset link should be shown in the login screen
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idps: allowed idps to login or register
        :param pulumi.Input[bool] ignore_unknown_usernames: defines if unknown username on login screen directly return an error or always display the password screen
        :param pulumi.Input[Sequence[pulumi.Input[str]]] multi_factors: allowed multi factors
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] passwordless_type: defines if passwordless is allowed for users
        :param pulumi.Input[Sequence[pulumi.Input[str]]] second_factors: allowed second factors
        :param pulumi.Input[bool] user_login: defines if a user is allowed to login with his username and password
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoginPolicyState.__new__(_LoginPolicyState)

        __props__.__dict__["allow_domain_discovery"] = allow_domain_discovery
        __props__.__dict__["allow_external_idp"] = allow_external_idp
        __props__.__dict__["allow_register"] = allow_register
        __props__.__dict__["default_redirect_uri"] = default_redirect_uri
        __props__.__dict__["disable_login_with_email"] = disable_login_with_email
        __props__.__dict__["disable_login_with_phone"] = disable_login_with_phone
        __props__.__dict__["external_login_check_lifetime"] = external_login_check_lifetime
        __props__.__dict__["force_mfa"] = force_mfa
        __props__.__dict__["force_mfa_local_only"] = force_mfa_local_only
        __props__.__dict__["hide_password_reset"] = hide_password_reset
        __props__.__dict__["idps"] = idps
        __props__.__dict__["ignore_unknown_usernames"] = ignore_unknown_usernames
        __props__.__dict__["mfa_init_skip_lifetime"] = mfa_init_skip_lifetime
        __props__.__dict__["multi_factor_check_lifetime"] = multi_factor_check_lifetime
        __props__.__dict__["multi_factors"] = multi_factors
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["password_check_lifetime"] = password_check_lifetime
        __props__.__dict__["passwordless_type"] = passwordless_type
        __props__.__dict__["second_factor_check_lifetime"] = second_factor_check_lifetime
        __props__.__dict__["second_factors"] = second_factors
        __props__.__dict__["user_login"] = user_login
        return LoginPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowDomainDiscovery")
    def allow_domain_discovery(self) -> pulumi.Output[Optional[bool]]:
        """
        if set to true, the suffix (@domain.com) of an unknown username input on the login screen will be matched against the org domains and will redirect to the registration of that organisation on success.
        """
        return pulumi.get(self, "allow_domain_discovery")

    @property
    @pulumi.getter(name="allowExternalIdp")
    def allow_external_idp(self) -> pulumi.Output[bool]:
        """
        defines if a user is allowed to add a defined identity provider. E.g. Google auth
        """
        return pulumi.get(self, "allow_external_idp")

    @property
    @pulumi.getter(name="allowRegister")
    def allow_register(self) -> pulumi.Output[bool]:
        """
        defines if a person is allowed to register a user on this organisation
        """
        return pulumi.get(self, "allow_register")

    @property
    @pulumi.getter(name="defaultRedirectUri")
    def default_redirect_uri(self) -> pulumi.Output[str]:
        """
        defines where the user will be redirected to if the login is started without app context (e.g. from mail)
        """
        return pulumi.get(self, "default_redirect_uri")

    @property
    @pulumi.getter(name="disableLoginWithEmail")
    def disable_login_with_email(self) -> pulumi.Output[Optional[bool]]:
        """
        defines if user can additionally (to the loginname) be identified by their verified email address
        """
        return pulumi.get(self, "disable_login_with_email")

    @property
    @pulumi.getter(name="disableLoginWithPhone")
    def disable_login_with_phone(self) -> pulumi.Output[Optional[bool]]:
        """
        defines if user can additionally (to the loginname) be identified by their verified phone number
        """
        return pulumi.get(self, "disable_login_with_phone")

    @property
    @pulumi.getter(name="externalLoginCheckLifetime")
    def external_login_check_lifetime(self) -> pulumi.Output[str]:
        return pulumi.get(self, "external_login_check_lifetime")

    @property
    @pulumi.getter(name="forceMfa")
    def force_mfa(self) -> pulumi.Output[bool]:
        """
        defines if a user MUST use a multi factor to log in
        """
        return pulumi.get(self, "force_mfa")

    @property
    @pulumi.getter(name="forceMfaLocalOnly")
    def force_mfa_local_only(self) -> pulumi.Output[bool]:
        """
        if activated, ZITADEL only enforces MFA on local authentications. On authentications through MFA, ZITADEL won't prompt for MFA.
        """
        return pulumi.get(self, "force_mfa_local_only")

    @property
    @pulumi.getter(name="hidePasswordReset")
    def hide_password_reset(self) -> pulumi.Output[bool]:
        """
        defines if password reset link should be shown in the login screen
        """
        return pulumi.get(self, "hide_password_reset")

    @property
    @pulumi.getter
    def idps(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        allowed idps to login or register
        """
        return pulumi.get(self, "idps")

    @property
    @pulumi.getter(name="ignoreUnknownUsernames")
    def ignore_unknown_usernames(self) -> pulumi.Output[bool]:
        """
        defines if unknown username on login screen directly return an error or always display the password screen
        """
        return pulumi.get(self, "ignore_unknown_usernames")

    @property
    @pulumi.getter(name="mfaInitSkipLifetime")
    def mfa_init_skip_lifetime(self) -> pulumi.Output[str]:
        return pulumi.get(self, "mfa_init_skip_lifetime")

    @property
    @pulumi.getter(name="multiFactorCheckLifetime")
    def multi_factor_check_lifetime(self) -> pulumi.Output[str]:
        return pulumi.get(self, "multi_factor_check_lifetime")

    @property
    @pulumi.getter(name="multiFactors")
    def multi_factors(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        allowed multi factors
        """
        return pulumi.get(self, "multi_factors")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="passwordCheckLifetime")
    def password_check_lifetime(self) -> pulumi.Output[str]:
        return pulumi.get(self, "password_check_lifetime")

    @property
    @pulumi.getter(name="passwordlessType")
    def passwordless_type(self) -> pulumi.Output[str]:
        """
        defines if passwordless is allowed for users
        """
        return pulumi.get(self, "passwordless_type")

    @property
    @pulumi.getter(name="secondFactorCheckLifetime")
    def second_factor_check_lifetime(self) -> pulumi.Output[str]:
        return pulumi.get(self, "second_factor_check_lifetime")

    @property
    @pulumi.getter(name="secondFactors")
    def second_factors(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        allowed second factors
        """
        return pulumi.get(self, "second_factors")

    @property
    @pulumi.getter(name="userLogin")
    def user_login(self) -> pulumi.Output[bool]:
        """
        defines if a user is allowed to login with his username and password
        """
        return pulumi.get(self, "user_login")

