# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['OrgArgs', 'Org']

@pulumi.input_type
class OrgArgs:
    def __init__(__self__, *,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Org resource.
        :param pulumi.Input[bool] is_default: True sets the org as default org for the instance. Only one org can be default org. Nothing happens if you set it to false until you set another org as default org.
        :param pulumi.Input[str] name: Name of the org
        """
        OrgArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_default=is_default,
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_default: Optional[pulumi.Input[bool]] = None,
             name: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isDefault' in kwargs:
            is_default = kwargs['isDefault']

        if is_default is not None:
            _setter("is_default", is_default)
        if name is not None:
            _setter("name", name)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[bool]]:
        """
        True sets the org as default org for the instance. Only one org can be default org. Nothing happens if you set it to false until you set another org as default org.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the org
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _OrgState:
    def __init__(__self__, *,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary_domain: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Org resources.
        :param pulumi.Input[bool] is_default: True sets the org as default org for the instance. Only one org can be default org. Nothing happens if you set it to false until you set another org as default org.
        :param pulumi.Input[str] name: Name of the org
        :param pulumi.Input[str] primary_domain: Primary domain of the org
        :param pulumi.Input[str] state: State of the org
        """
        _OrgState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_default=is_default,
            name=name,
            primary_domain=primary_domain,
            state=state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_default: Optional[pulumi.Input[bool]] = None,
             name: Optional[pulumi.Input[str]] = None,
             primary_domain: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isDefault' in kwargs:
            is_default = kwargs['isDefault']
        if 'primaryDomain' in kwargs:
            primary_domain = kwargs['primaryDomain']

        if is_default is not None:
            _setter("is_default", is_default)
        if name is not None:
            _setter("name", name)
        if primary_domain is not None:
            _setter("primary_domain", primary_domain)
        if state is not None:
            _setter("state", state)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[bool]]:
        """
        True sets the org as default org for the instance. Only one org can be default org. Nothing happens if you set it to false until you set another org as default org.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the org
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="primaryDomain")
    def primary_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Primary domain of the org
        """
        return pulumi.get(self, "primary_domain")

    @primary_domain.setter
    def primary_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_domain", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the org
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


class Org(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource representing an organization in ZITADEL, which is the highest level after the instance and contains several other resource including policies if the configuration differs to the default policies on the instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.Org("default")
        ```

        ## Import

        terraform The resource can be imported using the ID format `<id>`, e.g.

        ```sh
         $ pulumi import zitadel:index/org:Org imported '123456789012345678'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_default: True sets the org as default org for the instance. Only one org can be default org. Nothing happens if you set it to false until you set another org as default org.
        :param pulumi.Input[str] name: Name of the org
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[OrgArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource representing an organization in ZITADEL, which is the highest level after the instance and contains several other resource including policies if the configuration differs to the default policies on the instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.Org("default")
        ```

        ## Import

        terraform The resource can be imported using the ID format `<id>`, e.g.

        ```sh
         $ pulumi import zitadel:index/org:Org imported '123456789012345678'
        ```

        :param str resource_name: The name of the resource.
        :param OrgArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrgArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            OrgArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrgArgs.__new__(OrgArgs)

            __props__.__dict__["is_default"] = is_default
            __props__.__dict__["name"] = name
            __props__.__dict__["primary_domain"] = None
            __props__.__dict__["state"] = None
        super(Org, __self__).__init__(
            'zitadel:index/org:Org',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            is_default: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            primary_domain: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None) -> 'Org':
        """
        Get an existing Org resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_default: True sets the org as default org for the instance. Only one org can be default org. Nothing happens if you set it to false until you set another org as default org.
        :param pulumi.Input[str] name: Name of the org
        :param pulumi.Input[str] primary_domain: Primary domain of the org
        :param pulumi.Input[str] state: State of the org
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrgState.__new__(_OrgState)

        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_domain"] = primary_domain
        __props__.__dict__["state"] = state
        return Org(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[Optional[bool]]:
        """
        True sets the org as default org for the instance. Only one org can be default org. Nothing happens if you set it to false until you set another org as default org.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the org
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryDomain")
    def primary_domain(self) -> pulumi.Output[str]:
        """
        Primary domain of the org
        """
        return pulumi.get(self, "primary_domain")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the org
        """
        return pulumi.get(self, "state")

