# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['PersonalAccessTokenArgs', 'PersonalAccessToken']

@pulumi.input_type
class PersonalAccessTokenArgs:
    def __init__(__self__, *,
                 user_id: pulumi.Input[str],
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a PersonalAccessToken resource.
        :param pulumi.Input[str] user_id: ID of the user
        :param pulumi.Input[str] expiration_date: Expiration date of the token in the RFC3339 format
        :param pulumi.Input[str] org_id: ID of the organization
        """
        PersonalAccessTokenArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            user_id=user_id,
            expiration_date=expiration_date,
            org_id=org_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             user_id: pulumi.Input[str],
             expiration_date: Optional[pulumi.Input[str]] = None,
             org_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'userId' in kwargs:
            user_id = kwargs['userId']
        if 'expirationDate' in kwargs:
            expiration_date = kwargs['expirationDate']
        if 'orgId' in kwargs:
            org_id = kwargs['orgId']

        _setter("user_id", user_id)
        if expiration_date is not None:
            _setter("expiration_date", expiration_date)
        if org_id is not None:
            _setter("org_id", org_id)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[str]:
        """
        ID of the user
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[str]]:
        """
        Expiration date of the token in the RFC3339 format
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)


@pulumi.input_type
class _PersonalAccessTokenState:
    def __init__(__self__, *,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering PersonalAccessToken resources.
        :param pulumi.Input[str] expiration_date: Expiration date of the token in the RFC3339 format
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] token: Value of the token
        :param pulumi.Input[str] user_id: ID of the user
        """
        _PersonalAccessTokenState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            expiration_date=expiration_date,
            org_id=org_id,
            token=token,
            user_id=user_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             expiration_date: Optional[pulumi.Input[str]] = None,
             org_id: Optional[pulumi.Input[str]] = None,
             token: Optional[pulumi.Input[str]] = None,
             user_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'expirationDate' in kwargs:
            expiration_date = kwargs['expirationDate']
        if 'orgId' in kwargs:
            org_id = kwargs['orgId']
        if 'userId' in kwargs:
            user_id = kwargs['userId']

        if expiration_date is not None:
            _setter("expiration_date", expiration_date)
        if org_id is not None:
            _setter("org_id", org_id)
        if token is not None:
            _setter("token", token)
        if user_id is not None:
            _setter("user_id", user_id)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[str]]:
        """
        Expiration date of the token in the RFC3339 format
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        Value of the token
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the user
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


class PersonalAccessToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource representing a personal access token of a user

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.PersonalAccessToken("default",
            org_id=data["zitadel_org"]["default"]["id"],
            user_id=data["zitadel_machine_user"]["default"]["id"],
            expiration_date="2519-04-01T08:45:00Z")
        ```

        ## Import

        terraform The resource can be imported using the ID format `<id:user_id[:org_id][:token]>`, e.g.

        ```sh
         $ pulumi import zitadel:index/personalAccessToken:PersonalAccessToken imported '123456789012345678:123456789012345678:123456789012345678:LHt79...'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] expiration_date: Expiration date of the token in the RFC3339 format
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] user_id: ID of the user
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PersonalAccessTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource representing a personal access token of a user

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.PersonalAccessToken("default",
            org_id=data["zitadel_org"]["default"]["id"],
            user_id=data["zitadel_machine_user"]["default"]["id"],
            expiration_date="2519-04-01T08:45:00Z")
        ```

        ## Import

        terraform The resource can be imported using the ID format `<id:user_id[:org_id][:token]>`, e.g.

        ```sh
         $ pulumi import zitadel:index/personalAccessToken:PersonalAccessToken imported '123456789012345678:123456789012345678:123456789012345678:LHt79...'
        ```

        :param str resource_name: The name of the resource.
        :param PersonalAccessTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PersonalAccessTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            PersonalAccessTokenArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PersonalAccessTokenArgs.__new__(PersonalAccessTokenArgs)

            __props__.__dict__["expiration_date"] = expiration_date
            __props__.__dict__["org_id"] = org_id
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["token"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(PersonalAccessToken, __self__).__init__(
            'zitadel:index/personalAccessToken:PersonalAccessToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            expiration_date: Optional[pulumi.Input[str]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            token: Optional[pulumi.Input[str]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'PersonalAccessToken':
        """
        Get an existing PersonalAccessToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] expiration_date: Expiration date of the token in the RFC3339 format
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] token: Value of the token
        :param pulumi.Input[str] user_id: ID of the user
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PersonalAccessTokenState.__new__(_PersonalAccessTokenState)

        __props__.__dict__["expiration_date"] = expiration_date
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["token"] = token
        __props__.__dict__["user_id"] = user_id
        return PersonalAccessToken(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> pulumi.Output[Optional[str]]:
        """
        Expiration date of the token in the RFC3339 format
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[str]:
        """
        Value of the token
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        ID of the user
        """
        return pulumi.get(self, "user_id")

