# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 has_project_check: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 private_labeling_setting: Optional[pulumi.Input[str]] = None,
                 project_role_assertion: Optional[pulumi.Input[bool]] = None,
                 project_role_check: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[bool] has_project_check: ZITADEL checks if the org of the user has permission to this project
        :param pulumi.Input[str] name: Name of the project
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] private_labeling_setting: Defines from where the private labeling should be triggered, supported values: PRIVATE*LABELING*SETTING*UNSPECIFIED, PRIVATE*LABELING*SETTING*ENFORCE*PROJECT*RESOURCE*OWNER*POLICY, PRIVATE*LABELING*SETTING*ALLOW*LOGIN*USER*RESOURCE*OWNER*POLICY
        :param pulumi.Input[bool] project_role_assertion: describes if roles of user should be added in token
        :param pulumi.Input[bool] project_role_check: ZITADEL checks if the user has at least one on this project
        """
        ProjectArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            has_project_check=has_project_check,
            name=name,
            org_id=org_id,
            private_labeling_setting=private_labeling_setting,
            project_role_assertion=project_role_assertion,
            project_role_check=project_role_check,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             has_project_check: Optional[pulumi.Input[bool]] = None,
             name: Optional[pulumi.Input[str]] = None,
             org_id: Optional[pulumi.Input[str]] = None,
             private_labeling_setting: Optional[pulumi.Input[str]] = None,
             project_role_assertion: Optional[pulumi.Input[bool]] = None,
             project_role_check: Optional[pulumi.Input[bool]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'hasProjectCheck' in kwargs:
            has_project_check = kwargs['hasProjectCheck']
        if 'orgId' in kwargs:
            org_id = kwargs['orgId']
        if 'privateLabelingSetting' in kwargs:
            private_labeling_setting = kwargs['privateLabelingSetting']
        if 'projectRoleAssertion' in kwargs:
            project_role_assertion = kwargs['projectRoleAssertion']
        if 'projectRoleCheck' in kwargs:
            project_role_check = kwargs['projectRoleCheck']

        if has_project_check is not None:
            _setter("has_project_check", has_project_check)
        if name is not None:
            _setter("name", name)
        if org_id is not None:
            _setter("org_id", org_id)
        if private_labeling_setting is not None:
            _setter("private_labeling_setting", private_labeling_setting)
        if project_role_assertion is not None:
            _setter("project_role_assertion", project_role_assertion)
        if project_role_check is not None:
            _setter("project_role_check", project_role_check)

    @property
    @pulumi.getter(name="hasProjectCheck")
    def has_project_check(self) -> Optional[pulumi.Input[bool]]:
        """
        ZITADEL checks if the org of the user has permission to this project
        """
        return pulumi.get(self, "has_project_check")

    @has_project_check.setter
    def has_project_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_project_check", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the project
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="privateLabelingSetting")
    def private_labeling_setting(self) -> Optional[pulumi.Input[str]]:
        """
        Defines from where the private labeling should be triggered, supported values: PRIVATE*LABELING*SETTING*UNSPECIFIED, PRIVATE*LABELING*SETTING*ENFORCE*PROJECT*RESOURCE*OWNER*POLICY, PRIVATE*LABELING*SETTING*ALLOW*LOGIN*USER*RESOURCE*OWNER*POLICY
        """
        return pulumi.get(self, "private_labeling_setting")

    @private_labeling_setting.setter
    def private_labeling_setting(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_labeling_setting", value)

    @property
    @pulumi.getter(name="projectRoleAssertion")
    def project_role_assertion(self) -> Optional[pulumi.Input[bool]]:
        """
        describes if roles of user should be added in token
        """
        return pulumi.get(self, "project_role_assertion")

    @project_role_assertion.setter
    def project_role_assertion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "project_role_assertion", value)

    @property
    @pulumi.getter(name="projectRoleCheck")
    def project_role_check(self) -> Optional[pulumi.Input[bool]]:
        """
        ZITADEL checks if the user has at least one on this project
        """
        return pulumi.get(self, "project_role_check")

    @project_role_check.setter
    def project_role_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "project_role_check", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 has_project_check: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 private_labeling_setting: Optional[pulumi.Input[str]] = None,
                 project_role_assertion: Optional[pulumi.Input[bool]] = None,
                 project_role_check: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[bool] has_project_check: ZITADEL checks if the org of the user has permission to this project
        :param pulumi.Input[str] name: Name of the project
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] private_labeling_setting: Defines from where the private labeling should be triggered, supported values: PRIVATE*LABELING*SETTING*UNSPECIFIED, PRIVATE*LABELING*SETTING*ENFORCE*PROJECT*RESOURCE*OWNER*POLICY, PRIVATE*LABELING*SETTING*ALLOW*LOGIN*USER*RESOURCE*OWNER*POLICY
        :param pulumi.Input[bool] project_role_assertion: describes if roles of user should be added in token
        :param pulumi.Input[bool] project_role_check: ZITADEL checks if the user has at least one on this project
        :param pulumi.Input[str] state: State of the project
        """
        _ProjectState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            has_project_check=has_project_check,
            name=name,
            org_id=org_id,
            private_labeling_setting=private_labeling_setting,
            project_role_assertion=project_role_assertion,
            project_role_check=project_role_check,
            state=state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             has_project_check: Optional[pulumi.Input[bool]] = None,
             name: Optional[pulumi.Input[str]] = None,
             org_id: Optional[pulumi.Input[str]] = None,
             private_labeling_setting: Optional[pulumi.Input[str]] = None,
             project_role_assertion: Optional[pulumi.Input[bool]] = None,
             project_role_check: Optional[pulumi.Input[bool]] = None,
             state: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'hasProjectCheck' in kwargs:
            has_project_check = kwargs['hasProjectCheck']
        if 'orgId' in kwargs:
            org_id = kwargs['orgId']
        if 'privateLabelingSetting' in kwargs:
            private_labeling_setting = kwargs['privateLabelingSetting']
        if 'projectRoleAssertion' in kwargs:
            project_role_assertion = kwargs['projectRoleAssertion']
        if 'projectRoleCheck' in kwargs:
            project_role_check = kwargs['projectRoleCheck']

        if has_project_check is not None:
            _setter("has_project_check", has_project_check)
        if name is not None:
            _setter("name", name)
        if org_id is not None:
            _setter("org_id", org_id)
        if private_labeling_setting is not None:
            _setter("private_labeling_setting", private_labeling_setting)
        if project_role_assertion is not None:
            _setter("project_role_assertion", project_role_assertion)
        if project_role_check is not None:
            _setter("project_role_check", project_role_check)
        if state is not None:
            _setter("state", state)

    @property
    @pulumi.getter(name="hasProjectCheck")
    def has_project_check(self) -> Optional[pulumi.Input[bool]]:
        """
        ZITADEL checks if the org of the user has permission to this project
        """
        return pulumi.get(self, "has_project_check")

    @has_project_check.setter
    def has_project_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_project_check", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the project
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="privateLabelingSetting")
    def private_labeling_setting(self) -> Optional[pulumi.Input[str]]:
        """
        Defines from where the private labeling should be triggered, supported values: PRIVATE*LABELING*SETTING*UNSPECIFIED, PRIVATE*LABELING*SETTING*ENFORCE*PROJECT*RESOURCE*OWNER*POLICY, PRIVATE*LABELING*SETTING*ALLOW*LOGIN*USER*RESOURCE*OWNER*POLICY
        """
        return pulumi.get(self, "private_labeling_setting")

    @private_labeling_setting.setter
    def private_labeling_setting(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_labeling_setting", value)

    @property
    @pulumi.getter(name="projectRoleAssertion")
    def project_role_assertion(self) -> Optional[pulumi.Input[bool]]:
        """
        describes if roles of user should be added in token
        """
        return pulumi.get(self, "project_role_assertion")

    @project_role_assertion.setter
    def project_role_assertion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "project_role_assertion", value)

    @property
    @pulumi.getter(name="projectRoleCheck")
    def project_role_check(self) -> Optional[pulumi.Input[bool]]:
        """
        ZITADEL checks if the user has at least one on this project
        """
        return pulumi.get(self, "project_role_check")

    @project_role_check.setter
    def project_role_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "project_role_check", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the project
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 has_project_check: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 private_labeling_setting: Optional[pulumi.Input[str]] = None,
                 project_role_assertion: Optional[pulumi.Input[bool]] = None,
                 project_role_check: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Resource representing the project, which can then be granted to different organizations or users directly, containing different applications.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.Project("default",
            org_id=data["zitadel_org"]["default"]["id"],
            project_role_assertion=True,
            project_role_check=True,
            has_project_check=True,
            private_labeling_setting="PRIVATE_LABELING_SETTING_ENFORCE_PROJECT_RESOURCE_OWNER_POLICY")
        ```

        ## Import

        terraform The resource can be imported using the ID format `<id[:org_id]>`, e.g.

        ```sh
         $ pulumi import zitadel:index/project:Project imported '123456789012345678:123456789012345678'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] has_project_check: ZITADEL checks if the org of the user has permission to this project
        :param pulumi.Input[str] name: Name of the project
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] private_labeling_setting: Defines from where the private labeling should be triggered, supported values: PRIVATE*LABELING*SETTING*UNSPECIFIED, PRIVATE*LABELING*SETTING*ENFORCE*PROJECT*RESOURCE*OWNER*POLICY, PRIVATE*LABELING*SETTING*ALLOW*LOGIN*USER*RESOURCE*OWNER*POLICY
        :param pulumi.Input[bool] project_role_assertion: describes if roles of user should be added in token
        :param pulumi.Input[bool] project_role_check: ZITADEL checks if the user has at least one on this project
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProjectArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource representing the project, which can then be granted to different organizations or users directly, containing different applications.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.Project("default",
            org_id=data["zitadel_org"]["default"]["id"],
            project_role_assertion=True,
            project_role_check=True,
            has_project_check=True,
            private_labeling_setting="PRIVATE_LABELING_SETTING_ENFORCE_PROJECT_RESOURCE_OWNER_POLICY")
        ```

        ## Import

        terraform The resource can be imported using the ID format `<id[:org_id]>`, e.g.

        ```sh
         $ pulumi import zitadel:index/project:Project imported '123456789012345678:123456789012345678'
        ```

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ProjectArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 has_project_check: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 private_labeling_setting: Optional[pulumi.Input[str]] = None,
                 project_role_assertion: Optional[pulumi.Input[bool]] = None,
                 project_role_check: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["has_project_check"] = has_project_check
            __props__.__dict__["name"] = name
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["private_labeling_setting"] = private_labeling_setting
            __props__.__dict__["project_role_assertion"] = project_role_assertion
            __props__.__dict__["project_role_check"] = project_role_check
            __props__.__dict__["state"] = None
        super(Project, __self__).__init__(
            'zitadel:index/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            has_project_check: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            private_labeling_setting: Optional[pulumi.Input[str]] = None,
            project_role_assertion: Optional[pulumi.Input[bool]] = None,
            project_role_check: Optional[pulumi.Input[bool]] = None,
            state: Optional[pulumi.Input[str]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] has_project_check: ZITADEL checks if the org of the user has permission to this project
        :param pulumi.Input[str] name: Name of the project
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] private_labeling_setting: Defines from where the private labeling should be triggered, supported values: PRIVATE*LABELING*SETTING*UNSPECIFIED, PRIVATE*LABELING*SETTING*ENFORCE*PROJECT*RESOURCE*OWNER*POLICY, PRIVATE*LABELING*SETTING*ALLOW*LOGIN*USER*RESOURCE*OWNER*POLICY
        :param pulumi.Input[bool] project_role_assertion: describes if roles of user should be added in token
        :param pulumi.Input[bool] project_role_check: ZITADEL checks if the user has at least one on this project
        :param pulumi.Input[str] state: State of the project
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["has_project_check"] = has_project_check
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["private_labeling_setting"] = private_labeling_setting
        __props__.__dict__["project_role_assertion"] = project_role_assertion
        __props__.__dict__["project_role_check"] = project_role_check
        __props__.__dict__["state"] = state
        return Project(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="hasProjectCheck")
    def has_project_check(self) -> pulumi.Output[Optional[bool]]:
        """
        ZITADEL checks if the org of the user has permission to this project
        """
        return pulumi.get(self, "has_project_check")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the project
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="privateLabelingSetting")
    def private_labeling_setting(self) -> pulumi.Output[Optional[str]]:
        """
        Defines from where the private labeling should be triggered, supported values: PRIVATE*LABELING*SETTING*UNSPECIFIED, PRIVATE*LABELING*SETTING*ENFORCE*PROJECT*RESOURCE*OWNER*POLICY, PRIVATE*LABELING*SETTING*ALLOW*LOGIN*USER*RESOURCE*OWNER*POLICY
        """
        return pulumi.get(self, "private_labeling_setting")

    @property
    @pulumi.getter(name="projectRoleAssertion")
    def project_role_assertion(self) -> pulumi.Output[Optional[bool]]:
        """
        describes if roles of user should be added in token
        """
        return pulumi.get(self, "project_role_assertion")

    @property
    @pulumi.getter(name="projectRoleCheck")
    def project_role_check(self) -> pulumi.Output[Optional[bool]]:
        """
        ZITADEL checks if the user has at least one on this project
        """
        return pulumi.get(self, "project_role_check")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the project
        """
        return pulumi.get(self, "state")

