# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProjectRoleArgs', 'ProjectRole']

@pulumi.input_type
class ProjectRoleArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 role_key: pulumi.Input[str],
                 group: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ProjectRole resource.
        :param pulumi.Input[str] display_name: Name used for project role
        :param pulumi.Input[str] project_id: ID of the project
        :param pulumi.Input[str] role_key: Key used for project role
        :param pulumi.Input[str] group: Group used for project role
        :param pulumi.Input[str] org_id: ID of the organization
        """
        ProjectRoleArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            project_id=project_id,
            role_key=role_key,
            group=group,
            org_id=org_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: pulumi.Input[str],
             project_id: pulumi.Input[str],
             role_key: pulumi.Input[str],
             group: Optional[pulumi.Input[str]] = None,
             org_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'projectId' in kwargs:
            project_id = kwargs['projectId']
        if 'roleKey' in kwargs:
            role_key = kwargs['roleKey']
        if 'orgId' in kwargs:
            org_id = kwargs['orgId']

        _setter("display_name", display_name)
        _setter("project_id", project_id)
        _setter("role_key", role_key)
        if group is not None:
            _setter("group", group)
        if org_id is not None:
            _setter("org_id", org_id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        Name used for project role
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        ID of the project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="roleKey")
    def role_key(self) -> pulumi.Input[str]:
        """
        Key used for project role
        """
        return pulumi.get(self, "role_key")

    @role_key.setter
    def role_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_key", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        Group used for project role
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)


@pulumi.input_type
class _ProjectRoleState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 role_key: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ProjectRole resources.
        :param pulumi.Input[str] display_name: Name used for project role
        :param pulumi.Input[str] group: Group used for project role
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] project_id: ID of the project
        :param pulumi.Input[str] role_key: Key used for project role
        """
        _ProjectRoleState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            group=group,
            org_id=org_id,
            project_id=project_id,
            role_key=role_key,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: Optional[pulumi.Input[str]] = None,
             group: Optional[pulumi.Input[str]] = None,
             org_id: Optional[pulumi.Input[str]] = None,
             project_id: Optional[pulumi.Input[str]] = None,
             role_key: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'orgId' in kwargs:
            org_id = kwargs['orgId']
        if 'projectId' in kwargs:
            project_id = kwargs['projectId']
        if 'roleKey' in kwargs:
            role_key = kwargs['roleKey']

        if display_name is not None:
            _setter("display_name", display_name)
        if group is not None:
            _setter("group", group)
        if org_id is not None:
            _setter("org_id", org_id)
        if project_id is not None:
            _setter("project_id", project_id)
        if role_key is not None:
            _setter("role_key", role_key)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name used for project role
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        Group used for project role
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="roleKey")
    def role_key(self) -> Optional[pulumi.Input[str]]:
        """
        Key used for project role
        """
        return pulumi.get(self, "role_key")

    @role_key.setter
    def role_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_key", value)


class ProjectRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 role_key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource representing the project roles, which can be given as authorizations to users.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.ProjectRole("default",
            org_id=data["zitadel_org"]["default"]["id"],
            project_id=data["zitadel_project"]["default"]["id"],
            role_key="super-user",
            display_name="display_name2",
            group="role_group")
        ```

        ## Import

        terraform The resource can be imported using the ID format `<project_id:role_key[:org_id]>`, e.g.

        ```sh
         $ pulumi import zitadel:index/projectRole:ProjectRole imported '123456789012345678:my-role-key:123456789012345678'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] display_name: Name used for project role
        :param pulumi.Input[str] group: Group used for project role
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] project_id: ID of the project
        :param pulumi.Input[str] role_key: Key used for project role
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource representing the project roles, which can be given as authorizations to users.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.ProjectRole("default",
            org_id=data["zitadel_org"]["default"]["id"],
            project_id=data["zitadel_project"]["default"]["id"],
            role_key="super-user",
            display_name="display_name2",
            group="role_group")
        ```

        ## Import

        terraform The resource can be imported using the ID format `<project_id:role_key[:org_id]>`, e.g.

        ```sh
         $ pulumi import zitadel:index/projectRole:ProjectRole imported '123456789012345678:my-role-key:123456789012345678'
        ```

        :param str resource_name: The name of the resource.
        :param ProjectRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ProjectRoleArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 role_key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectRoleArgs.__new__(ProjectRoleArgs)

            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["group"] = group
            __props__.__dict__["org_id"] = org_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if role_key is None and not opts.urn:
                raise TypeError("Missing required property 'role_key'")
            __props__.__dict__["role_key"] = role_key
        super(ProjectRole, __self__).__init__(
            'zitadel:index/projectRole:ProjectRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            group: Optional[pulumi.Input[str]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            role_key: Optional[pulumi.Input[str]] = None) -> 'ProjectRole':
        """
        Get an existing ProjectRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] display_name: Name used for project role
        :param pulumi.Input[str] group: Group used for project role
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] project_id: ID of the project
        :param pulumi.Input[str] role_key: Key used for project role
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectRoleState.__new__(_ProjectRoleState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["group"] = group
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["role_key"] = role_key
        return ProjectRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Name used for project role
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def group(self) -> pulumi.Output[Optional[str]]:
        """
        Group used for project role
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        ID of the project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="roleKey")
    def role_key(self) -> pulumi.Output[str]:
        """
        Key used for project role
        """
        return pulumi.get(self, "role_key")

