# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[str],
                 insecure: Optional[pulumi.Input[bool]] = None,
                 jwt_profile_file: Optional[pulumi.Input[str]] = None,
                 jwt_profile_json: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] domain: Domain used to connect to the ZITADEL instance
        :param pulumi.Input[bool] insecure: Use insecure connection
        :param pulumi.Input[str] jwt_profile_file: Path to the file containing credentials to connect to ZITADEL. Either 'jwt_profile_file' or 'jwt_profile_json' is
               required
        :param pulumi.Input[str] jwt_profile_json: JSON value of credentials to connect to ZITADEL. Either 'jwt_profile_file' or 'jwt_profile_json' is required
        :param pulumi.Input[str] port: Used port if not the default ports 80 or 443 are configured
        :param pulumi.Input[str] token: Path to the file containing credentials to connect to ZITADEL
        """
        ProviderArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            domain=domain,
            insecure=insecure,
            jwt_profile_file=jwt_profile_file,
            jwt_profile_json=jwt_profile_json,
            port=port,
            token=token,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             domain: pulumi.Input[str],
             insecure: Optional[pulumi.Input[bool]] = None,
             jwt_profile_file: Optional[pulumi.Input[str]] = None,
             jwt_profile_json: Optional[pulumi.Input[str]] = None,
             port: Optional[pulumi.Input[str]] = None,
             token: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'jwtProfileFile' in kwargs:
            jwt_profile_file = kwargs['jwtProfileFile']
        if 'jwtProfileJson' in kwargs:
            jwt_profile_json = kwargs['jwtProfileJson']

        _setter("domain", domain)
        if insecure is not None:
            _setter("insecure", insecure)
        if jwt_profile_file is not None:
            _setter("jwt_profile_file", jwt_profile_file)
        if jwt_profile_json is not None:
            _setter("jwt_profile_json", jwt_profile_json)
        if port is not None:
            _setter("port", port)
        if token is not None:
            _setter("token", token)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[str]:
        """
        Domain used to connect to the ZITADEL instance
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def insecure(self) -> Optional[pulumi.Input[bool]]:
        """
        Use insecure connection
        """
        return pulumi.get(self, "insecure")

    @insecure.setter
    def insecure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insecure", value)

    @property
    @pulumi.getter(name="jwtProfileFile")
    def jwt_profile_file(self) -> Optional[pulumi.Input[str]]:
        """
        Path to the file containing credentials to connect to ZITADEL. Either 'jwt_profile_file' or 'jwt_profile_json' is
        required
        """
        return pulumi.get(self, "jwt_profile_file")

    @jwt_profile_file.setter
    def jwt_profile_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jwt_profile_file", value)

    @property
    @pulumi.getter(name="jwtProfileJson")
    def jwt_profile_json(self) -> Optional[pulumi.Input[str]]:
        """
        JSON value of credentials to connect to ZITADEL. Either 'jwt_profile_file' or 'jwt_profile_json' is required
        """
        return pulumi.get(self, "jwt_profile_json")

    @jwt_profile_json.setter
    def jwt_profile_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jwt_profile_json", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        Used port if not the default ports 80 or 443 are configured
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        Path to the file containing credentials to connect to ZITADEL
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 insecure: Optional[pulumi.Input[bool]] = None,
                 jwt_profile_file: Optional[pulumi.Input[str]] = None,
                 jwt_profile_json: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the zitadel package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain: Domain used to connect to the ZITADEL instance
        :param pulumi.Input[bool] insecure: Use insecure connection
        :param pulumi.Input[str] jwt_profile_file: Path to the file containing credentials to connect to ZITADEL. Either 'jwt_profile_file' or 'jwt_profile_json' is
               required
        :param pulumi.Input[str] jwt_profile_json: JSON value of credentials to connect to ZITADEL. Either 'jwt_profile_file' or 'jwt_profile_json' is required
        :param pulumi.Input[str] port: Used port if not the default ports 80 or 443 are configured
        :param pulumi.Input[str] token: Path to the file containing credentials to connect to ZITADEL
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the zitadel package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ProviderArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 insecure: Optional[pulumi.Input[bool]] = None,
                 jwt_profile_file: Optional[pulumi.Input[str]] = None,
                 jwt_profile_json: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            __props__.__dict__["insecure"] = pulumi.Output.from_input(insecure).apply(pulumi.runtime.to_json) if insecure is not None else None
            __props__.__dict__["jwt_profile_file"] = jwt_profile_file
            __props__.__dict__["jwt_profile_json"] = jwt_profile_json
            __props__.__dict__["port"] = port
            __props__.__dict__["token"] = token
        super(Provider, __self__).__init__(
            'zitadel',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        Domain used to connect to the ZITADEL instance
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="jwtProfileFile")
    def jwt_profile_file(self) -> pulumi.Output[Optional[str]]:
        """
        Path to the file containing credentials to connect to ZITADEL. Either 'jwt_profile_file' or 'jwt_profile_json' is
        required
        """
        return pulumi.get(self, "jwt_profile_file")

    @property
    @pulumi.getter(name="jwtProfileJson")
    def jwt_profile_json(self) -> pulumi.Output[Optional[str]]:
        """
        JSON value of credentials to connect to ZITADEL. Either 'jwt_profile_file' or 'jwt_profile_json' is required
        """
        return pulumi.get(self, "jwt_profile_json")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[str]]:
        """
        Used port if not the default ports 80 or 443 are configured
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[str]]:
        """
        Path to the file containing credentials to connect to ZITADEL
        """
        return pulumi.get(self, "token")

