# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['UserGrantArgs', 'UserGrant']

@pulumi.input_type
class UserGrantArgs:
    def __init__(__self__, *,
                 user_id: pulumi.Input[str],
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_grant_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 role_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a UserGrant resource.
        :param pulumi.Input[str] user_id: ID of the user
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] project_grant_id: ID of the granted project
        :param pulumi.Input[str] project_id: ID of the project
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_keys: List of roles granted
        """
        UserGrantArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            user_id=user_id,
            org_id=org_id,
            project_grant_id=project_grant_id,
            project_id=project_id,
            role_keys=role_keys,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             user_id: pulumi.Input[str],
             org_id: Optional[pulumi.Input[str]] = None,
             project_grant_id: Optional[pulumi.Input[str]] = None,
             project_id: Optional[pulumi.Input[str]] = None,
             role_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'userId' in kwargs:
            user_id = kwargs['userId']
        if 'orgId' in kwargs:
            org_id = kwargs['orgId']
        if 'projectGrantId' in kwargs:
            project_grant_id = kwargs['projectGrantId']
        if 'projectId' in kwargs:
            project_id = kwargs['projectId']
        if 'roleKeys' in kwargs:
            role_keys = kwargs['roleKeys']

        _setter("user_id", user_id)
        if org_id is not None:
            _setter("org_id", org_id)
        if project_grant_id is not None:
            _setter("project_grant_id", project_grant_id)
        if project_id is not None:
            _setter("project_id", project_id)
        if role_keys is not None:
            _setter("role_keys", role_keys)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[str]:
        """
        ID of the user
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectGrantId")
    def project_grant_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the granted project
        """
        return pulumi.get(self, "project_grant_id")

    @project_grant_id.setter
    def project_grant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_grant_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="roleKeys")
    def role_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of roles granted
        """
        return pulumi.get(self, "role_keys")

    @role_keys.setter
    def role_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "role_keys", value)


@pulumi.input_type
class _UserGrantState:
    def __init__(__self__, *,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_grant_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 role_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering UserGrant resources.
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] project_grant_id: ID of the granted project
        :param pulumi.Input[str] project_id: ID of the project
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_keys: List of roles granted
        :param pulumi.Input[str] user_id: ID of the user
        """
        _UserGrantState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            org_id=org_id,
            project_grant_id=project_grant_id,
            project_id=project_id,
            role_keys=role_keys,
            user_id=user_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             org_id: Optional[pulumi.Input[str]] = None,
             project_grant_id: Optional[pulumi.Input[str]] = None,
             project_id: Optional[pulumi.Input[str]] = None,
             role_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             user_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'orgId' in kwargs:
            org_id = kwargs['orgId']
        if 'projectGrantId' in kwargs:
            project_grant_id = kwargs['projectGrantId']
        if 'projectId' in kwargs:
            project_id = kwargs['projectId']
        if 'roleKeys' in kwargs:
            role_keys = kwargs['roleKeys']
        if 'userId' in kwargs:
            user_id = kwargs['userId']

        if org_id is not None:
            _setter("org_id", org_id)
        if project_grant_id is not None:
            _setter("project_grant_id", project_grant_id)
        if project_id is not None:
            _setter("project_id", project_id)
        if role_keys is not None:
            _setter("role_keys", role_keys)
        if user_id is not None:
            _setter("user_id", user_id)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectGrantId")
    def project_grant_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the granted project
        """
        return pulumi.get(self, "project_grant_id")

    @project_grant_id.setter
    def project_grant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_grant_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="roleKeys")
    def role_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of roles granted
        """
        return pulumi.get(self, "role_keys")

    @role_keys.setter
    def role_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "role_keys", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the user
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


class UserGrant(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_grant_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 role_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource representing the authorization given to a user directly, including the given roles.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.UserGrant("default",
            project_id=data["zitadel_project"]["default"]["id"],
            org_id=data["zitadel_org"]["default"]["id"],
            role_keys=["super-user"],
            user_id=data["zitadel_human_user"]["default"]["id"])
        ```

        ## Import

        terraform The resource can be imported using the ID format `<flow_type:trigger_type[:org_id]>`, e.g.

        ```sh
         $ pulumi import zitadel:index/userGrant:UserGrant imported '123456789012345678:123456789012345678:123456789012345678'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] project_grant_id: ID of the granted project
        :param pulumi.Input[str] project_id: ID of the project
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_keys: List of roles granted
        :param pulumi.Input[str] user_id: ID of the user
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserGrantArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource representing the authorization given to a user directly, including the given roles.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_zitadel as zitadel

        default = zitadel.UserGrant("default",
            project_id=data["zitadel_project"]["default"]["id"],
            org_id=data["zitadel_org"]["default"]["id"],
            role_keys=["super-user"],
            user_id=data["zitadel_human_user"]["default"]["id"])
        ```

        ## Import

        terraform The resource can be imported using the ID format `<flow_type:trigger_type[:org_id]>`, e.g.

        ```sh
         $ pulumi import zitadel:index/userGrant:UserGrant imported '123456789012345678:123456789012345678:123456789012345678'
        ```

        :param str resource_name: The name of the resource.
        :param UserGrantArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserGrantArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            UserGrantArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_grant_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 role_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserGrantArgs.__new__(UserGrantArgs)

            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_grant_id"] = project_grant_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["role_keys"] = role_keys
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
        super(UserGrant, __self__).__init__(
            'zitadel:index/userGrant:UserGrant',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            project_grant_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            role_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'UserGrant':
        """
        Get an existing UserGrant resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] org_id: ID of the organization
        :param pulumi.Input[str] project_grant_id: ID of the granted project
        :param pulumi.Input[str] project_id: ID of the project
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_keys: List of roles granted
        :param pulumi.Input[str] user_id: ID of the user
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserGrantState.__new__(_UserGrantState)

        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_grant_id"] = project_grant_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["role_keys"] = role_keys
        __props__.__dict__["user_id"] = user_id
        return UserGrant(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the organization
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectGrantId")
    def project_grant_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the granted project
        """
        return pulumi.get(self, "project_grant_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="roleKeys")
    def role_keys(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of roles granted
        """
        return pulumi.get(self, "role_keys")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        ID of the user
        """
        return pulumi.get(self, "user_id")

