# GigaChat CLI

[![PyPI Version](https://img.shields.io/pypi/v/gigachat-cli.svg)](https://pypi.org/project/gigachat-cli/)
[![PyPI - License](https://img.shields.io/pypi/l/gigachat-cli)](https://github.com/thechrismoth/GigaChat-Cli/blob/master/LICENSE.md)
[![Python Version](https://img.shields.io/pypi/pyversions/gigachat-cli)](https://pypi.org/project/gigachat-cli/)

Текстовый интерфейс для работы с GigaChat AI через командную строку с поддержкой терминальных команд и работы с файлами.

![GigaChat CLI Screenshot](https://github.com/thechrismoth/GigaChat-Cli/blob/asset/gigachat_menu.jpg)

## Особенности

- **Интуитивный текстовый интерфейс** - современный TUI на базе Textual
- **Интерактивный чат** - общайтесь с GigaChat в реальном времени  
- **Автодополнение команд** - умное автодополнение по Tab с описаниями
- **Автодополнение файлов** - интеллектуальное дополнение путей для терминальных команд
- **Выбор моделей** - переключайтесь между GigaChat 2 Lite/Pro/M
- **Встроенный терминал** - выполняйте системные команды прямо из чата (префикс `!`)
- **Анализ проекта** - нейросеть автоматически анализирует структуру и содержимое вашего проекта
- **Работа с кодом** - объяснение, рефакторинг и анализ кода с учетом контекста проекта
- **История диалога** - автоматическое сохранение контекста беседы
- **Подсветка синтаксиса** - красивый вывод кода и терминальных команд

## Установка

### Установка из PyPI
```
pip install gigachat-cli
```
### Установка из исходного кода
```
git clone https://github.com/thechrismoth/GigaChat-Cli.git
cd gigachat_cli
pip install .
```
## Настройка аутентификации

### Получение API ключа

1. Перейдите на [SberAI Developer Studio](https://developers.sber.ru/studio/login)
2. Зарегистрируйтесь или войдите в аккаунт
3. Создайте новый API ключ

### Настройка переменной окружения
```
export GIGACHAT_API_KEY="ваш_api_ключ_здесь"
```
Для постоянного хранения добавьте в ваш ~/.bashrc, ~/.zshrc или ~/.profile:
```
echo 'export GIGACHAT_API_KEY="ваш_api_ключ_здесь"' >> ~/.bashrc
```
## Начало работы

### Запуск приложения
```
gigachat
```
### Основное использование

1. **Запустите приложение** - введите команду gigachat
2. **Выберите "Начать чат"** - из главного меню
3. **Введите сообщение** - пишите вопросы и нажимайте Enter для отправки
4. **Используйте терминальные команды** - начинайте команды с `!` (например: `!ls -la`)
5. **Используйте автодополнение** - начните вводить / и используйте Tab для навигации
6. *Переключайте модели** - команда `/model` для выбора между **Lite/Pro/Max**
7. **Анализируйте проект** - просто упомяните файлы в запросе, нейросеть автоматически их найдет
8. **Выход** - введите `/exit` чтобы закончить работу приложения

![GigaChat CLI Screenshot](https://github.com/thechrismoth/GigaChat-Cli/blob/asset/gigachat_work.jpg)

## Доступные команды

- **/model** - выбор модели GigaChat (Lite/Pro/Max)
- **/help** - показать справку по командам
- **/exit** - выход из приложения


## Управление интерфейсом

- **Tab** / **Shift+Tab** - навигация по автодополнению команд
- **↑** / **↓** - навигация в выпадающих списках (селекторах)
- **Enter** - подтвердить выбор / отправить сообщение
- **Escape** - отмена / возврат / закрытие справки

## Примеры использования

### Базовый чат

Просто введите ваш вопрос и нажмите Shift+Enter

### Терминальные команды

- `!pwd` - показать текущую директорию
- `!python --version` - проверить версию Python  
- `!git status` - проверить статус git репозитория

### Работа с проектом

- `Объясни что делает main.py` - автоматически найдет и проанализирует файл
- `Как улучшить код в utils.py?` - анализ и предложения по улучшению
- `Покажи структуру проекта` - анализ всей файловой структуры
- `Рефакторинг функции calculate()` - поиск и улучшение конкретной функции


### Переключение моделей
- `/model` - открывает интерактивный выбор моделей

## Требования

- Python >= 3.13
- GigaChat API ключ

## Зависимости

- textual >= 6.2.0 - фреймворк для TUI приложений
- langchain-gigachat >= 0.3.12 - интеграция с GigaChat
- asyncio >= 4.0.0 - асинхронное программирование

## Лицензия

MIT License - смотрите файл [LICENSE.md](LICENSE.md) для деталей.

## Поддержка

Если вы столкнулись с проблемами или у вас есть предложения:

1. Создайте issue в репозитории
2. Убедитесь что GIGACHAT_API_KEY корректно установлен
3. Проверьте что Python версии 3.13 или выше

---

**GigaChat CLI** - мощный инструмент для разработчиков, сочетающий возможности AI-ассистента с удобством командной строки.
