# Data Generators

The core module of `synthbiodata` provides a clean, modular architecture for generating synthetic biological data. The module is organized around a base class with specialized implementations for different types of biological data.




Generates synthetic molecular descriptor data including molecular weight, LogP, TPSA, hydrogen bond donors/acceptors, and chemical fingerprints. Creates realistic binding probabilities based on molecular properties.

::: synthbiodata.core.molecular.MolecularGenerator
    options:
      show_source: false
      show_root_heading: true
      show_root_toc_entry: true
      show_object_full_path: false
      show_category_heading: true
      show_if_no_docstring: false
      members_order: source
      filters: ["!^_"]
      show_signature: true
      show_signature_annotations: true
      show_docstring_description: true
      show_docstring_examples: true
      show_docstring_parameters: true
      show_docstring_other_parameters: true
      show_docstring_raises: true
      show_docstring_warns: true
      show_docstring_yields: true
      show_docstring_returns: true


::: synthbiodata.core.adme.ADMEGenerator


::: synthbiodata.core.base.BaseGenerator
    options:
      show_source: false
      show_root_heading: true
      show_root_toc_entry: true
      show_object_full_path: false
      show_category_heading: true
      show_if_no_docstring: false
      members_order: source
      filters: ["!^_"]
      show_signature: true
      show_signature_annotations: true
      show_docstring_description: true
      show_docstring_examples: true
      show_docstring_parameters: true
      show_docstring_other_parameters: true
      show_docstring_raises: true
      show_docstring_warns: true
      show_docstring_yields: true
      show_docstring_returns: true