"""
Generated by qenerate plugin=pydantic_v1. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    Extra,
    Field,
    Json,
)

from reconcile.gql_definitions.fragments.aws_organization import AWSOrganization
from reconcile.gql_definitions.fragments.vault_secret import VaultSecret


DEFINITION = """
fragment AWSOrganization on AWSOrganization_v1 {
  payerAccount {
    organizationAccountTags
  }
  tags
}

fragment VaultSecret on VaultSecret_v1 {
  path
  field
  version
  format
}

query AWSAccountsCloudwatchLogRetentionCleanup {
  accounts: awsaccounts_v1 {
    name
    resourcesDefaultRegion
    automationToken {
      ...VaultSecret
    }
    disable {
      integrations
    }
    organization {
      ...AWSOrganization
    }
    cleanup {
      provider
      ... on AWSAccountCleanupOptionCloudWatch_v1 {
        regex
        retention_in_days
        delete_empty_log_group
        region
      }
    }
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    class Config:
        smart_union=True
        extra=Extra.forbid


class DisableClusterAutomationsV1(ConfiguredBaseModel):
    integrations: Optional[list[str]] = Field(..., alias="integrations")


class AWSAccountCleanupOptionV1(ConfiguredBaseModel):
    provider: str = Field(..., alias="provider")


class AWSAccountCleanupOptionCloudWatchV1(AWSAccountCleanupOptionV1):
    regex: str = Field(..., alias="regex")
    retention_in_days: int = Field(..., alias="retention_in_days")
    delete_empty_log_group: Optional[bool] = Field(..., alias="delete_empty_log_group")
    region: Optional[str] = Field(..., alias="region")


class AWSAccountV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    resources_default_region: str = Field(..., alias="resourcesDefaultRegion")
    automation_token: VaultSecret = Field(..., alias="automationToken")
    disable: Optional[DisableClusterAutomationsV1] = Field(..., alias="disable")
    organization: Optional[AWSOrganization] = Field(..., alias="organization")
    cleanup: Optional[list[Union[AWSAccountCleanupOptionCloudWatchV1, AWSAccountCleanupOptionV1]]] = Field(..., alias="cleanup")


class AWSAccountsCloudwatchLogRetentionCleanupQueryData(ConfiguredBaseModel):
    accounts: Optional[list[AWSAccountV1]] = Field(..., alias="accounts")


def query(query_func: Callable, **kwargs: Any) -> AWSAccountsCloudwatchLogRetentionCleanupQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        AWSAccountsCloudwatchLogRetentionCleanupQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return AWSAccountsCloudwatchLogRetentionCleanupQueryData(**raw_data)
