"""
Generated by qenerate plugin=pydantic_v1. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    Extra,
    Field,
    Json,
)

from reconcile.gql_definitions.service_dependencies.jenkins_instance_fragment import ServiceDependenciesJenkinsInstance


DEFINITION = """
fragment ServiceDependenciesJenkinsInstance on JenkinsInstance_v1 {
  name
}

query ServiceDependencies {
  apps: apps_v1 {
    name
    dependencies {
      name
    }
    codeComponents {
      url
    }
    jenkinsConfigs {
      instance {
        ...ServiceDependenciesJenkinsInstance
      }
    }
    saasFiles {
      pipelinesProvider {
        provider
      }
      resourceTemplates {
        targets {
          upstream {
            instance {
              ...ServiceDependenciesJenkinsInstance
            }
          }
        }
      }
    }
    quayRepos {
      org {
        name
        instance {
          name
        }
      }
    }
    namespaces {
      managedExternalResources
      externalResources {
        provider
      }
    }
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    class Config:
        smart_union=True
        extra=Extra.forbid


class DependencyV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class AppCodeComponentsV1(ConfiguredBaseModel):
    url: str = Field(..., alias="url")


class JenkinsConfigV1(ConfiguredBaseModel):
    instance: ServiceDependenciesJenkinsInstance = Field(..., alias="instance")


class PipelinesProviderV1(ConfiguredBaseModel):
    provider: str = Field(..., alias="provider")


class SaasResourceTemplateTargetUpstreamV1(ConfiguredBaseModel):
    instance: ServiceDependenciesJenkinsInstance = Field(..., alias="instance")


class SaasResourceTemplateTargetV2(ConfiguredBaseModel):
    upstream: Optional[SaasResourceTemplateTargetUpstreamV1] = Field(..., alias="upstream")


class SaasResourceTemplateV2(ConfiguredBaseModel):
    targets: list[SaasResourceTemplateTargetV2] = Field(..., alias="targets")


class SaasFileV2(ConfiguredBaseModel):
    pipelines_provider: PipelinesProviderV1 = Field(..., alias="pipelinesProvider")
    resource_templates: list[SaasResourceTemplateV2] = Field(..., alias="resourceTemplates")


class QuayInstanceV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class QuayOrgV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    instance: QuayInstanceV1 = Field(..., alias="instance")


class AppQuayReposV1(ConfiguredBaseModel):
    org: QuayOrgV1 = Field(..., alias="org")


class NamespaceExternalResourceV1(ConfiguredBaseModel):
    provider: str = Field(..., alias="provider")


class NamespaceV1(ConfiguredBaseModel):
    managed_external_resources: Optional[bool] = Field(..., alias="managedExternalResources")
    external_resources: Optional[list[NamespaceExternalResourceV1]] = Field(..., alias="externalResources")


class AppV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    dependencies: Optional[list[DependencyV1]] = Field(..., alias="dependencies")
    code_components: Optional[list[AppCodeComponentsV1]] = Field(..., alias="codeComponents")
    jenkins_configs: Optional[list[JenkinsConfigV1]] = Field(..., alias="jenkinsConfigs")
    saas_files: Optional[list[SaasFileV2]] = Field(..., alias="saasFiles")
    quay_repos: Optional[list[AppQuayReposV1]] = Field(..., alias="quayRepos")
    namespaces: Optional[list[NamespaceV1]] = Field(..., alias="namespaces")


class ServiceDependenciesQueryData(ConfiguredBaseModel):
    apps: Optional[list[AppV1]] = Field(..., alias="apps")


def query(query_func: Callable, **kwargs: Any) -> ServiceDependenciesQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        ServiceDependenciesQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return ServiceDependenciesQueryData(**raw_data)
