# pylint: skip-file
# pylint: disable=line-too-long
"""Create quantized model from JSON files..."""
import os
import warnings
import mxnet as mx
from mxnet.context import cpu
from mxnet.gluon import SymbolBlock
from gluoncv.utils.compress_json import get_compressed_model

__all__ = ['mobilenet1_0_int8', 'resnet50_v1_int8',
           'ssd_300_vgg16_atrous_voc_int8', 'ssd_512_mobilenet1_0_voc_int8',
           'ssd_512_resnet50_v1_voc_int8', 'ssd_512_vgg16_atrous_voc_int8',
           'fcn_resnet101_voc_int8', 'fcn_resnet101_coco_int8',
           'psp_resnet101_voc_int8', 'psp_resnet101_coco_int8',
           'deeplab_resnet101_voc_int8', 'deeplab_resnet101_coco_int8',
           'simple_pose_resnet18_v1b_int8',
           'simple_pose_resnet50_v1b_int8', 'simple_pose_resnet50_v1d_int8',
           'simple_pose_resnet101_v1b_int8', 'simple_pose_resnet101_v1d_int8',
           'vgg16_ucf101_int8', 'inceptionv3_ucf101_int8',
           'resnet18_v1b_kinetics400_int8', 'resnet50_v1b_kinetics400_int8',
           'inceptionv3_kinetics400_int8']

_compressed_int8_json = {
    'fcn_resnet101_voc_int8': b'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',    
    'fcn_resnet101_coco_int8': b'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',
    'psp_resnet101_voc_int8': b'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',
    'deeplab_resnet101_voc_int8': b'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',
    'psp_resnet101_coco_int8': b'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',
    'deeplab_resnet101_coco_int8': b'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',
    'simple_pose_resnet18_v1b_int8': b'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',
    'simple_pose_resnet50_v1b_int8': b'eJztnU1z40aShu/+FR06jSNsBeoDVcDedmdjY09z2og92A4GuyW3taOmevXh9uyE//uCVCMrQRQAEgCFt9DJ8dgEBJWKycrCiwf5Fv753bt3V7uHm9unq39591O18e7dPw//rnY/fK72Xe1e7u+vfnhX79xtP93ud99sn7ds993u88vzoY1fDrv+/Pqjo8Y2Hx52z4937zf/+7LdPd/93+3md93ROB3Cfr59fn7c/5G61WrXp+0fmw/b+6rJx+3u4+G39bWzWfUKv7g/7m53fNyP+lopX2a2ceDDy/Pm+R+fD0dsX54frr7+6M/Yh/0p++Hd/p9fej91Rwgfb592t8+/q/f7qPyebb7c3n387bn/4242N/vObTb7BpqfcLO5f9x8erl/fv2huj7+8dNv2/o3/+LsD+/MD+989c/3x4c9PzxuP95uuv/Ol5ujv9MXommReb99/vDb7uHx04eXm93u4ddfs83H7adP2wlRutvdfe36w64a9lNCmFro3t8+zxO5/7t9fPi2Qvf4stvd7T5uPt1udxLCSSH8ffso6bt5qsbS3++r2Bxm/0gs6/PfzdGhm/e7zfbD8ybrD2LkxGivXWmrM97QiTG7zrLWCZS6sz/i+fHltvHTL3fPv+171f3D9zv6We8ZVX09o/7w7icd3prw1oa3+eGt3r914W3Vgvp6QPVffTg9hz/19PL+4+P2829B8PBv5/UbaOih2CHsi2xmQmiDSZks8vPjYVK//jw6dNxfjUuLC/Tjr1XzD/cvz3cPuzO68+uXm8jR7UFMP7q5u98+H5r6y/7b/b7929VBf7993N3eHw5q6Ro66H77j0rh7Q/621//87+jh+weNu/vtvueXP3X0VAOx7x82vx6d/98+7g/zNnOgz4+PrwcIqWih3zeHvLpL9X4NvEOP1V6+eb1o1dDWX9/dXTI8RcV16evucCkatevTx1vXYJtyRzoUEJgXeIKA7Rr1Zn7Aj37t/0f/Fv1B8d27+zpZPvH3VN3Th4a3lQt984At59fm7j9McujB/x698fXa5XqsP/Y3j/F2/n08Ol29/zy6fXEW0aPeXm63Xy8f3i/va80yvYQ6q8tnjUZnHg+zcL5dORs8a8fnu9+3558Uni8vX8Z/Bav9pqnvjDf/8ZV/4f18Q/Atn5p/P7V9vHjhs782UFDVFGqolNFxR0duz9u8/jwZfP5+TEcrvlvHC6u1f4H6uiXf7vd3rz2sWj1se7feRTlZvP54eG+ytBeGRkCvj/6KOAxCfl1yO2Pjo5hfsZtncB6zrR01mudy6/2f4u+5UrCtn64n4b2IqLKmf3wqo76vRKvjZHTecqMC04fBr0PytHXynHSVVAVg9vHJ7UQ4Nn/vx1isAvFOkRCei4RQiE+k0Mo5Gf2UAoBmoUAqf4gRglQqawusAlQEU7IJbt85ZeyDBIpzciPCe+LcC4vFqdAEem1qcRR9ZGXvNKLqRMARtTs1sVZUfdBoKxoP/IHWdHrpzo6BIwVDUk/hNwAZEcnahXwLiKwpJ5uClOqX2kypfqrFbZEPz6JLZ2FNNQiSKONmlK5AlKCNKaHUJDG5BAK0pg9lII0ZkEauj+IEaRhrp11pXHQSEMxQaSYIlKOvWc3IlTBoEbJ3ltW22IXxxodWAoMbShMtKEujza6q0pA0Ub3p1oL2lDAaEPhog2FjzZUGmhjxLQjaAMWbQx+m4I2xqEN/aZoQ+cu9XINDcM29sFMNYYocCPlGKLRjTXEEgNvwEfy5uHLbolqv3TOH68RAi72S2SMAdf6pRtBOXPMHUk5b1xN5uK2P4JRJl6aTLliiIn/WFz7whilGweeAMVHlPJphro1Q92aH8NQt8mklu+MvrSVBwDu5p1aWx1fNadMpd2rKeTrF3XLpwVgEd9JGgS6gwiUu7OTwrjr18UZN9t6EzTciYXb6Po0N+W0ooWbm8NNb3O2SMuvS11k7mKFC0yjtX72+eHp+ak6UfUWNzy9jsBBlUe/9pMOZx62U8V26thOE9tpSQeynXlkp4n+oYy0Y3OnPt5pVORIU68gUo+kxWRnR70MgPSM3TYBEJ/Nbon8pENWJz+H7kkhJEfHvR7QrqGI0NPuTCwuQ3u6KUK0foEUW0y/ALoo8Lm9v/305a6KaSUszxt7D8/P97e72w9/r/Zmm83n+5en/v7xlS/aJRVn9HlC/cpggpxbv1LGP8jIi5Qf3hUD1ymNP5MddU0dbeujbXO0bY+286Ntd7Ttj/9eqwPHPVDHXVCmOzTh0orM15csuTFv7iY63DaFv2XaeXYxMDdNkzVwGJi7pgmHEO226QpCiXHfNHk7Ud4fxOji8UXmC/AVUgxXy0wuG6aXDRPMhq2Oazx7r8ON1f17PDtRTVfBMJfBxFxmdZhLVks5WQYi5EaHvgLtGjzlMmlQrhHTjlAuWEvR4LcplqJxfMPKailnTStW8Mb0EAremBxCwRuzh1Lwxix4w/UHMVoZnhlbetP4UHB4g5WEG7YErGXXXJYtAWvZErCWLQFrWN24Wb5wvANRgaENi4k2rKyWQod8O6ulWGC0YXHRhsVHGzYNtDFi2hG0AYs2Br9NQRvj0EYubvfz5pUchm0s7Y2dEkMUuJFyDNHoxhpiiYE3lo7kPMYqfzbjcNfKFepyJRwLGKts0FFsZx7b6WI7fWxnWGOW7SwjO03MrGVtxC5lbcxYpWPGKo1trHJgWCbHxDL56ipOxFh1unxFSI4OWQjaNXguk6fBZUbMO8JlFjVWLVLcOY+bSqXiphrMCnFTsde63VRO3FTnnVIcDJJLtsDDwRC5hEOIBuRWEEoMHpd8uVHRH8Som6osy6Jsri+JVm6Us+vqnJUV5Uw650w752FFop/ynL0PSw0d3uOVG9VIFYxtOUy25VbHtsRNdbIMRMiNDn0F2jV4tOXSQFsjph1BW7AlR4PfppQcjeMbXtxUZ00rXvDG9BAK3pgcQsEbs4dS8MYseKPsD2K00sjkmbYN2YWHN9iDN3J2kypnLqucuaxcFpCGUwxvOIY3HCLe2CMqMLThMdGGFzcVHfLtuKk8MNrwuGjD46MNnwbaGDHtCNqARRuD36agjXFooxA31XnzSgHDNpb2XEyJIQrcSDmGaHRjDbHEwBtLR3IeN5XK+kMZgRz+2mqvvG98srTtVC5maHKxp0+5mPHKxYxXLqyxy3b6yE5Wb9LsUssk5XTETsXKTJo7ke1UJRiXKTC5TLG6khOxU52uXxGSo0MXgnYNHswUaYCZEfOOgBlQO9UFqzvnsVPpVOxUg1khdir2WqudSn99gP1bMjmli7T8VLrz6e8Al+77aKYaQxQol3IM0aDcGmKJAeWWjuT0oiOl+sMYNVU5ZzN7MSA3S9WRY9VFjlUXeXbV7ZnZyrM1nD1bw9mxNZwd5BrORFZhEFdTscAgrrpba0Nc1SQkiOtENYiQHB0qC7RrWIhrSBOAIK5oNwVx1S8QxDUKzegDmhn8NqX2aBznUG/POQ7/SsRYFZlYlHCOGWIonGN6DIVzzB9L4RwzcQ7dH8Yo5/DaZyW2u8ozXeSZMPLMdeXZvSxfMM5RsvdhOeXDezzOcYBVYIxDYTIOtTp71QyM4yR/1b7gLVnGoYAZh8JlHAqfcag0GMeIeUcYByzjGPw2hXGMYxz6TRlHvi9reQUdydZyaBjGsY9mqjFEYRwpxxCNcawhlhiMAz6SNw9fdksUAx5OIGkUA76GCLgUMJFBBlwImG4E5dQxdyTlxHE1GY4r2x/CKBgvXObKxrV2DIz/aK4z65VvLr9+niW3LyqNIr+CAe+Cmzf4MQx4l3yZMSnyO4NStXUIAP7mnVpbgV+udOdRcxb4pQC/+xXe8mkBWNx3kiCB7iAC9O7spCDv+nVx5M223oQUd1LiNsk+iRLPtIaKOVux2evMZcqahtRKew2VIraKSaFiO2OrrRSx1VaK8GQdtjOP7Cyjfyi2MkqRRdZQ2f9668hSYa+hojSA+IzdRwGQn81uiQClQ74dh4leXoIO3PsB7RqKDD3tTsXiQrSnmyJF6xdI9cX0S6DqK4VbT0U311PJ8NdTeS1oGUwQWU+Fvda9nop5e5/RayEO+i3UztOLgbmJurQbYUoMUW6jphxDtBupa4glxq3UpSM5g88o7w9j9HaqyX2eYa+nUjLNXDLRXDLVXDLZXIbliH8qPXsf1hk+vMe91WrAaJfBpF1mdbRL1lM5XQ0iJEeHygLtGjztMmnQrhHzjtAuWK/R4LcpXqNxnMPKeir9QWpNLFY4xwwxFM4xPYbCOeaPpXCOmTiH6w9jlHNkPvNlsxocjnOwcvGSrRurMn7tlSm+wZaOVRlbO7ZkZeUlZFn5AViBcQ6LyTmsrKkSDlnpM6u71SBCcnSoLNCuwXMOmwbnGDHvCOeA5RyD36ZwjnGcI5c1VfqD1JpYchjOsbSBdkoMUThHyjFE4xxriCUG51g6kjMZrnx/KKMPrTZF5s3F1o5dwHClstizqFUWexi1ylx0r4/uDUvS8r1lZG8Zs3IdOtZyUx32to1XscdcUx1KrUrQEI0DQzQ5JqLJV1eKIsar04UsQnJ0CETQrsEjmjwNRDNi3hFEA/r06kuWfc5jt1Kp2K0G00LsVuy1bruVE7tVf5BaJxUHg+eWLlaYEkMUPJdyDNHw3BpiiYHnlo7kDGVIRX8YI2jOXGeZV/nF1kKapQxJKX59rXi5kdJ8w/CNsHxRtZHzjbAy0esGXikSsVYw1uUwWZdbHesS29XpqhAhOTrUFmjX4FmXS4N1jZh3hHXBliMNfptSjjSOd3ixXfUHqTWxeOEdM8RQeMf0GArvmD+Wwjtm4h1lfxijtitrc63ReYfjIMPzjYJvcEuWzhji0IrzDsd5h0PkHQd4BcY6PCbr8GK9Cod8O9YrD8w6PC7r8Pisw6fBOkbMO8I6YFnH4LcprGMc6yjEetUfpNbEUsCwjqUNGlNiiMI6Uo4hGutYQywxWMfSkZzHeqWz/lB2WK9UkdnGJ0vceqWjvicde4aV0lGblo7atHRYpZfv9bG9rCLlqGdt75XWEe8Vr0I52gvtvirBKE2BSWmK1VWkiPvqdC2LkBwdGhG0a/CUpkiD0oyYd4TSoLqvLlj9OY/7SqfivhpMC3Ffsde63VeluK/6g9Q6qZQwhG7pmoUpMUQhdCnHEI3QrSGWGIRu6UhOr0bSqj+MUfeVtYUvGpIZrxpJ85ojzWuODL/yNtyXZfgy0IYtA13frMpoA68aiXArGOsqMVlXuTrWJe6r01UhQnJ0qC3QrsGzrjIN1jVi3hHWBVuRNPhtSkXSON6hMrFf9UepNbNUIRPiMUMQBXnMEERhHhcIpkCPmaCH7g9jFHpo7S26BctYTjNyvsHNWYabs0zBoUfJNyyDHsYiQo8DwQIDHiRdwIhH1S8xYdEh344Jq9aFCPnRpbdQ+wZPPZrqABd7jJl8hHvAco/hr1PAx0jwocSL1R+l9tyiYMDH0paNSUFEAR9JBxENfKwimBjgY+lQzuTHMv2hjPqxiqzwqqF6Uvdj2agXyqro3qh3y0a9Wzas4Mv35rG9rEblqGdtj5XNYn4sVpdytBfZj6U1GrJRoMhGra5KRRxZZyhahPzoUoqofcNHNioRZDNi8hFkA2rLumRZ6Dy2LJOKLWs4L8SXxV5r9WWZQ469bZmSzl1avizTPq3gVCnto5lqDFFYXcoxREN1a4glBqlbOpIzlCjZ/jBGS5SKIlPKXYrSzVOiZHkhkuWFSJY7tix3bOV8leicrxJt+SrRFnKVaMKuMMyrqVxgkFfdrbURr2oyEuJ1oipESI4OtQXaNSzcNaQNQGhXtJsCu+oXCOwaxWjMgdFIeVKjf/PxjretTjrwjsO/ErFlRSYWnOKkpa+KpsRQeMf0GArvmD+Wwjtm4h15fxijvEPZslTglqycP+s758/6zrlZK+dmrdxx3uH5hma8I9eIvOMAr8BYB1x5T92ttRmyZmAdJxmy9iM/WdYBU9zTqbRAuwbPOhAre6LdFNZRv9JnHbOXowjreD0967ddgibbP/bjADvSLe7QMLDjEM5Ug4hCO5IOIhruWEUwMXgHfihvHr7slqgQfD2LpFEi+Boj4ALBVIYZcH1gwiGU88fsoZSzxwy4XPuzUbm+9tbosvmJIqj8R31tMuvUFAdvX1SOyv8cJ+COE3DXOIwTcMeXK5PyvxM61SdKAIA479TaSv/2M81UHn5S7V8KPLxf7i2fF4B1fydpE+gOInDwzk4KBa9fF6fgbOtN4HEnOG7D7ZPA8Uxrr7C7oydKt/zaFrmyjUUTUl97JY+ue5KXsb0uuk6Li67T4sLze/heE90b/Wt5dD2VvIitvbJvoX3sfi/02is5gBCN3WUBkKLNbokYDYd8O0YUvbwcHbgxBNo1FEl62k2MxUVpTzdFltYvkOKM6ZdD1VcKt/6Kaa6/kuGvv/Ja7zKYILL8Cnute/kV8/Z2pNc7rPA3VzvPLwbm9urSroUpMUS5v5pyDNFusK4hlhh3WJeO5Ax+pKI/jPHnYlenhqzxRBo8P5Lnl9qeP/3ac6eS504lH9Y0rjZyvpGxG7A+Q74B68C4l8HkXmZ13EvWXzldFSIkR4faAu0aPPYyaWCvEfOOYC9YT9LgtymepHHAw8r6K/1Bak0sVnjHDDEU3jE9hsI75o+l8I6ZeEfZH8ZoUbky2uuGbALkHbyS3PP1Zj1fb9bz9WYLvt5swdeb9bzg3EMWnB/gFRjrsJisw8r6K+GQlT4Qu1sRIiRHh9IC7Ro867BpsI4R846wDljWMfhtCusYxzpyWX9lIEqtmSWHgR2Lm2ynBBGFdiQdRDTcsYpgYvCOxUM5jx3LZP2xjNqxjKv+t6pHYRfRx1sX0cdbFza6N4/uDcvY8r0+tpeVpRz1rG2xKnTMjsVKUY72QtuxSjBUk2Oimnx1ZSlixzpD0CJkR4dOBO0aPKvJ02A1IyYeYTWoD8G+YA3oPCYslYoJazAtxITFXus2YTkxYQ1EqXVWcTCcbunShSkxRMF0KccQjdKtIZYYkG7pSE4vSjKqP4zRoqTC2rIAL0oqeOlRwUuPSn7pXXJ7VhkWN6o2DNsoClaUVBSIRUkEXMFol8OkXW51tEtMWKerQoTk6FBboF2Dh10uDdg1Yt4R2AVbmDT4bUph0jjg4cWE1R+k1sTihXfMEEPhHdNjKLxj/lgK75iJd+j+MEZ5R1b6zA4+2WNZ3lHyB32U/EEfJbdnldyeVfIHfZQl37CMd+w38HjHAV6BsQ6PyTq8mLDCId+OCcsDsw6Pyzo8PuvwabCOEfOOsA5Y1jH4bQrrGMc6CjFhDUSpNbMUMLBjcZ/GlCCi0I6kg4iGO1YRTAzesXgoZzJhmbOhR37trLWuYZ9I3ISls5gBSmex51zpLGbY0lnMsKWzsHYv35tH9vKylKOetYxVh71tE1YRfX4W1aTU6gQN1WgwVFNgoppidWUpYsI6Q9AiZEeHTgTtGjyrKdJgNSMmHmE1oCasS9aAzmPC0qmYsAbTQkxY7LVuE1YpJqyBKLXOKiUMp1u6dGFKDFEwXcoxRKN0a4glBqRbOpIzFCXZ/jBGi5JsplXWkN5wRUk6Y6VHOvN8o+AbzJ6lFVsZWiu2MvShNUW/A7kyNAFXMNpVYtKucnW0S0xYp6tChOToUFugXYOHXWUasGvEvCOwC7YwafDblMKkccBDZeLC6o9Sa2apQibEY4YgCvKYIYjCPC4QTIEeM0GPvD+MUehhlCsvV5Q0D/RQmtMMwzcs38j5huPQw/MNzaCH0ojQ40CwwIAHSRcw4lH1S7xYdMi348WqdSFCfnTpLdS+wVOPpjrAxR5jJh/hHrDcY/jrFPAxEnwosWQNhKk9uSgY8rG4bWNSFFHQR9pRRGMf64gmBvxYPJYz2bJcfywjBMRde+sybRqfLHFblopaolQZ26ujFi4dtXDpsJov32tie1mhylHP2rYsVURsWbw45WgvtC0rR+M2CpTbqNWVqogx6xxZi5AgXWoRtW/44EYlAm5GzD4CblDdWRcsDp3HnWVScWcN54XYs9hr3fYspcWfNRCm9olFw0C7pSsaJgURhdklHUQ0ZLeKYGIQu6VDOUO5kj8b1ulrowvjfeNTwZUraV6UpHlRkubuLc3dW5otHK11yTfYwtGHDbxyJaKvaOhLg6IvvTr0JS6tM7QhQn50aS7UvuGTL50I+Rox+Qj5wi1ZGvw6pWRpJP0w4tXqj1J7bjECP+YIosCPGYIo8OMCwRT4MRP8KMbAj1znBfgCNYZdbmmj+AZ3cRnu4jKW8Q6T842MwQ+TIcKPA8lCAx8GFHwY8WqFQ74hr5ZBBh8GGHyYBMCHSQR8jJh8BHzggo/Br1PAx0jwYcWrNRCm9uRiYcjH4l6OSVFEQR9pRxGNfawjmhjwY/FYzuTVKvtjGfVqFdqpvCF9UvdqmahPyvjo3qivy0R9XTYs+sv3qtheVrBy1LO2/8q4mFeLFakc7YX2ahVo3MaCchu7uoIV8WqdI2sREqRLLaL2DR/c2ETAzYjZR8ANqlfrgkWi83i1bDJercG8EK8We63cq5WLV2sgTO0TSw4D7ZauaJgURBRml3QQ0ZDdKoKJQeyWDuX0ciWb9Ycx/jwtk2cZ+NLSlhclWV6UZLmLy3IXl+VLS1u+tLTlS0tbyKWlib6ioa8cFH3lq0Nf4tU6Qxsi5EeX5kLtGz75yhMhXyMmHyFfuCVLg1+nlCyNpB9OvFr9UWrPLU7gxxxBFPgxQxAFflwgmAI/ZoIfqj+MEfihrkunc98QT4Dwgz8y3PJHhufcxZVzF1euGe/IDYcfBYcfBSL8OJAsNPDhQMGHE69WOOQb8mo5ZPDhgMGHSwB8uETAx4jJR8AHLvgY/DoFfIwEH168WgNhak8uHoZ8LO7lmBRFFPSRdhTR2Mc6ookBPxaP5TxeLavPJiDuOsu1tY0LrtS9WnnUJ5Xn0b1RX1ce9XXlYfFfvreM7WUFK0c9a/uvchvzarEilaO9yF4tq9C4jQflNn51BSvi1TpH1iIkSJdaRO0bPrjxiYCbEbOPgBtUr9YFi0Tn8WrlyXi1BvNCvFrstVavlj3kWPamzC7fhyIpq5Ztn1cyGGS3D2eqMUQBdinHEA3XrSGWGLBu6UjOUKlk+sMYtWn53CkDbtNyvB7J8Xokxw1cjhu4HF9V2vFVpR1fVdpBripN4BWGejWlCwz0qru1NuZVTUaCvE5UhQjJ0aG2QLuGxbuGtAEI7op2U2hX/QKhXaMgjT1AmsFvU6qUxgEP9fbA4/CvRNxZkYlFCe+YIYbCO6bHUHjH/LEU3jET77D9YYzwDntdurz0pvGp8HgHf1C44w8Kd9yz5bhny2cMcXjFeYfjvMMh8o4DvAJjHQqTdajV+bJmYB0n+bL2JW7Jsg4FzDoULutQ+KxDpcE6Rsw7wjpgWcfgtymsYxzr0G+7Ek22d9q/lngkW9yhYWDHIZypBhGFdiQdRDTcsYpgYvAO/FDePHzZLVEi+HoWSaRG8DVIwBWCqYwz4ALBhEMoJ5DZQymnjxl4ObfinryKWVEUTjc/UYSV/6ivC6+zovlgxvNMvH1ROar/8xyBe47AC35YwRF4wZctk/q/EzrVp0oAiDjv1Npq//YzzVQgflLxXwpAvF/uLZ8XgIV/J2kT6A4igPDOTgoGr18Xx+Bs603ocSc5btPtk8jxTMuvsG/8VOlWKU1bibeL+TqWWH/FR9c+8Sa6N7pWi4+u1eLDA334Xh/bW8T/WnRNFa9j66/sW2gfu98Lvf6KBVCisfssAFq02S1Ro+GQb8eKopfXowO3hkC7hqJJT7uNsbgq7emm6NL6BVKeMf16qPpK4ZZgsc0lWDL8JVheK14GE0RWYGGvda/AYt7ekPT1Hiv63dXO84uBub+6tG9hSgxRbrCmHEO0O6xriCXGLdalIzmDI8mfjeqK6yzzKh+8y7qsI6ngj8Mu+OOwC+5VKrhXqQjrGlcbJd+w7A5sYZHvwOZg3Mtgci+zOu4lK7CcrgoRkqNDbYF2DR57mTSw14h5R7AXrCtp8NsUV9I44GFlBZb+ILUmFiu8Y4YYCu+YHkPhHfPHUnjHTLyj6A9jdAUW731mGxdXeLyj5KXkJV9xtuQrzpZ8xdmSrzhb8hVnS15xXkJWnB/gFRjrsJisw8oKLOGQlT4Zu1sRIiRHh9IC7Ro867BpsI4R846wDljWMfhtCusYxzpyWYFlIEqtmSWHgR2Lu2ynBBGFdiQdRDTcsYpgYvCOxUM5kx+r7I9l7DE7xbV3JitW9TzsMvqM6zL6jOuyiO4tI3tNFlay5XtVZC+vSznqWdtjVbqoHyv67GwqSqnlCRqrKcBYTY7JavLV1aWIH+sMRYuQHR1CEbRr8LAmTwPWjJh4BNaAPgj7kkWg87iwVCourMG0EBcWe63bheXEhTUQpdZZxcGAuqVrF6bEEIXTpRxDNEy3hlhiULqlIzm9KombqU5dMMlfl2WGXpZkMi6WM8M3LN/I+UZY3qja8HwjLFv0uoFXlkTIFQx3OUzc5VaHu8SGdbosREiODrkF2jV42uXSoF0j5h2hXbClSYPfppQmjSMeXmxY/UFqTSxegMcMMRTgMT2GAjzmj6UAj5mAh+oPYwx4ZNfGZKZsyC9A4FFwksEe9mFUxjcU32AP+zDKcOBRcOBRIAKPA74Cgx0eE3Z48WGFQ74dH5YHhh0eF3Z4fNjh04AdI+YdgR2wsGPw2xTYMQ52FOLDGohSa2YpYGjH4laNKUFEwR1JBxGNd6wimBjAY/FQzuPDynV/LCPUI1fXJvc2M5eiHgv4sIyKeaCMij3ryqiYZ8uomGfLqLB+L99bxvaywpSjnrW8VYe9LR8WL0Y52ovsw8oVGKspMFlNsbrCFPFhnaFoEbKjQyiCdg0e1hRpwJoRE4/AGlQf1gWrQOfxYelUfFiDaSE+LPZKzoe1T51KQbzf3NzWFy2Ri6y+S6v4b/Jbs5rfgNVshcvDhg69Pu96et+VbDo6DNfKP/18tT8hbO9/rg75589XT3cfP21/rn6yv8ZTf/4ylTnq3B3GrV3yivrfbz/E1PlRVBs5Hwvp9uZ/4sK0V41zFd4ORLf67lPdx2o7d62fxkV2951QLqr3l5XfD9QeaF5UoHUjE88b05FHO84Heqvx/bC7PQzuSYO5GsaAeC0SutnwbhW5PZT8hkIHB3WTixwIwV04bpGLs77gDZ93Ypdc/ZdanZdYA5dWfZdUw5dSXacKbsXT3IqnuRVPcyuerq14vZGOaXym7e9fOqPbp+CbnS8mnNr2wkIlItf2Qi0ZtaZErZ2n1nhxqMnmVGtK1Nr40IlaGx06UWtTIydq7Wy1dsp5J3G1ZviFveHc23AdZ9jzXIzJZ1FrndE9Wa0ZN1GtaVFrrbBOVmta1NpZas14nmhTLkBaE5gWtTY+dKLWRodO1NrUyIlaO1utnXLeSV2t8Qt7y286Wq7jLHd9WjOLWuuM7slqzdpTTm10u7a+5br5Xfd16WsZxCZyh/ZE9++1cjrztvnltctgf4zWwVZ/nT789uX5YeALtPlExWrSUKz7KtqDYAU1oLyG8iAKkc7wVdgSrUXPzdmJV02Kzhb54DKD+8TThdXNSbtdgD6QeY5PkFxyW+6rt44Vb1i3uC3+eJ57+/pHPuss9df3ibpYFfdrF5Kp2e4uoGxe6irfeRBeyfb+YcEzVNXpo0N6LaSdlWim1ZPLFaLlZrj6zDZUYcknsLJZffZdHaRmcA4/rOv26uq8ujCwLgisCwHrAsDy63+p4I8K/ajAT9VtqPqXVf3bqq4b3DtrXt/UDeq6HV23o+t2dN0ZXTeo6wZ13aCuG9R1g6buoanbMXU7pm7H1O2Yuh1T/7qtf93WHbN1xywFqW7H1u3Yuh1b98fWDeZ1O3ndTl63k1O06wbzup28biev23F1x1zdoKvbcXU7jr62umOubtDV7fi6HV+34+uO+bpBX7fj63Z83Y6vO+brBou6naJup6jbKeqOFXWDRd1gUTdY1A0WdYNl3cOybqes2ynrdkoamHU7ZRiiNEYzGqQZjdKMhmlG4zSjgZrRSM1oqGbUchj0YdSHYa8svaOWw8gPQ5/GvtLUUx3Sidqj8a8oARRlgKIUUDT0FY19Zag9E/KTWqZEUJQJilJBGeopZYWibFCUDoryQVnqKaWGopRQlBOKkkLl1FPKD5WHCYTao8xQOfWUkkRRcijKDkXpUV3o0TtqmVJFuTBLUcuULcpRnylNFOWJokRRntqjnFGUK8qHVqinBfWUEkdRwijKGEUpoyhnVBHmUWqPskWV1F5JPaUUUpQ6inJHUfKoMkzMNDNT9mjKHk3ZozOanSmPNGWPpuzRWZjp6aRDeaQpezRlj6bs0XQC0ZRHOpw5KHs0O4lQT8NpJJw+wvkjnEDCGYTySFP2aBPOStQenU805ZGm7NGUPZqyR9NJRVMeaRtOc9QeZY+mM4umPNKUPZqyR1P2aDq9aMojTdmjKXs0ZY+mc4ymPNKUPZqyR1P2aMoe7cIpmdqjnNF0stF0ttGUR5qyR1P2aMoe7cM5nlqmPNKUR5rySFMeaToDacoeTdmjiyAaqD3KI03Zoyl7NGWPpjOQpjzSlD26DCokyBDSIZRHhrLHUPYYyh5DZyFDeWQoewxlj6HsMXQWMpRHhrLHUPYYyh5DZyFDeWQoZwydcQzljKGcMZQzhmks+t0gt4LeCoKLssJQLhjKBUPnFGODaKO/ZovvSMlG3TA0A379b5eIJcnx9b/hPFy/OUu50gAcJVhpjmEhpE9cv+kRrNROj3Kt2+mTp/VvRXQqqdL6r58kT89SpaQme8Ro3U5ElZIGrf/6SWL0FOlZt0OTQZ/0pAEV06BBb9K5/VTlOUJvUnsjlGfQm0Fb0u+erDLP15bU3oCipPZi2pLpyJDOpyrKKToyohnp/Kfo/BfXkUEzhgnnVPV4vmYMU1i/UqT2opoxzH80AZ6sFM/Xh9TegCqk9kboQ+ofU4pBxZ2vBal/AwqQ2otqwaD7qC8nK8DzdR+1N6D2qL2Y7mMaj/pysto7VdlRezTuh5QdtRfVeEHPUV9OVnbn67lw+u9XcdReVM8F7UZ90UFPBD1H7TFlR30JUiTAM6bsqD0mUIKeo74ERRIkCY17rvaCuqG+0NxuaG5v6L76HY1xQ2Pc0Nxu8iCXqD0a94bGuKExbmhuNzS3Gxr3hsa9oTFuaIwbmtsNze2Gxr2hcW9o3Bsa94bGvfFB0AVFR+3RGDc0xg3N7YbmdlOE3w1ykPpCY9zQ3G5objc07g2Ne1MGLUlikuZ2S3O7pXFvadxbGuOWxrilud2qIE6pPRr3lsa4pTFuaW63NLdbGveWxr2lMW5pjFuaxy0JcEvj3tK4tzTGLY1xS3O7pbnd0ri3NO4tjXtL494y5U3tBWoc5HgAyIEgB40eRDqNe0vj3tK4tzTuLY17S+Pe0nxvab63NO4tjXtLc7ulud3SuLc0xq1X39FVGLs7kpPh5PVHoVLk0x+72+fN77ePT/s7btXBV3e7fSVDpX6z7Jc/v/vz/wH7+w2V',
    'simple_pose_resnet50_v1d_int8': b'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',
    'simple_pose_resnet101_v1b_int8': b'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',
    'simple_pose_resnet101_v1d_int8': b'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',
    'vgg16_ucf101_int8': b'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',
    'inceptionv3_ucf101_int8': b'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',
    'resnet18_v1b_kinetics400_int8': b'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',
    'resnet50_v1b_kinetics400_int8': b'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',
    'inceptionv3_kinetics400_int8': b'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'
}

def _not_impl(*args, **kwargs):
    raise NotImplementedError("Not yet implemented for quantized models")

def _create_quantized_models(name, sym_prefix):
    def func(pretrained=False, tag=None, root='~/.mxnet/models', ctx=cpu(0), **kwargs):
        r"""Quantized model.

        Parameters
        ----------
        pretrained : bool or str
            Boolean value controls whether to load the default pretrained weights for model.
            String value represents the hashtag for a certain version of pretrained weights.
        tag : str, default is None
            Optional length-8 sha1sum of parameter file. If `None`, best parameter file
            will be used.
        ctx : Context, default CPU
            The context in which to load the pretrained weights.
        root : str, default $MXNET_HOME/models
            Location for keeping the model parameters.
        """
        from ..model_zoo import get_model
        from ..model_store import get_model_file
        curr_dir = os.path.abspath(os.path.dirname(__file__))
        model_name = name.replace('mobilenet1_', 'mobilenet1.')
        model_name = model_name.replace('mobilenet0_', 'mobilenet0.')
        with warnings.catch_warnings(record=True) as w:
            warnings.simplefilter("always")
            import tempfile
            if 'fcn' in model_name or 'psp' in model_name or 'deeplab' in model_name \
               or 'simple_pose' in model_name or 'ucf' in model_name or 'kinetics' in model_name:
                model_json = get_compressed_model(model_name, _compressed_int8_json)
                fd, path = tempfile.mkstemp(dir=curr_dir, suffix='.json', text=True)
                with open(path, 'w') as f:
                    f.write(model_json)
                sym_net = SymbolBlock.imports(path, ['data'], None, ctx=ctx)
                os.close(fd)
                try:
                    os.remove(path)
                except:
                    pass
            else:
                json_file = os.path.join(curr_dir, '{}-symbol.json'.format(model_name))
                sym_net = SymbolBlock.imports(json_file, ['data'], None, ctx=ctx)
            base_name = '_'.join(model_name.split('_')[:-1])
            param_file = get_model_file(base_name, tag=tag, root=root) if pretrained else None
            kw = {}
            if 'deeplab' not in base_name:
                kw.update({'prefix': sym_prefix})
            net = get_model('_'.join(model_name.split('_')[:-1]), **kw)
            classes = getattr(net, 'classes', [])
            if param_file:
                # directly imports weights saved by save_parameters is not applicable
                # so we hack it by load and export once to a temporary params file
                net.load_params(param_file)
                net.hybridize()
                if '512' in base_name:
                    net(mx.nd.zeros((1, 3, 512, 512)))
                elif '300' in base_name:
                    net(mx.nd.zeros((1, 3, 300, 300)))
                elif 'psp' in base_name or 'deeplab' in base_name:
                    net(mx.nd.zeros((1, 3, 480, 480)))
                elif 'inceptionv3' in base_name:
                    net(mx.nd.zeros((1, 3, 299, 299)))
                else:
                    net(mx.nd.zeros((1, 3, 224, 224)))
                with tempfile.TemporaryDirectory() as tmpdirname:
                    prefix = os.path.join(tmpdirname, 'tmp')
                    net.export(prefix, epoch=0)
                    param_prefix = prefix + '-0000.params'
                    sym_net.collect_params().load(param_prefix)
        sym_net.classes = classes
        sym_net.reset_class = _not_impl
        sym_net.set_nms = _not_impl
        return sym_net
    func.__name__ = name
    globals()[name] = func

_create_quantized_models('mobilenet1_0_int8', 'mobilenet0_')
_create_quantized_models('resnet50_v1_int8', 'resnetv10_')
_create_quantized_models('ssd_300_vgg16_atrous_voc_int8', 'ssd0_')
_create_quantized_models('ssd_512_mobilenet1_0_voc_int8', 'ssd0_')
_create_quantized_models('ssd_512_resnet50_v1_voc_int8', 'ssd0_')
_create_quantized_models('ssd_512_vgg16_atrous_voc_int8', 'ssd0_')
_create_quantized_models('fcn_resnet101_voc_int8', 'fcn0_')
_create_quantized_models('fcn_resnet101_coco_int8', 'fcn0_')
_create_quantized_models('psp_resnet101_voc_int8', 'pspnet0_')
_create_quantized_models('psp_resnet101_coco_int8', 'pspnet0_')
_create_quantized_models('deeplab_resnet101_voc_int8', 'deeplabv30_')
_create_quantized_models('deeplab_resnet101_coco_int8', 'deeplabv30_')
_create_quantized_models('simple_pose_resnet18_v1b_int8', 'pose0_')
_create_quantized_models('simple_pose_resnet50_v1b_int8', 'pose0_')
_create_quantized_models('simple_pose_resnet50_v1d_int8', 'pose0_')
_create_quantized_models('simple_pose_resnet101_v1b_int8', 'pose0_')
_create_quantized_models('simple_pose_resnet101_v1d_int8', 'pose0_')
_create_quantized_models('vgg16_ucf101_int8', 'vgg0_')
_create_quantized_models('inceptionv3_ucf101_int8', 'inception30_')
_create_quantized_models('resnet18_v1b_kinetics400_int8', 'resnetv10_')
_create_quantized_models('resnet50_v1b_kinetics400_int8', 'resnetv10_')
_create_quantized_models('inceptionv3_kinetics400_int8', 'inception30_')
