# MCPBundles Desktop Proxy

**Tunnel cloud requests from MCPBundles.com to local services on your machine.**

Connect your local databases, APIs, and services to the MCPBundles platform without exposing them to the internet. The proxy runs in the background and securely forwards requests over an encrypted WebSocket tunnel.

## Features

- **Secure OAuth2 authentication**
- **Auto-reconnection** with exponential backoff
- **Encrypted token storage**
- **Dynamic port forwarding** to any localhost service
- **Local browser service** (optional) - Control a real browser on your machine from the cloud
- **Background daemon** with status monitoring
- **Comprehensive logging**
- **Fast and lightweight** (~5MB)

## Installation

### Basic Installation

```bash
pip install mcpbundles-proxy
```

### With Browser Service

```bash
pip install mcpbundles-proxy[browser]

# After installation, install Playwright browsers
playwright install chromium
```

### Full Installation (All Features)

```bash
pip install mcpbundles-proxy[all]
playwright install chromium
```

## Quick Start

### 1. Authenticate

```bash
mcpbundles-proxy login
```

This opens your browser to authenticate with MCPBundles.com. Once complete, you can close the browser.

### 2. Start the tunnel

```bash
mcpbundles-proxy start
```

The tunnel runs in the background. You can close your terminal - it keeps running.

### 3. Check status

```bash
mcpbundles-proxy status
```

Example output:
```
✅ Running (PID: 12345)
   Uptime: 2:30:15
   Tunnel: 🟢 connected
```

## Commands

| Command | Description |
|---------|-------------|
| `login` | Authenticate with MCPBundles |
| `start` | Start tunnel daemon in background |
| `stop` | Stop tunnel daemon |
| `restart` | Restart tunnel daemon |
| `status` | Show connection status |
| `logs` | View tunnel logs |
| `logs -f` | Follow logs in real-time |
| `logout` | Remove stored credentials |

## How It Works

1. You create a provider on MCPBundles.com with base URL like `localhost:5432`
2. When you run a tool from that provider, the request is sent through the tunnel
3. The desktop proxy receives it and forwards to your local service
4. The response flows back through the tunnel to the cloud

```
MCPBundles Backend (Cloud)
  ↓ WebSocket Tunnel (encrypted)
Desktop Proxy (Your Machine)
  ↓ HTTP
Local Service (localhost:XXXX)
```

## Local Browser Service

The proxy can run a local browser (Chromium) that cloud tools can control. Perfect for web scraping, testing, and automation.

**Enable from web:**
1. Go to MCPBundles.com → Settings
2. Toggle "Browser Service" on
3. Choose "Show browser window" or "Hidden mode"
4. Browser starts automatically on your machine

**Benefits:**
- 🖥️  **Visible mode**: Watch the browser in action on your screen
- 🕶️  **Hidden mode**: Run in background for pure automation
- 🌍 **Use your IP**: Browse from your location
- 🔒 **Secure**: Browser runs locally, controlled via tunnel
- 📸 **Full control**: Screenshots, PDFs, form filling, JavaScript execution

**Cloud tools can:**
- Scrape websites using your IP/location
- Test web apps on your machine
- Fill forms and submit data
- Take screenshots and PDFs
- Execute JavaScript

All controlled from MCPBundles.com web interface!

## Configuration

All configuration is stored in `~/.mcpbundles/`:
- `token.json` - Encrypted OAuth tokens
- `tunnel.pid` - Process ID of running daemon
- `tunnel.log` - Log file

## Security

- ✅ Only forwards to `localhost` - never to your network
- ✅ OAuth2 authenticated tunnel
- ✅ All traffic encrypted over WSS (WebSocket Secure)
- ✅ Tokens stored encrypted with machine-specific key
- ✅ File permissions set to user-only (0600)

## Requirements

- Python 3.8+
- macOS or Linux (Windows support coming soon)

## Troubleshooting

### Tunnel won't start

```bash
# Check if already running
mcpbundles-proxy status

# View logs for errors
mcpbundles-proxy logs

# Try re-authenticating
mcpbundles-proxy logout
mcpbundles-proxy login
mcpbundles-proxy start
```

### Can't connect to local service

Make sure your local service is running:
```bash
# Example: Check if PostgreSQL is running on port 5432
curl http://localhost:5432
# or
lsof -i :5432
```

The proxy only forwards to services that are already running locally.

### View detailed logs

```bash
# Last 100 lines
mcpbundles-proxy logs -n 100

# Follow in real-time
mcpbundles-proxy logs -f
```

## Development

### Install from source

```bash
git clone https://github.com/mcpbundles/desktop-proxy.git
cd desktop-proxy
pip install -e .
```

### Run tests

```bash
pytest
```

## Support

- 📧 Email: support@mcpbundles.com
- 💬 Discord: https://discord.gg/mcpbundles
- 📖 Docs: https://mcpbundles.com/docs

## License

MIT License - see LICENSE file for details

