# Generated by "invoke backend.generate", do not edit directly

from __future__ import annotations

from typing import Optional

from pydantic import Field

from infrahub.core.constants import BranchSupportType, HashableModelState
from infrahub.core.models import HashableModel
from infrahub.core.schema.attribute_schema import AttributeSchema  # noqa: TC001
from infrahub.core.schema.relationship_schema import RelationshipSchema  # noqa: TC001


class GeneratedBaseNodeSchema(HashableModel):
    id: Optional[str] = Field(
        default=None, description="The ID of the node", json_schema_extra={"update": "not_applicable"}
    )
    name: str = Field(
        ...,
        description="Node name, must be unique within a namespace and must start with an uppercase letter.",
        pattern="^[A-Z][a-zA-Z0-9]+$",
        min_length=2,
        max_length=32,
        json_schema_extra={"update": "migration_required"},
    )
    namespace: str = Field(
        ...,
        description="Node Namespace, Namespaces are used to organize models into logical groups and to prevent name collisions.",
        pattern="^[A-Z][a-z0-9]+$",
        min_length=3,
        max_length=32,
        json_schema_extra={"update": "migration_required"},
    )
    description: Optional[str] = Field(
        default=None,
        description="Short description of the model, will be visible in the frontend.",
        max_length=128,
        json_schema_extra={"update": "allowed"},
    )
    label: Optional[str] = Field(
        default=None,
        description="Human friendly representation of the name/kind",
        max_length=64,
        json_schema_extra={"update": "allowed"},
    )
    branch: BranchSupportType = Field(
        default=BranchSupportType.AWARE,
        description="Type of branch support for the model.",
        json_schema_extra={"update": "not_supported"},
    )
    default_filter: Optional[str] = Field(
        default=None,
        description="Default filter used to search for a node in addition to its ID. (deprecated: please use human_friendly_id instead)",
        pattern=r"^[a-z0-9\_]+$",
        json_schema_extra={"update": "allowed"},
    )
    human_friendly_id: Optional[list[str]] = Field(
        default=None,
        description="Human friendly and unique identifier for the object.",
        json_schema_extra={"update": "allowed"},
    )
    display_labels: Optional[list[str]] = Field(
        default=None,
        description="List of attributes to use to generate the display label",
        json_schema_extra={"update": "allowed"},
    )
    include_in_menu: Optional[bool] = Field(
        default=None,
        description="Defines if objects of this kind should be included in the menu.",
        json_schema_extra={"update": "allowed"},
    )
    menu_placement: Optional[str] = Field(
        default=None,
        description="Defines where in the menu this object should be placed.",
        json_schema_extra={"update": "allowed"},
    )
    icon: Optional[str] = Field(
        default=None,
        description="Defines the icon to use in the menu. Must be a valid value from the MDI library https://icon-sets.iconify.design/mdi/",
        json_schema_extra={"update": "allowed"},
    )
    order_by: Optional[list[str]] = Field(
        default=None,
        description="List of attributes to use to order the results by default",
        json_schema_extra={"update": "allowed"},
    )
    uniqueness_constraints: Optional[list[list[str]]] = Field(
        default=None,
        description="List of multi-element uniqueness constraints that can combine relationships and attributes",
        json_schema_extra={"update": "validate_constraint"},
    )
    documentation: Optional[str] = Field(
        default=None,
        description="Link to a documentation associated with this object, can be internal or external.",
        json_schema_extra={"update": "allowed"},
    )
    state: HashableModelState = Field(
        default=HashableModelState.PRESENT,
        description="Expected state of the node/generic after loading the schema",
        json_schema_extra={"update": "not_applicable"},
    )
    attributes: list[AttributeSchema] = Field(
        default_factory=list, description="Node attributes", json_schema_extra={"update": "not_applicable"}
    )
    relationships: list[RelationshipSchema] = Field(
        default_factory=list, description="Node Relationships", json_schema_extra={"update": "not_applicable"}
    )
