"""Miscellaneous constants supporting the development of sprites."""

import string

TOTAL_SPRITES: int = 0x400

UNCOMPRESSED_GFX_START = 0x280000
UNCOMPRESSED_GFX_END = 0x330000
# UNCOMPRESSED_GFX_END = 0x333720

SPRITE_PTRS_START = 0x250000
SPRITE_PTRS_END = 0x251000

IMAGE_PTRS_START = 0x251800
IMAGE_PTRS_END = 0x252000

ANIMATION_PTRS_START = 0x252000
ANIMATION_PTRS_END = 0x252C00

ANIMATION_DATA_BANK_1_START = 0x259000
ANIMATION_DATA_BANK_1_END = 0x280000

ANIMATION_DATA_BANK_2_START = 0x360000
ANIMATION_DATA_BANK_2_END = 0x370000

PALETTE_OFFSET = 0x253000

DEBUG_INDEX = 3

ALPHABET = string.ascii_lowercase + string.digits

TOTAL_IMAGES = 512
TOTAL_ANIMATIONS = 444

MAX_MOLDS_PER_SPRITE = 32
MAX_SEQUENCES_PER_SPRITE = 16
