from types import SimpleNamespace

controller_direction_table = {
    0: "LEFT",
    1: "RIGHT",
    2: "DOWN",
    3: "UP",
    4: "X",
    5: "A",
    6: "Y",
    7: "B",
}

ControllerDirections = SimpleNamespace()
for i in controller_direction_table:
    setattr(ControllerDirections, controller_direction_table[i], i)

radial_direction_table = {
    0b0: "EAST",
    0b1: "SOUTHEAST",
    0b10: "SOUTH",
    0b11: "SOUTHWEST",
    0b100: "WEST",
    0b101: "NORTHWEST",
    0b110: "NORTH",
    0b111: "NORTHEAST",
}

RadialDirections = SimpleNamespace()
for i in radial_direction_table:
    setattr(RadialDirections, radial_direction_table[i], i)

room_table = {
    0x000: "_000_DEBUG_ROOM",
    0x001: "_001_____BLUE_BG_NOTHING_THERE",
    0x002: "_002_BOWSERS_KEEP_OUTSIDE_MARIO_ENTERS_AT_BEGINNING_OF_GAME",
    0x003: "_003_BOWSERS_KEEP_1ST_TIME_AREA_01",
    0x004: "_004_BOWSERS_KEEP_1ST_TIME_AREA_02",
    0x005: "_005_MARRYMORE_OUTSIDE_DURING_BOOSTER",
    0x006: "_006_MARRYMORE_INN_2F",
    0x007: "_007_MARRYMORE_INN_1F",
    0x008: "_008_BOWSERS_KEEP_AREA_09_TALL_ROOM_WO_SAVE_POINT_THIS_TIME",
    0x009: "_009_MARRYMORE_INN_REGULAR_ROOM",
    0x00A: "_010_BOWSERS_KEEP_1ST_TIME_AREA_04_THRONE_ROOM",
    0x00B: "_011_MARRYMORE_INN_3F",
    0x00C: "_012_MARRYMORE_INN_SUITE_ROOM",
    0x00D: "_013_BARREL_VOLCANO_FALLING_INTO_VOLCANO",
    0x00E: "_014_BOOSTER_HILL",
    0x00F: "_015_VISTA_HILL",
    0x010: "_016_MARIOS_PAD",
    0x011: "_017_MUSHROOM_KINGDOM_CASTLE_MAIN_HALL",
    0x012: "_018_MUSHROOM_KINGDOM_CASTLE_THRONE_ROOM",
    0x013: "_019_MUSHROOM_KINGDOM_CASTLE_STAIR_ROOM_TO_TOADSTOOLS_ROOM",
    0x014: "_020_MUSHROOM_KINGDOM_CASTLE_TOADSTOOLS_ROOM",
    0x015: "_021_MUSHROOM_KINGDOM_CASTLE_BRANCH_ROOM_TO_VAULTGUEST_ROOM",
    0x016: "_022_MUSHROOM_KINGDOM_CASTLE_GUEST_ROOM",
    0x017: "_023_MUSHROOM_KINGDOM_BEFORE_CROCO_OUTSIDE",
    0x018: "_024_SUNKEN_SHIP_POSTKC_AREA_15_BANDANA_RED_ROOM_WLONG_STAIRWELL",
    0x019: "_025_SUNKEN_SHIP_POSTKC_AREA_16_ENTRANCE_TO_JOHNNYS_ROOM",
    0x01A: "_026_SUNKEN_SHIP_POSTKC_AREA_12_UNDERWATER_ROOM_WSTAIRWELL_AND_ZEOSTARS",
    0x01B: "_027_SUNKEN_SHIP_POSTKC_AREA_13_LARGE_UNDERWATER_ROOM_WITH_A_BLOOBER",
    0x01C: "_028_SUNKEN_SHIP_POSTKC_AREA_17_JOHNNYS_ROOM",
    0x01D: "_029_MUSHROOM_KINGDOM_CASTLE_THRONE_ROOM_TOADSTOOL_RETURNS",
    0x01E: "_030_MUSHROOM_KINGDOM_CASTLE_TOADSTOOLS_ROOM_TOADSTOOL_RETURNS",
    0x01F: "_031_MUSHROOM_KINGDOM_CASTLE_VAULT",
    0x020: "_032_MUSHROOM_KINGDOM_CASTLE_ENTRANCE_TO_TOADSTOOLS_ROOM",
    0x021: "_033_YOSTER_ISLE_ENTRANCE_FROM_PIPE_VAULT",
    0x022: "_034_YOSTER_ISLE",
    0x023: "_035_BOOSTER_TOWER_7F_3LEVEL_WPARACHUTING_SPOOKUMS",
    0x024: "_036_BOOSTER_TOWER_6F_AREA_04_3LEVEL_WTHWOMP_ON_TEETERTOTTER",
    0x025: "_037_BOOSTER_TOWER_4F_3LEVEL_ROOM_WJUMPING_SPOOKUMS",
    0x026: "_038_BOOSTER_TOWER_9F_BOOSTERS_BOMBTHROWING_ROOM_WRAIL_TRACKS",
    0x027: "_039_BOOSTER_TOWER_5F_KNIFE_GUYS_JUGGLING_ROOM",
    0x028: "_040_BOOSTER_TOWER_5F_KNIFE_GUYS_JUGGLINE_ROOM_AFTER_DEFEAT",
    0x029: "_041_BOOSTER_TOWER_8F_AREA_01_MINESWEEPER_ROOM_WCOINS_AND_HIDDEN_FIREBALLS",
    0x02A: "_042_BOOSTER_TOWER_3F_AREA_02_NES_MARIO_ROOM",
    0x02B: "_043_BOOSTER_TOWER_1F_AREA_01_MAIN_ROOM",
    0x02C: "_044_MUSHROOM_KINGDOM_BEFORE_CROCO_JUMPING_KIDS_HOUSE_1F",
    0x02D: "_045_MUSHROOM_KINGDOM_BEFORE_CROCO_JUMPING_KIDS_HOUSE_2F",
    0x02E: "_046_MUSHROOM_KINGDOM_BEFORE_CROCO_RAZ_AND_RAINIS_HOUSE",
    0x02F: "_047_MUSHROOM_KINGDOM_BEFORE_CROCO_ITEM_SHOP_TOP_FLOOR",
    0x030: "_048_BOOSTER_TOWER_8F_AREA_02_ZOOM_SHOES_ROOM",
    0x031: "_049_MUSHROOM_KINGDOM_BEFORE_CROCO_INN_1F",
    0x032: "_050_____BLUE_BG_NOTHING_THERE",
    0x033: "_051_MUSHROOM_KINGDOM_BEFORE_CROCO_RUNNING_KIDS_HOUSE",
    0x034: "_052_MUSHROOM_KINGDOM_INN_2F",
    0x035: "_053_MUSHROOM_KINGDOM_BEFORE_CROCO_ITEM_SHOP_BASEMENT",
    0x036: "_054_BOOSTER_HILL_____DUMMY",
    0x037: "_055_PIPE_VAULT_ENTRANCE",
    0x038: "_056_KERO_SEWERS_AREA_02_LONG_ROOM_WTHREE_PIPES",
    0x039: "_057_KERO_SEWERS_AREA_03_LARGE_WATER_ROOM_WPIPE_IN_CENTER",
    0x03A: "_058_KERO_SEWERS_AREA_06_LONG_WATER_ROOM_WRAT_FUNKS_IN_A_LINE",
    0x03B: "_059_KERO_SEWERS_AREA_05_SUPER_STAR_ROOM_WFOUR_RAT_FUNKS",
    0x03C: "_060_KERO_SEWERS_AREA_04_LARGE_ROOM_WPANDORITE_AND_HIDING_RAT_FUNKS",
    0x03D: "_061_NIMBUS_LAND_OUTSIDE_DURING_VALENTINA_RIGHT_BEFORE_FIGHT",
    0x03E: "_062_KERO_SEWERS_AREA_01_WATER_ROOM_WSAVE",
    0x03F: "_063_MARRYMORE_SCENE",
    0x040: "_064_MARRYMORE_OUTSIDE",
    0x041: "_065_MARRYMORE_CHAPEL_SANCTUARY",
    0x042: "_066_ROSE_WAY_EXIT_AREA_WHERE_BOWSERS_TROOPS_GATHERED",
    0x043: "_067_MIDAS_RIVER_BUSINESS_TRANSACTION_AREA",
    0x044: "_068_MIDAS_RIVER_BARREL_JUMPING_RIVER",
    0x045: "_069_MIDAS_RIVER_WATERFALL",
    0x046: "_070_MIDAS_RIVER_1ST_TUNNEL",
    0x047: "_071_MIDAS_RIVER_2ND_TUNNEL_BOTH_LEFT_AND_RIGHT",
    0x048: "_072_MIDAS_RIVER_3RD_TUNNEL_ON_LEFT",
    0x049: "_073_MIDAS_RIVER_4TH_TUNNEL_ON_VERY_BOTTOM_RIGHT",
    0x04A: "_074_TADPOLE_POND_AREA_02",
    0x04B: "_075_TADPOLE_POND_AREA_01",
    0x04C: "_076_BANDITS_WAY_AREA_01",
    0x04D: "_077_BANDITS_WAY_AREA_03",
    0x04E: "_078_BANDITS_WAY_AREA_04",
    0x04F: "_079_ROSE_WAY_MAIN_AREA",
    0x050: "_080_ROSE_WAY_TWO_FASTFLOATING_PLATFORMS",
    0x051: "_081_ROSE_WAY_TREASURE_CHESTS_WCOINS_AREA",
    0x052: "_082_ROSE_WAY_WINDING_PATH_WCROOKS",
    0x053: "_083_ROSE_TOWN_DURING_BOWYER_OUTSIDE",
    0x054: "_084_ROSE_TOWN_OUTSIDE",
    0x055: "_085_ROSE_TOWN_DURING_BOWYER_INN_1F",
    0x056: "_086_ROSE_TOWN_INN_1F",
    0x057: "_087_ROSE_TOWN_ITEM_SHOP",
    0x058: "_088_SMITHYS_FINAL_FORM_DEFEAT_GENOS_REDEMPTION",
    0x059: "_089_ROSE_TOWN_DURING_BOWYER_THREE_GRANDKIDS_HOUSE",
    0x05A: "_090_ROSE_TOWN_THREE_GRANDKIDS_HOUSE",
    0x05B: "_091_ROSE_TOWN_COUPLES_HOUSE",
    0x05C: "_092_GRATE_GUYS_CASINO_INSIDE_CASINO",
    0x05D: "_093_ROSE_TOWN_DURING_BOWYER_TREASURE_HOUSE_1F",
    0x05E: "_094_ROSE_TOWN_TREASURE_HOUSE_1F",
    0x05F: "_095_ROSE_TOWN_DURING_BOWYER_INN_2F",
    0x060: "_096_ROSE_TOWN_INN_2F",
    0x061: "_097_ROSE_TOWN_DURING_BOWYER_TREASURE_HOUSE_2F",
    0x062: "_098_ROSE_TOWN_TREASURE_HOUSE_2F",
    0x063: "_099_ROSE_TOWN_GENO_AWAKENS_IN_INN_1F",
    0x064: "_100_BOOSTER_PASS_AREA_01",
    0x065: "_101_BOOSTER_PASS_AREA_02",
    0x066: "_102_MOLEVILLE_OUTSIDE_AT_EXIT_FROM_MINES",
    0x067: "_103_SMITHY_FACTORY_AREA_17_DOMINO_AND_CLOAKERS_ROOM",
    0x068: "_104_GRATE_GUYS_CASINO_FRONT_DOOR",
    0x069: "_105_MOLEVILLE_DYNA_AND_MITES_HOUSE_____DUMMY",
    0x06A: "_106_GRATE_GUYS_CASINO_OUTSIDE",
    0x06B: "_107_NIMBUS_CASTLE_AREA_09_STATUE_ROOM_AFTER_VALENTINA",
    0x06C: "_108_MOLEVILLE_OUTSIDE",
    0x06D: "_109_NIMBUS_CASTLE_AREA_01_ENTRANCE_HALL",
    0x06E: "_110_NIMBUS_CASTLE_AREA_18_DODOS_STATUEPOLISHING_ROOM",
    0x06F: "_111_NIMBUS_CASTLE_AREA_04_LEFT_OF_4WAY_PATH_RIGHTANGLE_RED_BRICK_PATH_W_TREASURE",
    0x070: "_112_NIMBUS_CASTLE_AREA_17_RIGHT_OF_4WAY_PATH_SAVE_POINT",
    0x071: "_113_NIMBUS_CASTLE_AREA_16_SMALL_TWODOOR_ROOM_WTREASURE_FROM_AREA_15",
    0x072: "_114_NIMBUS_CASTLE_AREA_10_RED_BRICK_2LEVEL_ROOM_WTREASURE_FROM_BIRDOS_ROOM",
    0x073: "_115_NIMBUS_CASTLE_AREA_03_4WAY_PATH_DURING_VALENTINA",
    0x074: "_116_NIMBUS_CASTLE_AREA_02_LEFT_OF_AREA_01",
    0x075: "_117_NIMBUS_CASTLE_AREA_15_FRONT_OF_4WAY_PATH_LARGE_RIGHTANGLE_ROOM_W_PLANT",
    0x076: "_118_NIMBUS_CASTLE_AREA_05_LONG_5EXIT_ROOM_DURING_VALENTINA",
    0x077: "_119_NIMBUS_CASTLE_AREA_06_LEFTMOST_FRONT_DOOR_FROM_AREA_05",
    0x078: "_120_NIMBUS_CASTLE_AREA_13_THRONE_ROOM_DURING_VALENTINA",
    0x079: "_121_NIMBUS_CASTLE_PATH_AFTER_THRONE_ROOM_2ND",
    0x07A: "_122_NIMBUS_CASTLE_AREA_12_ENTRANCE_TO_THRONE_ROOM",
    0x07B: "_123_PIPE_VAULT_AREA_01",
    0x07C: "_124_PIPE_VAULT_AREA_03_LINE_OF_PIPES",
    0x07D: "_125_PIPE_VAULT_AREA_04_LINE_OF_COINS_2_HIDDEN_TREASURES",
    0x07E: "_126_PIPE_VAULT_AREA_06_LINE_OF_RED_PIPES",
    0x07F: "_127_PIPE_VAULT_AREA_02",
    0x080: "_128_PIPE_VAULT_AREA_07_LONG_PATH_WMOVING_PLATFORMS",
    0x081: "_129_PIPE_VAULT_AREA_05",
    0x082: "_130_SEA_AREA_02_LARGE_ROOM_WITH_SHOP",
    0x083: "_131_SEA_AREA_04_BUNCH_OF_ZEOSTARS",
    0x084: "_132_SEA_AREA_05_FROM_AREA_02_WSAVE_POINT",
    0x085: "_133_SEA_AREA_06_WATER_ROOM_WWHIRLPOOLS",
    0x086: "_134_SEA_AREA_03_SUPER_STAR_ROOM",
    0x087: "_135_SEA_AREA_01_ENTRANCE",
    0x088: "_136_SEA_AREA_07_SMALL_UNDERWATER_ROOM",
    0x089: "_137_LANDS_END_AREA_01",
    0x08A: "_138_LANDS_END_AREA_02",
    0x08B: "_139_LANDS_END_AREA_03_GECKITS_PLAYING_CANNONBALL",
    0x08C: "_140_LANDS_END_AREA_012_NOTHING_THERE_UNUSED",
    0x08D: "_141_LANDS_END_AREA_04_ROTATING_FLOWERS",
    0x08E: "_142_LANDS_END_AREA_05_SKY_BRIDGE",
    0x08F: "_143_PIPE_VAULT_GOOMBATHUMPING_ROOM",
    0x090: "_144_BOWSERS_KEEP_6DOOR_TREASURE_AFTER_EACH_ROOM",
    0x091: "_145_STAR_HILL_AREA_01",
    0x092: "_146_PIPE_VAULT_AREA_02____DUMMY",
    0x093: "_147_GAME_INTRO_MIDAS_RIVER_WATER_TUNNEL",
    0x094: "_148_GAME_INTRO_BANDITS_WAY_AREA_04",
    0x095: "_149_GAME_INTRO_MIDAS_RIVER_BARREL_JUMPING",
    0x096: "_150_GAME_INTRO_MOLEVILLE_OUTSIDE_DURING_BOWSERS_TROOP_SCENE",
    0x097: "_151_GAME_INTRO_BOOSTER_HILL",
    0x098: "_152_MARRYMORE_CHAPEL_MAIN_HALL",
    0x099: "_153_MARRYMORE_CHAPEL_ENTRANCE_TO_SANCTUARY",
    0x09A: "_154_MARRYMORE_CHAPEL_SANCTUARY_DURING_BOOSTER",
    0x09B: "_155_MARRYMORE_CHAPEL_KITCHEN",
    0x09C: "_156_MARRYMORE_CHAPEL_KITCHEN_NO_SPRITESEXITS_UNUSED",
    0x09D: "_157_STAR_HILL_AREA_03",
    0x09E: "_158_STAR_HILL_AREA_02",
    0x09F: "_159_STAR_HILL_AREA_04",
    0x0A0: "_160_SUNKEN_SHIP_AREA_01",
    0x0A1: "_161_SUNKEN_SHIP_AREA_03_GREAPERS",
    0x0A2: "_162_SUNKEN_SHIP_AREA_04_GREAPERS__DRY_BONES",
    0x0A3: "_163_SUNKEN_SHIP_PUZZLE_ROOM_2",
    0x0A4: "_164_SUNKEN_SHIP_AREA_02_FROM_ENTRANCE_WSAVE_POINT",
    0x0A5: "_165_SUNKEN_SHIP_AREA_06_PUZZLE_ROOM_PASSAGEWAY",
    0x0A6: "_166_SUNKEN_SHIP_PUZZLE_ROOM_1",
    0x0A7: "_167_SUNKEN_SHIP_AREA_05_LONG_STAIRWELL_WITH_RUNNING_ALLEY_RATS",
    0x0A8: "_168_SUNKEN_SHIP_PUZZLE_ROOM_3",
    0x0A9: "_169_SUNKEN_SHIP_AREA_07_PUZZLE_ROOM_PASSAGEWAY_BRANCH_ROOM_WSHAMAN",
    0x0AA: "_170_SUNKEN_SHIP_AREA_14_____DUMMY",
    0x0AB: "_171_SUNKEN_SHIP_PUZZLE_ROOM_4",
    0x0AC: "_172_SUNKEN_SHIP_PUZZLE_ROOM_5",
    0x0AD: "_173_SUNKEN_SHIP_POSTKC_AREA_01_SMALL_ROOM_WTRAMPOLINE",
    0x0AE: "_174_SEA_AREA_08_SHORE_WITH_SUNKEN_SHIP",
    0x0AF: "_175_SUNKEN_SHIP_POSTKC_AREA_05_WDRY_BONES_LINKED_BY_MARIO_MIRROR_ROOM",
    0x0B0: "_176_SUNKEN_SHIP_AREA_08_WSAVE_POINT_AND_GREEN_SWITCH_FOR_BARREL",
    0x0B1: "_177_SUNKEN_SHIP_AREA_09_PASSWORD_ROOM",
    0x0B2: "_178_SUNKEN_SHIP_POSTKC_AREA_04_LONG_STAIRWELL_WRUNNING_ALLEY_RATS",
    0x0B3: "_179_SUNKEN_SHIP_POSTKC_AREA_06_MARIO_MIRROR_ROOM",
    0x0B4: "_180_SUNKEN_SHIP_POSTKC_AREA_02_SMALL_2LEVEL_ROOM",
    0x0B5: "_181_SUNKEN_SHIP_POSTKC_AREA_03_ALLEY_RATS_ON_CANNONS",
    0x0B6: "_182_SUNKEN_SHIP_POSTKC_AREA_07_THREE_DRY_BONES",
    0x0B7: "_183_SUNKEN_SHIP_POSTKC_AREA_08_SECRET_ROOM_WITH_FROG_COIN",
    0x0B8: "_184_SUNKEN_SHIP_POSTKC_AREA_09_HIDONS_ROOM_WSAVE_POINT",
    0x0B9: "_185_SUNKEN_SHIP_POSTKC_AREA_14_SECRET_SAFETY_RING",
    0x0BA: "_186_SUNKEN_SHIP_POSTKC_AREA_18_WARP_ROOM_FROM_JOHNNYS_ROOM",
    0x0BB: "_187_SUNKEN_SHIP_POSTKC_AREA_10_WATER_ROOM_WITH_FROG_COINS",
    0x0BC: "_188_SUNKEN_SHIP_POSTKC_AREA_11_WATER_ROOM_WITH_WHIRLPOOL",
    0x0BD: "_189_MARIOS_PIPEHOUSE",
    0x0BE: "_190_MUSHROOM_KINGDOM_DURING_MACK_OUTSIDE",
    0x0BF: "_191_MUSHROOM_KINGDOM_OUTSIDE",
    0x0C0: "_192_BOOSTER_TOWER_9F_AREA_02_BOOSTERS_CURTAIN_GAME_ROOM",
    0x0C1: "_193_BOOSTER_TOWER_2F_AREA_03_STEPS_WCIRCLING_BOBOMBS",
    0x0C2: "_194_BOOSTER_TOWER_2F_AREA_02_BOOSTERS_RAILWAY_ROOM",
    0x0C3: "_195_BOOSTER_TOWER_6F_AREA_02_BOOSTERS_ANCESTOR_GAME_ROOM",
    0x0C4: "_196_BOOSTER_TOWER_2F_AREA_01_WCONSTANTLY_APPEARING_SPOOKUMS",
    0x0C5: "_197_BOOSTER_TOWER_1F_AREA_02_HIGH_MASHER_ROOM_WTEETERTOTTER",
    0x0C6: "_198_BOOSTER_TOWER_8F_AREA_03_3LEVEL_WONE_CHOMP",
    0x0C7: "_199_BOOSTER_TOWER_9F_AREA_01_THREE_YELLOW_PLATFORMS_WSAVE_POINT",
    0x0C8: "_200_BOOSTER_TOWER_6F_AREA_03_ELDERS_ROOM_WCHOMP",
    0x0C9: "_201_BOOSTER_TOWER_6F_AREA_01_SMALL_ROOM_WSAVE_POINT",
    0x0CA: "_202_BOOSTER_TOWER_ENTRANCE",
    0x0CB: "_203_MUSHROOM_WAY_AREA_01",
    0x0CC: "_204_MUSHROOM_WAY_AREA_02",
    0x0CD: "_205_MUSHROOM_WAY_AREA_03",
    0x0CE: "_206_BANDITS_WAY_AREA_05",
    0x0CF: "_207_BANDITS_WAY_AREA_02",
    0x0D0: "_208_SEASIDE_TOWN_DURING_YARIDOVICH_OUTSIDE",
    0x0D1: "_209_SEASIDE_TOWN_DURING_YARIDOVICH_INN_1F",
    0x0D2: "_210_SEASIDE_TOWN_DURING_YARIDOVICH_INN_2F",
    0x0D3: "_211_SEASIDE_TOWN_DURING_YARIDOVICH_ELDERS_HOUSE_1F",
    0x0D4: "_212_SEASIDE_TOWN_DURING_YARIDOVICH_ELDERS_HOUSE_2F",
    0x0D5: "_213_SEASIDE_TOWN_DURING_YARIDOVICH_BEETLES_ARE_USBOMB_SHOP",
    0x0D6: "_214_SEASIDE_TOWN_DURING_YARIDOVICH_WEAPONS_AND_ARMOR_SHOP",
    0x0D7: "_215_SEASIDE_TOWN_DURING_YARIDOVICH_HEALTH_FOOD_STORE_LEFTMOST",
    0x0D8: "_216_SEASIDE_TOWN_DURING_YARIDOVICH_MUSHROOM_BOY_SHOP_MIDDLE",
    0x0D9: "_217_SEASIDE_TOWN_DURING_YARIDOVICH_ACCESSORY_SHOP_RIGHTMOST",
    0x0DA: "_218_SEASIDE_TOWN_DURING_YARIDOVICH_SHED_UNUSED_BC_INACCESSIBLE",
    0x0DB: "_219_GAME_INTRO_SEA_SHORE_WITH_SUNKEN_SHIP",
    0x0DC: "_220_SMITHY_FACTORY_AREA_02_WSAVE_POINT",
    0x0DD: "_221_SMITHY_FACTORY_AREA_04_GREEN_SWITCH_WAMEBOIDS",
    0x0DE: "_222_SMITHY_FACTORY_AREA_03_GLUM_REAPERS",
    0x0DF: "_223_SMITHY_FACTORY_AREA_07_COUNT_DOWNS_ROOM",
    0x0E0: "_224_FOREST_MAZE_AREA_01",
    0x0E1: "_225_FOREST_MAZE_AREA_05_TREE_TRUNK_AREA",
    0x0E2: "_226_FOREST_MAZE_AREA_02",
    0x0E3: "_227_FOREST_MAZE_AREA_09_LEADS_TO_4PATH_MAZE",
    0x0E4: "_228_FOREST_MAZE_AREA_04",
    0x0E5: "_229_FOREST_MAZE_AREA_06",
    0x0E6: "_230_FOREST_MAZE_4WAY_PATH_FROM_AREA_09",
    0x0E7: "_231_FOREST_MAZE_SECRET_ENTRANCE",
    0x0E8: "_232_FOREST_MAZE_BOWYERS_PRACTICE_PAD",
    0x0E9: "_233_FOREST_MAZE_AREA_03_UNDERGROUND",
    0x0EA: "_234_FOREST_MAZE_SECRET",
    0x0EB: "_235_FOREST_MAZE_AREA_08_UNDERGROUND",
    0x0EC: "_236_FOREST_MAZE_AREA_07_UNDERGROUND_WSLEEPING_WIGGLER",
    0x0ED: "_237_SMITHY_FACTORY_AREA_05_WSAVE_POINT",
    0x0EE: "_238_SMITHY_FACTORY_FALL_FROM_LUGNUT_ROOMS_AREA_06__PRIOR",
    0x0EF: "_239_SMITHY_FACTORY_AREA_06_ULTRA_HAMMER",
    0x0F0: "_240_VOLCANO_AREA_21_____DUMMY",
    0x0F1: "_241_VOLCANO_AREA_02_____DUMMY",
    0x0F2: "_242_FOREST_MAZE_ALL_TREE_TRUNK_UNDERGROUND_AREAS",
    0x0F3: "_243_GAME_INTRO_MUSHROOM_KINGDOM_CASTLE_THRONE_ROOM",
    0x0F4: "_244_GAME_INTRO_YOSTER_ISLE_TALK_TO_YOSHI__RUN_AROUND",
    0x0F5: "_245_GAME_INTRO_PIPE_VAULT_AREA_02_WTHWOMP",
    0x0F6: "_246_GAME_INTRO_KERO_SEWERS_ENTRANCE",
    0x0F7: "_247_GAME_INTRO_TADPOLE_POND_MARIO_SUMMONS_TADPOLES",
    0x0F8: "_248_GAME_INTRO_MUSHROOM_WAY_AREA_01",
    0x0F9: "_249_GAME_INTRO_VISTA_HILL",
    0x0FA: "_250_GAME_INTRO_BOOSTER_TOWER_BALCONY_WITH_TOADSTOOL_CRYING",
    0x0FB: "_251_BEAN_VALLEY_PIRANHA_PIPE_AREA",
    0x0FC: "_252_BEAN_VALLEY_MAIN_AREA",
    0x0FD: "_253_BEAN_VALLEY_MAGIC_BRICK_TO_BEANSTALK_AREA",
    0x0FE: "_254_BEAN_VALLEY_SMILAX_AREA",
    0x0FF: "_255_MONSTRO_TOWN_JINXS_DOJO",
    0x100: "_256_FOREST_MAZE_SMALL_AREA_WTREE_TRUNK_UNUSED",
    0x101: "_257_GAME_INTRO_FOREST_MAZE_FIGHTING_MAGIKOOPA_AT_BOWYERS_PAD",
    0x102: "_258_BOOSTER_TOWER_BALCONY_AT_TOP_FLOOR",
    0x103: "_259_BOOSTER_TOWER_3F_AREA_01_GREEN_SWITCH_FOR_BP_SECRET",
    0x104: "_260_GAME_INTRO_FOREST_MAZE_JUMPING_ON_WIGGLER",
    0x105: "_261_BOWSERS_KEEP_1ST_TIME_AREA_03_LAVA_ROOM_WBRIDGE",
    0x106: "_262_LANDS_END_UNDERGROUND_AREA_04_BUY_SUPER_STARS",
    0x107: "_263_LANDS_END_UNDERGROUND_AREA_01",
    0x108: "_264_LANDS_END_UNDERGROUND_AREA_02",
    0x109: "_265_LANDS_END_UNDERGROUND_AREA_03",
    0x10A: "_266_BOWSERS_KEEP_AREA_10_MAGIKOOPAS_ROOM",
    0x10B: "_267_MONSTRO_TOWN_ENTRANCE",
    0x10C: "_268_BELOME_TEMPLE_AREA_08_BELOMES_ROOM",
    0x10D: "_269_ENDING_CREDITS_NIMBUS_LAND_PRINCE_MALLOW",
    0x10E: "_270_LANDS_END_SECRET_UNDERGROUND_AREA_01_LEADS_TO_KERO_SEWERS",
    0x10F: "_271_MOLEVILLE_MINES_AREA_17_PUNCHINELLOS_ROOM_AFTER_BATTLE",
    0x110: "_272_MOLEVILLE_MINES_AREA_11_BOMBED_ROOM_WSINGING_MOLES",
    0x111: "_273_MOLEVILLE_MINES_AREA_04_WTRAMPOLINE",
    0x112: "_274_MOLEVILLE_MINES_AREA_02",
    0x113: "_275_MOLEVILLE_MINES_AREA_06_SMALL_ROOM_LEADING_TO_AREA_06",
    0x114: "_276_MOLEVILLE_MINES_AREA_01_ENTRANCE",
    0x115: "_277_MOLEVILLE_MINES_AREA_05_LEFT_OF_TRAMPOLINE_ROOM",
    0x116: "_278_MOLEVILLE_MINES_AREA_03_LEADS_BACK_TO_AREA_1",
    0x117: "_279_MOLEVILLE_MINES_AREA_08_CROCOS_BOMBED_ROOM",
    0x118: "_280_MOLEVILLE_MINES_AREA_15_2LEVEL_ROOM_WSPARKY_AND_10COIN_TC",
    0x119: "_281_MOLEVILLE_MINES_AREA_07_FROM_CROCOS_BOMBED_ROOM",
    0x11A: "_282_MOLEVILLE_MINES_AREA_10_SMALL_ROOM_WMINECART_TRACKS",
    0x11B: "_283_MOLEVILLE_MINES_AREA_09_LEADS_LEFT_TO_CROCOS_BOMBED_ROOM",
    0x11C: "_284_MOLEVILLE_MINES_AREA_18_MINECART_ROOM",
    0x11D: "_285_MOLEVILLE_MINES_AREA_13_LONG_MINECART_TRACKS_ROOM",
    0x11E: "_286_MOLEVILLE_MINES_AREA_12_2LEVEL_ROOM_LEADS_TO_LONG_MINECART_TRACKS_ROOM",
    0x11F: "_287_MOLEVILLE_MINES_AREA_14_2LEVEL_ROOM_FROM_LONG_MINECART_TRACKS_ROOM",
    0x120: "_288_MOLEVILLE_MINES_AREA_16_LARGE_SAVEPOINT_ROOM_WFOUR_BOBOMBS",
    0x121: "_289_MOLEVILLE_MINES_AREA_17_PUNCHINELLOS_ROOM_BEFORE_BATTLE",
    0x122: "_290_MOLEVILLE_MINES_AREA_19_FROM_OUTSIDE_AFTER_PAYING",
    0x123: "_291_GAME_INTRO_BOOSTER_TOWER_7F_PARACHUTING_SPOOKUMS",
    0x124: "_292_____UNMAPPED_HOUSE_ROOM",
    0x125: "_293_____UNMAPPED_HOUSE_ROOM",
    0x126: "_294_____UNMAPPED_HOUSE_ROOM",
    0x127: "_295_____UNMAPPED_HOUSE_ROOM",
    0x128: "_296_____UNMAPPED_HOUSE_ROOM",
    0x129: "_297_____UNMAPPED_OUTSIDE_TOWNPLACE_RESEMBLES_SEASIDE_TOWN",
    0x12A: "_298_____UNMAPPED_HOUSE_ROOM",
    0x12B: "_299_____UNMAPPED_HOUSE_ROOM",
    0x12C: "_300_____UNMAPPED_HOUSE_ROOM",
    0x12D: "_301_KERO_SEWERS_AREA_07_WATER_SWITCH_ROOM_WBOOS",
    0x12E: "_302_KERO_SEWERS_AREA_08_BELOMES_ROOM",
    0x12F: "_303_KERO_SEWERS_AREA_08_BELOMES_ROOM_AFTER_DEFEAT",
    0x130: "_304_SEASIDE_TOWN_OUTSIDE",
    0x131: "_305_SEASIDE_TOWN_INN_1F",
    0x132: "_306_SEASIDE_TOWN_INN_2F",
    0x133: "_307_SEASIDE_TOWN_ELDERS_HOUSE_1F",
    0x134: "_308_SEASIDE_TOWN_ELDERS_HOUSE_2F",
    0x135: "_309_SEASIDE_TOWN_BEETLES_ARE_US",
    0x136: "_310_SEASIDE_TOWN_WEAPON_AND_ARMOR_SHOP",
    0x137: "_311_SEASIDE_TOWN_HEALTH_FOOD_STORE",
    0x138: "_312_SEASIDE_TOWN_MUSHROOM_BOYS_SHOP",
    0x139: "_313_SEASIDE_TOWN_ACCESSORY_SHOP",
    0x13A: "_314_SEASIDE_TOWN_SHED",
    0x13B: "_315_SEASIDE_TOWN_DURING_YARIDOVICH_BEACH",
    0x13C: "_316_SEASIDE_TOWN_BEACH",
    0x13D: "_317_LANDS_END_DESERT_AREA_01",
    0x13E: "_318_LANDS_END_DESERT_AREA_02",
    0x13F: "_319_LANDS_END_DESERT_AREA_06",
    0x140: "_320_MUSHROOM_KINGDOM_CASTLE_ENTRANCE_TO_THRONE_ROOM",
    0x141: "_321_BOWSERS_KEEP_6DOOR_ACTION_ROOM_2A_SLOW_ELEVATING_PLATFORMS",
    0x142: "_322_BOWSERS_KEEP_6DOOR_ACTION_ROOM_1A_JUMPING_TERRAPIN",
    0x143: "_323_MUSHROOM_KINGDOM_CASTLE_DURING_MACK_ENTRANCE_TO_THRONE_ROOM",
    0x144: "_324_MONSTRO_TOWN_OUTSIDE",
    0x145: "_325_MUSHROOM_KINGDOM_CASTLE_DURING_MACK_MAIN_HALL",
    0x146: "_326_MUSHROOM_KINGDOM_CASTLE_DURING_MACK_THRONE_ROOM",
    0x147: "_327_MUSHROOM_KINGDOM_CASTLE_DURING_MACK_STAIRWELL_TO_TOADSTOOLS_ROOM",
    0x148: "_328_MUSHROOM_KINGDOM_CASTLE_DURING_MACK_TOADSTOOLS_ROOM",
    0x149: "_329_MUSHROOM_KINGDOM_CASTLE_DURING_MACK_BRANCH_ROOM_TO_VAULTGUEST_ROOM",
    0x14A: "_330_MUSHROOM_KINGDOM_CASTLE_DURING_MACK_GUEST_ROOM",
    0x14B: "_331_MUSHROOM_KINGDOM_CASTLE_DURING_MACK_VAULT",
    0x14C: "_332_MUSHROOM_KINGDOM_CASTLE_DURING_MACK_ENTRANCE_TO_TOADSTOOLS_ROOM",
    0x14D: "_333_KERO_SEWERS_ENTRANCE",
    0x14E: "_334_BEAN_VALLEY_PIPE_ROOM_LEFTMOST_PIPE",
    0x14F: "_335_BEAN_VALLEY_PIPE_ROOM_RIGHTMOST_PIPE_LARGE_ROOM",
    0x150: "_336_MOLEVILLE_ITEM_SHOP",
    0x151: "_337_MOLEVILLE_INN",
    0x152: "_338_MOLEVILLE_DYNA_AND_MITES_HOUSE",
    0x153: "_339_MOLEVILLE_FIREWORKS_SHOP",
    0x154: "_340_MOLEVILLE_SPECIAL_ITEMTRADING_SHOP",
    0x155: "_341_NIMBUS_LAND_GARROS_HOUSE",
    0x156: "_342_NIMBUS_LAND_LOWER_HOUSE",
    0x157: "_343_NIMBUS_LAND_INN",
    0x158: "_344_NIMBUS_LAND_ITEM_SHOP",
    0x159: "_345_NIMBUS_LAND_TOPRIGHT_HOUSE_CROCO_DROPS_SIGNAL_RING",
    0x15A: "_346_NIMBUS_LAND_INN_BEDROOM",
    0x15B: "_347_BEAN_VALLEY_PIPE_ROOM_TOP_PIPE_LEADS_TO_GRATE_GUYS_CASINO",
    0x15C: "_348_BEAN_VALLEY_PIPE_ROOM_BOTTOM_LEFT",
    0x15D: "_349_BEAN_VALLEY_PIPE_ROOM_BOTTOM_RIGHT",
    0x15E: "_350_SMITHY_FACTORY_AREA_01",
    0x15F: "_351_CULEXS_ROOM",
    0x160: "_352_VOLCANO_AREA_21_CZAR_DRAGONS_ROOM",
    0x161: "_353_VOLCANO_AREA_18_HINO_MART",
    0x162: "_354_VOLCANO_AREA_01",
    0x163: "_355_VOLCANO_AREA_03_SECRET_WTWO_FLOWERS",
    0x164: "_356_VOLCANO_AREA_08",
    0x165: "_357_VOLCANO_POSTCD_AREA_01",
    0x166: "_358_VOLCANO_AREA_11",
    0x167: "_359_VOLCANO_AREA_02",
    0x168: "_360_VOLCANO_AREA_04_BUNCH_OF_STEPS",
    0x169: "_361_VOLCANO_AREA_09",
    0x16A: "_362_VOLCANO_AREA_07_STOMPING_CORKPEDITE",
    0x16B: "_363_VOLCANO_AREA_15_STOMPING_CORKPEDITE",
    0x16C: "_364_VOLCANO_AREA_14",
    0x16D: "_365_VOLCANO_POSTCD_AREA_03",
    0x16E: "_366_VOLCANO_AREA_13_WSAVE_POINT",
    0x16F: "_367_VOLCANO_AREA_17_LEADS_TO_HINOPIOS_SHOP",
    0x170: "_368_NIMBUS_LAND_ROYAL_BUS_STATION",
    0x171: "_369_NIMBUS_LAND_ENTRANCE_WWARP_TRAMPOLINE",
    0x172: "_370_NIMBUS_LAND_ENTRANCE_TO_HOT_SPRINGS",
    0x173: "_371_NIMBUS_LAND_FALL_FROM_PLATFORM_1ST",
    0x174: "_372_NIMBUS_LAND_FALL_FROM_PLATFORM_2ND",
    0x175: "_373_NIMBUS_LAND_FALL_FROM_PLATFORM_3RD",
    0x176: "_374_NIMBUS_LAND_FALL_FROM_PLATFORM_4TH",
    0x177: "_375_ENDING_CREDITS_STAR_PIECES_SHOOT_THROUGH_THE_SKY",
    0x178: "_376_BOWSERS_KEEP_6DOOR_BATTLE_ROOM_2B_1ST_FIGHT_CHEWY",
    0x179: "_377_BOWSERS_KEEP_6DOOR_BATTLE_ROOM_2C_1ST_FIGHT_SPARKY",
    0x17A: "_378_BEAN_VALLEY_BEANSTALKS_AREA_01",
    0x17B: "_379_BEAN_VALLEY_BEANSTALKS_AREA_02",
    0x17C: "_380_BEAN_VALLEY_BEANSTALKS_AREA_03_FROM_RIGHT_BEANSTALK_OF_AREA_02",
    0x17D: "_381_BEAN_VALLEY_BEANSTALKS_AREA_04_FROM_LEFT_BEANSTALK_OF_AREA_02",
    0x17E: "_382_NIMBUS_LAND_ENTRANCE_NO_TRAMPOLINESEXITS",
    0x17F: "_383_VOLCANO_AREA_10_JUMPING_PYROSPHERES",
    0x180: "_384_VOLCANO_AREA_05",
    0x181: "_385_VOLCANO_AREA_06",
    0x182: "_386_VOLCANO_AREA_12_ERUPTING_STUMPET",
    0x183: "_387_VOLCANO_AREA_19_FROM_HINO_MART_WSAVE_POINT",
    0x184: "_388_VOLCANO_POSTCD_AREA_02",
    0x185: "_389_VOLCANO_AREA_20_JUMPING_PYROSPHERES",
    0x186: "_390_VOLCANO_AREA_16_ERUPTING_STUMPET",
    0x187: "_391_VOLCANO_POSTCD_AREA_04",
    0x188: "_392_VOLCANO_POSTCD_AREA_06",
    0x189: "_393_VOLCANO_POSTCD_AREA_07_WARP_TO_WORLD_MAP",
    0x18A: "_394_VOLCANO_POSTCD_AREA_05",
    0x18B: "_395_MONSTRO_TOWN_MONSTERMAMAS_HOUSE_1F",
    0x18C: "_396_MONSTRO_TOWN_MONSTERMAMAS_HOUSE_2F",
    0x18D: "_397_MONSTRO_TOWN_SUPERJUMPING_ROOM",
    0x18E: "_398_MONSTRO_TOWN_WEAPON_AND_ARMOR_SHOP",
    0x18F: "_399_MONSTRO_TOWN_3_MUSTY_FEARS_INN",
    0x190: "_400_BOWSERS_KEEP_AREA_13_2ND_THRONE_ROOM_BOOMERS_ROOM",
    0x191: "_401_LANDS_END_SECRET_UNDERGROUND_AREA_02_LEADS_TO_KERO_SEWERS",
    0x192: "_402_LANDS_END_DESERT_AREA_03",
    0x193: "_403_LANDS_END_DESERT_AREA_05",
    0x194: "_404_LANDS_END_DESERT_AREA_04",
    0x195: "_405_BOOSTER_PASS_SECRET",
    0x196: "_406_FACTORY_GROUNDS_AREA_01_WITH_TOAD",
    0x197: "_407_LANDS_END_CLIFF_CLIMB_WSKY_TROOPAS",
    0x198: "_408_NIMBUS_CASTLE_AREA_14_RIGHTMOST_FRONT_DOOR_OF_LONG_5EXIT_ROOM_",
    0x199: "_409_NIMBUS_CASTLE_AREA_09_BIRDOS_ROOM",
    0x19A: "_410_NIMBUS_CASTLE_AREA_07_STRAIGHT_FROM_AREA_06_WLONG_STAIRCASE",
    0x19B: "_411_NIMBUS_CASTLE_PATH_AFTER_THRONE_ROOM_1ST",
    0x19C: "_412_NIMBUS_CASTLE_AREA_11_LONG_HALLWAY_DOOR_TO_KINGS_CELLAR",
    0x19D: "_413_NIMBUS_CASTLE_KINGS_LOCKED_CELLAR",
    0x19E: "_414_NIMBUS_CASTLE_AREA_08_FROM_AREA_07_GET_ROOM_KEY_1_HERE",
    0x19F: "_415_NIMBUS_LAND_SMALL_PLATFORM_AFTER_NIMBUS_CASTLE_THRONE_PATHS",
    0x1A0: "_416_NIMBUS_LAND_OUTSIDE_BEFORE_VALENTINA",
    0x1A1: "_417_GARDENERS_HOUSE_OUTSIDE",
    0x1A2: "_418_GARDENERS_HOUSE",
    0x1A3: "_419_LAZY_SHELL_CLOUD",
    0x1A4: "_420_BELOME_TEMPLE_AREA_02_FORTUNE_ROOM",
    0x1A5: "_421_BELOME_TEMPLE_AREA_04_ROOM_DETERMINED_BY_FORTUNE",
    0x1A6: "_422_BELOME_TEMPLE_AREA_09_BELOMES_TREASURE_ROOM",
    0x1A7: "_423_BELOME_TEMPLE_AREA_06_BELOMES_FORTUNE_ROOM_WELEVATING_PLATFORM",
    0x1A8: "_424_BELOME_TEMPLE_AREA_03_PIPE_TO_ROOM_DETERMINED_BY_FORTUNE",
    0x1A9: "_425_BELOME_TEMPLE_AREA_05_FROM_FORTUNE_ROOM",
    0x1AA: "_426_BELOME_TEMPLE_AREA_07_PIPE_TO_BELOMES_ROOM",
    0x1AB: "_427_BELOME_TEMPLE_AREA_10_PIPE_TO_MONSTRO_TOWN",
    0x1AC: "_428_BELOME_TEMPLE_AREA_01_WWARP_TRAMPOLINE",
    0x1AD: "_429_GAME_INTRO_NIMBUS_LAND_OUTSIDE_WITH_PATROLLING_BIRDIES",
    0x1AE: "_430_NIMBUS_LAND_OUTSIDE_DURING_VALENTINA",
    0x1AF: "_431_BOWSERS_KEEP_6DOOR_PUZZLE_ROOMS",
    0x1B0: "_432_ENDING_CREDITS_JOHNNY_LOOKING_OUT_AT_SUNSET_ON_BEACH_SHORE",
    0x1B1: "_433_SMITHY_FACTORY_AREA_01_____DUMMY",
    0x1B2: "_434_SMITHY_FACTORY_AREA_09_FALLING_AXEM_REDS_ON_CONVEYOR_BELTS",
    0x1B3: "_435_ENDING_CREDITS_BOWSERS_KEEP_BOWSER__TROOPS_REPAIR",
    0x1B4: "_436_SMITHY_FACTORY_AREA_01_____DUMMY",
    0x1B5: "_437_NIMBUS_CASTLE_PATH_AFTER_THRONE_ROOM_3RD",
    0x1B6: "_438_NIMBUS_LAND_OUTSIDE_AFTER_VALENTINA",
    0x1B7: "_439_BOWSERS_KEEP_OUTSIDE_TALK_TO_EXOR",
    0x1B8: "_440_NIMBUS_CASTLE_AREA_13_THRONE_ROOM_AFTER_VALENTINA",
    0x1B9: "_441_ENDING_CREDITS_TOADOFSKY_CONDUCTS_CHOIR",
    0x1BA: "_442_SMITHY_FACTORY_AREA_11_CONVEYOR_BELTS_SPAWNING_DRILL_BITS_AND_MACKS",
    0x1BB: "_443_SMITHY_FACTORY_AREA_16_SMALL_ROOM_WTWO_TREASURES_AFTER_FALLING_YARIDOVICH_ROOM",
    0x1BC: "_444_SMITHY_FACTORY_AREA_09_____DUMMY",
    0x1BD: "_445_SMITHY_FACTORY_AREA_10_FALL_FROM_AREA_09",
    0x1BE: "_446_BOWSERS_KEEP_6DOOR_EXIT_ROOM_AFTER_FINISHING_4_DOORS",
    0x1BF: "_447_NIMBUS_LAND_HOT_SPRINGS",
    0x1C0: "_448_BOWSERS_KEEP_AREA_09_TALL_ROOM_WSAVE_POINT",
    0x1C1: "_449_BOWSERS_KEEP_AREA_11_THWOMPBULLET_ROOM_AFTER_MAGIKOOPAS_ROOM",
    0x1C2: "_450_BOWSERS_KEEP_AREA_12_CROCOS_SHOP_2_AFTER_MAGIKOOPAS_ROOM",
    0x1C3: "_451_BOWSERS_KEEP_AREA_07_150_COINS_AND_A_MUSHROOM",
    0x1C4: "_452_BOWSERS_KEEP_AREA_06_SAVE_POINT_WCROCO_SHOP",
    0x1C5: "_453_BOWSERS_KEEP_AREA_05_DARK_TUNNEL_AFTER_THRONE_ROOM",
    0x1C6: "_454_BOWSERS_KEEP_AREA_08_ROOM_WITH_6_DOORS",
    0x1C7: "_455_BOWSERS_KEEP_6DOOR_ACTION_ROOM_2C_VERY_SLOW_MOVING_CIRCLING_PLATFORMS",
    0x1C8: "_456_BOWSERS_KEEP_6DOOR_ACTION_ROOM_1C_GORILLA_THROWING_BARRELS",
    0x1C9: "_457_BOWSERS_KEEP_6DOOR_ACTION_ROOM_2B_CANNONBALL_RIDING",
    0x1CA: "_458_BOWSERS_KEEP_6DOOR_ACTION_ROOM_1B_MOVING_PLATFORMS",
    0x1CB: "_459_BOWSERS_KEEP_6DOOR_BATTLE_ROOM_1A_1ST_FIGHT_TERRA_COTTA",
    0x1CC: "_460_BOWSERS_KEEP_6DOOR_BATTLE_ROOM_1B_1ST_FIGHT_ALLEY_RAT",
    0x1CD: "_461_BOWSERS_KEEP_6DOOR_BATTLE_ROOM_1C_1ST_FIGHT_BOBOMB",
    0x1CE: "_462_BOWSERS_KEEP_6DOOR_BATTLE_ROOM_2A_1ST_FIGHT_GU_GOOMBA",
    0x1CF: "_463_BOWSERS_KEEP_6DOOR_PUZZLE_ROOM_1B_BARRELCOUNTING",
    0x1D0: "_464_BOWSERS_KEEP_6DOOR_PUZZLE_ROOM_1A_QUIZ",
    0x1D1: "_465_BOWSERS_KEEP_6DOOR_PUZZLE_ROOM_2B_GREEN_SWITCHES",
    0x1D2: "_466_BOWSERS_KEEP_6DOOR_PUZZLE_ROOM_1C_WORD_PROBLEM",
    0x1D3: "_467_BOWSERS_KEEP_6DOOR_PUZZLE_ROOM_2A_COIN_COLLECTING",
    0x1D4: "_468_BOWSERS_KEEP_6DOOR_PUZZLE_ROOM_2C_BALL_SOLITAIRE",
    0x1D5: "_469_FACTORY_GROUNDS_AREA_01",
    0x1D6: "_470_FACTORY_GROUNDS_AREA_04_GUN_YOLKS_ROOM",
    0x1D7: "_471_FACTORY_GROUNDS_AREA_02",
    0x1D8: "_472_FACTORY_GROUNDS_AREA_03",
    0x1D9: "_473_SMITHY_FACTORY_AREA_13_BOWYERS_FALLING_DOWN_CONVEYOR_BELTS",
    0x1DA: "_474_SMITHY_FACTORY_AREA_15_FALLING_YARIDOVICHS",
    0x1DB: "_475_SMITHY_FACTORY_AREA_12_LOTS_OF_CONSECUTIVE_CONVEYOR_BELTS_AND_LILXXBOOS",
    0x1DC: "_476_BOWSERS_KEEP_2ND_TIME_AREA_01",
    0x1DD: "_477_BOWSERS_KEEP_2ND_TIME_AREA_02",
    0x1DE: "_478_BOWSERS_KEEP_2ND_TIME_AREA_03_LAVA_ROOM_WBRIDGE",
    0x1DF: "_479_BOWSERS_KEEP_2ND_TIME_AREA_04_THRONE_ROOM",
    0x1E0: "_480_MUSHROOM_KINGDOM_DURING_MACK_JUMPING_KIDS_HOUSE_1F",
    0x1E1: "_481_MUSHROOM_KINGDOM_DURING_MACK_JUMPING_KIDS_HOUSE_2F",
    0x1E2: "_482_MUSHROOM_KINGDOM_DURING_MACK_RAZ_AND_RAINIS_HOUSE",
    0x1E3: "_483_MUSHROOM_KINGDOM_DURING_MACK_ITEM_SHOP_TOP_FLOOR",
    0x1E4: "_484_MUSHROOM_KINGDOM_DURING_MACK_ITEM_SHOP_BASEMENT",
    0x1E5: "_485_MUSHROOM_KINGDOM_DURING_MACK_INN_1F",
    0x1E6: "_486_ENDING_CREDITS_STAR_PIECES_ROSE_TOWN_LAST_STAR_PIECE_TO_THANK_YOU",
    0x1E7: "_487_MUSHROOM_KINGDOM_DURING_MACK_RUNNING_KIDS_HOUSE",
    0x1E8: "_488_MUSHROOM_KINGDOM_JUMPING_KIDS_HOUSE_1F",
    0x1E9: "_489_MUSHROOM_KINGDOM_JUMPING_KIDS_HOUSE_2F",
    0x1EA: "_490_MUSHROOM_KINGDOM_RAZ_AND_RAINIS_HOUSE",
    0x1EB: "_491_MUSHROOM_KINGDOM_ITEM_SHOP_TOP_FLOOR",
    0x1EC: "_492_MUSHROOM_KINGDOM_ITEM_SHOP_BASEMENT",
    0x1ED: "_493_MUSHROOM_KINGDOM_INN_1F",
    0x1EE: "_494_MUSHROOM_KINGDOM_INN_2F",
    0x1EF: "_495_MUSHROOM_KINGDOM_RUNNING_KIDS_HOUSE",
    0x1F0: "_496_FACTORY_GROUNDS_FIGHT_WITH_SMITHY_USES_SLEDGE",
    0x1F1: "_497_NIMBUS_CASTLE_AREA_06_____DUMMY",
    0x1F2: "_498_NIMBUS_CASTLE_AREA_10_____DUMMY",
    0x1F3: "_499_NIMBUS_CASTLE_AREA_05_LONG_5EXIT_ROOM_AFTER_VALENTINA",
    0x1F4: "_500_NIMBUS_CASTLE_AREA_04_____DUMMY",
    0x1F5: "_501_NIMBUS_CASTLE_AREA_03_4WAY_PATH_AFTER_VALENTINA",
    0x1F6: "_502_NIMBUS_LAND_DREAM_CUSHION_DREAM_SMALL_CLOUD_PERSON_CHEERS_ON_MARIOBED_FLOATS",
    0x1F7: "_503_NIMBUS_LAND_DREAM_CUSHION_DREAM_HEAVY_TROOPA_LAYING_ON_MARIO",
    0x1F8: "_504_NIMBUS_LAND_DREAM_CUSHION_DREAM_TORTES_ARE_SEASONING_MARIO",
    0x1F9: "_505_ENDING_CREDITS_YOSTER_ISLE_CROCO_RACING_YOSHI",
    0x1FA: "_506_ENDING_CREDITS_MARRYMORE_CHAPEL_BOOSTER_WEDDING_VALENTINA",
    0x1FB: "_507_SMITHY_FACTORY_AREA_08_TRAMPOLINE_AFTER_COUNT_DOWN",
    0x1FC: "_508_SMITHY_FACTORY_AREA_14_WSAVE_POINT",
    0x1FD: "_509_FACTORY_GROUNDS_SMITHYS_PAD",
}

Rooms = SimpleNamespace()
for i in room_table:
    setattr(Rooms, room_table[i], i)

sound_table = {
    0x00: "_000_SILENCE",
    0x01: "_001_MENU_SELECT",
    0x02: "_002_MENU_CANCEL",
    0x03: "_003_MENU_SCROLL",
    0x04: "_004_JUMP",
    0x05: "_005_BLOCK_SWITCH",
    0x06: "_006_RUNNING_WATER",
    0x07: "_007_GUSHING_WATER",
    0x08: "_008_WATERFALL",
    0x09: "_009_GREEN_SWITCH",
    0x0A: "_010_TRAMPOLINE",
    0x0B: "_011_WHOOSH_AWAY",
    0x0C: "_012_DIZZINESS",
    0x0D: "_013_COIN",
    0x0E: "_014_FLOWER",
    0x0F: "_015_NIGHT_CRICKETS",
    0x10: "_016_OPEN_DOOR",
    0x11: "_017_OPEN_FRONT_GATE",
    0x12: "_018_SUDDEN_STOP",
    0x13: "_019_LONG_FALL",
    0x14: "_020_LIGHTING_BOLT",
    0x15: "_021_RUMBLING",
    0x16: "_022_CLOSE_DOOR",
    0x17: "_023_HELICOPTER",
    0x18: "_024_TAPPING_FEET",
    0x19: "_025_HEEL_CLICK",
    0x1A: "_026_LAUGHING_BOWSER",
    0x1B: "_027_FOUND_AN_ITEM",
    0x1C: "_028_PIPE_ENTRANCE",
    0x1D: "_029_ALARM_CLOCK",
    0x1E: "_030_SURPRISED_MONSTER",
    0x1F: "_031_SPINNING_FLOWER",
    0x20: "_032_UNDERGROUND_WARP",
    0x21: "_033_JUMPING_BOUNCING_FISH",
    0x22: "_034_SQUIRM_WRITHE",
    0x23: "_035_RUNNING_WATER",
    0x24: "_036_TADPOLE_POND_STAFF_DO",
    0x25: "_037_TADPOLE_POND_STAFF_RE",
    0x26: "_038_TADPOLE_POND_STAFF_MI",
    0x27: "_039_TADPOLE_POND_STAFF_FA",
    0x28: "_040_TADPOLE_POND_STAFF_SO",
    0x29: "_041_TADPOLE_POND_STAFF_LA",
    0x2A: "_042_TADPOLE_POND_STAFF_TI",
    0x2B: "_043_POP_UP_FROM_WATER",
    0x2C: "_044_GHOST_FLOAT",
    0x2D: "_045_GOOMBA_TAUNT",
    0x2E: "_046_CRUMBLING_NOISE",
    0x2F: "_047_SNOOZE",
    0x30: "_048_MINECART_START",
    0x31: "_049_BIG_SHELL_HIT",
    0x32: "_050_WATER_DROPLET",
    0x33: "_051_MOVING_YELLOW_SWITCH",
    0x34: "_052_DEEP_BOUNCE",
    0x35: "_053_BOUNCE",
    0x36: "_054_GOODNIGHT",
    0x37: "_055_LOSE_COINS_COIN_FOUNTAIN",
    0x38: "_056_SHAKE_HEAD",
    0x39: "_057_FINGER_SNAP",
    0x3A: "_058_INSERT",
    0x3B: "_059_HOVERING_FROGFUCIUS",
    0x3C: "_060_DYNAMITE_BOMB_EXPLOSION",
    0x3D: "_061_DEEP_UHOH",
    0x3E: "_062_BIG_YOSHI_TALK",
    0x3F: "_063_YOSHI_TALK",
    0x40: "_064_SPINNING_COPTERS",
    0x41: "_065_THWOMP_STOMP",
    0x42: "_066_KICK_BALL_SHELL",
    0x43: "_067_SWORD_IN_KEEP",
    0x44: "_068_MALLOW_YELLING_AT_CROCO",
    0x45: "_069_MALLOW_FALLING_LANDING",
    0x46: "_070_MALLOW_SLIDING_ON_WALL",
    0x47: "_071_MUSHROOM_CURE",
    0x48: "_072_SYRUP_CURE",
    0x49: "_073_THWOMP_STOMP",
    0x4A: "_074_BOOSTERS_TRAIN",
    0x4B: "_075_ROCKETING_BLAST",
    0x4C: "_076_BOOSTERS_TRAIN_HORN",
    0x4D: "_077_EXOTIC_BIRD_CALLS",
    0x4E: "_078_CLICK",
    0x4F: "_079_YELP_IN_DISTANCE",
    0x50: "_080_BEEPING",
    0x51: "_081_STAR",
    0x52: "_082_SCREECHING_STOP",
    0x53: "_083_WEIRD_LAUGH",
    0x54: "_084_SMOKED",
    0x55: "_085_FLOWER",
    0x56: "_086_BIG_BOUNCE",
    0x57: "_087_CORRECT_SIGNAL",
    0x58: "_088_WRONG_SIGNAL",
    0x59: "_089_LIT_FUSE",
    0x5A: "_090_CURTAIN",
    0x5B: "_091_TUMBLING_BOULDERS",
    0x5C: "_092_LAKITU_ATTACHES_FROGFUCIUS",
    0x5D: "_093_JUMP_INTO_WATER",
    0x5E: "_094_FROG_COIN",
    0x5F: "_095_LEVEL_UP_WITH_STAR",
    0x60: "_096_SWINGING_FIST",
    0x61: "_097_ENGAGE_IN_BATTLE",
    0x62: "_098_PUZZLE_GAME_TIMER",
    0x63: "_099_TAPPING_FEET",
    0x64: "_100_MINECART_RIDE",
    0x65: "_101_TERRAPIN_ATTACK",
    0x66: "_102_TIME_RUNNING_OUT",
    0x67: "_103_TOADSTOOL_CRYING",
    0x68: "_104_DEEP_SCRAPING",
    0x69: "_105_SURPRISE",
    0x6A: "_106_OFF_BALANCE",
    0x6B: "_107_DRUM_ROLL",
    0x6C: "_108_DRUM_ROLL_END",
    0x6D: "_109_BIG_SHELL_HIT",
    0x6E: "_110_ABSTRACT_MUSIC",
    0x6F: "_111_SLEEPING",
    0x70: "_112_DRAINING_WATER",
    0x71: "_113_OPEN_CHAMBER_DOOR",
    0x72: "_114_ORCHESTRA_HIT_A",
    0x73: "_115_ORCHESTRA_HIT_A",
    0x74: "_116_ORCHESTRA_HIT_B",
    0x75: "_117_SPINNING_MONSTER",
    0x76: "_118_BECKONING_TENTACLE",
    0x77: "_119_CZAR_DRAGON_ROAR",
    0x78: "_120_METAL_BOLT_STRIKE",
    0x79: "_121_AXEM_RANGER_TELEPORT",
    0x7A: "_122_SKY_TROOPAS_APPROACHING",
    0x7B: "_123_CHAIN_RUMBLING_NOISE",
    0x7C: "_124_ENGINE_STARTING",
    0x7D: "_125_ENTER_DEEP_WATER",
    0x7E: "_126_EMERGE_DEEP_WATER",
    0x7F: "_127_LIGHT_RATTLE",
    0x80: "_128_FLOATING_HOVERING",
    0x81: "_129_BABY_YOSHI",
    0x82: "_130_BIG_BABY_YOSHI",
    0x83: "_131_JUMP_ON_ORGAN",
    0x84: "_132_HONKING_HORN",
    0x85: "_133_CLOSE_HIT_DOOR",
    0x86: "_134_SWIPE",
    0x87: "_135_IMPENDING_BLAST",
    0x88: "_136_TOADOFSKY_COMPOSITION_DO",
    0x89: "_137_TOADOFSKY_COMPOSITION_RE",
    0x8A: "_138_TOADOFSKY_COMPOSITION_MI",
    0x8B: "_139_TOADOFSKY_COMPOSITION_FA",
    0x8C: "_140_TOADOFSKY_COMPOSITION_SO",
    0x8D: "_141_TOADOFSKY_COMPOSITION_LA",
    0x8E: "_142_TOADOFSKY_COMPOSITION_TI",
    0x8F: "_143_METRONOME_UPBEAT_DING",
    0x90: "_144_CLICK",
    0x91: "_145_BLACKSMITH_HAMMER_STRIKE",
    0x92: "_146_MACHINE_TRANSFORM",
    0x93: "_147_CLICK",
    0x94: "_148_SURGING_ELECTRICITY",
    0x95: "_149_CASINO_SECRET_PASSAGE",
    0x96: "_150_EXIT_TO_WORLD_MAP",
    0x97: "_151_CRASH_HIT",
    0x98: "_152_SLIP_HIT",
    0x99: "_153_SLOT_MACHINES",
    0x9A: "_154_BIG_SQUISH",
    0x9B: "_155_POSTCREDITS_MARIO_THEME_WHISTLE",
    0x9C: "_156_LINK_FANFARE",
    0x9D: "_157_DESCENDING_FALL",
    0x9E: "_158_HARD_LAND",
    0x9F: "_159_DEEP_UNDERGROUND_NOISE",
    0xA0: "_160_CHOMP",
    0xA1: "_161_GHOST",
    0xA2: "_162_CLOSING_GATE_DOOR",
}

Sounds = SimpleNamespace()
for i in sound_table:
    setattr(Sounds, sound_table[i], i)

area_object_table = {
    0x00: "MARIO",
    0x01: "TOADSTOOL",
    0x02: "BOWSER",
    0x03: "GENO",
    0x04: "MALLOW",
    0x05: "DUMMY_0X05",
    0x06: "DUMMY_0X06",
    0x07: "DUMMY_0X07",
    0x08: "CHARACTER_IN_SLOT_1",
    0x09: "CHARACTER_IN_SLOT_2",
    0x0A: "CHARACTER_IN_SLOT_3",
    0x0B: "DUMMY_0X0B",
    0x0C: "SCREEN_FOCUS",
    0x0D: "LAYER_1",
    0x0E: "LAYER_2",
    0x0F: "LAYER_3",
    0x10: "MEM_70A8",
    0x11: "MEM_70A9",
    0x12: "MEM_70AA",
    0x13: "MEM_70AB",
    0x14: "NPC_0",
    0x15: "NPC_1",
    0x16: "NPC_2",
    0x17: "NPC_3",
    0x18: "NPC_4",
    0x19: "NPC_5",
    0x1A: "NPC_6",
    0x1B: "NPC_7",
    0x1C: "NPC_8",
    0x1D: "NPC_9",
    0x1E: "NPC_10",
    0x1F: "NPC_11",
    0x20: "NPC_12",
    0x21: "NPC_13",
    0x22: "NPC_14",
    0x23: "NPC_15",
    0x24: "NPC_16",
    0x25: "NPC_17",
    0x26: "NPC_18",
    0x27: "NPC_19",
    0x28: "NPC_20",
    0x29: "NPC_21",
    0x2A: "NPC_22",
    0x2B: "NPC_23",
    0x2C: "NPC_24",
    0x2D: "NPC_25",
    0x2E: "NPC_26",
    0x2F: "NPC_27",
}

AreaObjects = SimpleNamespace()
for i in area_object_table:
    setattr(AreaObjects, area_object_table[i], i)

npc_packet_table = {
    0x00: "_000_FLOWER",
    0x01: "_001_MUSHROOM",
    0x02: "_002_KEY",
    0x03: "_003_SUPER_STAR",
    0x04: "_004_MONSTER_FACE",
    0x05: "_005_ITEM_BAG",
    0x06: "_006____SPARKLES",
    0x07: "_007____SPARKLES",
    0x08: "_008____BOMB_EXPLOSION",
    0x09: "_009____BLUE_CLOUD",
    0x0A: "_010____SMALL_FROG_COIN",
    0x0B: "_011____LEVELUP_TEXT",
    0x0C: "_012____GREY_EXPLOSION",
    0x0D: "_013____AXEM_RED_MINI",
    0x0E: "_014____NULL",
    0x0F: "_015____NULL",
    0x10: "_016_BIG_COIN",
    0x11: "_017_SMALL_COIN_NOT_MOVING",
    0x12: "_018_SMALL_COIN",
    0x13: "_019_FROG_COIN",
    0x14: "_020_WATER_SPLASH_DROPS",
    0x15: "_021_BULLET_BILL_IGNITION",
    0x16: "_022_SPARKLES_MOVE_N",
    0x17: "_023_SPARKLES_MOVE_W",
    0x18: "_024_BOMB_EXPLOSION_SFX",
    0x19: "_025_BLUE_CLOUD_SFX",
    0x1A: "_026_MAGIKOOPA_SFX",
    0x1B: "_027_TERRAPIN",
    0x1C: "_028_MUSHROOM_THROWN_SW",
    0x1D: "_029_SPARKLE_LINE_LOOPED",
    0x1E: "_030_WATER_SPLASH_DROPS_SFX",
    0x1F: "_031_LEVELUP_TEXT",
    0x20: "_032_BLUE_CLOUD",
    0x21: "_033_BOMB_EXPLOSION",
    0x22: "_034_GREY_EXPLOSION_SFX",
    0x23: "_035_FLOWER_JUMPS",
    0x24: "_036_MUSHROOM_JUMPS",
    0x25: "_037_ITEM_BAG_JUMPS",
    0x26: "_038_MUSHROOM_JUMPS",
    0x27: "_039_SPARKLE",
    0x28: "_040_AXEM_RED",
    0x29: "_041_AXEM_BLACK",
    0x2A: "_042_AXEM_PINK",
    0x2B: "_043_AXEM_YELLOW",
    0x2C: "_044_AXEM_GREEN",
    0x2D: "_045_AXEM_RED_TELEPORT_SFX",
    0x2E: "_046_AXEM_RED_MINI",
    0x2F: "_047_BLUE_FIRE_TRAIL_FOLLOWS_OBJECT",
    0x30: "_048_STAR_PIECE_MINI",
    0x31: "_049_HAMMER_SPARKS_SFX",
    0x32: "_050_WATER_BLAST_SFX",
    0x33: "_051_DRILL_BIT",
    0x34: "_052_BOMB_EXPLOSION_FASTER",
    0x35: "_053_FROG_COIN_RANDOM_WALKING",
    0x36: "_054____LEVELUP_BONUS_POW",
    0x37: "_055____LEVELUP_BONUS_S",
    0x38: "_056____LEVELUP_BONUS_HP",
    0x39: "_057____DONUT_LIFT",
    0x3A: "_058____8BIT_MARIO",
    0x3B: "_059____BOOSTERS_TRAIN",
    0x3C: "_060____MAGIKOOPA",
    0x3D: "_061____TERRAPIN",
    0x3E: "_062____WATER_SPLASH_DROPS",
    0x3F: "_063____RIVER_FISH",
    0x40: "_064_BIG_COIN_ROLLS_E",
    0x41: "_065_BIG_COIN_FALLS_SE",
    0x42: "_066_BIG_COIN_ROLLS_S",
    0x43: "_067_BIG_COIN_ROLLS_SW",
    0x44: "_068_BIG_COIN_ROLLS_W",
    0x45: "_069_BIG_COIN_FALLS_W",
    0x46: "_070_BIG_COIN_FALLS_S",
    0x47: "_071_BIG_COIN_FALLS_NE",
    0x48: "_072_BIG_COIN_FALLS_NE",
    0x49: "_073____GREY_BRICK",
    0x4A: "_074____BRIDGE_RAILS",
    0x4B: "_075____WOODEN_BRIDGE",
    0x4C: "_076____STONE_BRIDGE",
    0x4D: "_077____HANGING_TOADSTOOL",
    0x4E: "_078____PLYWOOD_DOOR",
    0x4F: "_079____BEETLE",
}

NPCPackets = SimpleNamespace()
for i in npc_packet_table:
    setattr(NPCPackets, npc_packet_table[i], i)

location_table = {
    0x00: "_000_TO_MARIOS_PAD_BEFORE",
    0x01: "_001_INNER_FACTORY",
    0x02: "_002_TO_MARIOS_PAD",
    0x03: "_003_VISTA_HILL",
    0x04: "_004_BOWSERS_KEEP",
    0x05: "_005_GATE",
    0x06: "_006_TO_NIMBUS_LAND",
    0x07: "_007_TO_BOWSERS_KEEP",
    0x08: "_008_MARIOS_PAD",
    0x09: "_009_MUSHROOM_WAY",
    0x0A: "_010_MUSHROOM_KINGDOM",
    0x0B: "_011_BANDITS_WAY",
    0x0C: "_012_KERO_SEWERS",
    0x0D: "_013_TO_MUSHROOM_KINGDOM",
    0x0E: "_014_KERO_SEWERS",
    0x0F: "_015_MIDAS_RIVER",
    0x10: "_016_TADPOLE_POND",
    0x11: "_017_ROSE_WAY",
    0x12: "_018_ROSE_TOWN",
    0x13: "_019_FOREST_MAZE",
    0x14: "_020_PIPE_VAULT",
    0x15: "_021_TO_YOSTER_ISLE",
    0x16: "_022_TO_MOLEVILLE",
    0x17: "_023_TO_PIPE_VAULT",
    0x18: "_024_MOLEVILLE",
    0x19: "_025_BOOSTER_PASS",
    0x1A: "_026_BOOSTER_TOWER",
    0x1B: "_027_BOOSTER_HILL",
    0x1C: "_028_MARRYMORE",
    0x1D: "_029_TO_STAR_HILL",
    0x1E: "_030_TO_MARRYMORE",
    0x1F: "_031_STAR_HILL",
    0x20: "_032_SEASIDE_TOWN",
    0x21: "_033_SEA",
    0x22: "_034_SUNKEN_SHIP",
    0x23: "_035_TO_LANDS_END",
    0x24: "_036_TO_SEASIDE_TOWN",
    0x25: "_037_LANDS_END",
    0x26: "_038_MONSTRO_TOWN",
    0x27: "_039_BEAN_VALLEY",
    0x28: "_040_GRATE_GUYS_CASINO",
    0x29: "_041_TO_NIMBUS_LAND",
    0x2A: "_042_TO_SEASIDE_TOWN",
    0x2B: "_043_LANDS_END",
    0x2C: "_044_MONSTRO_TOWN",
    0x2D: "_045_BEAN_VALLEY",
    0x2E: "_046_GRATE_GUYS_CASINO",
    0x2F: "_047_TO_NIMBUS_LAND",
    0x30: "_048_TO_BEAN_VALLEY",
    0x31: "_049_NIMBUS_LAND",
    0x32: "_050_BARREL_VOLCANO",
    0x33: "_051_TO_BOWSERS_KEEP",
    0x34: "_052_YOSTER_ISLE",
    0x35: "_053_TO_PIPE_VAULT",
    0x36: "_054_COAL_MINES_BOWSERS_KEEP",
    0x37: "_055_FACTORY_BOWSERS_KEEP",
}

Locations = SimpleNamespace()
for i in location_table:
    setattr(Locations, location_table[i], i)

shop_table = {
    0x00: "_00_MUSHROOM_KINGDOM",
    0x01: "_01_ROSE_TOWN_ITEMS",
    0x02: "_02_ROSE_TOWN_ARMOR",
    0x03: "_03_FROG_DISCIPLE_SHOP",
    0x04: "_04_MOLEVILLE_SHOP",
    0x05: "_05_MARRYMORE_SHOP",
    0x06: "_06_FROG_COIN_EMPORIUM",
    0x07: "_07_SEA_ITEM_SHOP",
    0x08: "_08_SEASIDE_TOWN_ITEMS_PREYARIDOVICH",
    0x09: "_09_JUICE_BAR_NO_CARD",
    0x0A: "_10_JUICE_BAR_ALTO_CARD",
    0x0B: "_11_JUICE_BAR_TENOR_CARD",
    0x0C: "_12_JUICE_BAR_SOPRANO_CARD",
    0x0D: "_13_SEASIDE_WEAPONS",
    0x0E: "_14_SEASIDE_ARMOR",
    0x0F: "_15_SEASIDE_ACCESSORY",
    0x10: "_16_SEASIDE_HEALTH_FOODS",
    0x11: "_17_MONSTRO_TOWN_SHOP",
    0x12: "_18_NIMBUS_LAND_SHOP",
    0x13: "_19_HINOPIOS_SHOP",
    0x14: "_20_BABY_GOOMBA_SHOP",
    0x15: "_21_NIMBUS_LAND_ITEMWEAPON",
    0x16: "_22_CROCOS_SHOP_1",
    0x17: "_23_CROCOS_SHOP_2",
    0x18: "_24_TOADS_SHOP",
    0x19: "_25____DUMMY",
    0x1A: "_26____DUMMY",
    0x1B: "_27____DUMMY",
    0x1C: "_28____DUMMY",
    0x1D: "_29____DUMMY",
    0x1E: "_30____DUMMY",
    0x1F: "_31____DUMMY",
    0x20: "_32____DUMMY",
}

Shops = SimpleNamespace()
for i in shop_table:
    setattr(Shops, shop_table[i], i)

event_sequence_table = {
    0x00: "_00_OPEN_GAME_SELECT_MENU",
    0x01: "_01_OPEN_OVERWORLD_MENU",
    0x02: "_02_OPEN_LOCATION",
    0x03: "_03_OPEN_SHOP_MENU",
    0x04: "_04_OPEN_SAVE_GAME_MENU",
    0x05: "_05_OPEN_ITEMS_MAXED_OUT_MENU",
    0x06: "_06_UNKNOWN",
    0x07: "_07_RUN_MENU_TUTORIAL",
    0x08: "_08_ADD_STAR_PIECE",
    0x09: "_09_RUN_MOLEVILLE_MOUNTAIN",
    0x0A: "_10_UNKNOWN",
    0x0B: "_11_RUN_MOLEVILLE_MOUNTAIN_INTRO",
    0x0C: "_12_UNKNOWN",
    0x0D: "_13_RUN_STAR_PIECE_END_SEQUENCE",
    0x0E: "_14_RUN_GARDEN_INTRO_SEQUENCE",
    0x0F: "_15_ENTER_GATE_TO_SMITHY_FACTORY",
    0x10: "_16_RUN_WORLD_MAP_EVENT_SEQUENCE",
}

EventSequences = SimpleNamespace()
for i in event_sequence_table:
    setattr(EventSequences, event_sequence_table[i], i)

menu_tutorial_table = {
    0x00: "_00_HOW_TO_EQUIP",
    0x01: "_01_HOW_TO_USE_ITEMS",
    0x02: "_02_HOW_TO_SWITCH_ALLIES",
    0x03: "_03_HOW_TO_PLAY_BEETLE_MANIA",
}

MenuTutorials = SimpleNamespace()
for i in menu_tutorial_table:
    setattr(MenuTutorials, menu_tutorial_table[i], i)

overworld_sequence_table = {
    0x00: "_00_MARIO_FALLS_TO_PIPEHOUSE",
    0x01: "_01_MARIO_RETURNS_TO_MK",
    0x02: "_02_MARIO_TAKES_NIMBUS_BUS",
}

OverworldSequences = SimpleNamespace()
for i in overworld_sequence_table:
    setattr(OverworldSequences, overworld_sequence_table[i], i)

playable_characters_table = {
    0x00: "MARIO",
    0x01: "TOADSTOOL",
    0x02: "BOWSER",
    0x03: "GENO",
    0x04: "MALLOW",
}

PlayableCharacters = SimpleNamespace()
for i in playable_characters_table:
    setattr(PlayableCharacters, playable_characters_table[i], i)

equip_slots_table = {0x00: "WEAPON", 0x01: "ARMOR", 0x02: "ACCESSORY"}

EquipSlots = SimpleNamespace()
for i in equip_slots_table:
    setattr(EquipSlots, equip_slots_table[i], i)

dialog_duration_table = {
    0x00: "FOREVER",
    0x01: "SHORT",
    0x02: "LONG",
    0x03: "ALSO_FOREVER",
}

DialogDurations = SimpleNamespace()
for i in dialog_duration_table:
    setattr(DialogDurations, dialog_duration_table[i], i)

intro_titles_table = {
    0x00: "SUPER_MARIO",
    0x01: "PRINCESS_TOADSTOOL",
    0x02: "KING_BOWSER",
    0x03: "MALLOW",
    0x04: "GENO",
    0x05: "IN",
}

IntroTitles = SimpleNamespace()
for i in intro_titles_table:
    setattr(IntroTitles, intro_titles_table[i], i)

colours_table = {
    0x00: "BLACK",
    0x01: "BLUE",
    0x02: "RED",
    0x03: "PINK",
    0x04: "GREEN",
    0x05: "AQUA",
    0x06: "YELLOW",
    0x07: "WHITE",
}

Colours = SimpleNamespace()
for i in colours_table:
    setattr(Colours, colours_table[i], i)

palette_set_types_table = {
    0x00: "NOTHING",
    0x06: "GLOW",
    0x0C: "SET_TO",
    0x0E: "FADE_TO",
}

PaletteSetTypes = SimpleNamespace()
for i in palette_set_types_table:
    setattr(PaletteSetTypes, palette_set_types_table[i], i)

music_table = {
    0x00: "_00_CURRENT",
    0x01: "_01_DODOS_COMING",
    0x02: "_02_MUSHROOM_KINGDOM",
    0x03: "_03_FIGHT_AGAINST_STRONGER_MONSTER",
    0x04: "_04_YOSTER_ISLAND",
    0x05: "_05_SEASIDE_TOWN",
    0x06: "_06_FIGHT_AGAINST_MONSTERS",
    0x07: "_07_PIPE_VAULT",
    0x08: "_08_INVINCIBLE_STAR",
    0x09: "_09_VICTORY",
    0x0A: "_10_IN_THE_FLOWER_GARDEN",
    0x0B: "_11_BOWSERS_CASTLE_1ST_TIME",
    0x0C: "_12_FIGHT_AGAINST_BOWSER",
    0x0D: "_13_ROAD_IS_FULL_OF_DANGERS",
    0x0E: "_14_MARIOS_PAD",
    0x0F: "_15_HERES_SOME_WEAPONS",
    0x10: "_16_LETS_RACE",
    0x11: "_17_TADPOLE_POND",
    0x12: "_18_ROSE_TOWN",
    0x13: "_19_RACE_TRAINING",
    0x14: "_20_SHOCK",
    0x15: "_21_SAD_SONG",
    0x16: "_22_MIDAS_RIVER",
    0x17: "_23_GOT_A_STAR_PIECE_PART_1",
    0x18: "_24_GOT_A_STAR_PIECE_PART_2",
    0x19: "_25_FIGHT_AGAINST_AN_ARMED_BOSS",
    0x1A: "_26_FOREST_MAZE",
    0x1B: "_27_DUNGEON_IS_FULL_OF_MONSTERS",
    0x1C: "_28_LETS_PLAY_GENO",
    0x1D: "_29_START_SLOT_MENU",
    0x1E: "_30_LONG_LONG_AGO",
    0x1F: "_31_BOOSTERS_TOWER",
    0x20: "_32_AND_MY_NAMES_BOOSTER",
    0x21: "_33_MOLEVILLE",
    0x22: "_34_STAR_HILL",
    0x23: "_35_MOUNTAIN_RAILROAD",
    0x24: "_36_EXPLANATION",
    0x25: "_37_BOOSTER_HILL_START",
    0x26: "_38_BOOSTER_HILL",
    0x27: "_39_MARRYMORE",
    0x28: "_40_NEW_PARTNER",
    0x29: "_41_SUNKEN_SHIP",
    0x2A: "_42_STILL_THE_ROAD_IS_FULL_OF_MONSTERS",
    0x2B: "_43_SILENCE",
    0x2C: "_44_SEA",
    0x2D: "_45_HEART_BEATING_A_LITTLE_FASTER_PART_1",
    0x2E: "_46_HEART_BEATING_A_LITTLE_FASTER_PART_2",
    0x2F: "_47_GRATE_GUYS_CASINO",
    0x30: "_48_GENO_AWAKENS",
    0x31: "_49_CELEBRATIONAL",
    0x32: "_50_NIMBUS_LAND",
    0x33: "_51_MONSTRO_TOWN",
    0x34: "_52_TOADOFSKY",
    0x35: "_53_SILENCE",
    0x36: "_54_HAPPY_ADVENTURE_DELIGHFUL_ADVENTURE",
    0x37: "_55_WORLD_MAP",
    0x38: "_56_FACTORY",
    0x39: "_57_SWORD_CRASHES_AND_STARS_SCATTER",
    0x3A: "_58_CONVERSATION_WITH_CULEX",
    0x3B: "_59_FIGHT_AGAINST_CULEX",
    0x3C: "_60_VICTORY_AGAINST_CULEX",
    0x3D: "_61_VALENTINA",
    0x3E: "_62_BARREL_VOLCANO",
    0x3F: "_63_AXEM_RANGERS_DROP_IN",
    0x40: "_64_THE_END",
    0x41: "_65_GATE",
    0x42: "_66_BOWSERS_CASTLE_2ND_TIME",
    0x43: "_67_WEAPONS_FACTORY",
    0x44: "_68_FIGHT_AGAINST_SMITHY_1",
    0x45: "_69_FIGHT_AGAINST_SMITHY_2",
    0x46: "_70_ENDING_PART_1",
    0x47: "_71_ENDING_PART_2",
    0x48: "_72_ENDING_PART_3",
    0x49: "_73_ENDING_PART_4",
}

Music = SimpleNamespace()
for i in music_table:
    setattr(Music, music_table[i], i)

music_direction_table = {0x00: "SLOW_DOWN", 0x01: "SPEED_UP"}

MusicDirections = SimpleNamespace()
for i in music_direction_table:
    setattr(MusicDirections, music_direction_table[i], i)

music_pitch_table = {0x00: "RAISE", 0x01: "LOWER"}

MusicPitch = SimpleNamespace()
for i in music_pitch_table:
    setattr(MusicPitch, music_pitch_table[i], i)

coord_table = {0x00: "X", 0x01: "Y", 0x02: "Z", 0x05: "F"}

Coords = SimpleNamespace()
for i in coord_table:
    setattr(Coords, coord_table[i], i)

coord_unit_table = {0x00: "PIXEL", 0x01: "ISOMETRIC"}

CoordUnits = SimpleNamespace()
for i in coord_unit_table:
    setattr(CoordUnits, coord_unit_table[i], i)

tutorial_table = {
    0x00: "_00_HOW_TO_EQUIP",
    0x01: "_01_HOW_TO_USE_ITEMS",
    0x02: "_02_HOW_TO_SWITCH_ALLIES",
    0x03: "_03_HOW_TO_PLAY_BEETLE_MANIA",
}

Tutorials = SimpleNamespace()
for i in tutorial_table:
    setattr(Tutorials, tutorial_table[i], i)

_0x40_flags = {13: "RETURN_ON_LEVEL_EXIT", 14: "BIT_6", 15: "BIT_7"}

_0x40Flags = SimpleNamespace()
for i in _0x40_flags:
    setattr(_0x40Flags, _0x40_flags[i], i)

_0x60_flags = {
    5: "CLOSABLE",
    6: "BIT_6",
    7: "ASYNC",
    14: "MULTILINE",
    15: "USE_BACKGROUND",
}

_0x60Flags = SimpleNamespace()
for i in _0x60_flags:
    setattr(_0x60Flags, _0x60_flags[i], i)

_0x62_flags = {7: "ASYNC"}

_0x62Flags = SimpleNamespace()
for i in _0x62_flags:
    setattr(_0x62Flags, _0x62_flags[i], i)

_0x63_flags = {5: "CLOSABLE", 7: "ASYNC"}

_0x63Flags = SimpleNamespace()
for i in _0x63_flags:
    setattr(_0x63Flags, _0x63_flags[i], i)

_0x68_flags = {11: "SHOW_MESSAGE", 15: "RUN_ENTRANCE_EVENT", 31: "Z_HALF"}

_0x68Flags = SimpleNamespace()
for i in _0x68_flags:
    setattr(_0x68Flags, _0x68_flags[i], i)

_0x6A_flags = {15: "USE_ALTERNATE"}

_0x6AFlags = SimpleNamespace()
for i in _0x6A_flags:
    setattr(_0x6AFlags, _0x6A_flags[i], i)

_0x6B_flags = {15: "PERMANENT"}

_0x6BFlags = SimpleNamespace()
for i in _0x6B_flags:
    setattr(_0x6BFlags, _0x6B_flags[i], i)

_0x81_flags = {
    0: "LAYER_1",
    1: "LAYER_2",
    2: "LAYER_3",
    3: "LAYER_4",
    4: "NPC_SPRITES",
    5: "BACKGROUND",
    6: "HALF_INTENSITY",
    7: "MINUS_SUB",
}

_0x81Flags = SimpleNamespace()
for i in _0x81_flags:
    setattr(_0x81Flags, _0x81_flags[i], i)

_0x84_flags = {0: "LAYER_1", 1: "LAYER_2", 2: "LAYER_3", 3: "LAYER_4"}

_0x84Flags = SimpleNamespace()
for i in _0x84_flags:
    setattr(_0x84Flags, _0x84_flags[i], i)
