from django.core.management.base import BaseCommand
from randomizer.management.disassembler_common import shortify, bit, dbyte, hbyte, named, con, byte, byte_int, short, short_int, build_table, use_table_name, get_flag_string, flags, con_int, flags_short, writeline, bit_bool_from_num
from randomizer.helpers.npcmodeltables import sprite_name_table, vram_store_table, shadow_size_table


start = 0x1DB800
# end = 0x1dc5ff
end = 0x1DDDFF


class Command(BaseCommand):

    def add_arguments(self, parser):
        parser.add_argument('-r', '--rom', dest='rom',
                            help='Path to a Mario RPG rom')

        parser.add_argument('-d', '--debug', action="store_true",
                            help='If set, dumps to a gitignored folder instead of overwriting the scripts sourced by SMRPG Randomizer')

    def handle(self, *args, **options):
        debug = options['debug']

        dest = 'randomizer/data'
        if debug:
            dest = 'randomizer/management/commands/output/disassembler'

        global rom
        rom = bytearray(open(options['rom'], 'rb').read())


        file = open("%s/npcmodels.py" % dest, "w")
        writeline(file, '# AUTOGENERATED DO NOT EDIT!!')
        writeline(file, '# Run the following command if you need to rebuild the table')
        writeline(file, '# python manage.py npcmodeldisassembler --rom ROM')
        writeline(file, 'from randomizer.helpers.npcmodeltables import SpriteName, VramStore, ShadowSize')
        writeline(file, 'models = [None]* %i' % ((end + 1 - start) // 7))
        ctr = 0
        for offset in range(start, end+1, 7):
            if offset + 7 > end:
                break
            raw_data = rom[offset:(offset+7)]
            if raw_data == bytearray([0xFF] * 7):
                writeline(file, 'models[%i] = None # 0x%06x' % (ctr, offset))
            else:

                sprite_val = ((raw_data[1] << 8) | raw_data[0]) & 0x03FF
                sprite, _ = byte(prefix="SpriteName", table=sprite_name_table)([sprite_val])
                vram_store_val = (raw_data[1] >> 2) & 0x07
                vram_store, _ = byte(prefix="VramStore", table=vram_store_table)([vram_store_val])
                vram_size = (raw_data[1] >> 5) # are these the vram buffer settings?

                priority0 = (raw_data[2] & 0x20) == 0x20 # bit 5
                priority1 = (raw_data[2] & 0x40) == 0x40 # bit 6
                priority2 = (raw_data[2] & 0x80) == 0x80 # bit 7
                byte2_bit0 = (raw_data[2] & 0x01) == 0x01 # bit 0
                byte2_bit1 = (raw_data[2] & 0x02) == 0x02 # bit 1
                byte2_bit2 = (raw_data[2] & 0x04) == 0x04 # bit 2
                byte2_bit3 = (raw_data[2] & 0x08) == 0x08 # bit 3
                byte2_bit4 = (raw_data[2] & 0x10) == 0x10 # bit 4
                
                y_pixel_shift = raw_data[3] & 0x0F
                shift_16_px_down = (raw_data[3] & 0x10) == 0x10 # bit 4
                shadow_val = (raw_data[3] & 0x60) >> 5
                shadow, _ = byte(prefix="ShadowSize", table=shadow_size_table)([shadow_val])
                cannot_clone = (raw_data[3] & 0x80) == 0x80 # bit 7

                acute_axis = raw_data[4] & 0x0F
                obtuse_axis = (raw_data[4] & 0xF0) >> 4

                height = raw_data[5] & 0x1F
                show_shadow = (raw_data[5] & 0x20) == 0x20 # bit 5
                byte5_bit6 = (raw_data[5] & 0x40) == 0x40 # bit 6
                byte5_bit7 = (raw_data[5] & 0x80) == 0x80 # bit 7

                byte6_bit2 = (raw_data[6] & 0x04) == 0x04 # bit 2

                writeline(file, 'models[%i] = {' % (ctr))
                writeline(file, '  "sprite": %s,' % sprite)
                writeline(file, '  "priority_0": %r,' % priority0)
                writeline(file, '  "priority_1": %r,' % priority1)
                writeline(file, '  "priority_2": %r,' % priority2)
                writeline(file, '  "show_shadow": %r,' % show_shadow)
                writeline(file, '  "shadow": %s,' % shadow)
                writeline(file, '  "y_pixel_shift": %i,' % (y_pixel_shift + (-16 if shift_16_px_down else 0)))
                writeline(file, '  "acute_axis": %i,' % acute_axis)
                writeline(file, '  "obtuse_axis": %i,' % obtuse_axis)
                writeline(file, '  "height": %i,' % height)
                writeline(file, '  "vram_store": %s,' % vram_store)
                writeline(file, '  "vram_size": %i,' % vram_size)
                writeline(file, '  "cannot_clone": %r,' % cannot_clone)
                writeline(file, '  "byte2_bit0": %r,' % byte2_bit0)
                writeline(file, '  "byte2_bit1": %r,' % byte2_bit1)
                writeline(file, '  "byte2_bit2": %r,' % byte2_bit2)
                writeline(file, '  "byte2_bit3": %r,' % byte2_bit3)
                writeline(file, '  "byte2_bit4": %r,' % byte2_bit4)
                writeline(file, '  "byte5_bit6": %r,' % byte5_bit6)
                writeline(file, '  "byte5_bit7": %r,' % byte5_bit7)
                writeline(file, '  "byte6_bit2": %r' % byte6_bit2)
                writeline(file, '} # 0x%06x' % (offset))
            ctr += 1

        file.close()

        self.stdout.write(
            self.style.SUCCESS(
                "Successfully disassembled NPC models to randomizer/data/npcmodels.py"
            )
        )
