from django.core.management.base import BaseCommand


def color_to_bytes(color):
    color_int = int(color, 16)
    r = color_int >> 19
    g = (color_int >> 10) & 0x3E
    b = (color_int >> 1) & 0x7C

    byte_1 = r + ((g << 4) & 0xF0)
    byte_2 = b + (g >> 4)
    return [byte_1, byte_2]


def palette_to_bytes(colors):
    ret = []
    for color in colors:
        ret += color_to_bytes(color)
    return ret


palettes = [
    [
        "F8F8A0",
        "F8E870",
        "F8E870",
        "0",
        "D09020",
        "F8E870",
        "E0C000",
        "906010",
        "482818",
        "906010",
        "D09020",
        "482818",
        "D09020",
        "0",
        "181818",
    ],
    [
        "F8E870",
        "C08020",
        "F8E870",
        "F8F8A0",
        "906010",
        "E0C000",
        "C08020",
        "C08020",
        "E0C000",
        "906010",
        "683808",
        "784818",
        "482818",
        "906010",
        "301830",
    ],
    [
        "F8F8A0",
        "F8E870",
        "F8E870",
        "E0C000",
        "C08020",
        "906010",
        "E0C000",
        "906010",
        "906010",
        "E0C000",
        "C08020",
        "906010",
        "683808",
        "482818",
        "301830",
    ],
    [
        "F8F8F8",
        "F8E870",
        "E0C000",
        "C08020",
        "906010",
        "F8E870",
        "C08020",
        "E0C000",
        "D09020",
        "906010",
        "784818",
        "E0C000",
        "906010",
        "683808",
        "181818",
    ],
    [
        "F8F8A0",
        "E0C000",
        "906010",
        "C08020",
        "E0C000",
        "C08020",
        "683808",
        "301830",
        "F8F8A0",
        "F8E870",
        "D09020",
        "784818",
        "E0C000",
        "482818",
        "301830",
    ],
    [
        "F8E870",
        "F8E870",
        "E0C000",
        "D09020",
        "906010",
        "784818",
        "301830",
        "784818",
        "906010",
        "E0C000",
        "D09020",
        "906010",
        "482818",
        "301830",
        "181818",
    ],
    [
        "F8F8A0",
        "E0C000",
        "906010",
        "E0C000",
        "683808",
        "482818",
        "E0C000",
        "C08020",
        "482818",
        "F8E870",
        "E0C000",
        "C08020",
        "906010",
        "482818",
        "301830",
    ],
    [
        "F8F8A0",
        "E0C000",
        "E0C000",
        "906010",
        "F8E870",
        "E0C000",
        "D09020",
        "784818",
        "482818",
        "F8E870",
        "E0C000",
        "D09020",
        "482818",
        "301830",
        "181818",
    ],
    [
        "F8F8A0",
        "E0C000",
        "D09020",
        "A87828",
        "482818",
        "E0C000",
        "784818",
        "301830",
        "F8F8A0",
        "F8E870",
        "906010",
        "301830",
        "F8F8A0",
        "E0C000",
        "301830",
    ],
    [
        "F8F8F8",
        "F8F8A0",
        "F8E870",
        "E0C000",
        "D09020",
        "F8F8A0",
        "784818",
        "906010",
        "E0C000",
        "482818",
        "D09020",
        "0",
        "0",
        "0",
        "181818",
    ],
    [
        "F8F8A0",
        "F8E870",
        "D09020",
        "784818",
        "482818",
        "D09020",
        "784818",
        "301830",
        "482818",
        "F8E870",
        "E0C000",
        "D09020",
        "784818",
        "301830",
        "181818",
    ],
    [
        "F8F8A0",
        "F8E870",
        "E0C000",
        "D0A000",
        "C08020",
        "906010",
        "301830",
        "C08020",
        "482818",
        "F8E870",
        "E0C000",
        "C08020",
        "482818",
        "E0C000",
        "301830",
    ],
    [
        "F8F8A0",
        "F8F8A0",
        "F8E870",
        "E0C000",
        "F8F8A0",
        "F8E870",
        "E0C000",
        "D0A000",
        "C08020",
        "906010",
        "784818",
        "482818",
        "0",
        "0",
        "181818",
    ],
    [
        "F8F8A0",
        "E0C000",
        "C08020",
        "784818",
        "F8F8A0",
        "E0C000",
        "000000",
        "906010",
        "784818",
        "906010",
        "301830",
        "784818",
        "683808",
        "482818",
        "301830",
    ],
    [
        "F8F8A0",
        "F8E870",
        "906010",
        "C08020",
        "906010",
        "301830",
        "F8E870",
        "E0C000",
        "C08020",
        "683808",
        "0",
        "0",
        "0",
        "0",
        "181818",
    ],
    [
        "F8F8A0",
        "F8E870",
        "F8E870",
        "E0C000",
        "F8F8F8",
        "D0A000",
        "C08020",
        "C08020",
        "906010",
        "C08020",
        "482818",
        "D09020",
        "482818",
        "E0C000",
        "301830",
    ],
    [
        "F8F8A0",
        "F8E870",
        "E0C000",
        "E0C000",
        "E0C000",
        "D09020",
        "D09020",
        "F8E870",
        "F8E870",
        "906010",
        "D09020",
        "906010",
        "E0C000",
        "F8E870",
        "906010",
    ],
    [
        "C08020",
        "E0C000",
        "D0A000",
        "F8F8A0",
        "181818",
        "F8E870",
        "F8F890",
        "D8C000",
        "906010",
        "F0E860",
        "D08800",
        "F0A808",
        "604800",
        "302000",
        "180800",
    ],
    [
        "E0C000",
        "D0A000",
        "683808",
        "F8E870",
        "906010",
        "E0C000",
        "784818",
        "F8F8A0",
        "C08020",
        "906010",
        "D0A000",
        "F8E870",
        "F8E870",
        "F8F8F8",
        "D0A000",
    ],
    [
        "F8D008",
        "F8A008",
        "F8F888",
        "984000",
        "F8F8F8",
        "181818",
        "F8B010",
        "401800",
        "F8D008",
        "F8F8B0",
        "582000",
        "C88008",
        "F8D060",
        "582000",
        "200000",
    ],
    [
        "E0C000",
        "D0A000",
        "D0A000",
        "482818",
        "683808",
        "301830",
        "C08020",
        "D0A000",
        "F8F8A0",
        "F8E870",
        "906010",
        "E0C000",
        "C08020",
        "F8E048",
        "C08020",
    ],
    [
        "E0C000",
        "C08020",
        "482818",
        "D0A000",
        "E0C000",
        "C08020",
        "C08020",
        "D0A000",
        "F8F8A0",
        "F8E870",
        "E0C000",
        "F0E870",
        "986000",
        "F8F8A0",
        "000000",
    ],
    [
        "683808",
        "E0C000",
        "906010",
        "C08020",
        "683808",
        "C08020",
        "F8E870",
        "F8F8A0",
        "906010",
        "E0C000",
        "784818",
        "E0C000",
        "C8A008",
        "F8E870",
        "C08020",
    ],
    [
        "C08020",
        "E0C000",
        "784818",
        "906010",
        "D0A000",
        "683808",
        "F8E870",
        "301830",
        "E0C000",
        "C08020",
        "F8F8A0",
        "C08020",
        "D0A000",
        "482818",
        "906010",
    ],
    [
        "F8E870",
        "D0A000",
        "F8F8A0",
        "482818",
        "D0A000",
        "784818",
        "E0C000",
        "906010",
        "683808",
        "C08020",
        "301830",
        "181818",
        "906010",
        "784818",
        "482818",
    ],
    [
        "906010",
        "906010",
        "C08020",
        "E0C000",
        "784818",
        "301830",
        "D0A000",
        "E0C000",
        "784818",
        "C08020",
        "D0A000",
        "F8E870",
        "F8F8A0",
        "000000",
        "000000",
    ],
    [
        "F8F8A0",
        "F8E870",
        "683808",
        "E0C000",
        "784717",
        "301830",
        "C08020",
        "D0A000",
        "E0C000",
        "C08020",
        "906010",
        "784818",
        "F8E870",
        "784818",
        "E0C000",
    ],
    [
        "D0A000",
        "F8E870",
        "D0A000",
        "F8E870",
        "F8F8A0",
        "C08020",
        "301830",
        "683808",
        "C08020",
        "E0C000",
        "906010",
        "784818",
        "F8E870",
        "482818",
        "301830",
    ],
    [
        "683808",
        "D0A000",
        "F8F060",
        "906010",
        "784818",
        "D09020",
        "C08020",
        "784818",
        "F8F8A0",
        "E0C000",
        "C08020",
        "F8E870",
        "906010",
        "000000",
        "000000",
    ],
    [
        "482818",
        "F8E870",
        "C08020",
        "906010",
        "F8F8A0",
        "F8E870",
        "D0A000",
        "E0C000",
        "482818",
        "D0A000",
        "F8E870",
        "683808",
        "E0C000",
        "683808",
        "F8F8A0",
    ],
]


class Command(BaseCommand):
    def handle(self, *args, **options):

        output = bytearray()
        for e, b in enumerate(palettes):
            output += bytearray(palette_to_bytes(b))
            print(e + 1, len(output))

        f = open(f"write_to_somewhere.img", "wb")
        f.write(output)
        f.close()
