# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### CloudFrontToOrigins <a name="CloudFrontToOrigins" id="must-cdk.CloudFrontToOrigins"></a>

#### Initializers <a name="Initializers" id="must-cdk.CloudFrontToOrigins.Initializer"></a>

```python
import must_cdk

must_cdk.CloudFrontToOrigins(
  scope: Construct,
  id: str,
  additional_domain_names: typing.List[str] = None,
  cache_behaviors: typing.List[CacheBehaviorConfig] = None,
  certificate: ICertificate = None,
  comment: str = None,
  create_route53_records: bool = None,
  custom_domain_name: str = None,
  default_origin_id: str = None,
  default_root_object: str = None,
  enabled: bool = None,
  enable_ipv6: bool = None,
  enable_logging: bool = None,
  error_pages: typing.List[ErrorResponse] = None,
  geo_restriction: GeoRestriction = None,
  hosted_zone: IHostedZone = None,
  http_origins: typing.List[HttpOriginConfig] = None,
  http_version: HttpVersion = None,
  log_bucket: IBucket = None,
  log_include_cookies: bool = None,
  log_prefix: str = None,
  price_class: PriceClass = None,
  s3_origins: typing.List[S3OriginConfig] = None,
  web_acl_id: str = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.additionalDomainNames">additional_domain_names</a></code> | <code>typing.List[str]</code> | Additional domain names (aliases) for the distribution Note: All domains must be covered by the same certificate. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.cacheBehaviors">cache_behaviors</a></code> | <code>typing.List[CacheBehaviorConfig](#must-cdk.CacheBehaviorConfig)</code> | Cache behaviors for specific path patterns. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.certificate">certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | Existing ACM certificate to use for the CloudFront distribution Certificate must be in us-east-1 region for CloudFront. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.comment">comment</a></code> | <code>str</code> | Comment for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.createRoute53Records">create_route53_records</a></code> | <code>bool</code> | Create Route53 records for all domain names. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.customDomainName">custom_domain_name</a></code> | <code>str</code> | Primary custom domain name for the CloudFront distribution. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.defaultOriginId">default_origin_id</a></code> | <code>str</code> | ID of the origin to use as default behavior If not specified, will use the first HTTP origin, then first S3 origin. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.defaultRootObject">default_root_object</a></code> | <code>str</code> | Default root object for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.enabled">enabled</a></code> | <code>bool</code> | Whether the distribution is enabled. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.enableIpv6">enable_ipv6</a></code> | <code>bool</code> | Enable IPv6 for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.enableLogging">enable_logging</a></code> | <code>bool</code> | Enable CloudFront access logging. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.errorPages">error_pages</a></code> | <code>typing.List[aws_cdk.aws_cloudfront.ErrorResponse]</code> | Custom error page configurations If not provided, intelligent defaults will be applied based on origin types. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.geoRestriction">geo_restriction</a></code> | <code>aws_cdk.aws_cloudfront.GeoRestriction</code> | Geographic restriction configuration. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.hostedZone">hosted_zone</a></code> | <code>aws_cdk.aws_route53.IHostedZone</code> | Route53 hosted zone for the custom domain Required for creating Route53 records. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.httpOrigins">http_origins</a></code> | <code>typing.List[HttpOriginConfig](#must-cdk.HttpOriginConfig)</code> | HTTP origins configuration. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.httpVersion">http_version</a></code> | <code>aws_cdk.aws_cloudfront.HttpVersion</code> | HTTP version to support. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.logBucket">log_bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | Existing S3 bucket for logs If not provided and logging is enabled, a new bucket will be created. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.logIncludeCookies">log_include_cookies</a></code> | <code>bool</code> | Include cookies in access logs. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.logPrefix">log_prefix</a></code> | <code>str</code> | Prefix for log files. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.priceClass">price_class</a></code> | <code>aws_cdk.aws_cloudfront.PriceClass</code> | CloudFront distribution price class. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.s3Origins">s3_origins</a></code> | <code>typing.List[S3OriginConfig](#must-cdk.S3OriginConfig)</code> | S3 origins configuration. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.webAclId">web_acl_id</a></code> | <code>str</code> | Web Application Firewall (WAF) web ACL ID. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.id"></a>

- *Type:* str

---

##### `additional_domain_names`<sup>Optional</sup> <a name="additional_domain_names" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.additionalDomainNames"></a>

- *Type:* typing.List[str]

Additional domain names (aliases) for the distribution Note: All domains must be covered by the same certificate.

CloudFront only supports one certificate per distribution.

---

##### `cache_behaviors`<sup>Optional</sup> <a name="cache_behaviors" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.cacheBehaviors"></a>

- *Type:* typing.List[CacheBehaviorConfig](#must-cdk.CacheBehaviorConfig)

Cache behaviors for specific path patterns.

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.certificate"></a>

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

Existing ACM certificate to use for the CloudFront distribution Certificate must be in us-east-1 region for CloudFront.

The certificate must cover all domains (customDomainName + additionalDomainNames).
CloudFront only supports one certificate per distribution.

---

##### `comment`<sup>Optional</sup> <a name="comment" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.comment"></a>

- *Type:* str

Comment for the distribution.

---

##### `create_route53_records`<sup>Optional</sup> <a name="create_route53_records" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.createRoute53Records"></a>

- *Type:* bool
- *Default:* true if hostedZone is provided

Create Route53 records for all domain names.

---

##### `custom_domain_name`<sup>Optional</sup> <a name="custom_domain_name" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.customDomainName"></a>

- *Type:* str

Primary custom domain name for the CloudFront distribution.

---

##### `default_origin_id`<sup>Optional</sup> <a name="default_origin_id" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.defaultOriginId"></a>

- *Type:* str

ID of the origin to use as default behavior If not specified, will use the first HTTP origin, then first S3 origin.

---

##### `default_root_object`<sup>Optional</sup> <a name="default_root_object" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.defaultRootObject"></a>

- *Type:* str
- *Default:* "index.html"

Default root object for the distribution.

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.enabled"></a>

- *Type:* bool
- *Default:* true

Whether the distribution is enabled.

---

##### `enable_ipv6`<sup>Optional</sup> <a name="enable_ipv6" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.enableIpv6"></a>

- *Type:* bool
- *Default:* false

Enable IPv6 for the distribution.

---

##### `enable_logging`<sup>Optional</sup> <a name="enable_logging" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.enableLogging"></a>

- *Type:* bool
- *Default:* true

Enable CloudFront access logging.

---

##### `error_pages`<sup>Optional</sup> <a name="error_pages" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.errorPages"></a>

- *Type:* typing.List[aws_cdk.aws_cloudfront.ErrorResponse]

Custom error page configurations If not provided, intelligent defaults will be applied based on origin types.

---

##### `geo_restriction`<sup>Optional</sup> <a name="geo_restriction" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.geoRestriction"></a>

- *Type:* aws_cdk.aws_cloudfront.GeoRestriction

Geographic restriction configuration.

---

##### `hosted_zone`<sup>Optional</sup> <a name="hosted_zone" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.hostedZone"></a>

- *Type:* aws_cdk.aws_route53.IHostedZone

Route53 hosted zone for the custom domain Required for creating Route53 records.

---

##### `http_origins`<sup>Optional</sup> <a name="http_origins" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.httpOrigins"></a>

- *Type:* typing.List[HttpOriginConfig](#must-cdk.HttpOriginConfig)

HTTP origins configuration.

---

##### `http_version`<sup>Optional</sup> <a name="http_version" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.httpVersion"></a>

- *Type:* aws_cdk.aws_cloudfront.HttpVersion
- *Default:* HttpVersion.HTTP2

HTTP version to support.

---

##### `log_bucket`<sup>Optional</sup> <a name="log_bucket" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.logBucket"></a>

- *Type:* aws_cdk.aws_s3.IBucket

Existing S3 bucket for logs If not provided and logging is enabled, a new bucket will be created.

---

##### `log_include_cookies`<sup>Optional</sup> <a name="log_include_cookies" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.logIncludeCookies"></a>

- *Type:* bool
- *Default:* false

Include cookies in access logs.

---

##### `log_prefix`<sup>Optional</sup> <a name="log_prefix" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.logPrefix"></a>

- *Type:* str
- *Default:* "cloudfront"

Prefix for log files.

---

##### `price_class`<sup>Optional</sup> <a name="price_class" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.priceClass"></a>

- *Type:* aws_cdk.aws_cloudfront.PriceClass
- *Default:* PRICE_CLASS_100

CloudFront distribution price class.

---

##### `s3_origins`<sup>Optional</sup> <a name="s3_origins" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.s3Origins"></a>

- *Type:* typing.List[S3OriginConfig](#must-cdk.S3OriginConfig)

S3 origins configuration.

---

##### `web_acl_id`<sup>Optional</sup> <a name="web_acl_id" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.webAclId"></a>

- *Type:* str

Web Application Firewall (WAF) web ACL ID.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.CloudFrontToOrigins.getHttpOrigin">get_http_origin</a></code> | Get HTTP origin by origin ID. |
| <code><a href="#must-cdk.CloudFrontToOrigins.getS3Bucket">get_s3_bucket</a></code> | Get S3 bucket by origin ID. |

---

##### `to_string` <a name="to_string" id="must-cdk.CloudFrontToOrigins.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `get_http_origin` <a name="get_http_origin" id="must-cdk.CloudFrontToOrigins.getHttpOrigin"></a>

```python
def get_http_origin(
  origin_id: str
) -> HttpOrigin
```

Get HTTP origin by origin ID.

###### `origin_id`<sup>Required</sup> <a name="origin_id" id="must-cdk.CloudFrontToOrigins.getHttpOrigin.parameter.originId"></a>

- *Type:* str

---

##### `get_s3_bucket` <a name="get_s3_bucket" id="must-cdk.CloudFrontToOrigins.getS3Bucket"></a>

```python
def get_s3_bucket(
  origin_id: str
) -> IBucket
```

Get S3 bucket by origin ID.

###### `origin_id`<sup>Required</sup> <a name="origin_id" id="must-cdk.CloudFrontToOrigins.getS3Bucket.parameter.originId"></a>

- *Type:* str

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### ~~`is_construct`~~ <a name="is_construct" id="must-cdk.CloudFrontToOrigins.isConstruct"></a>

```python
import must_cdk

must_cdk.CloudFrontToOrigins.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.CloudFrontToOrigins.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.aRecords">a_records</a></code> | <code>typing.List[aws_cdk.aws_route53.ARecord]</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.distribution">distribution</a></code> | <code>aws_cdk.aws_cloudfront.Distribution</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.distributionDomainName">distribution_domain_name</a></code> | <code>str</code> | Get the CloudFront distribution domain name. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.distributionUrl">distribution_url</a></code> | <code>str</code> | Get the CloudFront distribution URL with protocol. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.httpOriginIds">http_origin_ids</a></code> | <code>typing.List[str]</code> | Get all HTTP origin IDs. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.httpOrigins">http_origins</a></code> | <code>typing.List[HttpOriginInfo](#must-cdk.HttpOriginInfo)</code> | Get all HTTP origins as an array of objects with ID and origin. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.s3OriginIds">s3_origin_ids</a></code> | <code>typing.List[str]</code> | Get all S3 bucket origin IDs. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.s3Origins">s3_origins</a></code> | <code>typing.List[S3OriginInfo](#must-cdk.S3OriginInfo)</code> | Get all S3 buckets as an array of objects with ID and bucket. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.certificate">certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.customDomainUrl">custom_domain_url</a></code> | <code>str</code> | Get the custom domain URL (if configured). |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.domainNames">domain_names</a></code> | <code>typing.List[str]</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.logBucket">log_bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.CloudFrontToOrigins.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `a_records`<sup>Required</sup> <a name="a_records" id="must-cdk.CloudFrontToOrigins.property.aRecords"></a>

```python
a_records: typing.List[ARecord]
```

- *Type:* typing.List[aws_cdk.aws_route53.ARecord]

---

##### `distribution`<sup>Required</sup> <a name="distribution" id="must-cdk.CloudFrontToOrigins.property.distribution"></a>

```python
distribution: Distribution
```

- *Type:* aws_cdk.aws_cloudfront.Distribution

---

##### `distribution_domain_name`<sup>Required</sup> <a name="distribution_domain_name" id="must-cdk.CloudFrontToOrigins.property.distributionDomainName"></a>

```python
distribution_domain_name: str
```

- *Type:* str

Get the CloudFront distribution domain name.

---

##### `distribution_url`<sup>Required</sup> <a name="distribution_url" id="must-cdk.CloudFrontToOrigins.property.distributionUrl"></a>

```python
distribution_url: str
```

- *Type:* str

Get the CloudFront distribution URL with protocol.

---

##### `http_origin_ids`<sup>Required</sup> <a name="http_origin_ids" id="must-cdk.CloudFrontToOrigins.property.httpOriginIds"></a>

```python
http_origin_ids: typing.List[str]
```

- *Type:* typing.List[str]

Get all HTTP origin IDs.

---

##### `http_origins`<sup>Required</sup> <a name="http_origins" id="must-cdk.CloudFrontToOrigins.property.httpOrigins"></a>

```python
http_origins: typing.List[HttpOriginInfo]
```

- *Type:* typing.List[HttpOriginInfo](#must-cdk.HttpOriginInfo)

Get all HTTP origins as an array of objects with ID and origin.

---

##### `s3_origin_ids`<sup>Required</sup> <a name="s3_origin_ids" id="must-cdk.CloudFrontToOrigins.property.s3OriginIds"></a>

```python
s3_origin_ids: typing.List[str]
```

- *Type:* typing.List[str]

Get all S3 bucket origin IDs.

---

##### `s3_origins`<sup>Required</sup> <a name="s3_origins" id="must-cdk.CloudFrontToOrigins.property.s3Origins"></a>

```python
s3_origins: typing.List[S3OriginInfo]
```

- *Type:* typing.List[S3OriginInfo](#must-cdk.S3OriginInfo)

Get all S3 buckets as an array of objects with ID and bucket.

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.CloudFrontToOrigins.property.certificate"></a>

```python
certificate: ICertificate
```

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

---

##### `custom_domain_url`<sup>Optional</sup> <a name="custom_domain_url" id="must-cdk.CloudFrontToOrigins.property.customDomainUrl"></a>

```python
custom_domain_url: str
```

- *Type:* str

Get the custom domain URL (if configured).

---

##### `domain_names`<sup>Optional</sup> <a name="domain_names" id="must-cdk.CloudFrontToOrigins.property.domainNames"></a>

```python
domain_names: typing.List[str]
```

- *Type:* typing.List[str]

---

##### `log_bucket`<sup>Optional</sup> <a name="log_bucket" id="must-cdk.CloudFrontToOrigins.property.logBucket"></a>

```python
log_bucket: IBucket
```

- *Type:* aws_cdk.aws_s3.IBucket

---


### CacheBehaviorConfig <a name="CacheBehaviorConfig" id="must-cdk.CacheBehaviorConfig"></a>

#### Initializer <a name="Initializer" id="must-cdk.CacheBehaviorConfig.Initializer"></a>

```python
import must_cdk

must_cdk.CacheBehaviorConfig(
  origin_id: str,
  path_pattern: str,
  allowed_methods: AllowedMethods = None,
  cached_methods: CachedMethods = None,
  cache_policy: ICachePolicy = None,
  cache_policy_id: str = None,
  compress: bool = None,
  origin_request_policy: IOriginRequestPolicy = None,
  origin_request_policy_id: str = None,
  response_headers_policy: IResponseHeadersPolicy = None,
  response_headers_policy_id: str = None,
  viewer_protocol_policy: ViewerProtocolPolicy = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.originId">origin_id</a></code> | <code>str</code> | Origin ID to route this pattern to. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.pathPattern">path_pattern</a></code> | <code>str</code> | Path pattern for this behavior (e.g., "/api/*", "*.jpg"). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.allowedMethods">allowed_methods</a></code> | <code>aws_cdk.aws_cloudfront.AllowedMethods</code> | Allowed HTTP methods. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.cachedMethods">cached_methods</a></code> | <code>aws_cdk.aws_cloudfront.CachedMethods</code> | Methods to cache. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.cachePolicy">cache_policy</a></code> | <code>aws_cdk.aws_cloudfront.ICachePolicy</code> | Cache policy (alternative to cachePolicyId). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.cachePolicyId">cache_policy_id</a></code> | <code>str</code> | Cache policy ID (use AWS managed policies). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.compress">compress</a></code> | <code>bool</code> | Enable compression. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.originRequestPolicy">origin_request_policy</a></code> | <code>aws_cdk.aws_cloudfront.IOriginRequestPolicy</code> | Origin request policy (alternative to originRequestPolicyId). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.originRequestPolicyId">origin_request_policy_id</a></code> | <code>str</code> | Origin request policy ID. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.responseHeadersPolicy">response_headers_policy</a></code> | <code>aws_cdk.aws_cloudfront.IResponseHeadersPolicy</code> | Response headers policy (alternative to responseHeadersPolicyId). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.responseHeadersPolicyId">response_headers_policy_id</a></code> | <code>str</code> | Response headers policy ID. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.viewerProtocolPolicy">viewer_protocol_policy</a></code> | <code>aws_cdk.aws_cloudfront.ViewerProtocolPolicy</code> | Viewer protocol policy. |

---

##### `origin_id`<sup>Required</sup> <a name="origin_id" id="must-cdk.CacheBehaviorConfig.property.originId"></a>

```python
origin_id: str
```

- *Type:* str

Origin ID to route this pattern to.

---

##### `path_pattern`<sup>Required</sup> <a name="path_pattern" id="must-cdk.CacheBehaviorConfig.property.pathPattern"></a>

```python
path_pattern: str
```

- *Type:* str

Path pattern for this behavior (e.g., "/api/*", "*.jpg").

---

##### `allowed_methods`<sup>Optional</sup> <a name="allowed_methods" id="must-cdk.CacheBehaviorConfig.property.allowedMethods"></a>

```python
allowed_methods: AllowedMethods
```

- *Type:* aws_cdk.aws_cloudfront.AllowedMethods
- *Default:* ALLOW_GET_HEAD for S3, ALLOW_ALL for HTTP

Allowed HTTP methods.

---

##### `cached_methods`<sup>Optional</sup> <a name="cached_methods" id="must-cdk.CacheBehaviorConfig.property.cachedMethods"></a>

```python
cached_methods: CachedMethods
```

- *Type:* aws_cdk.aws_cloudfront.CachedMethods
- *Default:* CACHE_GET_HEAD_OPTIONS

Methods to cache.

---

##### `cache_policy`<sup>Optional</sup> <a name="cache_policy" id="must-cdk.CacheBehaviorConfig.property.cachePolicy"></a>

```python
cache_policy: ICachePolicy
```

- *Type:* aws_cdk.aws_cloudfront.ICachePolicy

Cache policy (alternative to cachePolicyId).

---

##### `cache_policy_id`<sup>Optional</sup> <a name="cache_policy_id" id="must-cdk.CacheBehaviorConfig.property.cachePolicyId"></a>

```python
cache_policy_id: str
```

- *Type:* str

Cache policy ID (use AWS managed policies).

---

##### `compress`<sup>Optional</sup> <a name="compress" id="must-cdk.CacheBehaviorConfig.property.compress"></a>

```python
compress: bool
```

- *Type:* bool
- *Default:* true

Enable compression.

---

##### `origin_request_policy`<sup>Optional</sup> <a name="origin_request_policy" id="must-cdk.CacheBehaviorConfig.property.originRequestPolicy"></a>

```python
origin_request_policy: IOriginRequestPolicy
```

- *Type:* aws_cdk.aws_cloudfront.IOriginRequestPolicy

Origin request policy (alternative to originRequestPolicyId).

---

##### `origin_request_policy_id`<sup>Optional</sup> <a name="origin_request_policy_id" id="must-cdk.CacheBehaviorConfig.property.originRequestPolicyId"></a>

```python
origin_request_policy_id: str
```

- *Type:* str

Origin request policy ID.

---

##### `response_headers_policy`<sup>Optional</sup> <a name="response_headers_policy" id="must-cdk.CacheBehaviorConfig.property.responseHeadersPolicy"></a>

```python
response_headers_policy: IResponseHeadersPolicy
```

- *Type:* aws_cdk.aws_cloudfront.IResponseHeadersPolicy

Response headers policy (alternative to responseHeadersPolicyId).

---

##### `response_headers_policy_id`<sup>Optional</sup> <a name="response_headers_policy_id" id="must-cdk.CacheBehaviorConfig.property.responseHeadersPolicyId"></a>

```python
response_headers_policy_id: str
```

- *Type:* str

Response headers policy ID.

---

##### `viewer_protocol_policy`<sup>Optional</sup> <a name="viewer_protocol_policy" id="must-cdk.CacheBehaviorConfig.property.viewerProtocolPolicy"></a>

```python
viewer_protocol_policy: ViewerProtocolPolicy
```

- *Type:* aws_cdk.aws_cloudfront.ViewerProtocolPolicy
- *Default:* REDIRECT_TO_HTTPS

Viewer protocol policy.

---

### CloudFrontToOriginsProps <a name="CloudFrontToOriginsProps" id="must-cdk.CloudFrontToOriginsProps"></a>

#### Initializer <a name="Initializer" id="must-cdk.CloudFrontToOriginsProps.Initializer"></a>

```python
import must_cdk

must_cdk.CloudFrontToOriginsProps(
  additional_domain_names: typing.List[str] = None,
  cache_behaviors: typing.List[CacheBehaviorConfig] = None,
  certificate: ICertificate = None,
  comment: str = None,
  create_route53_records: bool = None,
  custom_domain_name: str = None,
  default_origin_id: str = None,
  default_root_object: str = None,
  enabled: bool = None,
  enable_ipv6: bool = None,
  enable_logging: bool = None,
  error_pages: typing.List[ErrorResponse] = None,
  geo_restriction: GeoRestriction = None,
  hosted_zone: IHostedZone = None,
  http_origins: typing.List[HttpOriginConfig] = None,
  http_version: HttpVersion = None,
  log_bucket: IBucket = None,
  log_include_cookies: bool = None,
  log_prefix: str = None,
  price_class: PriceClass = None,
  s3_origins: typing.List[S3OriginConfig] = None,
  web_acl_id: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.additionalDomainNames">additional_domain_names</a></code> | <code>typing.List[str]</code> | Additional domain names (aliases) for the distribution Note: All domains must be covered by the same certificate. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.cacheBehaviors">cache_behaviors</a></code> | <code>typing.List[CacheBehaviorConfig](#must-cdk.CacheBehaviorConfig)</code> | Cache behaviors for specific path patterns. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.certificate">certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | Existing ACM certificate to use for the CloudFront distribution Certificate must be in us-east-1 region for CloudFront. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.comment">comment</a></code> | <code>str</code> | Comment for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.createRoute53Records">create_route53_records</a></code> | <code>bool</code> | Create Route53 records for all domain names. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.customDomainName">custom_domain_name</a></code> | <code>str</code> | Primary custom domain name for the CloudFront distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.defaultOriginId">default_origin_id</a></code> | <code>str</code> | ID of the origin to use as default behavior If not specified, will use the first HTTP origin, then first S3 origin. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.defaultRootObject">default_root_object</a></code> | <code>str</code> | Default root object for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.enabled">enabled</a></code> | <code>bool</code> | Whether the distribution is enabled. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.enableIpv6">enable_ipv6</a></code> | <code>bool</code> | Enable IPv6 for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.enableLogging">enable_logging</a></code> | <code>bool</code> | Enable CloudFront access logging. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.errorPages">error_pages</a></code> | <code>typing.List[aws_cdk.aws_cloudfront.ErrorResponse]</code> | Custom error page configurations If not provided, intelligent defaults will be applied based on origin types. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.geoRestriction">geo_restriction</a></code> | <code>aws_cdk.aws_cloudfront.GeoRestriction</code> | Geographic restriction configuration. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.hostedZone">hosted_zone</a></code> | <code>aws_cdk.aws_route53.IHostedZone</code> | Route53 hosted zone for the custom domain Required for creating Route53 records. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.httpOrigins">http_origins</a></code> | <code>typing.List[HttpOriginConfig](#must-cdk.HttpOriginConfig)</code> | HTTP origins configuration. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.httpVersion">http_version</a></code> | <code>aws_cdk.aws_cloudfront.HttpVersion</code> | HTTP version to support. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.logBucket">log_bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | Existing S3 bucket for logs If not provided and logging is enabled, a new bucket will be created. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.logIncludeCookies">log_include_cookies</a></code> | <code>bool</code> | Include cookies in access logs. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.logPrefix">log_prefix</a></code> | <code>str</code> | Prefix for log files. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.priceClass">price_class</a></code> | <code>aws_cdk.aws_cloudfront.PriceClass</code> | CloudFront distribution price class. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.s3Origins">s3_origins</a></code> | <code>typing.List[S3OriginConfig](#must-cdk.S3OriginConfig)</code> | S3 origins configuration. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.webAclId">web_acl_id</a></code> | <code>str</code> | Web Application Firewall (WAF) web ACL ID. |

---

##### `additional_domain_names`<sup>Optional</sup> <a name="additional_domain_names" id="must-cdk.CloudFrontToOriginsProps.property.additionalDomainNames"></a>

```python
additional_domain_names: typing.List[str]
```

- *Type:* typing.List[str]

Additional domain names (aliases) for the distribution Note: All domains must be covered by the same certificate.

CloudFront only supports one certificate per distribution.

---

##### `cache_behaviors`<sup>Optional</sup> <a name="cache_behaviors" id="must-cdk.CloudFrontToOriginsProps.property.cacheBehaviors"></a>

```python
cache_behaviors: typing.List[CacheBehaviorConfig]
```

- *Type:* typing.List[CacheBehaviorConfig](#must-cdk.CacheBehaviorConfig)

Cache behaviors for specific path patterns.

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.CloudFrontToOriginsProps.property.certificate"></a>

```python
certificate: ICertificate
```

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

Existing ACM certificate to use for the CloudFront distribution Certificate must be in us-east-1 region for CloudFront.

The certificate must cover all domains (customDomainName + additionalDomainNames).
CloudFront only supports one certificate per distribution.

---

##### `comment`<sup>Optional</sup> <a name="comment" id="must-cdk.CloudFrontToOriginsProps.property.comment"></a>

```python
comment: str
```

- *Type:* str

Comment for the distribution.

---

##### `create_route53_records`<sup>Optional</sup> <a name="create_route53_records" id="must-cdk.CloudFrontToOriginsProps.property.createRoute53Records"></a>

```python
create_route53_records: bool
```

- *Type:* bool
- *Default:* true if hostedZone is provided

Create Route53 records for all domain names.

---

##### `custom_domain_name`<sup>Optional</sup> <a name="custom_domain_name" id="must-cdk.CloudFrontToOriginsProps.property.customDomainName"></a>

```python
custom_domain_name: str
```

- *Type:* str

Primary custom domain name for the CloudFront distribution.

---

##### `default_origin_id`<sup>Optional</sup> <a name="default_origin_id" id="must-cdk.CloudFrontToOriginsProps.property.defaultOriginId"></a>

```python
default_origin_id: str
```

- *Type:* str

ID of the origin to use as default behavior If not specified, will use the first HTTP origin, then first S3 origin.

---

##### `default_root_object`<sup>Optional</sup> <a name="default_root_object" id="must-cdk.CloudFrontToOriginsProps.property.defaultRootObject"></a>

```python
default_root_object: str
```

- *Type:* str
- *Default:* "index.html"

Default root object for the distribution.

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="must-cdk.CloudFrontToOriginsProps.property.enabled"></a>

```python
enabled: bool
```

- *Type:* bool
- *Default:* true

Whether the distribution is enabled.

---

##### `enable_ipv6`<sup>Optional</sup> <a name="enable_ipv6" id="must-cdk.CloudFrontToOriginsProps.property.enableIpv6"></a>

```python
enable_ipv6: bool
```

- *Type:* bool
- *Default:* false

Enable IPv6 for the distribution.

---

##### `enable_logging`<sup>Optional</sup> <a name="enable_logging" id="must-cdk.CloudFrontToOriginsProps.property.enableLogging"></a>

```python
enable_logging: bool
```

- *Type:* bool
- *Default:* true

Enable CloudFront access logging.

---

##### `error_pages`<sup>Optional</sup> <a name="error_pages" id="must-cdk.CloudFrontToOriginsProps.property.errorPages"></a>

```python
error_pages: typing.List[ErrorResponse]
```

- *Type:* typing.List[aws_cdk.aws_cloudfront.ErrorResponse]

Custom error page configurations If not provided, intelligent defaults will be applied based on origin types.

---

##### `geo_restriction`<sup>Optional</sup> <a name="geo_restriction" id="must-cdk.CloudFrontToOriginsProps.property.geoRestriction"></a>

```python
geo_restriction: GeoRestriction
```

- *Type:* aws_cdk.aws_cloudfront.GeoRestriction

Geographic restriction configuration.

---

##### `hosted_zone`<sup>Optional</sup> <a name="hosted_zone" id="must-cdk.CloudFrontToOriginsProps.property.hostedZone"></a>

```python
hosted_zone: IHostedZone
```

- *Type:* aws_cdk.aws_route53.IHostedZone

Route53 hosted zone for the custom domain Required for creating Route53 records.

---

##### `http_origins`<sup>Optional</sup> <a name="http_origins" id="must-cdk.CloudFrontToOriginsProps.property.httpOrigins"></a>

```python
http_origins: typing.List[HttpOriginConfig]
```

- *Type:* typing.List[HttpOriginConfig](#must-cdk.HttpOriginConfig)

HTTP origins configuration.

---

##### `http_version`<sup>Optional</sup> <a name="http_version" id="must-cdk.CloudFrontToOriginsProps.property.httpVersion"></a>

```python
http_version: HttpVersion
```

- *Type:* aws_cdk.aws_cloudfront.HttpVersion
- *Default:* HttpVersion.HTTP2

HTTP version to support.

---

##### `log_bucket`<sup>Optional</sup> <a name="log_bucket" id="must-cdk.CloudFrontToOriginsProps.property.logBucket"></a>

```python
log_bucket: IBucket
```

- *Type:* aws_cdk.aws_s3.IBucket

Existing S3 bucket for logs If not provided and logging is enabled, a new bucket will be created.

---

##### `log_include_cookies`<sup>Optional</sup> <a name="log_include_cookies" id="must-cdk.CloudFrontToOriginsProps.property.logIncludeCookies"></a>

```python
log_include_cookies: bool
```

- *Type:* bool
- *Default:* false

Include cookies in access logs.

---

##### `log_prefix`<sup>Optional</sup> <a name="log_prefix" id="must-cdk.CloudFrontToOriginsProps.property.logPrefix"></a>

```python
log_prefix: str
```

- *Type:* str
- *Default:* "cloudfront"

Prefix for log files.

---

##### `price_class`<sup>Optional</sup> <a name="price_class" id="must-cdk.CloudFrontToOriginsProps.property.priceClass"></a>

```python
price_class: PriceClass
```

- *Type:* aws_cdk.aws_cloudfront.PriceClass
- *Default:* PRICE_CLASS_100

CloudFront distribution price class.

---

##### `s3_origins`<sup>Optional</sup> <a name="s3_origins" id="must-cdk.CloudFrontToOriginsProps.property.s3Origins"></a>

```python
s3_origins: typing.List[S3OriginConfig]
```

- *Type:* typing.List[S3OriginConfig](#must-cdk.S3OriginConfig)

S3 origins configuration.

---

##### `web_acl_id`<sup>Optional</sup> <a name="web_acl_id" id="must-cdk.CloudFrontToOriginsProps.property.webAclId"></a>

```python
web_acl_id: str
```

- *Type:* str

Web Application Firewall (WAF) web ACL ID.

---

### HttpOriginConfig <a name="HttpOriginConfig" id="must-cdk.HttpOriginConfig"></a>

#### Initializer <a name="Initializer" id="must-cdk.HttpOriginConfig.Initializer"></a>

```python
import must_cdk

must_cdk.HttpOriginConfig(
  domain_name: str,
  id: str,
  http_origin_props: HttpOriginProps = None,
  http_port: typing.Union[int, float] = None,
  https_port: typing.Union[int, float] = None,
  origin_path: str = None,
  protocol_policy: OriginProtocolPolicy = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.HttpOriginConfig.property.domainName">domain_name</a></code> | <code>str</code> | Domain name of the HTTP origin (required). |
| <code><a href="#must-cdk.HttpOriginConfig.property.id">id</a></code> | <code>str</code> | Unique identifier for this HTTP origin. |
| <code><a href="#must-cdk.HttpOriginConfig.property.httpOriginProps">http_origin_props</a></code> | <code>aws_cdk.aws_cloudfront_origins.HttpOriginProps</code> | Additional HTTP origin properties. |
| <code><a href="#must-cdk.HttpOriginConfig.property.httpPort">http_port</a></code> | <code>typing.Union[int, float]</code> | HTTP port (for HTTP protocol). |
| <code><a href="#must-cdk.HttpOriginConfig.property.httpsPort">https_port</a></code> | <code>typing.Union[int, float]</code> | HTTPS port (for HTTPS protocol). |
| <code><a href="#must-cdk.HttpOriginConfig.property.originPath">origin_path</a></code> | <code>str</code> | Origin path for HTTP requests (e.g., "/api/v1"). |
| <code><a href="#must-cdk.HttpOriginConfig.property.protocolPolicy">protocol_policy</a></code> | <code>aws_cdk.aws_cloudfront.OriginProtocolPolicy</code> | Protocol policy for the origin. |

---

##### `domain_name`<sup>Required</sup> <a name="domain_name" id="must-cdk.HttpOriginConfig.property.domainName"></a>

```python
domain_name: str
```

- *Type:* str

Domain name of the HTTP origin (required).

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.HttpOriginConfig.property.id"></a>

```python
id: str
```

- *Type:* str

Unique identifier for this HTTP origin.

---

##### `http_origin_props`<sup>Optional</sup> <a name="http_origin_props" id="must-cdk.HttpOriginConfig.property.httpOriginProps"></a>

```python
http_origin_props: HttpOriginProps
```

- *Type:* aws_cdk.aws_cloudfront_origins.HttpOriginProps

Additional HTTP origin properties.

---

##### `http_port`<sup>Optional</sup> <a name="http_port" id="must-cdk.HttpOriginConfig.property.httpPort"></a>

```python
http_port: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* 80

HTTP port (for HTTP protocol).

---

##### `https_port`<sup>Optional</sup> <a name="https_port" id="must-cdk.HttpOriginConfig.property.httpsPort"></a>

```python
https_port: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* 443

HTTPS port (for HTTPS protocol).

---

##### `origin_path`<sup>Optional</sup> <a name="origin_path" id="must-cdk.HttpOriginConfig.property.originPath"></a>

```python
origin_path: str
```

- *Type:* str

Origin path for HTTP requests (e.g., "/api/v1").

---

##### `protocol_policy`<sup>Optional</sup> <a name="protocol_policy" id="must-cdk.HttpOriginConfig.property.protocolPolicy"></a>

```python
protocol_policy: OriginProtocolPolicy
```

- *Type:* aws_cdk.aws_cloudfront.OriginProtocolPolicy
- *Default:* HTTPS_ONLY

Protocol policy for the origin.

---

### HttpOriginInfo <a name="HttpOriginInfo" id="must-cdk.HttpOriginInfo"></a>

HTTP origin information.

#### Initializer <a name="Initializer" id="must-cdk.HttpOriginInfo.Initializer"></a>

```python
import must_cdk

must_cdk.HttpOriginInfo(
  id: str,
  origin: HttpOrigin
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.HttpOriginInfo.property.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.HttpOriginInfo.property.origin">origin</a></code> | <code>aws_cdk.aws_cloudfront_origins.HttpOrigin</code> | *No description.* |

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.HttpOriginInfo.property.id"></a>

```python
id: str
```

- *Type:* str

---

##### `origin`<sup>Required</sup> <a name="origin" id="must-cdk.HttpOriginInfo.property.origin"></a>

```python
origin: HttpOrigin
```

- *Type:* aws_cdk.aws_cloudfront_origins.HttpOrigin

---

### S3OriginConfig <a name="S3OriginConfig" id="must-cdk.S3OriginConfig"></a>

#### Initializer <a name="Initializer" id="must-cdk.S3OriginConfig.Initializer"></a>

```python
import must_cdk

must_cdk.S3OriginConfig(
  bucket: IBucket,
  id: str,
  origin_access_identity: OriginAccessIdentity = None,
  origin_path: str = None,
  s3_origin_props: S3OriginProps = None,
  use_legacy_oa_i: bool = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.S3OriginConfig.property.bucket">bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | Existing S3 bucket to use as origin (required). |
| <code><a href="#must-cdk.S3OriginConfig.property.id">id</a></code> | <code>str</code> | Unique identifier for this S3 origin. |
| <code><a href="#must-cdk.S3OriginConfig.property.originAccessIdentity">origin_access_identity</a></code> | <code>aws_cdk.aws_cloudfront.OriginAccessIdentity</code> | Existing Origin Access Identity (only used if useLegacyOAI is true). |
| <code><a href="#must-cdk.S3OriginConfig.property.originPath">origin_path</a></code> | <code>str</code> | Origin path for S3 requests (e.g., "/static"). |
| <code><a href="#must-cdk.S3OriginConfig.property.s3OriginProps">s3_origin_props</a></code> | <code>aws_cdk.aws_cloudfront_origins.S3OriginProps</code> | Additional S3 origin properties. |
| <code><a href="#must-cdk.S3OriginConfig.property.useLegacyOAI">use_legacy_oa_i</a></code> | <code>bool</code> | Use legacy Origin Access Identity instead of modern Origin Access Control. |

---

##### `bucket`<sup>Required</sup> <a name="bucket" id="must-cdk.S3OriginConfig.property.bucket"></a>

```python
bucket: IBucket
```

- *Type:* aws_cdk.aws_s3.IBucket

Existing S3 bucket to use as origin (required).

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.S3OriginConfig.property.id"></a>

```python
id: str
```

- *Type:* str

Unique identifier for this S3 origin.

---

##### `origin_access_identity`<sup>Optional</sup> <a name="origin_access_identity" id="must-cdk.S3OriginConfig.property.originAccessIdentity"></a>

```python
origin_access_identity: OriginAccessIdentity
```

- *Type:* aws_cdk.aws_cloudfront.OriginAccessIdentity

Existing Origin Access Identity (only used if useLegacyOAI is true).

---

##### `origin_path`<sup>Optional</sup> <a name="origin_path" id="must-cdk.S3OriginConfig.property.originPath"></a>

```python
origin_path: str
```

- *Type:* str

Origin path for S3 requests (e.g., "/static").

---

##### `s3_origin_props`<sup>Optional</sup> <a name="s3_origin_props" id="must-cdk.S3OriginConfig.property.s3OriginProps"></a>

```python
s3_origin_props: S3OriginProps
```

- *Type:* aws_cdk.aws_cloudfront_origins.S3OriginProps

Additional S3 origin properties.

---

##### `use_legacy_oa_i`<sup>Optional</sup> <a name="use_legacy_oa_i" id="must-cdk.S3OriginConfig.property.useLegacyOAI"></a>

```python
use_legacy_oa_i: bool
```

- *Type:* bool
- *Default:* false - uses OAC for better security

Use legacy Origin Access Identity instead of modern Origin Access Control.

---

### S3OriginInfo <a name="S3OriginInfo" id="must-cdk.S3OriginInfo"></a>

S3 origin information.

#### Initializer <a name="Initializer" id="must-cdk.S3OriginInfo.Initializer"></a>

```python
import must_cdk

must_cdk.S3OriginInfo(
  bucket: IBucket,
  id: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.S3OriginInfo.property.bucket">bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | *No description.* |
| <code><a href="#must-cdk.S3OriginInfo.property.id">id</a></code> | <code>str</code> | *No description.* |

---

##### `bucket`<sup>Required</sup> <a name="bucket" id="must-cdk.S3OriginInfo.property.bucket"></a>

```python
bucket: IBucket
```

- *Type:* aws_cdk.aws_s3.IBucket

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.S3OriginInfo.property.id"></a>

```python
id: str
```

- *Type:* str

---

