# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### EcsCodeDeploy <a name="EcsCodeDeploy" id="must-cdk.EcsCodeDeploy"></a>

#### Initializers <a name="Initializers" id="must-cdk.EcsCodeDeploy.Initializer"></a>

```python
import must_cdk

must_cdk.EcsCodeDeploy(
  scope: Construct,
  id: str,
  certificates: typing.List[ICertificate],
  cluster: ICluster,
  containers: typing.List[ContainerProps],
  security_groups: typing.List[ISecurityGroup],
  service_name: str,
  subnets: SubnetSelection,
  vpc: IVpc,
  alb_target_port: typing.Union[int, float] = None,
  auto_scaling: AutoScalingProps = None,
  enable_public_load_balancer: bool = None,
  memory_limit: typing.Union[int, float] = None,
  task_cp_u: typing.Union[int, float] = None,
  task_exec_role: IRole = None,
  task_role: IRole = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.certificates">certificates</a></code> | <code>typing.List[aws_cdk.aws_certificatemanager.ICertificate]</code> | Optional ACM certificates for HTTPS termination. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.cluster">cluster</a></code> | <code>aws_cdk.aws_ecs.ICluster</code> | ECS Cluster where the service will run. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.containers">containers</a></code> | <code>typing.List[ContainerProps](#must-cdk.ContainerProps)</code> | Configuration related to the task definition and container. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.securityGroups">security_groups</a></code> | <code>typing.List[aws_cdk.aws_ec2.ISecurityGroup]</code> | Security group config. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.serviceName">service_name</a></code> | <code>str</code> | Base name used for resources like log groups, roles, services, etc. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.subnets">subnets</a></code> | <code>aws_cdk.aws_ec2.SubnetSelection</code> | Select which subnets the Service and ALB will placed on. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.vpc">vpc</a></code> | <code>aws_cdk.aws_ec2.IVpc</code> | VPC in which to deploy ECS and ALB resources. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.albTargetPort">alb_target_port</a></code> | <code>typing.Union[int, float]</code> | The ALB target port. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.autoScaling">auto_scaling</a></code> | <code><a href="#must-cdk.AutoScalingProps">AutoScalingProps</a></code> | Optional auto-scaling configuration. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.enablePublicLoadBalancer">enable_public_load_balancer</a></code> | <code>bool</code> | Whether the load balancer should be internet-facing (default: false). |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.memoryLimit">memory_limit</a></code> | <code>typing.Union[int, float]</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.taskCPU">task_cp_u</a></code> | <code>typing.Union[int, float]</code> | CPU units for the task (default: 1024). |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.taskExecRole">task_exec_role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | Task execution role for the ECS task. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.taskRole">task_role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | Task role for the ECS task. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.EcsCodeDeploy.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.EcsCodeDeploy.Initializer.parameter.id"></a>

- *Type:* str

---

##### `certificates`<sup>Required</sup> <a name="certificates" id="must-cdk.EcsCodeDeploy.Initializer.parameter.certificates"></a>

- *Type:* typing.List[aws_cdk.aws_certificatemanager.ICertificate]

Optional ACM certificates for HTTPS termination.

---

##### `cluster`<sup>Required</sup> <a name="cluster" id="must-cdk.EcsCodeDeploy.Initializer.parameter.cluster"></a>

- *Type:* aws_cdk.aws_ecs.ICluster

ECS Cluster where the service will run.

---

##### `containers`<sup>Required</sup> <a name="containers" id="must-cdk.EcsCodeDeploy.Initializer.parameter.containers"></a>

- *Type:* typing.List[ContainerProps](#must-cdk.ContainerProps)

Configuration related to the task definition and container.

---

##### `security_groups`<sup>Required</sup> <a name="security_groups" id="must-cdk.EcsCodeDeploy.Initializer.parameter.securityGroups"></a>

- *Type:* typing.List[aws_cdk.aws_ec2.ISecurityGroup]

Security group config.

---

##### `service_name`<sup>Required</sup> <a name="service_name" id="must-cdk.EcsCodeDeploy.Initializer.parameter.serviceName"></a>

- *Type:* str

Base name used for resources like log groups, roles, services, etc.

---

##### `subnets`<sup>Required</sup> <a name="subnets" id="must-cdk.EcsCodeDeploy.Initializer.parameter.subnets"></a>

- *Type:* aws_cdk.aws_ec2.SubnetSelection

Select which subnets the Service and ALB will placed on.

---

##### `vpc`<sup>Required</sup> <a name="vpc" id="must-cdk.EcsCodeDeploy.Initializer.parameter.vpc"></a>

- *Type:* aws_cdk.aws_ec2.IVpc

VPC in which to deploy ECS and ALB resources.

---

##### `alb_target_port`<sup>Optional</sup> <a name="alb_target_port" id="must-cdk.EcsCodeDeploy.Initializer.parameter.albTargetPort"></a>

- *Type:* typing.Union[int, float]

The ALB target port.

---

##### `auto_scaling`<sup>Optional</sup> <a name="auto_scaling" id="must-cdk.EcsCodeDeploy.Initializer.parameter.autoScaling"></a>

- *Type:* <a href="#must-cdk.AutoScalingProps">AutoScalingProps</a>

Optional auto-scaling configuration.

---

##### `enable_public_load_balancer`<sup>Optional</sup> <a name="enable_public_load_balancer" id="must-cdk.EcsCodeDeploy.Initializer.parameter.enablePublicLoadBalancer"></a>

- *Type:* bool

Whether the load balancer should be internet-facing (default: false).

---

##### `memory_limit`<sup>Optional</sup> <a name="memory_limit" id="must-cdk.EcsCodeDeploy.Initializer.parameter.memoryLimit"></a>

- *Type:* typing.Union[int, float]

---

##### `task_cp_u`<sup>Optional</sup> <a name="task_cp_u" id="must-cdk.EcsCodeDeploy.Initializer.parameter.taskCPU"></a>

- *Type:* typing.Union[int, float]

CPU units for the task (default: 1024).

---

##### `task_exec_role`<sup>Optional</sup> <a name="task_exec_role" id="must-cdk.EcsCodeDeploy.Initializer.parameter.taskExecRole"></a>

- *Type:* aws_cdk.aws_iam.IRole

Task execution role for the ECS task.

---

##### `task_role`<sup>Optional</sup> <a name="task_role" id="must-cdk.EcsCodeDeploy.Initializer.parameter.taskRole"></a>

- *Type:* aws_cdk.aws_iam.IRole

Task role for the ECS task.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.EcsCodeDeploy.allListeners">all_listeners</a></code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.blueListener">blue_listener</a></code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.greenListener">green_listener</a></code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.loadBalancerDnsName">load_balancer_dns_name</a></code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.serviceArn">service_arn</a></code> | *No description.* |

---

##### `to_string` <a name="to_string" id="must-cdk.EcsCodeDeploy.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `all_listeners` <a name="all_listeners" id="must-cdk.EcsCodeDeploy.allListeners"></a>

```python
def all_listeners() -> typing.List[ApplicationListener]
```

##### `blue_listener` <a name="blue_listener" id="must-cdk.EcsCodeDeploy.blueListener"></a>

```python
def blue_listener() -> ApplicationListener
```

##### `green_listener` <a name="green_listener" id="must-cdk.EcsCodeDeploy.greenListener"></a>

```python
def green_listener() -> ApplicationListener
```

##### `load_balancer_dns_name` <a name="load_balancer_dns_name" id="must-cdk.EcsCodeDeploy.loadBalancerDnsName"></a>

```python
def load_balancer_dns_name() -> str
```

##### `service_arn` <a name="service_arn" id="must-cdk.EcsCodeDeploy.serviceArn"></a>

```python
def service_arn() -> str
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### ~~`is_construct`~~ <a name="is_construct" id="must-cdk.EcsCodeDeploy.isConstruct"></a>

```python
import must_cdk

must_cdk.EcsCodeDeploy.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.EcsCodeDeploy.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.EcsCodeDeploy.property.blueTargetGroup">blue_target_group</a></code> | <code>aws_cdk.aws_elasticloadbalancingv2.ApplicationTargetGroup</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.codeDeployApp">code_deploy_app</a></code> | <code>aws_cdk.aws_codedeploy.EcsApplication</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.greenTargetGroup">green_target_group</a></code> | <code>aws_cdk.aws_elasticloadbalancingv2.ApplicationTargetGroup</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.loadBalancer">load_balancer</a></code> | <code>aws_cdk.aws_elasticloadbalancingv2.ApplicationLoadBalancer</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.service">service</a></code> | <code>aws_cdk.aws_ecs.FargateService</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.taskDef">task_def</a></code> | <code>aws_cdk.aws_ecs.TaskDefinition</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.taskExecutionRole">task_execution_role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.taskRole">task_role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.EcsCodeDeploy.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `blue_target_group`<sup>Required</sup> <a name="blue_target_group" id="must-cdk.EcsCodeDeploy.property.blueTargetGroup"></a>

```python
blue_target_group: ApplicationTargetGroup
```

- *Type:* aws_cdk.aws_elasticloadbalancingv2.ApplicationTargetGroup

---

##### `code_deploy_app`<sup>Required</sup> <a name="code_deploy_app" id="must-cdk.EcsCodeDeploy.property.codeDeployApp"></a>

```python
code_deploy_app: EcsApplication
```

- *Type:* aws_cdk.aws_codedeploy.EcsApplication

---

##### `green_target_group`<sup>Required</sup> <a name="green_target_group" id="must-cdk.EcsCodeDeploy.property.greenTargetGroup"></a>

```python
green_target_group: ApplicationTargetGroup
```

- *Type:* aws_cdk.aws_elasticloadbalancingv2.ApplicationTargetGroup

---

##### `load_balancer`<sup>Required</sup> <a name="load_balancer" id="must-cdk.EcsCodeDeploy.property.loadBalancer"></a>

```python
load_balancer: ApplicationLoadBalancer
```

- *Type:* aws_cdk.aws_elasticloadbalancingv2.ApplicationLoadBalancer

---

##### `service`<sup>Required</sup> <a name="service" id="must-cdk.EcsCodeDeploy.property.service"></a>

```python
service: FargateService
```

- *Type:* aws_cdk.aws_ecs.FargateService

---

##### `task_def`<sup>Required</sup> <a name="task_def" id="must-cdk.EcsCodeDeploy.property.taskDef"></a>

```python
task_def: TaskDefinition
```

- *Type:* aws_cdk.aws_ecs.TaskDefinition

---

##### `task_execution_role`<sup>Required</sup> <a name="task_execution_role" id="must-cdk.EcsCodeDeploy.property.taskExecutionRole"></a>

```python
task_execution_role: IRole
```

- *Type:* aws_cdk.aws_iam.IRole

---

##### `task_role`<sup>Required</sup> <a name="task_role" id="must-cdk.EcsCodeDeploy.property.taskRole"></a>

```python
task_role: IRole
```

- *Type:* aws_cdk.aws_iam.IRole

---


### AutoScalingProps <a name="AutoScalingProps" id="must-cdk.AutoScalingProps"></a>

Configuration for ECS service auto-scaling.

#### Initializer <a name="Initializer" id="must-cdk.AutoScalingProps.Initializer"></a>

```python
import must_cdk

must_cdk.AutoScalingProps(
  max_capacity: typing.Union[int, float],
  min_capacity: typing.Union[int, float],
  cpu_scale: CpuUtilizationScalingProps = None,
  memory_scale: MemoryUtilizationScalingProps = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.AutoScalingProps.property.maxCapacity">max_capacity</a></code> | <code>typing.Union[int, float]</code> | Maximum number of tasks to run. |
| <code><a href="#must-cdk.AutoScalingProps.property.minCapacity">min_capacity</a></code> | <code>typing.Union[int, float]</code> | Minimum number of tasks to run. |
| <code><a href="#must-cdk.AutoScalingProps.property.cpuScale">cpu_scale</a></code> | <code>aws_cdk.aws_ecs.CpuUtilizationScalingProps</code> | Scale task based on CPU utilization. |
| <code><a href="#must-cdk.AutoScalingProps.property.memoryScale">memory_scale</a></code> | <code>aws_cdk.aws_ecs.MemoryUtilizationScalingProps</code> | Scale task based on memory utilization. |

---

##### `max_capacity`<sup>Required</sup> <a name="max_capacity" id="must-cdk.AutoScalingProps.property.maxCapacity"></a>

```python
max_capacity: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Maximum number of tasks to run.

---

##### `min_capacity`<sup>Required</sup> <a name="min_capacity" id="must-cdk.AutoScalingProps.property.minCapacity"></a>

```python
min_capacity: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Minimum number of tasks to run.

---

##### `cpu_scale`<sup>Optional</sup> <a name="cpu_scale" id="must-cdk.AutoScalingProps.property.cpuScale"></a>

```python
cpu_scale: CpuUtilizationScalingProps
```

- *Type:* aws_cdk.aws_ecs.CpuUtilizationScalingProps

Scale task based on CPU utilization.

---

##### `memory_scale`<sup>Optional</sup> <a name="memory_scale" id="must-cdk.AutoScalingProps.property.memoryScale"></a>

```python
memory_scale: MemoryUtilizationScalingProps
```

- *Type:* aws_cdk.aws_ecs.MemoryUtilizationScalingProps

Scale task based on memory utilization.

---

### ContainerProps <a name="ContainerProps" id="must-cdk.ContainerProps"></a>

Configuration for the ECS Fargate task definition and container.

#### Initializer <a name="Initializer" id="must-cdk.ContainerProps.Initializer"></a>

```python
import must_cdk

must_cdk.ContainerProps(
  container_port: typing.Union[int, float],
  image: ContainerImage,
  health_check: HealthCheck = None,
  memory_limit: typing.Union[int, float] = None,
  memory_reservation: typing.Union[int, float] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ContainerProps.property.containerPort">container_port</a></code> | <code>typing.Union[int, float]</code> | The port number the container listens on. |
| <code><a href="#must-cdk.ContainerProps.property.image">image</a></code> | <code>aws_cdk.aws_ecs.ContainerImage</code> | Container image to deploy. |
| <code><a href="#must-cdk.ContainerProps.property.healthCheck">health_check</a></code> | <code>aws_cdk.aws_ecs.HealthCheck</code> | Optional container health check configuration. |
| <code><a href="#must-cdk.ContainerProps.property.memoryLimit">memory_limit</a></code> | <code>typing.Union[int, float]</code> | Hard memory limit in MiB for the task (default: 2048). |
| <code><a href="#must-cdk.ContainerProps.property.memoryReservation">memory_reservation</a></code> | <code>typing.Union[int, float]</code> | Soft memory reservation in MiB for the container (default: 1024). |

---

##### `container_port`<sup>Required</sup> <a name="container_port" id="must-cdk.ContainerProps.property.containerPort"></a>

```python
container_port: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The port number the container listens on.

---

##### `image`<sup>Required</sup> <a name="image" id="must-cdk.ContainerProps.property.image"></a>

```python
image: ContainerImage
```

- *Type:* aws_cdk.aws_ecs.ContainerImage

Container image to deploy.

---

##### `health_check`<sup>Optional</sup> <a name="health_check" id="must-cdk.ContainerProps.property.healthCheck"></a>

```python
health_check: HealthCheck
```

- *Type:* aws_cdk.aws_ecs.HealthCheck

Optional container health check configuration.

---

##### `memory_limit`<sup>Optional</sup> <a name="memory_limit" id="must-cdk.ContainerProps.property.memoryLimit"></a>

```python
memory_limit: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Hard memory limit in MiB for the task (default: 2048).

---

##### `memory_reservation`<sup>Optional</sup> <a name="memory_reservation" id="must-cdk.ContainerProps.property.memoryReservation"></a>

```python
memory_reservation: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Soft memory reservation in MiB for the container (default: 1024).

---

### EcsCodeDeployProps <a name="EcsCodeDeployProps" id="must-cdk.EcsCodeDeployProps"></a>

Properties for the EcsCodeDeploy construct.

#### Initializer <a name="Initializer" id="must-cdk.EcsCodeDeployProps.Initializer"></a>

```python
import must_cdk

must_cdk.EcsCodeDeployProps(
  certificates: typing.List[ICertificate],
  cluster: ICluster,
  containers: typing.List[ContainerProps],
  security_groups: typing.List[ISecurityGroup],
  service_name: str,
  subnets: SubnetSelection,
  vpc: IVpc,
  alb_target_port: typing.Union[int, float] = None,
  auto_scaling: AutoScalingProps = None,
  enable_public_load_balancer: bool = None,
  memory_limit: typing.Union[int, float] = None,
  task_cp_u: typing.Union[int, float] = None,
  task_exec_role: IRole = None,
  task_role: IRole = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.certificates">certificates</a></code> | <code>typing.List[aws_cdk.aws_certificatemanager.ICertificate]</code> | Optional ACM certificates for HTTPS termination. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.cluster">cluster</a></code> | <code>aws_cdk.aws_ecs.ICluster</code> | ECS Cluster where the service will run. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.containers">containers</a></code> | <code>typing.List[ContainerProps](#must-cdk.ContainerProps)</code> | Configuration related to the task definition and container. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.securityGroups">security_groups</a></code> | <code>typing.List[aws_cdk.aws_ec2.ISecurityGroup]</code> | Security group config. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.serviceName">service_name</a></code> | <code>str</code> | Base name used for resources like log groups, roles, services, etc. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.subnets">subnets</a></code> | <code>aws_cdk.aws_ec2.SubnetSelection</code> | Select which subnets the Service and ALB will placed on. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.vpc">vpc</a></code> | <code>aws_cdk.aws_ec2.IVpc</code> | VPC in which to deploy ECS and ALB resources. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.albTargetPort">alb_target_port</a></code> | <code>typing.Union[int, float]</code> | The ALB target port. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.autoScaling">auto_scaling</a></code> | <code><a href="#must-cdk.AutoScalingProps">AutoScalingProps</a></code> | Optional auto-scaling configuration. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.enablePublicLoadBalancer">enable_public_load_balancer</a></code> | <code>bool</code> | Whether the load balancer should be internet-facing (default: false). |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.memoryLimit">memory_limit</a></code> | <code>typing.Union[int, float]</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.taskCPU">task_cp_u</a></code> | <code>typing.Union[int, float]</code> | CPU units for the task (default: 1024). |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.taskExecRole">task_exec_role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | Task execution role for the ECS task. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.taskRole">task_role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | Task role for the ECS task. |

---

##### `certificates`<sup>Required</sup> <a name="certificates" id="must-cdk.EcsCodeDeployProps.property.certificates"></a>

```python
certificates: typing.List[ICertificate]
```

- *Type:* typing.List[aws_cdk.aws_certificatemanager.ICertificate]

Optional ACM certificates for HTTPS termination.

---

##### `cluster`<sup>Required</sup> <a name="cluster" id="must-cdk.EcsCodeDeployProps.property.cluster"></a>

```python
cluster: ICluster
```

- *Type:* aws_cdk.aws_ecs.ICluster

ECS Cluster where the service will run.

---

##### `containers`<sup>Required</sup> <a name="containers" id="must-cdk.EcsCodeDeployProps.property.containers"></a>

```python
containers: typing.List[ContainerProps]
```

- *Type:* typing.List[ContainerProps](#must-cdk.ContainerProps)

Configuration related to the task definition and container.

---

##### `security_groups`<sup>Required</sup> <a name="security_groups" id="must-cdk.EcsCodeDeployProps.property.securityGroups"></a>

```python
security_groups: typing.List[ISecurityGroup]
```

- *Type:* typing.List[aws_cdk.aws_ec2.ISecurityGroup]

Security group config.

---

##### `service_name`<sup>Required</sup> <a name="service_name" id="must-cdk.EcsCodeDeployProps.property.serviceName"></a>

```python
service_name: str
```

- *Type:* str

Base name used for resources like log groups, roles, services, etc.

---

##### `subnets`<sup>Required</sup> <a name="subnets" id="must-cdk.EcsCodeDeployProps.property.subnets"></a>

```python
subnets: SubnetSelection
```

- *Type:* aws_cdk.aws_ec2.SubnetSelection

Select which subnets the Service and ALB will placed on.

---

##### `vpc`<sup>Required</sup> <a name="vpc" id="must-cdk.EcsCodeDeployProps.property.vpc"></a>

```python
vpc: IVpc
```

- *Type:* aws_cdk.aws_ec2.IVpc

VPC in which to deploy ECS and ALB resources.

---

##### `alb_target_port`<sup>Optional</sup> <a name="alb_target_port" id="must-cdk.EcsCodeDeployProps.property.albTargetPort"></a>

```python
alb_target_port: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The ALB target port.

---

##### `auto_scaling`<sup>Optional</sup> <a name="auto_scaling" id="must-cdk.EcsCodeDeployProps.property.autoScaling"></a>

```python
auto_scaling: AutoScalingProps
```

- *Type:* <a href="#must-cdk.AutoScalingProps">AutoScalingProps</a>

Optional auto-scaling configuration.

---

##### `enable_public_load_balancer`<sup>Optional</sup> <a name="enable_public_load_balancer" id="must-cdk.EcsCodeDeployProps.property.enablePublicLoadBalancer"></a>

```python
enable_public_load_balancer: bool
```

- *Type:* bool

Whether the load balancer should be internet-facing (default: false).

---

##### `memory_limit`<sup>Optional</sup> <a name="memory_limit" id="must-cdk.EcsCodeDeployProps.property.memoryLimit"></a>

```python
memory_limit: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

---

##### `task_cp_u`<sup>Optional</sup> <a name="task_cp_u" id="must-cdk.EcsCodeDeployProps.property.taskCPU"></a>

```python
task_cp_u: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

CPU units for the task (default: 1024).

---

##### `task_exec_role`<sup>Optional</sup> <a name="task_exec_role" id="must-cdk.EcsCodeDeployProps.property.taskExecRole"></a>

```python
task_exec_role: IRole
```

- *Type:* aws_cdk.aws_iam.IRole

Task execution role for the ECS task.

---

##### `task_role`<sup>Optional</sup> <a name="task_role" id="must-cdk.EcsCodeDeployProps.property.taskRole"></a>

```python
task_role: IRole
```

- *Type:* aws_cdk.aws_iam.IRole

Task role for the ECS task.

---

