# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### SubDomainOptions <a name="SubDomainOptions" id="must-cdk.SubDomainOptions"></a>

Subdomain configuration for a custom domain in an Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.SubDomainOptions.Initializer"></a>

```python
import must_cdk

must_cdk.SubDomainOptions(
  branch_name: str,
  prefix: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.SubDomainOptions.property.branchName">branch_name</a></code> | <code>str</code> | The branch name to map to this subdomain. |
| <code><a href="#must-cdk.SubDomainOptions.property.prefix">prefix</a></code> | <code>str</code> | The prefix for the subdomain. |

---

##### `branch_name`<sup>Required</sup> <a name="branch_name" id="must-cdk.SubDomainOptions.property.branchName"></a>

```python
branch_name: str
```

- *Type:* str

The branch name to map to this subdomain.

---

##### `prefix`<sup>Required</sup> <a name="prefix" id="must-cdk.SubDomainOptions.property.prefix"></a>

```python
prefix: str
```

- *Type:* str

The prefix for the subdomain.

Use empty string for the root domain.

---

