# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### WebSocketApiGatewayToLambda <a name="WebSocketApiGatewayToLambda" id="must-cdk.WebSocketApiGatewayToLambda"></a>

#### Initializers <a name="Initializers" id="must-cdk.WebSocketApiGatewayToLambda.Initializer"></a>

```python
import must_cdk

must_cdk.WebSocketApiGatewayToLambda(
  scope: Construct,
  id: str,
  api_name: str,
  lambda_function: IFunction,
  api_props: WebSocketApiProps = None,
  custom_domain_name: str = None,
  custom_routes: typing.List[WebSocketRoute] = None,
  enable_logging: bool = None,
  existing_certificate: ICertificate = None,
  hosted_zone: IHostedZone = None,
  log_group_props: LogGroupProps = None,
  stage_name: str = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.apiName">api_name</a></code> | <code>str</code> | WebSocket API configuration. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.lambdaFunction">lambda_function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | Primary Lambda function for the API (usually handles $default route). |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.apiProps">api_props</a></code> | <code>aws_cdk.aws_apigatewayv2.WebSocketApiProps</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.customDomainName">custom_domain_name</a></code> | <code>str</code> | Optional custom domain name for API Gateway. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.customRoutes">custom_routes</a></code> | <code>typing.List[WebSocketRoute](#must-cdk.WebSocketRoute)</code> | Custom routes for WebSocket API Common routes: $connect, $disconnect, $default, or custom route keys. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.enableLogging">enable_logging</a></code> | <code>bool</code> | Enable CloudWatch logging for API Gateway. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.existingCertificate">existing_certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | Optional ACM certificate to use instead of creating a new one. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.hostedZone">hosted_zone</a></code> | <code>aws_cdk.aws_route53.IHostedZone</code> | Optional Route53 hosted zone for custom domain. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.logGroupProps">log_group_props</a></code> | <code>aws_cdk.aws_logs.LogGroupProps</code> | CloudWatch Logs configuration. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.stageName">stage_name</a></code> | <code>str</code> | Stage name for the WebSocket API. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.id"></a>

- *Type:* str

---

##### `api_name`<sup>Required</sup> <a name="api_name" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.apiName"></a>

- *Type:* str

WebSocket API configuration.

---

##### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.lambdaFunction"></a>

- *Type:* aws_cdk.aws_lambda.IFunction

Primary Lambda function for the API (usually handles $default route).

---

##### `api_props`<sup>Optional</sup> <a name="api_props" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.apiProps"></a>

- *Type:* aws_cdk.aws_apigatewayv2.WebSocketApiProps

---

##### `custom_domain_name`<sup>Optional</sup> <a name="custom_domain_name" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.customDomainName"></a>

- *Type:* str

Optional custom domain name for API Gateway.

---

##### `custom_routes`<sup>Optional</sup> <a name="custom_routes" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.customRoutes"></a>

- *Type:* typing.List[WebSocketRoute](#must-cdk.WebSocketRoute)

Custom routes for WebSocket API Common routes: $connect, $disconnect, $default, or custom route keys.

---

##### `enable_logging`<sup>Optional</sup> <a name="enable_logging" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.enableLogging"></a>

- *Type:* bool

Enable CloudWatch logging for API Gateway.

---

##### `existing_certificate`<sup>Optional</sup> <a name="existing_certificate" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.existingCertificate"></a>

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

Optional ACM certificate to use instead of creating a new one.

---

##### `hosted_zone`<sup>Optional</sup> <a name="hosted_zone" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.hostedZone"></a>

- *Type:* aws_cdk.aws_route53.IHostedZone

Optional Route53 hosted zone for custom domain.

---

##### `log_group_props`<sup>Optional</sup> <a name="log_group_props" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.logGroupProps"></a>

- *Type:* aws_cdk.aws_logs.LogGroupProps

CloudWatch Logs configuration.

---

##### `stage_name`<sup>Optional</sup> <a name="stage_name" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.stageName"></a>

- *Type:* str
- *Default:* 'dev'

Stage name for the WebSocket API.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.addRoute">add_route</a></code> | Add a custom route after construction (for dynamic route addition). |

---

##### `to_string` <a name="to_string" id="must-cdk.WebSocketApiGatewayToLambda.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `add_route` <a name="add_route" id="must-cdk.WebSocketApiGatewayToLambda.addRoute"></a>

```python
def add_route(
  handler: IFunction,
  route_key: str,
  route_response_selection_expression: str = None
) -> WebSocketRoute
```

Add a custom route after construction (for dynamic route addition).

###### `handler`<sup>Required</sup> <a name="handler" id="must-cdk.WebSocketApiGatewayToLambda.addRoute.parameter.handler"></a>

- *Type:* aws_cdk.aws_lambda.IFunction

---

###### `route_key`<sup>Required</sup> <a name="route_key" id="must-cdk.WebSocketApiGatewayToLambda.addRoute.parameter.routeKey"></a>

- *Type:* str

---

###### `route_response_selection_expression`<sup>Optional</sup> <a name="route_response_selection_expression" id="must-cdk.WebSocketApiGatewayToLambda.addRoute.parameter.routeResponseSelectionExpression"></a>

- *Type:* str

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### ~~`is_construct`~~ <a name="is_construct" id="must-cdk.WebSocketApiGatewayToLambda.isConstruct"></a>

```python
import must_cdk

must_cdk.WebSocketApiGatewayToLambda.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.WebSocketApiGatewayToLambda.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.lambdaFunction">lambda_function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.webSocketApi">web_socket_api</a></code> | <code>aws_cdk.aws_apigatewayv2.WebSocketApi</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.webSocketStage">web_socket_stage</a></code> | <code>aws_cdk.aws_apigatewayv2.WebSocketStage</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.webSocketUrl">web_socket_url</a></code> | <code>str</code> | Get the WebSocket API URL (useful for outputs). |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.apiGatewayLogGroup">api_gateway_log_group</a></code> | <code>aws_cdk.aws_logs.LogGroup</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.aRecord">a_record</a></code> | <code>aws_cdk.aws_route53.ARecord</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.certificate">certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.domain">domain</a></code> | <code>aws_cdk.aws_apigatewayv2.DomainName</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.WebSocketApiGatewayToLambda.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="must-cdk.WebSocketApiGatewayToLambda.property.lambdaFunction"></a>

```python
lambda_function: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

---

##### `web_socket_api`<sup>Required</sup> <a name="web_socket_api" id="must-cdk.WebSocketApiGatewayToLambda.property.webSocketApi"></a>

```python
web_socket_api: WebSocketApi
```

- *Type:* aws_cdk.aws_apigatewayv2.WebSocketApi

---

##### `web_socket_stage`<sup>Required</sup> <a name="web_socket_stage" id="must-cdk.WebSocketApiGatewayToLambda.property.webSocketStage"></a>

```python
web_socket_stage: WebSocketStage
```

- *Type:* aws_cdk.aws_apigatewayv2.WebSocketStage

---

##### `web_socket_url`<sup>Required</sup> <a name="web_socket_url" id="must-cdk.WebSocketApiGatewayToLambda.property.webSocketUrl"></a>

```python
web_socket_url: str
```

- *Type:* str

Get the WebSocket API URL (useful for outputs).

---

##### `api_gateway_log_group`<sup>Optional</sup> <a name="api_gateway_log_group" id="must-cdk.WebSocketApiGatewayToLambda.property.apiGatewayLogGroup"></a>

```python
api_gateway_log_group: LogGroup
```

- *Type:* aws_cdk.aws_logs.LogGroup

---

##### `a_record`<sup>Optional</sup> <a name="a_record" id="must-cdk.WebSocketApiGatewayToLambda.property.aRecord"></a>

```python
a_record: ARecord
```

- *Type:* aws_cdk.aws_route53.ARecord

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.WebSocketApiGatewayToLambda.property.certificate"></a>

```python
certificate: ICertificate
```

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

---

##### `domain`<sup>Optional</sup> <a name="domain" id="must-cdk.WebSocketApiGatewayToLambda.property.domain"></a>

```python
domain: DomainName
```

- *Type:* aws_cdk.aws_apigatewayv2.DomainName

---


## Structs <a name="Structs" id="Structs"></a>

### WebSocketApiGatewayToLambdaProps <a name="WebSocketApiGatewayToLambdaProps" id="must-cdk.WebSocketApiGatewayToLambdaProps"></a>

#### Initializer <a name="Initializer" id="must-cdk.WebSocketApiGatewayToLambdaProps.Initializer"></a>

```python
import must_cdk

must_cdk.WebSocketApiGatewayToLambdaProps(
  api_name: str,
  lambda_function: IFunction,
  api_props: WebSocketApiProps = None,
  custom_domain_name: str = None,
  custom_routes: typing.List[WebSocketRoute] = None,
  enable_logging: bool = None,
  existing_certificate: ICertificate = None,
  hosted_zone: IHostedZone = None,
  log_group_props: LogGroupProps = None,
  stage_name: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.apiName">api_name</a></code> | <code>str</code> | WebSocket API configuration. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.lambdaFunction">lambda_function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | Primary Lambda function for the API (usually handles $default route). |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.apiProps">api_props</a></code> | <code>aws_cdk.aws_apigatewayv2.WebSocketApiProps</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.customDomainName">custom_domain_name</a></code> | <code>str</code> | Optional custom domain name for API Gateway. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.customRoutes">custom_routes</a></code> | <code>typing.List[WebSocketRoute](#must-cdk.WebSocketRoute)</code> | Custom routes for WebSocket API Common routes: $connect, $disconnect, $default, or custom route keys. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.enableLogging">enable_logging</a></code> | <code>bool</code> | Enable CloudWatch logging for API Gateway. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.existingCertificate">existing_certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | Optional ACM certificate to use instead of creating a new one. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.hostedZone">hosted_zone</a></code> | <code>aws_cdk.aws_route53.IHostedZone</code> | Optional Route53 hosted zone for custom domain. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.logGroupProps">log_group_props</a></code> | <code>aws_cdk.aws_logs.LogGroupProps</code> | CloudWatch Logs configuration. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.stageName">stage_name</a></code> | <code>str</code> | Stage name for the WebSocket API. |

---

##### `api_name`<sup>Required</sup> <a name="api_name" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.apiName"></a>

```python
api_name: str
```

- *Type:* str

WebSocket API configuration.

---

##### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.lambdaFunction"></a>

```python
lambda_function: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

Primary Lambda function for the API (usually handles $default route).

---

##### `api_props`<sup>Optional</sup> <a name="api_props" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.apiProps"></a>

```python
api_props: WebSocketApiProps
```

- *Type:* aws_cdk.aws_apigatewayv2.WebSocketApiProps

---

##### `custom_domain_name`<sup>Optional</sup> <a name="custom_domain_name" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.customDomainName"></a>

```python
custom_domain_name: str
```

- *Type:* str

Optional custom domain name for API Gateway.

---

##### `custom_routes`<sup>Optional</sup> <a name="custom_routes" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.customRoutes"></a>

```python
custom_routes: typing.List[WebSocketRoute]
```

- *Type:* typing.List[WebSocketRoute](#must-cdk.WebSocketRoute)

Custom routes for WebSocket API Common routes: $connect, $disconnect, $default, or custom route keys.

---

##### `enable_logging`<sup>Optional</sup> <a name="enable_logging" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.enableLogging"></a>

```python
enable_logging: bool
```

- *Type:* bool

Enable CloudWatch logging for API Gateway.

---

##### `existing_certificate`<sup>Optional</sup> <a name="existing_certificate" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.existingCertificate"></a>

```python
existing_certificate: ICertificate
```

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

Optional ACM certificate to use instead of creating a new one.

---

##### `hosted_zone`<sup>Optional</sup> <a name="hosted_zone" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.hostedZone"></a>

```python
hosted_zone: IHostedZone
```

- *Type:* aws_cdk.aws_route53.IHostedZone

Optional Route53 hosted zone for custom domain.

---

##### `log_group_props`<sup>Optional</sup> <a name="log_group_props" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.logGroupProps"></a>

```python
log_group_props: LogGroupProps
```

- *Type:* aws_cdk.aws_logs.LogGroupProps

CloudWatch Logs configuration.

---

##### `stage_name`<sup>Optional</sup> <a name="stage_name" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.stageName"></a>

```python
stage_name: str
```

- *Type:* str
- *Default:* 'dev'

Stage name for the WebSocket API.

---

### WebSocketRoute <a name="WebSocketRoute" id="must-cdk.WebSocketRoute"></a>

#### Initializer <a name="Initializer" id="must-cdk.WebSocketRoute.Initializer"></a>

```python
import must_cdk

must_cdk.WebSocketRoute(
  handler: IFunction,
  route_key: str,
  route_response_selection_expression: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketRoute.property.handler">handler</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketRoute.property.routeKey">route_key</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketRoute.property.routeResponseSelectionExpression">route_response_selection_expression</a></code> | <code>str</code> | *No description.* |

---

##### `handler`<sup>Required</sup> <a name="handler" id="must-cdk.WebSocketRoute.property.handler"></a>

```python
handler: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

---

##### `route_key`<sup>Required</sup> <a name="route_key" id="must-cdk.WebSocketRoute.property.routeKey"></a>

```python
route_key: str
```

- *Type:* str

---

##### `route_response_selection_expression`<sup>Optional</sup> <a name="route_response_selection_expression" id="must-cdk.WebSocketRoute.property.routeResponseSelectionExpression"></a>

```python
route_response_selection_expression: str
```

- *Type:* str

---



