#!/usr/bin/env python3

import sys
import os
sys.path.append(os.path.join(os.path.dirname(__file__), '../../'))

from aws_cdk import App, Stack
from constructs import Construct
from must_cdk import AmplifyApp

class TestAmplifyStack(Stack):
    def __init__(self, scope: Construct, id: str, **kwargs) -> None:
        super().__init__(scope, id, **kwargs)

        # This is your exact use case
        AmplifyApp(self, 'Amplify',
                   app_name='must-cdk',
                   repository='https://github.com/globalmsq/must-cdk')

# Test the construct
app = App()
TestAmplifyStack(app, "TestAmplifyStack")

# This will show the CloudFormation template without deploying
print("🎯 Testing Amplify construct with your configuration...")
print("📋 CloudFormation template preview:")
print(app.synth().get_stack_by_name("TestAmplifyStack").template)
