# CloudFront Examples

This directory contains examples for creating Amazon CloudFront distributions with multiple origins and advanced configurations.

## Examples

### Multi-Origin CloudFront Distribution
- **Files**: `cloudfront-distribution.ts` / `cloudfront_distribution.py`
- **Description**: Production-ready CloudFront distribution with S3 and API Gateway origins
- **Features**:
  - Multi-origin setup (S3 for static assets, API Gateway for APIs)
  - Custom cache behaviors for different content types
  - Security headers and WAF integration
  - Geographic restrictions
  - Custom error pages and comprehensive logging
  - Performance optimizations

## Key Components

### 1. Origins
- **S3 Origin**: Static assets (HTML, CSS, JS, images)
- **API Gateway Origin**: Dynamic API endpoints
- Origin Access Identity for secure S3 access

### 2. Cache Behaviors
- Default behavior for static assets with long TTL
- API-specific behavior with shorter TTL
- Compression enabled for better performance

### 3. Security Features
- WAF integration for DDoS protection
- Security headers (HSTS, CSP, etc.)
- Geographic restrictions
- HTTPS enforcement

### 4. Performance Optimizations
- HTTP/2 support
- Gzip compression
- Edge location optimization
- Caching strategies

## Deployment

```bash
# TypeScript
npm install
cdk deploy CloudFrontDistributionStack

# Python
pip install aws-cdk-lib must-cdk
cdk deploy CloudFrontDistributionStack
```

## Customization

### Origins Configuration
Add or modify origins:
```typescript
additionalOrigins: [
  {
    id: 'api-origin',
    domainName: 'api.example.com',
    customOriginConfig: {
      httpPort: 80,
      httpsPort: 443,
      originProtocolPolicy: 'https-only'
    }
  }
]
```

### Cache Behaviors
Configure caching for different paths:
```typescript
additionalCacheBehaviors: [
  {
    pathPattern: '/api/*',
    targetOriginId: 'api-origin',
    cachePolicyId: 'managed-caching-disabled',
    viewerProtocolPolicy: 'redirect-to-https'
  }
]
```

### Security Headers
Customize security headers:
```typescript
responseHeadersPolicy: {
  securityHeadersConfig: {
    strictTransportSecurity: {
      accessControlMaxAgeSec: 31536000,
      includeSubdomains: true
    },
    contentTypeOptions: { override: true },
    frameOptions: { frameOption: 'DENY' }
  }
}
```

## Monitoring and Logging

- Real-time metrics in CloudWatch
- Access logs stored in S3
- WAF logs for security analysis
- Custom metrics and alarms

## Best Practices

### Performance
- Use appropriate cache policies
- Enable compression
- Optimize image formats
- Implement proper TTL values

### Security
- Enable WAF protection
- Use security headers
- Implement geographic restrictions
- Regular security audits

### Cost Optimization
- Choose appropriate price class
- Monitor data transfer costs
- Use efficient caching strategies
- Regular cost reviews
