import * as cdk from 'aws-cdk-lib';
import { EcsCodeDeploy } from 'must-cdk';

export class EcsBlueGreenStack extends cdk.Stack {
  constructor(scope: cdk.App, id: string, props?: cdk.StackProps) {
    super(scope, id, props);

    new EcsCodeDeploy(this, 'EcsService', {
      serviceName: 'sample-service',
      cluster: {
        name: 'production-cluster',
        vpc: {
          maxAzs: 2,
        },
      },
      taskDefinition: {
        taskCPU: 1024,
        memoryLimit: 2048,
        containers: [
          {
            name: 'web',
            image: 'nginx:latest',
            containerPort: 80,
            healthCheck: {
              command: ['CMD-SHELL', 'curl -f http://localhost/ || exit 1'],
              interval: 30,
              retries: 3,
              timeout: 5,
            },
          },
        ],
      },
      loadBalancer: {
        healthCheckPath: '/',
        port: 80,
      },
      deployment: {
        type: 'BLUE_GREEN',
        autoRollback: true,
        terminationWaitTime: 10,
      },
      desiredCount: 2,
      autoScaling: {
        minCapacity: 2,
        maxCapacity: 10,
        targetCpuUtilization: 75,
      },
    });
  }
}

const app = new cdk.App();
new EcsBlueGreenStack(app, 'EcsBlueGreenStack', {
  env: {
    account: process.env.CDK_DEFAULT_ACCOUNT,
    region: 'ap-northeast-2',
  },
});
