# Archive

This directory contains development and implementation documents that are not needed by end users but are preserved for historical reference.

## Directory Structure

### `development/` - Development Process Documents
- **handoffs/** - Session handoff documents
- **planning/** - Session planning documents
- **reviews/** - Quality review reports
- **status/** - Development status snapshots
- **releases/** - Old release notes and instructions

### `implementation/` - Implementation Records
- **week1/** - Week 1: Python symbol extraction
- **week2/** - Week 2: JavaScript, TypeScript, Go, Rust
- **week3/** - Week 3: C++, Java, C#
- **week4/** - Week 4: PHP, Ruby, Swift
- **week5/** - Week 5: Kotlin
- **sessions/** - Session summaries (SESSION_13, 14, 15)
- **V0.11.0_*.md** - v0.11.0 status documents

## Purpose

These documents were used during the development of Clauxton v0.11.0 (Repository Map feature). They contain:
- Daily/weekly progress reports
- Technical decisions and trade-offs
- Session handoffs between development sessions
- Quality review findings
- Implementation lessons learned

## For End Users

If you're looking for documentation on how to use Clauxton, please refer to:
- **README.md** - Main project documentation
- **docs/** - User guides and tutorials
- **CHANGELOG.md** - Release history

## For Contributors

These archived documents may be useful for:
- Understanding the development history
- Learning about design decisions
- Reference for similar feature implementations
- Code archaeology and debugging context

Last updated: 2025-10-24 (v0.11.0 release)
