# Pull Request

## Description

Please include a summary of the changes and the related issue.

Fixes # (issue)

## Type of Change

Please delete options that are not relevant.

- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] Documentation update
- [ ] Refactoring (no functional changes)
- [ ] Performance improvement
- [ ] Test coverage improvement

## Changes Made

- Change 1
- Change 2
- Change 3

## How Has This Been Tested?

Please describe the tests that you ran to verify your changes.

- [ ] Unit tests added/updated
- [ ] Integration tests added/updated
- [ ] Manual testing performed
- [ ] All existing tests pass

**Test Configuration**:
- Python version:
- OS:
- Clauxton version:

## Checklist

Before submitting, please ensure:

- [ ] My code follows the style guidelines of this project (PEP 8, type hints, docstrings)
- [ ] I have performed a self-review of my own code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation
- [ ] My changes generate no new warnings
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] New and existing unit tests pass locally with my changes
- [ ] Any dependent changes have been merged and published
- [ ] I have updated the CHANGELOG.md file
- [ ] I have run `mypy` and it passes (strict mode)
- [ ] I have run `ruff check` and it passes
- [ ] I have run `pytest` and all tests pass

## Screenshots (if applicable)

Add screenshots to help explain your changes.

## Breaking Changes

If this PR introduces breaking changes, please describe:

1. What breaks?
2. How should users migrate?
3. Is there a deprecation path?

## Additional Context

Add any other context about the pull request here.

## Reviewer Notes

Any specific areas you'd like reviewers to focus on?
