# Documentation Archive

This directory contains historical documentation that is no longer actively maintained but preserved for reference.

## Directory Structure

### `sessions/`
Development session records and planning documents:
- Session summaries (Sessions 7-12)
- Session plans and reviews
- Week 12 summaries and gap analyses
- Timeline tracking

These documents track the development process but are not needed by end users.

### `planning/`
Internal planning and analysis documents:
- Coverage gap analyses
- Quality analyses
- Test performance reports
- Implementation plans
- Design documents (v0.10.0 planning)
- Research documents

These were used during development to plan features and analyze quality metrics.

### `releases/`
Historical release documentation:
- Phase completion summaries (Phase 0, 1, 2)
- Phase plans (outdated)
- Version-specific guides (v0.9.0-beta)

These documents describe completed phases and are superseded by newer documentation.

## Active Documentation

For current, user-facing documentation, see:
- `../` - Main documentation directory
- `../RELEASE_NOTES_v0.10.0.md` - Current release notes
- `../README.md` - Main project README
- `../quick-start.md` - Quick start guide
- `../mcp-server.md` - MCP integration guide

## Why Archive?

These documents are archived to:
1. **Reduce clutter** - Keep main docs directory focused on user-facing content
2. **Preserve history** - Maintain development history for future reference
3. **Improve navigation** - Make it easier to find relevant documentation
4. **Clean repository** - Present a professional, organized documentation structure

## Archived Date

- **Date**: 2025-10-22
- **Release**: v0.10.0
- **Reason**: Post-release cleanup and organization

---

**Note**: If you need information from these archived documents, they remain available in git history and this archive directory.
