# v0.15.0 Phase 2-4 Execution Plan: SubAgent Parallel Development

**Version**: v0.15.0 Unified Memory Model
**Duration**: 24 days (Week 3-8, Day 13-36)
**Strategy**: SubAgent-based parallel development with comprehensive quality assurance
**Last Updated**: 2025-11-03

---

## Table of Contents

1. [Overview](#overview)
2. [Phase 2: Smart Memory (Week 3-4)](#phase-2-smart-memory-week-3-4)
3. [Phase 3: Memory Intelligence (Week 5-6)](#phase-3-memory-intelligence-week-5-6)
4. [Phase 4: UX Polish (Week 7-8)](#phase-4-ux-polish-week-7-8)
5. [Quality Assurance Strategy](#quality-assurance-strategy)
6. [Timeline Summary](#timeline-summary)
7. [Risk Management](#risk-management)

---

## Overview

### Objectives

**Phase 2 (Smart Memory)**: Auto-extract memories from Git commits and detect relationships
**Phase 3 (Memory Intelligence)**: Q&A, summarization, prediction, graph visualization
**Phase 4 (UX Polish)**: Documentation, integration tests, TUI integration

### Parallel Execution Strategy

- **Week 3-4**: 3 agents (2 parallel + 1 sequential)
- **Week 5-6**: 3 agents (all parallel)
- **Week 7-8**: 4 agents (all parallel)
- **Quality Reviews**: After each phase (1.5 days each)
- **Improvement Tasks**: Parallel execution via SubAgents

### Success Criteria

- All tests pass (target: 2,500+ total tests)
- Coverage: >90% on new modules
- Quality Score: >90/100 (Grade A or higher)
- Performance: Meet or exceed targets
- Documentation: Complete and accurate

---

## Phase 2: Smart Memory (Week 3-4)

**Duration**: Day 13-24 (10 working days + 1.5 quality review)
**Goal**: Auto-extraction from commits, relationship detection, merge suggestions

### Agent 6: Memory Extraction (Day 13-18, 6 days)

**Depends on**: Phase 1 complete ✅

#### Tasks

1. **Implement MemoryExtractor** (`clauxton/semantic/memory_extractor.py`)
   - `extract_from_commit(commit_sha)` - Extract memories from single commit
   - `extract_from_recent_commits(since_days)` - Extract from recent commits
   - `_extract_decision(commit_message)` - Detect architectural decisions
   - `_detect_patterns(diff)` - Detect code patterns from diff

2. **Decision Detection**
   - Pattern matching for decision keywords:
     - "feat:", "fix:", "refactor:", "perf:"
     - "Switch to X", "Migrate to Y", "Replace X with Y"
     - "Add authentication", "Implement caching"
   - Extract rationale from commit message body
   - Confidence scoring based on keyword strength

3. **Pattern Detection**
   - Analyze diff for code changes:
     - New API endpoints added
     - Database migrations
     - New component patterns (React, Vue, etc.)
   - File type detection (API, UI, DB, etc.)
   - Confidence scoring based on change size

4. **Tests** (`tests/semantic/test_memory_extractor.py`, 15 tests)
   - Test decision extraction from various commit messages
   - Test pattern detection from diffs
   - Test confidence scoring
   - Test auto-add to memory system
   - Test edge cases (empty commits, merge commits)

#### Deliverables

- `clauxton/semantic/memory_extractor.py` (~350 lines)
- `tests/semantic/test_memory_extractor.py` (15 tests)
- Coverage: >90%

#### Quality Requirements

- Type hints: 100%
- Docstrings: Google style
- mypy --strict: Pass
- ruff check: Pass
- Performance: Extract <100ms per commit

---

### Agent 7: Relationship Detection (Day 13-18, 6 days)

**Depends on**: Phase 1 complete ✅
**Runs in parallel with**: Agent 6

#### Tasks

1. **Implement MemoryLinker** (`clauxton/semantic/memory_linker.py`)
   - `find_relationships(entry, existing)` - Find related memories
   - `auto_link_all()` - Auto-link all memories
   - `suggest_merge_candidates()` - Find duplicate/similar memories

2. **Relationship Scoring**
   - Semantic similarity (embeddings, if available)
   - Shared tags (high weight)
   - Same category (medium weight)
   - Temporal proximity (low weight)
   - File/code overlap (high weight for code type)

3. **Merge Candidate Detection**
   - Title similarity (Levenshtein distance)
   - Content similarity (TF-IDF cosine similarity)
   - Same type + category
   - Threshold: >0.8 similarity = merge candidate

4. **Tests** (`tests/semantic/test_memory_linker.py`, 15 tests)
   - Test semantic similarity linking
   - Test tag-based linking
   - Test category-based linking
   - Test temporal proximity
   - Test merge candidate detection
   - Test edge cases (self-linking, circular links)

#### Deliverables

- `clauxton/semantic/memory_linker.py` (~300 lines)
- `tests/semantic/test_memory_linker.py` (15 tests)
- Coverage: >90%

#### Quality Requirements

- Type hints: 100%
- Docstrings: Google style
- mypy --strict: Pass
- ruff check: Pass
- Performance: Link <200ms for 1,000 entries

---

### Agent 8: CLI Extract Commands (Day 19-22, 4 days)

**Depends on**: Agent 6, Agent 7 complete
**Runs sequentially after**: Agents 6-7

#### Tasks

1. **Implement CLI Commands** (`clauxton/cli/memory.py` - add to existing)
   - `clauxton memory extract --since 7d` - Extract from last 7 days
   - `clauxton memory extract --commit abc123` - Extract from specific commit
   - `clauxton memory extract --auto-add` - Auto-add to memory
   - `clauxton memory link --auto` - Auto-link all memories
   - `clauxton memory link MEM-ID` - Link specific memory
   - `clauxton memory suggest-merge` - Find merge candidates

2. **Interactive Workflows**
   - Preview extracted memories before adding
   - Confirm merge suggestions
   - Show relationship graph

3. **Tests** (`tests/cli/test_memory_extract.py`, 10 tests)
   - Test extract commands
   - Test link commands
   - Test suggest-merge
   - Test interactive workflows

#### Deliverables

- `clauxton/cli/memory.py` (updated, +200 lines)
- `tests/cli/test_memory_extract.py` (10 tests)
- Coverage: >85%

#### Quality Requirements

- Type hints: 100%
- Docstrings: Google style
- mypy --strict: Pass
- ruff check: Pass

---

### Phase 2 Parallel Execution Strategy

```
Day 13-18 (6 days):
  Agent 6 (Memory Extraction) ┐
  Agent 7 (Relationship)      ┘─ Parallel (2 agents)

Day 19-22 (4 days):
  Agent 8 (CLI Extract) → Sequential (depends on 6, 7)

Total: 10 days
```

### Phase 2 Deliverables Summary

- **Implementation**: 3 files (~850 lines)
- **Tests**: 40 tests
- **Coverage**: >90%
- **Quality**: All checks pass

---

## Phase 3: Memory Intelligence (Week 5-6)

**Duration**: Day 25-36 (6 working days + 1.5 quality review)
**Goal**: Q&A, summarization, prediction, graph visualization

### Agent 9: Question-Answering (Day 25-30, 6 days)

**Depends on**: Phase 2 complete

#### Tasks

1. **Implement MemoryQA** (`clauxton/semantic/memory_qa.py`)
   - `answer_question(question)` - Answer questions about project
   - `_rank_by_context(question, memories)` - Rank by relevance
   - `_generate_answer(question, memories)` - Generate natural language answer
   - `_calculate_confidence(memories)` - Calculate answer confidence

2. **Question Types**
   - Architecture: "Why did we switch to PostgreSQL?"
   - Patterns: "What authentication method do we use?"
   - Tasks: "What should I work on next?"
   - History: "When did we add feature X?"

3. **Answer Generation**
   - Simple approach: Extract most relevant content
   - Advanced approach: Use LLM to synthesize (optional, local model)
   - Include sources (memory IDs)
   - Confidence score

4. **MCP Tool** (`clauxton/mcp/server.py`)
   - `answer_question(question)` - MCP tool for Claude Code

5. **Tests** (`tests/semantic/test_memory_qa.py`, 10 tests)
   - Test answering architecture questions
   - Test answering pattern questions
   - Test answering task questions
   - Test confidence scoring
   - Test source tracking

#### Deliverables

- `clauxton/semantic/memory_qa.py` (~250 lines)
- `clauxton/mcp/server.py` (updated, +50 lines)
- `tests/semantic/test_memory_qa.py` (10 tests)
- Coverage: >90%

---

### Agent 10: Summarization & Prediction (Day 25-30, 6 days)

**Depends on**: Phase 2 complete
**Runs in parallel with**: Agent 9

#### Tasks

1. **Implement MemorySummarizer** (`clauxton/semantic/memory_summarizer.py`)
   - `summarize_project()` - Generate project summary
   - `predict_next_tasks(context)` - Predict likely next tasks
   - `generate_knowledge_gaps()` - Identify missing knowledge

2. **Project Summary**
   - Architecture decisions (from type=decision)
   - Active patterns (from type=pattern)
   - Recent changes (from recent memories)
   - Tech stack (extracted from memories)
   - Constraints (from memories with constraint tags)

3. **Task Prediction**
   - Based on current task memories (status=pending)
   - Recent activity patterns
   - Project phase (from commit activity)
   - Time-based patterns (e.g., Friday = cleanup tasks)

4. **Knowledge Gap Detection**
   - Missing authentication decision
   - API error handling pattern not documented
   - Database backup strategy missing
   - Test coverage gaps

5. **MCP Tools** (`clauxton/mcp/server.py`)
   - `get_project_summary()` - Get project summary
   - `suggest_next_tasks(limit)` - Get next task suggestions
   - `detect_knowledge_gaps()` - Get knowledge gaps

6. **Tests** (`tests/semantic/test_memory_summarizer.py`, 10 tests)
   - Test project summarization
   - Test next task prediction
   - Test knowledge gap detection

#### Deliverables

- `clauxton/semantic/memory_summarizer.py` (~300 lines)
- `clauxton/mcp/server.py` (updated, +100 lines)
- `tests/semantic/test_memory_summarizer.py` (10 tests)
- Coverage: >90%

---

### Agent 11: Memory Graph Visualization (Day 25-30, 6 days)

**Depends on**: Phase 2 complete (for relationships)
**Runs in parallel with**: Agent 9, Agent 10

#### Tasks

1. **Implement MemoryGraph** (`clauxton/visualization/memory_graph.py`)
   - `generate_graph_data()` - Generate graph data for visualization
   - `export_to_dot()` - Export to Graphviz DOT format
   - `export_to_mermaid()` - Export to Mermaid diagram (for Markdown)
   - `export_to_json()` - Export to JSON (for web visualization)

2. **Graph Data Format**
   ```json
   {
     "nodes": [
       {"id": "MEM-001", "type": "knowledge", "title": "...", "size": 10},
       ...
     ],
     "edges": [
       {"source": "MEM-001", "target": "MEM-002", "weight": 0.85},
       ...
     ]
   }
   ```

3. **Node Sizing**
   - Based on number of relationships
   - Based on importance (number of references)

4. **Edge Weighting**
   - Based on relationship strength (from MemoryLinker)

5. **CLI Command** (`clauxton/cli/memory.py`)
   - `clauxton memory graph --output graph.png` - Generate graph image
   - `clauxton memory graph --format mermaid` - Mermaid diagram
   - `clauxton memory graph --type knowledge` - Filter by type

6. **Tests** (`tests/visualization/test_memory_graph.py`, 5 tests)
   - Test graph data generation
   - Test DOT export
   - Test Mermaid export
   - Test JSON export
   - Test filtering

#### Deliverables

- `clauxton/visualization/memory_graph.py` (~200 lines)
- `clauxton/cli/memory.py` (updated, +100 lines)
- `tests/visualization/test_memory_graph.py` (5 tests)
- Coverage: >85%

---

### Phase 3 Parallel Execution Strategy

```
Day 25-30 (6 days):
  Agent 9 (Q&A)         ┐
  Agent 10 (Summary)    ├─ Parallel (3 agents)
  Agent 11 (Graph)      ┘

Total: 6 days
```

### Phase 3 Deliverables Summary

- **Implementation**: 4 files (~800 lines)
- **Tests**: 25 tests
- **Coverage**: >90%
- **MCP Tools**: +3 (38 → 41 total)

---

## Phase 4: UX Polish (Week 7-8)

**Duration**: Day 37-48 (6 working days + 1.5 quality review)
**Goal**: Documentation, integration tests, TUI integration

### Agent 12: Core Documentation (Day 37-42, 6 days)

**Depends on**: Phase 2, Phase 3 complete

#### Tasks

1. **Memory System Guide** (`docs/MEMORY_SYSTEM.md`)
   - Concept overview (5 memory types)
   - CLI usage examples
   - MCP tool reference
   - Migration guide (link to existing)
   - FAQ

2. **Memory Quick Start** (`docs/MEMORY_QUICK_START.md`)
   - 5-minute quick start
   - Common workflows
   - Best practices

3. **Advanced Features Guide** (`docs/MEMORY_ADVANCED.md`)
   - Memory extraction from commits
   - Relationship detection
   - Q&A system usage
   - Graph visualization

#### Deliverables

- `docs/MEMORY_SYSTEM.md` (~800 lines)
- `docs/MEMORY_QUICK_START.md` (~200 lines)
- `docs/MEMORY_ADVANCED.md` (~400 lines)

---

### Agent 13: API Documentation (Day 37-42, 6 days)

**Depends on**: Phase 2, Phase 3 complete
**Runs in parallel with**: Agent 12

#### Tasks

1. **Update MCP Documentation** (`docs/mcp-memory.md`)
   - All 9 memory MCP tools
   - Usage examples
   - Integration patterns

2. **Update Main README** (`README.md`)
   - Memory system features
   - Update feature list
   - Update quick start examples

3. **Update Architecture Docs** (`docs/architecture.md`)
   - Memory system architecture
   - Data flow diagrams
   - Component relationships

4. **API Reference** (`docs/API_REFERENCE.md`)
   - All public APIs
   - Code examples
   - Migration from old APIs

#### Deliverables

- `docs/mcp-memory.md` (~300 lines)
- `README.md` (updated, +100 lines)
- `docs/architecture.md` (updated, +200 lines)
- `docs/API_REFERENCE.md` (~500 lines)

---

### Agent 14: Integration Tests (Day 37-42, 6 days)

**Depends on**: Phase 2, Phase 3 complete
**Runs in parallel with**: Agent 12, Agent 13

#### Tasks

1. **End-to-End Workflows** (`tests/integration/test_memory_workflow.py`)
   - Add memory → Search → Get → Update → Delete
   - Migrate KB/Tasks → Search mixed types → Update
   - Extract from commits → Auto-link → Q&A
   - Generate summary → Predict tasks → Visualize graph

2. **Backward Compatibility** (`tests/integration/test_backward_compat.py`)
   - Ensure old KB/Task APIs work after full migration
   - MCP tool compatibility
   - CLI command compatibility

3. **Performance Tests** (`tests/performance/test_memory_performance.py`)
   - Search performance: 1,000 entries
   - Auto-link performance: 500 entries
   - Q&A performance: complex questions
   - Graph generation: 100 nodes

4. **Security Tests** (`tests/security/test_memory_security.py`)
   - Input validation
   - YAML safety
   - File operations
   - Injection attacks

#### Deliverables

- `tests/integration/test_memory_workflow.py` (15 tests)
- `tests/integration/test_backward_compat.py` (10 tests)
- `tests/performance/test_memory_performance.py` (5 tests)
- `tests/security/test_memory_security.py` (5 tests)
- Total: 35 tests

---

### Agent 15: TUI Integration (Day 37-42, 6 days)

**Depends on**: Phase 2, Phase 3 complete
**Runs in parallel with**: Agent 12, Agent 13, Agent 14

#### Tasks

1. **Memory Explorer Tab** (`clauxton/tui/memory_explorer.py`)
   - 3-panel layout: Filters | Memory List | Details
   - Type filters (knowledge, decision, code, task, pattern)
   - Search box
   - Memory details view with relationships

2. **Keyboard Shortcuts**
   - `m` - Show Memories tab
   - `/` - Search memories
   - `f` - Toggle filters
   - `a` - Add memory (guided)
   - `e` - Edit selected memory
   - `d` - Delete selected memory
   - `g` - Show memory graph
   - `?` - Ask question (Q&A)

3. **Integration** (`clauxton/tui/app.py`)
   - Add memory tab to main TUI
   - Update navigation
   - Update status bar

4. **Tests** (`tests/tui/test_memory_explorer.py`, 10 tests)
   - Test memory list display
   - Test filtering
   - Test search
   - Test keyboard shortcuts

#### Deliverables

- `clauxton/tui/memory_explorer.py` (~300 lines)
- `clauxton/tui/app.py` (updated, +50 lines)
- `tests/tui/test_memory_explorer.py` (10 tests)
- Coverage: >85%

---

### Phase 4 Parallel Execution Strategy

```
Day 37-42 (6 days):
  Agent 12 (Core Docs)    ┐
  Agent 13 (API Docs)     ├─ Parallel (4 agents)
  Agent 14 (Integration)  │
  Agent 15 (TUI)          ┘

Total: 6 days
```

### Phase 4 Deliverables Summary

- **Documentation**: 7 files (~2,500 lines)
- **Tests**: 45 tests
- **TUI**: Memory Explorer tab
- **Coverage**: >85%

---

## Quality Assurance Strategy

### After Each Phase: Review Agent

**Duration**: 1.5 days per phase
**Total QA Time**: 4.5 days (3 phases)

#### Review Process

1. **Launch Review Agent** (using improved prompts from Phase 1)
2. **Generate Reports**:
   - Executive Summary
   - Quality Review
   - Detailed Findings
   - Improvement Tasks
3. **Execute Improvement Tasks** (parallel with SubAgents)

#### Quality Checklist (Same as Phase 1)

1. **Code Quality** (A- or higher)
   - DRY, SOLID, naming conventions
   - Function complexity <10
   - No code smells

2. **Performance** (B+ or higher)
   - Meet or exceed performance targets
   - Benchmark critical operations
   - Profile and optimize

3. **Testing** (A or higher)
   - Coverage >90%
   - All observation points tested
   - Performance + security tests

4. **Security** (A or higher)
   - 0 vulnerabilities
   - Input validation
   - YAML safety

5. **Lint & Type Check** (A- or higher)
   - mypy --strict: Pass
   - ruff check: Pass

6. **Documentation** (B+ or higher)
   - API docs complete
   - Usage examples
   - Migration guides

7. **Integration** (A or higher)
   - Components work together
   - No breaking changes
   - Backward compatibility

### Improvement Task Execution

**Strategy**: Parallel SubAgent execution

Example:
```
Phase 2 Review identifies 3 High-priority issues:
- Issue 1: Performance optimization (1 day)
- Issue 2: Missing tests (0.5 day)
- Issue 3: Documentation gaps (0.5 day)

→ Launch 3 SubAgents in parallel
→ Total time: 1 day (instead of 2 days sequential)
```

---

## Timeline Summary

### Overall Schedule

```
Phase 1: Core Integration (Day 1-12)
  ✅ COMPLETED
  - Agent 1-5 (parallel)
  - Quality review
  - Improvements

Phase 2: Smart Memory (Day 13-24)
  📋 Week 3-4
  - Agent 6-7 (parallel, 6 days)
  - Agent 8 (sequential, 4 days)
  - Quality review (1.5 days)
  - Improvements (1-2 days)

Phase 3: Memory Intelligence (Day 25-36)
  📋 Week 5-6
  - Agent 9-11 (parallel, 6 days)
  - Quality review (1.5 days)
  - Improvements (1-2 days)

Phase 4: UX Polish (Day 37-48)
  📋 Week 7-8
  - Agent 12-15 (parallel, 6 days)
  - Quality review (1.5 days)
  - Improvements (1-2 days)

Total: 48 days (with QA) → 40-42 days (with parallel improvements)
```

### Time Savings

| Approach | Duration | Savings |
|----------|----------|---------|
| **Sequential** | 56 days | - |
| **Phase 1 Parallel** | 12 days | ✅ Completed |
| **Phase 2 Parallel** | 11.5 days | -33% |
| **Phase 3 Parallel** | 9.5 days | -50% |
| **Phase 4 Parallel** | 9.5 days | -50% |
| **Total** | 42.5 days | **-24%** |

---

## Risk Management

### Risk 1: Agent Dependencies

**Risk**: Sequential agents (Agent 8) wait for parallel agents
**Mitigation**:
- Clear dependency specification
- Start Agent 8 immediately after Agent 6-7 complete
- Use agent completion signals

### Risk 2: Quality Issues in Parallel Development

**Risk**: Multiple agents introduce inconsistent code
**Mitigation**:
- Phase-end quality review (comprehensive)
- Strict quality requirements for each agent
- Automated checks (mypy, ruff, pytest)

### Risk 3: Integration Conflicts

**Risk**: Parallel agents modify same files
**Mitigation**:
- Clear file ownership (each agent has separate files)
- Integration tests after each phase
- Git branch strategy:
  - `phase2-agent6`, `phase2-agent7`, `phase2-agent8`
  - Merge sequentially after validation

### Risk 4: Performance Degradation

**Risk**: New features slow down system
**Mitigation**:
- Performance tests in each phase
- Benchmarks as gate criteria
- Profile critical paths

### Risk 5: Documentation Drift

**Risk**: Documentation doesn't match implementation
**Mitigation**:
- Documentation agents run after implementation
- Code examples tested
- API reference auto-generated where possible

---

## Execution Instructions

### Starting Phase 2

```bash
# 1. Confirm Phase 1 complete
git log --oneline | head -1
# Should show: "feat: implement v0.15.0 Unified Memory Model (Phase 1 complete)"

# 2. Launch Agent 6 (Memory Extraction)
# Use Task tool with detailed prompt (see SUBAGENT_PLAN.md)

# 3. Launch Agent 7 (Relationship Detection) in parallel
# Use Task tool with detailed prompt

# 4. Wait for both to complete (6 days)

# 5. Launch Agent 8 (CLI Extract Commands)
# Use Task tool with detailed prompt

# 6. After Phase 2 complete (Day 24):
#    Launch Review Agent with improved prompts
#    Execute improvement tasks in parallel
```

### Starting Phase 3

Same process as Phase 2, but with 3 parallel agents (9-11)

### Starting Phase 4

Same process as Phase 2, but with 4 parallel agents (12-15)

---

## Success Metrics

### Code Metrics

- **Total Tests**: 2,500+ (current: 2,346)
- **Coverage**: >90% overall
- **Quality Score**: >90/100 for each phase
- **Performance**: All targets met or exceeded

### User Metrics

- **Migration Success Rate**: >95%
- **Documentation Clarity**: User testing (5+ users)
- **Feature Usage**: Auto-extraction, Q&A, Graph (tracked)

### Development Metrics

- **Time Savings**: -24% vs. sequential
- **Quality**: Grade A or higher on all phases
- **Bug Rate**: <5 bugs per 1,000 LOC

---

**Last Updated**: 2025-11-03
**Status**: 📋 Ready to Execute
**Next Action**: Launch Phase 2 Agent 6 and Agent 7 in parallel

