# <span style="color: magenta;">Methodism</span>
Methodism sizga djangoda API larni tezroq yaratish va tez ishlatish imkoni beradi.  
***Egamberdiyav Xudoyberdi Tomonidan Yaratilgan***

# O'rnatish uchun qo'llanma 
1. Virtual muhit yarating va faollashtiring:
   
``` 
    python -m venv venv
   # Windows: venv\Scripts\activate
   # Linux/Mac: source venv/bin/activate
```
3. Pip va setuptools ni yangilang (muhim!):
```
     python -m pip install --upgrade pip setuptools wheel
```
3. Methodism ni o'rnating:
```bash
    pip install methodism
```
Agar Python 3.12+ da muammo bo'lsa, `--no-build-isolation` flagini qo'shing:
```bash
    pip install methodism --no-build-isolation
```

## About
Ushbu Kutubxona Egamberdiyev Xudoyberdi Tomonidan yaratilgan bo'lib tog'ridan tog'ri django 
kutubxonasi ustiga qurulgan. Bu sizga API lar yozganda uni tez ishlatish va tezroq API yozish imkoni beradi.
Avtomatik tarzda siz yozgan funksiyani method ga aylantirgan holatda api hosil qiladi

### filelar
* ``methodism/costumizing.py``  ushbu file tayyor bir qator claslarni custum holarga o'tqazilgan varianti hisoblandi.  
* ``methodism/decors.py`` Ushbu file kerakli bo'lgan decoratorlarni yozish uchun ishlatiluvchi file.
* ``methodism/error_messages.py`` bo'lishi mumkin bo'lgan xatoliklar yig'ilgan lug'at ko'rinishidagi file.   
* ``methodism/helper.py`` Yordamchi funksiyalar joylangan file.   
* ``methodism/main.py`` Asosiy class yozilgan file
* ``methodism/models.py`` Kerakli bo'lishi mumkin bo'lgan modellar to'plami
* ``methodism/paginator.py`` va ``methodism/sqlpaginator.py`` Ushbu fayllar bizga paginatsiya hosil qilishda yordam beradi


## Ishlatish ketma ketligi

#### Birinchi navbatda kerakli kutubxonalarni o'rnatib olishingiz kerak
#### From GitHub
``` python
  pip install -r requirements.txt
```  
#### From PyPi
``` python
  pip install Django==4.2 django-rest-framework==0.1.0 djangorestframework==3.14.0
```  

Yuklab olib bo'lgach O'zingizga  `views.py` faylida kerakli bo'lgan classni yozing va uni `urls.py` ga ulang,
class ga esa `methodism/main.py` dagi `METHODISM` classidan vorislik bering.  
### Example in `views.py`

```python
from methodism.main import METHODISM

# agar bundan foydalansangiz settings.INSTALLED_APPS ga 'rest_framework.authtoken' ni qo'shib qo'ying
from rest_framework.authtoken.models import Token 


class YourClass(METHODISM):

    file = '__main__'
    get_methods = "__main__"  # faqat get methodlari uchun
    token_key = "Bearer"
    auth_headers = "Authorization"
    token_class = Token
    not_auth_methods = [] # ro'yxatdan o'tish shart bo'lmagan kutubxonalarni qo'shib qo'ying
    
    
    """ Misol uchun yozgan funksiyangiz:
        def salom_dunyo(requests, params):
            return "salom"
        methodism:
            salom.dunyo
        
        siz yozgan har qanday ostki chiziqli yoki oddiy chiziqli funksiyalar nuqta orqali avtomatik ajratiladi!
        not_auth_methods = ['salom.dunyo']
     """
```
# Navbatdagi class SqlAPIMethodism

```python
from methodism.main import SqlAPIMethodism

# agar bundan foydalansangiz settings.INSTALLED_APPS ga 'rest_framework.authtoken' ni qo'shib qo'ying
from rest_framework.authtoken.models import Token 
# import your funksitions located file

class YourClass(SqlAPIMethodism):

    file = "__main__"  # funksiyalar joylashgan fileni hech qanday qo'shimchalarsiz tanishitiring
    get_methods = "__main__"  # faqat get methodlari uchun
    token_key = "Bearer"
    auth_headers = "Authorization"
    token_class = Token
    not_auth_methods = [] # ro'yxatdan o'tish shart bo'lmagan kutubxonalarni qo'shib qo'ying
    
    
    """ Misol uchun yozgan funksiyangiz:
        def sizni_funksiyangiz(request, params):
            return "select columns from your_table", True  # natija bitta bo'sa True ko'p bo'lsa False Qo'yiladi      
        
        siz yozgan har qanday ostki chiziqli yoki oddiy chiziqli funksiyalar nuqta orqali avtomatik ajratiladi!
        not_auth_methods = ['sizni.funksiyangiz']
     """

```

### funksiya taxmianan shunaqa yozilishi shart!
```python
def funk(request, params):
    return "select colums from your_table", False

# sql zaprosga istalgancha uzunlik mumkin, funk 2ta qiymat strda->sql va ikkinchisi Bool typiga ega bo'lishi kerak
# True -> agar natija bitta bo'lsa
# False -> agar natija bittadan ko'p bo'lsa

# AGARDA XATOLIK QAYTARMOQCHI BO'LINSA

# post funksiya
def funk(request, params):
    return {"error": "xatolik"}  # xatolikni chiqarish uchun list yoki dict formatlaridan foydalananing!!

# DIQQAT: GET zaprosi uchun funksiya yozilganda Params kirib kelmaydi

```

## <span style="color: orange;">Qo'shimcha ishlatishga oid qoidalarni Methodism Asosiy funksiyasigaa kiritilgan documentatsiyadan ham o'rganib olish mumkin</span>

---

## <span style='color: magenta;'> Kod Manbalari</span>
   * ### [GitHub](https://github.com/xudikk/Methodism)  
   * ### [PyPi](https://pypi.org/project/methodism/) 

 <span style="color: blue;">Methodism Barcha uchun ochiq kutubxona. Kodlari va yoki qo'shimcha ma'lumotlarni bemalol githubdan yoki dasturchining o'zidan so'rab o'rganib olishingiz mumkin</span>

# Happy Time. Enjoy IT ;)

###### if you can't understand contact with [programmer](https://t.me/xudikk)

