# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ComputeClusterHostGroupArgs', 'ComputeClusterHostGroup']

@pulumi.input_type
class ComputeClusterHostGroupArgs:
    def __init__(__self__, *,
                 compute_cluster_id: pulumi.Input[_builtins.str],
                 host_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ComputeClusterHostGroup resource.
        :param pulumi.Input[_builtins.str] compute_cluster_id: The managed object reference
               ID of the cluster to put the group in.  Forces a new
               resource if changed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_system_ids: The managed object IDs of
               the hosts to put in the cluster.
               
               > **NOTE:** The namespace for cluster names on this resource (defined by the
               `name` argument) is shared with the
               `ComputeClusterVmGroup`
               resource. Make sure your names are unique across both resources.
        :param pulumi.Input[_builtins.str] name: The name of the host group. This must be unique in the
               cluster. Forces a new resource if changed.
        """
        pulumi.set(__self__, "compute_cluster_id", compute_cluster_id)
        if host_system_ids is not None:
            pulumi.set(__self__, "host_system_ids", host_system_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The managed object reference
        ID of the cluster to put the group in.  Forces a new
        resource if changed.
        """
        return pulumi.get(self, "compute_cluster_id")

    @compute_cluster_id.setter
    def compute_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compute_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="hostSystemIds")
    def host_system_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The managed object IDs of
        the hosts to put in the cluster.

        > **NOTE:** The namespace for cluster names on this resource (defined by the
        `name` argument) is shared with the
        `ComputeClusterVmGroup`
        resource. Make sure your names are unique across both resources.
        """
        return pulumi.get(self, "host_system_ids")

    @host_system_ids.setter
    def host_system_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_system_ids", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the host group. This must be unique in the
        cluster. Forces a new resource if changed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ComputeClusterHostGroupState:
    def __init__(__self__, *,
                 compute_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ComputeClusterHostGroup resources.
        :param pulumi.Input[_builtins.str] compute_cluster_id: The managed object reference
               ID of the cluster to put the group in.  Forces a new
               resource if changed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_system_ids: The managed object IDs of
               the hosts to put in the cluster.
               
               > **NOTE:** The namespace for cluster names on this resource (defined by the
               `name` argument) is shared with the
               `ComputeClusterVmGroup`
               resource. Make sure your names are unique across both resources.
        :param pulumi.Input[_builtins.str] name: The name of the host group. This must be unique in the
               cluster. Forces a new resource if changed.
        """
        if compute_cluster_id is not None:
            pulumi.set(__self__, "compute_cluster_id", compute_cluster_id)
        if host_system_ids is not None:
            pulumi.set(__self__, "host_system_ids", host_system_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The managed object reference
        ID of the cluster to put the group in.  Forces a new
        resource if changed.
        """
        return pulumi.get(self, "compute_cluster_id")

    @compute_cluster_id.setter
    def compute_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="hostSystemIds")
    def host_system_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The managed object IDs of
        the hosts to put in the cluster.

        > **NOTE:** The namespace for cluster names on this resource (defined by the
        `name` argument) is shared with the
        `ComputeClusterVmGroup`
        resource. Make sure your names are unique across both resources.
        """
        return pulumi.get(self, "host_system_ids")

    @host_system_ids.setter
    def host_system_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_system_ids", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the host group. This must be unique in the
        cluster. Forces a new resource if changed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("vsphere:index/computeClusterHostGroup:ComputeClusterHostGroup")
class ComputeClusterHostGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `ComputeClusterHostGroup` resource can be used to manage groups
        of hosts in a cluster, either created by the
        `ComputeCluster` resource or looked up
        by the `ComputeCluster` data source.

        This resource mainly serves as an input to the
        `ComputeClusterVmHostRule`
        resource - see the documentation for that resource for further details on how
        to use host groups.

        > **NOTE:** This resource requires vCenter and is not available on direct ESXi
        connections.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        config = pulumi.Config()
        datacenter = config.get("datacenter")
        if datacenter is None:
            datacenter = "dc-01"
        hosts = config.get_object("hosts")
        if hosts is None:
            hosts = [
                "esxi-01.example.com",
                "esxi-02.example.com",
                "esxi-03.example.com",
            ]
        datacenter_get_datacenter = vsphere.get_datacenter(name=datacenter)
        hosts_get_host = [vsphere.get_host(name=hosts[__index],
            datacenter_id=datacenter_get_datacenter.id) for __index in range(len(hosts))]
        compute_cluster = vsphere.ComputeCluster("compute_cluster",
            name="compute-cluster-test",
            datacenter_id=dc["id"],
            host_system_ids=[[__item.id for __item in hosts_get_host]],
            drs_enabled=True,
            drs_automation_level="fullyAutomated",
            ha_enabled=True)
        cluster_host_group = vsphere.ComputeClusterHostGroup("cluster_host_group",
            name="test-cluster-host-group",
            compute_cluster_id=compute_cluster.id,
            host_system_ids=[[__item.id for __item in hosts_get_host]])
        ```

        ## Import

        An existing group can be imported into this resource by

        supplying both the path to the cluster, and the name of the host group. If the

        name or cluster is not found, or if the group is of a different type, an error

        will be returned. An example is below:

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        ```sh
        $ pulumi import vsphere:index/computeClusterHostGroup:ComputeClusterHostGroup cluster_host_group \\
        ```

          '{"compute_cluster_path": "/dc1/host/cluster1", \\

          "name": "pulumi-test-cluster-host-group"}'

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compute_cluster_id: The managed object reference
               ID of the cluster to put the group in.  Forces a new
               resource if changed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_system_ids: The managed object IDs of
               the hosts to put in the cluster.
               
               > **NOTE:** The namespace for cluster names on this resource (defined by the
               `name` argument) is shared with the
               `ComputeClusterVmGroup`
               resource. Make sure your names are unique across both resources.
        :param pulumi.Input[_builtins.str] name: The name of the host group. This must be unique in the
               cluster. Forces a new resource if changed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComputeClusterHostGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ComputeClusterHostGroup` resource can be used to manage groups
        of hosts in a cluster, either created by the
        `ComputeCluster` resource or looked up
        by the `ComputeCluster` data source.

        This resource mainly serves as an input to the
        `ComputeClusterVmHostRule`
        resource - see the documentation for that resource for further details on how
        to use host groups.

        > **NOTE:** This resource requires vCenter and is not available on direct ESXi
        connections.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        config = pulumi.Config()
        datacenter = config.get("datacenter")
        if datacenter is None:
            datacenter = "dc-01"
        hosts = config.get_object("hosts")
        if hosts is None:
            hosts = [
                "esxi-01.example.com",
                "esxi-02.example.com",
                "esxi-03.example.com",
            ]
        datacenter_get_datacenter = vsphere.get_datacenter(name=datacenter)
        hosts_get_host = [vsphere.get_host(name=hosts[__index],
            datacenter_id=datacenter_get_datacenter.id) for __index in range(len(hosts))]
        compute_cluster = vsphere.ComputeCluster("compute_cluster",
            name="compute-cluster-test",
            datacenter_id=dc["id"],
            host_system_ids=[[__item.id for __item in hosts_get_host]],
            drs_enabled=True,
            drs_automation_level="fullyAutomated",
            ha_enabled=True)
        cluster_host_group = vsphere.ComputeClusterHostGroup("cluster_host_group",
            name="test-cluster-host-group",
            compute_cluster_id=compute_cluster.id,
            host_system_ids=[[__item.id for __item in hosts_get_host]])
        ```

        ## Import

        An existing group can be imported into this resource by

        supplying both the path to the cluster, and the name of the host group. If the

        name or cluster is not found, or if the group is of a different type, an error

        will be returned. An example is below:

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        ```sh
        $ pulumi import vsphere:index/computeClusterHostGroup:ComputeClusterHostGroup cluster_host_group \\
        ```

          '{"compute_cluster_path": "/dc1/host/cluster1", \\

          "name": "pulumi-test-cluster-host-group"}'

        :param str resource_name: The name of the resource.
        :param ComputeClusterHostGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeClusterHostGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeClusterHostGroupArgs.__new__(ComputeClusterHostGroupArgs)

            if compute_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'compute_cluster_id'")
            __props__.__dict__["compute_cluster_id"] = compute_cluster_id
            __props__.__dict__["host_system_ids"] = host_system_ids
            __props__.__dict__["name"] = name
        super(ComputeClusterHostGroup, __self__).__init__(
            'vsphere:index/computeClusterHostGroup:ComputeClusterHostGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compute_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            host_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ComputeClusterHostGroup':
        """
        Get an existing ComputeClusterHostGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compute_cluster_id: The managed object reference
               ID of the cluster to put the group in.  Forces a new
               resource if changed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_system_ids: The managed object IDs of
               the hosts to put in the cluster.
               
               > **NOTE:** The namespace for cluster names on this resource (defined by the
               `name` argument) is shared with the
               `ComputeClusterVmGroup`
               resource. Make sure your names are unique across both resources.
        :param pulumi.Input[_builtins.str] name: The name of the host group. This must be unique in the
               cluster. Forces a new resource if changed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeClusterHostGroupState.__new__(_ComputeClusterHostGroupState)

        __props__.__dict__["compute_cluster_id"] = compute_cluster_id
        __props__.__dict__["host_system_ids"] = host_system_ids
        __props__.__dict__["name"] = name
        return ComputeClusterHostGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The managed object reference
        ID of the cluster to put the group in.  Forces a new
        resource if changed.
        """
        return pulumi.get(self, "compute_cluster_id")

    @_builtins.property
    @pulumi.getter(name="hostSystemIds")
    def host_system_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The managed object IDs of
        the hosts to put in the cluster.

        > **NOTE:** The namespace for cluster names on this resource (defined by the
        `name` argument) is shared with the
        `ComputeClusterVmGroup`
        resource. Make sure your names are unique across both resources.
        """
        return pulumi.get(self, "host_system_ids")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the host group. This must be unique in the
        cluster. Forces a new resource if changed.
        """
        return pulumi.get(self, "name")

